# -*- coding: utf-8 -*-

from resources.lib import simple_requests as requests
from resources.lib import common
from base64 import b64decode
import re

timeout = common.get_timeout()
headers = {'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                'Accept-Encoding': 'gzip,deflate,sdch',
                'Accept-Language': 'en-US,en;q=0.8',
                'Connection': 'keep-alive',
                'User-Agent': 'Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.69 Safari/537.36'}

def unshorten_adfly(uri):
    try:
        r = requests.get(uri, headers=headers, timeout=timeout)
        html = r.text
        ysmm = re.findall(r"var ysmm =.*\;?", html)

        if len(ysmm) > 0:
            ysmm = re.sub(r'var ysmm \= \'|\'\;', '', ysmm[0])

            left = ''
            right = ''

            for c in [ysmm[i:i+2] for i in range(0, len(ysmm), 2)]:
                left += c[0]
                right = c[1] + right

            decoded_uri = b64decode(left.encode() + right.encode())[2:].decode()

            if re.search(r'go\.php\?u\=', decoded_uri):
                decoded_uri = b64decode(re.sub(r'(.*?)u=', '', decoded_uri)).decode()

            return decoded_uri
        else:
            return uri

    except Exception as e:
        return uri, str(e)