# -*- coding: utf-8 -*-

import xbmc,os,re,time
import json
from resources.lib import simple_requests as requests
from resources.lib import json_handle
from resources.lib import common

site = 'proxer'
base_url = 'http://proxer.me'
tv_url = base_url+'/anime/animeseries/title/%s/'
movie_url = base_url+'/anime/movie/title/%s/'
ova_url = base_url+'/anime/ova/title/%s/'
raw_format = '?format=raw'
json_format = '?format=json'
headers = {'User-Agent': 'Mozilla/5.0 (Windows NT 6.3)',
            'Host': 'proxer.me'}
timeout = common.get_timeout()

def get_mirror(type,anime,episode,cache_time=False):
    mirror = []
    try:
        id = get_anime_id(type,anime,cache_time)
        if id:
            episodes = get_episodes(type,id,cache_time)
            for epi in episodes:
                if epi['episode'] == episode:
                    mirror = epi['url']
                    break
        if mirror:
            mirror_list = get_mirror_list(mirror)
            if mirror_list:
                return mirror_list
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror error' % site, e
    return mirror
        
def get_mirror_list(mirror):
    mirror_list = []
    try:
        content = requests.get(mirror, headers=headers, timeout=timeout).text
        streams = re.findall('var streams = \[(.*?)\]', content, re.DOTALL)[0]
        _data = re.findall('\{(.*?)}', streams, re.DOTALL)
        for data in _data:
            data = data.replace('\/','/')
            code = re.findall('"code":"(.*?)"', data)[0]
            link = re.findall('"replace":"(.*?)"', data)[0]
            if link: link = link.replace('#',code)
            else: link = code
            if not 'http:' in link: link = 'http:'+link
            if not '/article' in link:
                mirror_list.append(link)
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror_list error' % site, e
    return mirror_list

def get_abc_list_mirror(type,abc,cache_time=False):
    if type == 'tv': url = tv_url % abc
    elif type == 'movie': url = movie_url % abc
    elif type == 'ova': url = ova_url % abc
    anime_list = get_anime_list(url,cache_time)
    return anime_list

def get_abc_list(type,abc,cache_time=False):
    return []
    
def get_new_series(cache_time=False):
    return []

def get_anime_list(abc_url,cache_time=False):
    cache_url = common.cleanfilename(abc_url)
    anime_list = json_handle.load_json(site, cache_url, cache_time=1)
    if anime_list:
        return anime_list
    else:
        anime_list = []
        re_pages = 15
        try:
            for i in range(0, int(re_pages)):
                url = abc_url+str(i+1)+raw_format
                content = requests.get(url, timeout=timeout, headers=headers).text
                items = re.findall('title="Cover:.*?" href="(.*?)".*?>(.*?)</a>', content, re.DOTALL)
                if items:
                    for url, name in items:
                        url = base_url+url.replace('#top','')
                        anime_list.append({'site': site, 'id': url, 'name': name})
                else: break
            if anime_list: json_handle.save_json(site, cache_url, anime_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_list error' % site, e
        return anime_list

def get_episode_list(type,name,cache_time=False):
    return []

def get_episodes(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    episodes = json_handle.load_json(site, cache_url+'episodes', cache_time)
    if episodes:
        return episodes
    else:
        episodes = []
        try:
            json_data = requests.get(id+'/list%s' % json_format, timeout=timeout, headers=headers).json()
            for e in json_data['data']:
                if e['typ'] == 'gersub' or e['typ'] == 'gerdub':
                    episode = e['no']
                    typ = e['typ']
                    url = id+'/%s/%s%s' % (episode,typ,raw_format)
                    url = url.replace('/info/','/watch/')
                    episodes.append({'url': url, 'episode': episode})
            if episodes: json_handle.save_json(site, cache_url+'episodes', episodes)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_episodes error' % site, e
        return episodes

def get_anime_id(type,anime,cache_time=False):
    id = None
    try:
        alt_list = common.get_ani_alt_list(anime)
        alt_list.insert(0, {'alt_name': anime})
        for alt_name in alt_list:
            name = alt_name['alt_name']
            abc = name[0]
            if abc.isalpha(): abc = abc.upper()
            else: abc = '0-9'
            anime_list = get_abc_list_mirror(type,abc,cache_time)
            match = common.find_anime(name, anime_list)
            if match: break
        id = match[0]['id']
    except Exception, e:
        print '[plugin.video.animeanime] %s get_anime_id' % site, e
    return id