# -*- coding: utf-8 -*-

import xbmc,os,re,time
import json
from resources.lib import simple_requests as requests
from resources.lib import json_handle
from resources.lib import common

site = 'burning'
type = 'tv'
base_url = 'http://bs.to/'
genre_url = base_url+'andere-serien'
cover_url = 'http://s.bs.to/img/cover/%s.jpg|encoding=gzip'
headers = {'User-Agent': 'bs-android'}
timeout = common.get_timeout()

def get_mirror(type,anime,episode,cache_time=False):
    mirror = []
    return mirror

def get_burning_seasons(name,cache_time=False):
    burning_seasons = []
    anime_list = get_complete_anime_list(cache_time)
    alt_list = common.get_ani_alt_list(name,cache_only=True)
    alt_list.insert(0, {'alt_name': name})
    for alt_name in alt_list:
        name = alt_name['alt_name']
        match = common.find_anime(name, anime_list, clean_burning=True)
        if match: break
    for series in match:
        b_id = series['id']
        b_name = series['name']
        data = get_anime_data(b_id,cache_time)
        seasons = data['seasons']
        cover = data['cover']
        for i in range(int(seasons)):
            name = b_name+' Staffel: %s' % str(i+1)
            rpl = '/%s/' % str(i+1)
            id = b_id.replace('/1/',rpl)
            burning_seasons.append({'name': name, 'id':id, 'cover': cover})
    return burning_seasons
    
def get_abc_list(type,abc,cache_time=False):
    abc_list = []
    if abc == 'num': abc = ('.','0', '1', '2', '3', '4', '5', '6', '7', '8', '9')
    elif abc == 'all': abc = ''
    else: abc = abc.lower()
    if type == 'tv': anime_list = get_complete_anime_list(cache_time)
    else: anime_list = []
    if abc:
        for anime in anime_list:
            if anime['name'].lower().startswith(abc):
                abc_list.append(anime)
    else:
        abc_list = anime_list
    return abc_list

def get_new_series(cache_time=False):
    return []

def get_anime_info(type,id,cache_time=False):
    anime = []
    try:
        json_data = get_anime_data(id,cache_time)
        name = json_data['name'].encode('utf-8')
        id = json_data['id']
        plot = json_data['plot']
        cover = json_data['cover']
        genres = json_data['genres']
        year = json_data['year']
        anime = ({'site': site, 'type': type, 'name': name, 'id': id, 'plot': plot, 'cover': cover,
                    'genre': genres, 'episodes': '', 'episodes_aired': '', 'year': year})
    except Exception, e:
        print '[plugin.video.animeanime] %s get_anime_info error' % site, e
    return anime
    
def get_complete_anime_list(cache_time=False):
    cache_url = common.cleanfilename(genre_url)
    anime_list = json_handle.load_json(site, cache_url, cache_time)
    if anime_list:
        return anime_list
    else:
        anime_list = []
        try:
            data = requests.get(genre_url, timeout=timeout, headers=headers).text
            anime = re.findall('<strong>Anime</strong>.*?<ul>(.*?)</ul>', data, re.DOTALL)[0]
            series = re.findall('<a href="(.*?)">(.*?)</a>', anime, re.DOTALL)
            for id,name in series:
                id = id+'/1/'
                anime_list.append({'site': site, 'type': type, 'name': name, 'id': id, 'plot': '', 'cover': '',
                                    'genre': '', 'episodes': '', 'episodes_aired': '', 'year': ''})
            json_handle.save_json(site, cache_url, anime_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_complete_anime_list error' % site, e
        return anime_list

def get_anime_list(bids):
    anime_list = []
    for id in bids:
        anime = get_anime_info(id)
        anime_list.append(anime)
    return anime_list
    
def get_anime_data(id,cache_time=False):
    cache_url = common.cleanfilename(id)
    json_data = None
    json_data = json_handle.load_json(site,cache_url,cache_time)
    if json_data:
        return json_data
    else:
        try:
            url = base_url+id
            data = requests.get(url, timeout=timeout, headers=headers).text
            
            name = re.findall('<h2>(.*?)<', data, re.DOTALL)[0]
            name = name.rstrip()
            
            s_match = re.findall('<ul class="pages">(.*?)</ul>', data, re.DOTALL)[0]
            seasons = re.findall('<li class=".*?"><a href=".*?">(\d+)</a></li>', s_match, re.DOTALL)[-1]
            
            e_match = re.findall('<table>(.*?)</table>', data, re.DOTALL)[0]
            eps = re.findall('<td>(\d+)</td>.*?<td class="nowrap">(.*?)</td>', e_match, re.DOTALL)
            episodes = []
            for episode, hoster_list in eps:
                h_list = []
                hoster_info = re.findall('href="(.*?)">(.*?)</a>', hoster_list, re.DOTALL)
                for hoster_url, hoster_name in hoster_info:
                    h_entry = {'hoster_url': hoster_url, 'hoster_name': hoster_name}
                    h_list.append(h_entry)
                episodes.append({'episode': episode, 'hoster': h_list})
            
            plot = re.findall('<strong>Beschreibung</strong>.*?<p>(.*?)</p>', data, re.DOTALL)[0]
            
            year = re.findall('<span id="years">.*?(\d+)', data, re.DOTALL)[0]
            
            g_match = re.findall('<ul id="ul-genre">(.*?)</ul>', data, re.DOTALL)[0]
            genres = re.findall('<li>(.*?)</li>', g_match, re.DOTALL)
            
            a_id = re.findall('<img src=".*?/cover/(\d+)', data, re.DOTALL)[0]
            cover = cover_url % a_id
            
            json_data = {'name': name, 'id': id, 'seasons': seasons, 'episodes': episodes,
                        'plot': plot, 'year': year, 'genres': genres, 'cover': cover}
            json_handle.save_json(site, cache_url, json_data)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_data error' % site, e
        return json_data

def get_episode_list(type,anime,cache_time=False):
    return []

def get_episodes(id,cache_time=False):
    json_data = get_anime_data(id,cache_time)
    episodes = json_data['episodes']
    return episodes
    
def get_hoster_list(id,episode):
    links = []
    hoster_list = []
    data = get_anime_data(id)
    episodes = data['episodes']
    for e in episodes:
        if e['episode'] == episode:
            hoster_list = e['hoster']
    for hoster in hoster_list:
        h_id = hoster['hoster_url']
        link = get_stream_link(h_id)
        links.append(link)
    return links
    
def get_stream_link(id):
    link = []
    try:
        url = base_url+id
        data = requests.get(url, headers=headers, timeout=timeout).text
        link = re.findall("<a target='_blank' href='(.*?)'", data, re.DOTALL)[0]
    except Exception, e:
        print '[plugin.video.animeanime] %s get_stream_link error' % site, e
    return link