# -*- coding: utf-8 -*-

import xbmc,os,re,time
import json
from resources.lib import simple_requests as requests
from resources.lib import json_handle
from resources.lib import common

site = 'anisearch'
type = 'tv'
base_url = 'http://de.anisearch.com/'
anime_url = base_url+'anime/%s'
streams_url = base_url+'anime/streams?sort=%s'
search_url = base_url+'ajax/search/anime'
cover_url = 'http://cdn.anisearch.com/images/anime/cover/full/%s/%s.jpg'
timeout = common.get_timeout()

def get_mirror(type,anime,episode,cache_time=False):
    mirror = []
    try:
        id = get_anime_id(type,anime,cache_time)
        if id:
            episodes = get_episodes(type,id,cache_time)
            for epi in episodes:
                if epi['episode'] == episode:
                    hoster_list = epi['url']
                    for url in hoster_list:
                        mirror.append(url)
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror error' % site, e
    return mirror

def get_anime_list(abc, type, cache_time=False):
    if type == 'new': sort = 'newest'
    else: sort = 'title'
    cache_url = common.cleanfilename(streams_url % (str(abc)))
    anime_list = json_handle.load_json(site, cache_url, cache_time=cache_time)
    if anime_list:
        return anime_list
    else:
        anime_list = []
        try:
            content = requests.get(streams_url % sort).text
            pages = re.findall('<span class="pagenav-pages">Seite 1 von (\d+)</span>', content, re.DOTALL)[0]
            if type == 'new':
                url = streams_url % sort
                anime_list = get_page_anime_list(anime_list, type, url, content)
            else:
                page = common.get_page(abc,pages)
                url = '%s&page=%s' % ((streams_url % sort), str(page))
                anime_list = get_page_anime_list(anime_list, type, url)
                next_page = 1
                new_page = page
                loops = 0
                while next_page !=0:
                    next_page = check_first_position(anime_list,abc)
                    new_page = new_page + next_page
                    if new_page == page or next_page == 0 or new_page == 0: break
                    url = '%s&page=%s' % ((streams_url % sort), str(new_page))
                    page_anime_list = get_page_anime_list(anime_list, type, url)
                    if new_page < page:
                        for anime in page_anime_list:
                            anime_list.insert(0,anime)
                    if new_page > page:
                        for anime in page_anime_list:
                            anime_list.append(anime)
                    loops += 1
                    if loops == 5:
                        break
            if anime_list: json_handle.save_json(site, cache_url, anime_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_list error' % site, e
        return anime_list
        
def check_first_position(anime_list,abc):
    page = 0
    anime_position = common.get_position(anime_list[0]['name'][0])
    abc_position = common.get_position(abc)
    if anime_position >= abc_position:
        page = -1
    if anime_position < abc_position:
        page = check_last_position(anime_list,abc)
    return page

def check_last_position(anime_list,abc):
    page = 0
    anime_position = common.get_position(anime_list[-1]['name'][0])
    abc_position = common.get_position(abc)
    if anime_position <= abc_position:
        page = 1
    return page

def get_page_anime_list(anime_list, type, url, content=False):
    page_anime_list = []
    if not content: content = requests.get(url, timeout=timeout).text
    index = re.findall('<table class="index-gallery">(.*?)</table>', content, re.DOTALL)[0]
    items = re.findall('<td><a(.*?)</td>', index, re.DOTALL)
    for item in items:
            if 'TV' in item: typ = 'tv'
            elif 'Movie' in item: typ = 'movie'
            elif 'OVA' in item: typ = 'ova'
            elif 'Web' in item: typ = 'tv'
            else: typ = None
            url = re.findall('href="(.*?)"', item, re.DOTALL)[0]
            cover = re.findall('<img src="(.*?)"', item, re.DOTALL)[0]
            cover = cover.replace('thumb','full')
            name = re.findall('alt="(.+?)"', item, re.DOTALL)[0]
            try: year = re.findall('advinfo mtA.*?([0-9]{4})', item, re.DOTALL)[0]
            except: year = ''
            try: genre = re.findall('advinfoB.*?gt;(.*?)&lt', item, re.DOTALL)[0]
            except: genre = ''
            genre = genre.split(',')
            if typ:
                page_anime_list.append({'site': site, 'type': typ, 'name': name, 'id': url, 'plot': '', 'cover': cover,
                                        'genre': genre, 'episodes': '', 'episodes_aired': '', 'year': year})
            if type == 'new' and len(page_anime_list) == 8:
                break
    return page_anime_list

def get_episode_list(type,name,cache_time=False):
    episodes = []
    id = get_anime_id(type,name)
    if id:
        episodes = get_episodes(type,id,cache_time)
    return episodes
        
def get_anime_info(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    anime = json_handle.load_json(site, cache_url, cache_time)
    if anime:
        return anime
    else:
        anime = []
        try:
            content = requests.get(base_url+id, timeout=timeout).text
            match = re.findall('itemprop="headline">(.*?)</div>', content, re.DOTALL)[0]
            name = re.findall('<span itemprop="name">(.*?)</span>', match, re.DOTALL)[0]
            genres = re.findall('normal">.*?\), (.*?)</span>', match, re.DOTALL)[0]
            year = re.findall('normal">.*?\(([0-9]{4})\)', match, re.DOTALL)[0]
            try: genre = genres.split(',')
            except: genre = [genres]
            try: plot = re.findall('<div itemprop="description".*?>(.*?)</div>', content, re.DOTALL)[0]
            except: plot = ''
            plot = re.sub('<(.*?)>', '', plot)
            episodes = re.findall('itemprop="numberOfEpisodes" content="(\d+)"', content)[0]
            cover = re.findall('<img itemprop="image" src="(.*?)"', content, re.DOTALL)[0]
            anime = ({'site': site, 'type': type, 'name': name, 'id': id, 'plot': plot, 'cover': cover,
                      'genre': genre, 'episodes': episodes, 'episodes_aired': '', 'year': year})
            if anime: json_handle.save_json(site, cache_url, anime)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_info' % site, e
        return anime

def get_abc_list(type,abc,cache_time=False):
    abc_list = []
    if abc.isalpha() and not abc == 'num': abc = abc.upper()
    anime_list = get_anime_list(abc,type,cache_time)
    if abc == 'num': abc = ('.','0', '1', '2', '3', '4', '5', '6', '7', '8', '9')
    for anime in anime_list:
        if (anime['name'].lower().startswith(abc) or anime['name'].startswith(abc)) and anime['type'] == type:
            abc_list.append(anime)
    return abc_list
        
def get_new_series(cache_time=False):
    type = 'new'
    abc = ''
    new_list = get_anime_list(abc,type,cache_time)
    return new_list
        
def get_episodes(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    episodes = json_handle.load_json(site, cache_url+'episodes', cache_time)
    if episodes:
        return episodes
    else:
        episodes = []
        try:
            content = requests.get(base_url+id, timeout=timeout).text
            match = re.findall('<ul class="streams">(.*?)</ul>', content, re.DOTALL)[0]
            urls = re.findall('<li><a href="(.*?)"', match, re.DOTALL)
            urls = common.remove_duplicates(urls)
            for url in urls:
                url = url.replace('amp;','')
                content = requests.get(base_url+url, timeout=timeout).text
                streamlist = re.findall('<div class="title"><h2>Streams(.*?)</ul>', content, re.DOTALL)[0]
                items = re.findall('<stro(.*?)</li>', streamlist, re.DOTALL)
                for item in items:
                    hoster_list = []
                    url_list = re.findall('href="(.*?)"', item, re.DOTALL)
                    for url in url_list:
                        if 'redirect' in url: url = base_url+url
                        hoster_list.append(url)
                    title = re.findall('ng>(.*?)</strong>', item)[0]
                    try:
                        episode = re.findall('Episode.+?(\d+)', title)[0]
                        while episode.startswith('0'):
                            episode = episode[1:]
                    except:
                        episode = '1'
                    episodes.append({'name': title, 'url': hoster_list, 'episode': episode})
            if episodes: json_handle.save_json(site, cache_url+'episodes', episodes)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_episodes error' % site, e
        return episodes
        
def get_anime_id(type,anime,cache_time=False):
    id = None
    try:
        alt_list = common.get_ani_alt_list(anime)
        alt_list.insert(0, {'alt_name': anime})
        for alt_name in alt_list:
            name = alt_name['alt_name']
            abc = name[0]
            if abc.isalpha(): abc = abc.upper()
            else: abc = 'num'
            anime_list = get_abc_list(type,abc,cache_time)
            match = common.find_anime(name, anime_list)
            if match: break
        id = match[0]['id']
    except Exception, e:
        print '[plugin.video.animeanime] %s get_anime_id' % site, e
    return id
        
def get_trailer(name):
    aid = search(name)
    try:
        content = requests.get(anime_url % str(aid), timeout=timeout).text
        match = re.findall('<a itemprop="trailer" href="(.*?)"', content, re.DOTALL)
        for trailer in match:
            if 'youtube' in trailer:
                return trailer
    except Exception, e:
        print '[plugin.video.animeanime] %s get_trailer error' % site, e
        
def get_similar(name):
    anime_list = []
    aid = search(name)
    if aid:
        try:
            content = requests.get(anime_url % str(aid)+'/relations#similar', timeout=timeout).text
            similar = re.findall('<a id="recommendations">(.*?)</main>', content, re.DOTALL)[0]
            items = re.findall('<img src="(.*?)" alt="(.*?)"', similar, re.DOTALL)
            for cover, name in items:
                anime_list.append({'name': name.decode('utf-8'), 'cover': cover})
            return anime_list
        except Exception, e:
            print '[plugin.video.animeanime] %s get_similar error' % site, e
        
def get_alt_list(name,cache_only):
    cache_name = 'alt_name_list_'+common.cleantitle(name,clean_burning=True)
    alt_list = json_handle.load_json(site, cache_name, cache_time=30)
    if not alt_list:
        alt_list = []
        if cache_only: return alt_list
        aid = search(name)
        if aid:
            try:
                content = requests.get(anime_url % str(aid), timeout=timeout).text
                try:
                    titel = re.findall('<table class="index-list tdvam">(.*?)<table>', content, re.DOTALL)[0]
                    items = re.findall('<span lang=.*?>(.*?)</span>', titel, re.DOTALL)
                    for alt_name in items:
                        alt_list.append({'alt_name': alt_name})
                except:
                    pass
                try:
                    synonyme = re.findall('Synonyme(.*?)</tr>', titel, re.DOTALL)[0]
                    items = re.findall('<td>(.*?)</td>', synonyme, re.DOTALL)
                    for alt_name in items:
                        alt_list.append({'alt_name': alt_name})
                except:
                    pass
                if alt_list:
                    for item in alt_list:
                        name = item['alt_name']
                        cache_name = 'alt_name_list_'+common.cleantitle(name,clean_burning=True)
                        json_handle.save_json(site, cache_name, alt_list)
            except Exception, e:
                print '[plugin.video.animeanime] %s get_alt_list error' % site, e
    return alt_list

def get_search_list(search_string):
    search_list = []
    result = search(search_string,return_result=True)
    for anime in result:
        try:
            id = anime['i']
            if len(id) < 4: c = '0'
            elif len(id) == 4: c = id[0]
            elif len(id) > 4: c = id[:2]
            cover = cover_url % (c,id)
            name = anime['t']
            name = common.clean(name)
            v = anime['v'].split(',')
            plot = v[-3]
            plot = re.sub('<(.*?)>', ' ', plot)
            if 'TV' in plot: typ = 'tv'
            elif 'Movie' in plot: typ = 'movie'
            elif 'OVA' in plot: typ = 'ova'
            else: typ = None
            v1 = v[-2]
            episodes = re.findall('(\d+)', v1)[0]
            year = re.findall('\((\d{4})\)', v1)[0]
            genre = v[-1].split(',')
            if typ == 'tv' or typ == 'movie' or typ == 'ova':
                search_list.append({'site': site, 'type': typ, 'name': name, 'id': id, 'plot': plot, 'cover': cover,
                                    'genre': genre, 'episodes': episodes, 'episodes_aired': '', 'year': year})
        except Exception, e:
            print '[plugin.video.animeanime] %s get_search_list error' % site, e
    return search_list

def search(name, return_result=False):
    aid = None
    try:
        data = {"t": name.decode('utf-8'), "p": 0}
        headers = {'X-Requested-With': 'XMLHttpRequest'}
        json_result = requests.post(search_url, headers=headers, data=data, timeout=timeout).json()
        result = json_result['r']
        if return_result:
            return result
        else:
            for anime in result:
                if name == anime['t']:
                    aid = anime['i']
                    break
            if not aid:
                aid = json_result['r'][0]['i']
    except Exception, e:
        print '[plugin.video.animeanime] %s search error' % site, e
    return aid