# -*- coding: utf-8 -*-

import os,xbmc,xbmcvfs
import common

def add_to_library(type,anime,most_episodes,mode):
    path = None
    if type == 'tv':
        path = common.get_library_path('series_path')
    if type == 'movie':
        path = common.get_library_path('movies_path')
    if type == 'ova': 
        path = common.get_library_path('ovas_path')
    if path:
        final_path = None
        name = get_name(anime)
        if name:
            folder = deumlaut(name)
            final_path = os.path.join(path, folder)
        if final_path:
            season = None
            if type == 'tv': season = get_season()
            if season:
                final_path = os.path.join(final_path, season) 
            create_strm_files(final_path,type,mode,anime,most_episodes,season)
    else:
        common.open_Settings()

def create_strm_files(final_path,type,mode,anime,most_episodes,season):
    success = False
    episodes = get_episodes(most_episodes)
    if episodes.isdigit():
        for e in range(1,int(episodes)+1):
            episode = str(e)
            if type == 'movie': name = '%s %s' % (anime,episode)
            else: name = 'Episode %s' % episode
            if not season: season = 's1'
            strmname = '%se%s.strm' % (season,episode)
            strmentry = common.build_url({'type': type, 'mode': mode, 'name': name, 'anime': anime, 'episode': episode})
            strm = os.path.join(final_path, strmname)
            strm = xbmc.makeLegalFilename(strm)
            if not xbmcvfs.exists(os.path.dirname(strm)):
                try: 
                    xbmcvfs.mkdirs(os.path.dirname(strm))
                except:
                    xbmc.executebuiltin('Notification(Info: Konnte keinen Ordner erstellen!,)')
                    break
            old_strmentry = ''
            try:
                fh = xbmcvfs.File(strm, 'r')
                old_strmentry = fh.read()
                fh.close()
            except:
                pass
            if strmentry != old_strmentry:
                try:
                    file_desc = xbmcvfs.File(strm, 'w')
                    file_desc.write(strmentry)
                    file_desc.close()
                    if xbmcvfs.exists(strm):
                        success = True
                        print success
                except:
                    xbmc.executebuiltin('Notification(Info: Konnte keine Datei erstellen!,)')
                    break
        if success:
            xbmc.sleep(100)
            xbmc.executebuiltin('UpdateLibrary(video)')

def get_name(anime):
    name = None
    title = 'Enter Anime (Folder) Name'
    name = common.enter_string(title, anime)
    return name

def get_season():
    season = None
    title = 'Enter Season Number'
    season = common.enter_string(title, '1')
    if season.isdigit():
        season = 's%s' % season
    return season
    
def get_episodes(most_episodes):
    episodes = None
    title = 'Enter Episode Number'
    episodes = common.enter_string(title, str(most_episodes))
    return episodes

def deumlaut(s):
    try: s = s.encode('utf-8')
    except: pass
    s = s.replace('ß', 'ss')
    s = s.replace('ü', 'ue')
    s = s.replace('Ü', 'Ue')
    s = s.replace('ö', 'oe')
    s = s.replace('Ö', 'Oe')
    s = s.replace('ä', 'ae')
    s = s.replace('Ä', 'Ae')
    return s