# -*- coding: utf-8 -*-

import os,sys,re,urllib,xbmc,xbmcaddon,xbmcgui,shutil,json,time

addon = xbmcaddon.Addon(id='plugin.video.animeanime')
datapath = xbmc.translatePath('special://profile/addon_data/plugin.video.animeanime')
if not os.path.isdir(datapath):
    os.mkdir(datapath)

def get_installedversion():
    json_query = xbmc.executeJSONRPC('{ "jsonrpc": "2.0", "method": "Application.GetProperties", "params": {"properties": ["version", "name"]}, "id": 1 }')
    json_query = unicode(json_query, 'utf-8', errors='ignore')
    json_query = json.loads(json_query)
    version_installed = []
    if json_query.has_key('result') and json_query['result'].has_key('version'):
        version_installed  = json_query['result']['version']['major']
    return version_installed
    
def get_genres():
    genres = ['Abenteuer', 'Action', 'Actiondrama', 'Actionkom\xc3\xb6die', 'Alltagsdrama', 'Drama',
                'Fighting-Shounen', 'Ganbatte', 'Geistergeschichten', 'Genre-Mix', 'Hentai', 'Horror', 
                'Kom\xc3\xb6die', 'Krimi', 'Liebesdrama', 'Nonsense-Kom\xc3\xb6die',
                'Romantische Kom\xc3\xb6die', 'Romanze', 'Sentimentales Drama', 'Thriller']
    return genres

def get_alphabet():
    alphabet = ['num', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
                'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S',
                'T', 'U', 'V', 'W', 'X', 'Y', 'Z']
    return alphabet
    
def build_url(query):
    return sys.argv[0] + '?' + urllib.urlencode(query)

def sleep(t):
    time.sleep(t)
    return
    
def get_library_path(type):
    path = None
    path = addon.getSetting(type)
    return path
  
def get_addon():
    return addon
    
def get_dialog():
    return xbmcgui.Dialog()
    
def open_Settings():
    return addon.openSettings()
    
def clear_cache():
    folders = [ name for name in os.listdir(datapath) if os.path.isdir(os.path.join(datapath, name)) ]
    for folder in folders:
        shutil.rmtree(os.path.join(datapath, folder))

def get_image():
    home = addon.getAddonInfo('path').decode('utf-8')
    image = xbmc.translatePath(os.path.join(home, 'icon.png'))
    return image
    
def get_subtitle():
    subtitle = os.path.join(datapath,'subtitle.ass')
    return subtitle
    
def get_timeout():
    timeout = addon.getSetting('timeout')
    try: timeout = int(timeout)
    except: timeout = None
    return timeout
    
def get_amv_quality():
    amv_quality = addon.getSetting('amv_quality')
    return amv_quality

def get_ani_alt_list(name,cache_only=True):
    alt_list = []
    if addon.getSetting('alt_list') == 'true':
        start_time = time.time()
        from resources.lib.sites import anisearch
        alt_list = anisearch.get_alt_list(name, cache_only)
        complete_time = time.time() - start_time
        print '[plugin.video.animeanime] getting alt list from anisearch in %ss' % (complete_time)
    return alt_list

def find_anime(name, anime_list, clean_burning=False):
    anime = []
    try: name = name.encode('utf-8')
    except: pass
    try: anime = [i for i in anime_list if name == i['name'].encode('utf-8')]
    except: anime = [i for i in anime_list if name == i['name']]
    if not anime and len(name) > 5:
        name = cleantitle(name, clean_burning)
        anime = [i for i in anime_list if name == cleantitle(i['name'], clean_burning)]
        if not anime and clean_burning: anime = [i for i in anime_list if name in cleantitle(i['name'], clean_burning)]
        if not anime and clean_burning: anime = [i for i in anime_list if cleantitle(i['name'], clean_burning) in name]
    return anime

def sort_anime_list_by_site(sites,anime_list):
    sorted_anime_list = []
    for site in sites:
        for anime in anime_list:
            try: anime_site = anime['site']
            except: anime_site = 'genx'
            if anime_site in str(site):
                sorted_anime_list.append(anime)  
    return sorted_anime_list

def get_most_episodes(episodes):
    most_episodes = 0
    for list in episodes:
        if list:
            last_episode = get_last_episode(list)
            if last_episode > most_episodes:
                most_episodes = last_episode
    return most_episodes

def get_last_episode(list):
    last_episode = 0
    for e in list:
        try:
            episode = int(e['episode'])
            if episode > last_episode:
                last_episode = episode
        except:
            pass
    return last_episode
    
def remove_duplicates(list):
    try: all_ids = [ cleantitle(each['name'], clean_burning=False) for each in list ]
    except: all_ids = list
    anime_list = [ list[ all_ids.index(id) ] for id in set(all_ids) ]
    return anime_list
    
def cleantitle(title, clean_burning):
    try: title = title.encode('utf-8')
    except: pass
    title = parse(title)
    if clean_burning:
        new_title = re.sub('\n|([[].+?[]])|([(].+?[)])|\s(vs|v[.])\s|(:|;|-|\~|"|,|\'|\.|\!|\?|\=|\&|/)|\s|(\d{4})|(\d{1})|([(])|([)])', '', title).lower() 
    else:
        new_title = re.sub('\n|([[].+?[]])|\s(vs|v[.])\s|(:|;|-|\~|"|,|\.|\?|\=|\&|/)|\s|([(])|([)])', '', title).lower()
    try: new_title = new_title.encode('utf-8')
    except: pass
    new_title = re.sub("(\’|\´|\`|\\xe2\\x80\\x98)", "'", new_title)
    new_title = re.sub('é|è', 'e', new_title)
    if not new_title.endswith("'"): new_title = re.sub("'", "", new_title)
    if not new_title.endswith("!"): new_title = re.sub("!", "", new_title)
    if len(title) > 4: return new_title
    else: return title

def parse(title):
    try:
        import HTMLParser
        parser = HTMLParser.HTMLParser()
        title = parser.unescape(title)
    except: 
        pass
    return title

def clean(name):
    name = parse(name)
    while name.startswith(' '):
        name = name[1:]
    try: name = name.encode('utf-8')
    except: pass
    return name
    
def cleanfilename(title):
    title = re.sub('(:|;|-|"|,|\'|\.|\?|\=|\&|/)', '', title).lower()
    return title
    
def enter_string(title,entry=None):
    string_entered = None
    kb = xbmc.Keyboard(entry, title, False)
    kb.doModal()
    string_entered = kb.getText()
    return string_entered
    
def get_position(abc):
    alphabet = get_alphabet()
    try:
        position = alphabet.index(abc) + 1
    except:
        position = 1
    return position
    
def get_page(abc,pages):
    position = get_position(abc)
    page = (float(position) / 27) * int(pages)
    page = int(round(page,0))
    if page == 0: page = 1
    return page