# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/GioppyGio/plugin.py
from Components.Label import Label
from Components.ConfigList import ConfigListScreen, ConfigList
from Components.ActionMap import ActionMap
from Components.MenuList import MenuList
from Components.Pixmap import Pixmap
from Plugins.Plugin import PluginDescriptor
from Screens.Screen import Screen
from Screens.MessageBox import MessageBox
from Components.MultiContent import MultiContentEntryText
from enigma import *
import sys, os
from Moduli.Setting import *
from Moduli.Config import *
from Moduli.Select import *
plugin_path = '/usr/lib/enigma2/python/Plugins/Extensions/GioppyGio/Panel/'
from enigma import addFont
try:
	addFont('%s/Raleway-Black.ttf' % plugin_path, 'Rale', 100, 1)
except Exception as ex:
	print ex

class MenuListGioB(MenuList):

	def __init__(self, list):
		MenuList.__init__(self, list, True, eListboxPythonMultiContent)
		self.l.setFont(0, gFont('Rale', 22))
		self.l.setItemHeight(40)


class MenuListGioA(MenuList):

	def __init__(self, list):
		MenuList.__init__(self, list, True, eListboxPythonMultiContent)
		self.l.setFont(0, gFont('Rale', 22))
		self.l.setItemHeight(45)


class MenuGio(Screen):

	def __init__(self, session):
		self.session = session
		skin = '%s/Skin/Main.xml' % os.path.dirname(sys.modules[__name__].__file__)
		f = open(skin, 'r')
		self.skin = f.read()
		f.close()
		Screen.__init__(self, session)
		self['actions'] = ActionMap(['OkCancelActions',
		 'ShortcutActions',
		 'WizardActions',
		 'ColorActions',
		 'SetupActions',
		 'NumberActions',
		 'MenuActions',
		 'HelpActions',
		 'EPGSelectActions'], {'ok': self.keyOK,
		 'up': self.keyUp,
		 'down': self.keyDown,
		 'blue': self.Auto,
		 'yellow': self.Select,
		 'cancel': self.exitplug,
		 'left': self.keyRightLeft,
		 'right': self.keyRightLeft,
		 'red': self.exitplug}, -1)
		self['autotimer'] = Label('')
		self['namesat'] = Label('')
		self['text'] = Label('')
		self['dataDow'] = Label('')
		self['Green'] = Pixmap()
		self['Blue'] = Pixmap()
		self['Yellow'] = Pixmap()
		self['Yellow'].show()
		self['Blue'].show()
		self['Key_Red'] = Label(_('Exit'))
		self['Key_Green'] = Label(_('Installed list:'))
		self['Key_Personal'] = Label('')
		self['A'] = MenuListGioA([])
		self['B'] = MenuListGioB([])
		self['B'].selectionEnabled(1)
		self['A'].selectionEnabled(1)
		self.currentlist = 'B'
		self.ServerOn = True
		self.DubleClick = True
		self.MenuA()
		self.List = DownloadSetting()
		self.MenuB()
		self.iTimer = eTimer()
		if os.path.exists("/var/lib/dpkg/status"):
			self.iTimer_conn = self.iTimer.timeout.connect(self.keyRightLeft)
		else:
			self.iTimer.callback.append(self.keyRightLeft)
		self.iTimer.start(1000, True)
		self.iTimer1 = eTimer()
		if os.path.exists("/var/lib/dpkg/status"):
			self.iTimer1_conn = self.iTimer1.timeout.connect(self.StartSetting)
		else:
			self.iTimer1.callback.append(self.StartSetting)
		self.OnWriteAuto = eTimer()
		if os.path.exists("/var/lib/dpkg/status"):
			self.OnWriteAuto_conn = self.OnWriteAuto.timeout.connect(self.WriteAuto)
		else:
			self.OnWriteAuto.callback.append(self.WriteAuto)
		self.StopAutoWrite = False
		self.ExitPlugin = eTimer()
		if os.path.exists("/var/lib/dpkg/status"):
			self.ExitPlugin_conn = self.ExitPlugin.timeout.connect(self.PluginClose)
		else:
			self.ExitPlugin.callback.append(self.PluginClose)
		self.onShown.append(self.ReturnSelect)
		self.onShown.append(self.Info)

	def PluginClose(self):
		try:
			self.ExitPlugin.stop()
		except:
			pass

		self.close()

	def exitplug(self):
		if self.DubleClick:
			self.ExitPlugin.start(10, True)
			self.DubleClick = False
		else:
			self.PluginClose()

	def Select(self):
		Type, AutoTimer, Personal, NumberSat, NameSat, Date, NumberDtt, DowDate, NameInfo = Load()
		if str(Personal).strip() == '0':
			self['Key_Personal'].setText(_('Favourite: Yes'))
			Personal = '1'
			self.session.open(MenuSelect)
		else:
			self['Key_Personal'].setText(_('Favourite: No'))
			Personal = '0'
		WriteSave(Type, AutoTimer, Personal, NumberSat, NameSat, Date, NumberDtt, DowDate, NameInfo)

	def ReturnSelect(self):
		Type, AutoTimer, Personal, NumberSat, NameSat, Date, NumberDtt, DowDate, NameInfo = Load()
		if not os.path.exists('/usr/lib/enigma2/python/Plugins/Extensions/GioppyGio/Moduli/Settings/Select') or os.path.getsize('/usr/lib/enigma2/python/Plugins/Extensions/GioppyGio/Moduli/Settings/Select') < 20:
			self['Key_Personal'].setText(_('Favourites: No'))
			WriteSave(Type, AutoTimer, '0', NumberSat, NameSat, Date, NumberDtt, DowDate, NameInfo)

	def Auto(self):
		if self.StopAutoWrite:
			return
		self.StopAutoWrite = True
		iTimerClass.StopTimer()
		self.Type, AutoTimer, self.Personal, self.NumberSat, self.NameSat, self.Date, self.NumberDtt, self.DowDate, self.NameInfo = Load()
		if int(AutoTimer) == 0:
			self['autotimer'].setText(_('Auto Update: Yes'))
			self.jAutoTimer = 1
			iTimerClass.TimerSetting()
		else:
			self['autotimer'].setText(_('Auto Update: No'))
			self.jAutoTimer = 0
		self.OnWriteAuto.start(1000, True)

	def WriteAuto(self):
		self.StopAutoWrite = False
		WriteSave(self.Type, self.jAutoTimer, self.Personal, self.NumberSat, self.NameSat, self.Date, self.NumberDtt, self.DowDate, self.NameInfo)

	def Info(self):
		Type, AutoTimer, Personal, NumberSat, NameSat, Date, NumberDtt, DowDate, NameInfo = Load()
		if int(AutoTimer) == 0:
			TypeTimer = 'No'
		else:
			TypeTimer = 'Yes'
		if int(Personal) == 0:
			jPersonal = 'No'
		else:
			jPersonal = 'Yes'
		if str(Date) == '0':
			newdate = ''
		else:
			newdate = ' - ' + ConverDate(Date)
		if str(DowDate) == '0':
			newDowDate = _('Last Update: Never')
		else:
			newDowDate = _('Last Update: ') + DowDate
		self['Key_Personal'].setText(_('Favourite: ') + jPersonal)
		self['autotimer'].setText(_('Auto Update: ') + TypeTimer)
		self['namesat'].setText(NameInfo + newdate)
		self['dataDow'].setText(newDowDate)

	def hauptListEntryMenuA(self, name, type):
		res = [(name, type)]
		res.append(MultiContentEntryText(pos=(35, 7), size=(170, 40), font=0, text=name, flags=RT_HALIGN_CENTER))
		res.append(MultiContentEntryText(pos=(0, 0), size=(4, 0), font=0, text=type, flags=RT_HALIGN_LEFT))
		return res

	def hauptListEntryMenuB(self, NumberSat, Name, jData, NumberDtt):
		res = [(NumberSat,
		  Name,
		  jData,
		  NumberDtt)]
		if NumberDtt == 'xx':
			res.append(MultiContentEntryText(pos=(10, 5), size=(750, 35), font=0, text=Name, flags=RT_HALIGN_LEFT))
			res.append(MultiContentEntryText(pos=(0, 0), size=(0, 0), font=0, text=jData, flags=RT_HALIGN_LEFT))
		else:
			res.append(MultiContentEntryText(pos=(10, 5), size=(460, 35), font=0, text=Name, flags=RT_HALIGN_LEFT))
			res.append(MultiContentEntryText(pos=(470, 5), size=(120, 35), font=0, text=jData, flags=RT_HALIGN_LEFT))
		res.append(MultiContentEntryText(pos=(0, 0), size=(0, 0), font=0, text=NumberDtt, flags=RT_HALIGN_LEFT))
		res.append(MultiContentEntryText(pos=(0, 0), size=(0, 0), font=0, text=NumberSat, flags=RT_HALIGN_LEFT))
		return res

	def MenuA(self):
		self.jA = []
		self.jA.append(self.hauptListEntryMenuA('Mono + DTT', 'mono + dtt'))
		self.jA.append(self.hauptListEntryMenuA('Dual + DTT', 'dual + dtt'))
		self.jA.append(self.hauptListEntryMenuA('Trial', 'trial'))
		self.jA.append(self.hauptListEntryMenuA('Quadri', 'quadri'))
		self.jA.append(self.hauptListEntryMenuA('Motor + DTT', 'motor + dtt'))
		self.jA.append(self.hauptListEntryMenuA('Free IPTV', 'free iptv'))
		self['A'].setList(self.jA)

	def MenuB(self):
		self.jB = []
		if not self.DubleClick:
			self.ServerOn = False
			self.jB.append(self.hauptListEntryMenuB('', _(''), 'xx', 'xx'))
			self.jB.append(self.hauptListEntryMenuB('', _(''), 'xx', 'xx'))
			self.jB.append(self.hauptListEntryMenuB('', _(''), 'xx', 'xx'))
			self.jB.append(self.hauptListEntryMenuB('', _(''), 'xx', 'xx'))
			self.jB.append(self.hauptListEntryMenuB('', _(''), 'xx', 'xx'))
			self.jB.append(self.hauptListEntryMenuB('', _(''), 'xx', 'xx'))
			self['B'].setList(self.jB)
			return
		for NumberSat, NameSat, LinkSat, DateSat, NumberDtt, NameDtt, LinkDtt, DateDtt in self.List:
			if NameSat.lower().find(self['A'].getCurrent()[0][1]) != -1:
				if str(NameDtt) != '0':
					jData = str(DateSat)
					if int(DateDtt) > int(DateSat):
						jData = str(DateDtt)
					self.jB.append(self.hauptListEntryMenuB(NumberSat, NameSat.split('(')[0] + ' + ' + NameDtt, ConverDate(str(jData)), NumberDtt))
				else:
					self.jB.append(self.hauptListEntryMenuB(NumberSat, NameSat, ConverDate(str(DateSat)), '0'))

		if not self.jB:
			self.jB.append(self.hauptListEntryMenuB(_('Server down for maintenance'), '', '', ''))
			self['B'].setList(self.jB)
			self.ServerOn = False
			self.MenuA()
			return
		self['B'].setList(self.jB)

	def keyOK(self):
		if not self.ServerOn:
			return
		if self.currentlist == 'A':
			self.currentlist = 'B'
			self['B'].selectionEnabled(1)
			self['A'].selectionEnabled(0)
			return
		Type, self.AutoTimer, self.Personal, NumberSat, NameSat, self.Date, NumberDtt, self.DowDate, NameInfo = Load()
		self.name = self['B'].getCurrent()[0][1]
		self.NumberSat = self['B'].getCurrent()[0][0]
		self.NumberDtt = self['B'].getCurrent()[0][3]
		self.jType = '1'
		if self.name.lower().find('dtt') != -1:
			self.jType = '0'
		try:
			nData = int(self.Date)
		except:
			nData = 0

		try:
			njData = int(self['B'].getCurrent()[0][2].replace('-', ''))
		except:
			njData = 999999

		if NameSat != self.name or Type != self.jType:
			self.session.openWithCallback(self.OnDownload, MessageBox, _('\nList: %s\nDate: %s\nYour selection is ready to install,\nwant to continue ? \nThis make take a few seconds, please wait ...') % (self.name, self['B'].getCurrent()[0][2]), MessageBox.TYPE_YESNO, timeout=20)
		elif njData > nData:
			self.session.openWithCallback(self.OnDownload, MessageBox, _('\nList: %s\nDate: %s\nYour selection is ready to install,\nwant to continue ? \nThis make take a few seconds, please wait ...') % (self.name, self['B'].getCurrent()[0][2]), MessageBox.TYPE_YESNO, timeout=20)
		else:
			self.session.openWithCallback(self.OnDownloadForce, MessageBox, _('\nList: %s\nDate: %s\nYour selection is already installed,\nwant to continue ? \nThis make take a few seconds, please wait ...'), MessageBox.TYPE_YESNO, timeout=20)

	def OnDownloadForce(self, conf):
		if conf:
			self.OnDownload(True, False)

	def StartSetting(self):
		iTimerClass.StopTimer()
		iTimerClass.startTimerSetting(True)

	def OnDownload(self, conf, noForce = True):
		if conf:
			if noForce:
				WriteSave(self.jType, self.AutoTimer, self.Personal, self.NumberSat, self.name, self.Date, self.NumberDtt, self.DowDate, self.name)
			self.iTimer1.start(100, True)
		else:
			WriteSave(self.jType, self.AutoTimer, self.Personal, self.NumberSat, self.name, '0', self.NumberDtt, self.DowDate, self.name)
		self.Info()

	def keyUp(self):
		self[self.currentlist].up()
		if self.currentlist == 'A':
			self.MenuB()

	def keyDown(self):
		self[self.currentlist].down()
		if self.currentlist == 'A':
			self.MenuB()

	def keyRightLeft(self):
		self['A'].selectionEnabled(0)
		self['B'].selectionEnabled(0)
		if self.currentlist == 'A':
			if not self.ServerOn:
				return
			self.currentlist = 'B'
			self['B'].selectionEnabled(1)
			self.MenuB()
		else:
			self.currentlist = 'A'
			self['A'].selectionEnabled(1)


jsession = None
iTimerClass = GioppyGioSettings(jsession)

def SessionStart(reason, **kwargs):
	if reason == 0:
		iTimerClass.gotSession(kwargs['session'])
	jsession = kwargs['session']


def AutoStart(reason, **kwargs):
	if reason == 1:
		iTimerClass.StopTimer()


def Main(session, **kwargs):
	session.open(MenuGio)


def Plugins(**kwargs):
	return [PluginDescriptor(name='GioppyGio Settings', description='Enigma2 Channel Settings Lists!', icon='/usr/lib/enigma2/python/Plugins/Extensions/GioppyGio/Panel/plugin.png', where=[PluginDescriptor.WHERE_EXTENSIONSMENU, PluginDescriptor.WHERE_PLUGINMENU], fnc=Main), PluginDescriptor(where=PluginDescriptor.WHERE_SESSIONSTART, fnc=SessionStart), PluginDescriptor(where=PluginDescriptor.WHERE_AUTOSTART, fnc=AutoStart)]