#!/bin/sh 
#------------------------------------------------------------------
# Barry Allen by gutemine
#------------------------------------------------------------------
BAVERSION=12.36
LINE="-------------------------------------------------------------"
ENIGMAVERSION="Enigma2"
BAINFO="/.bainfo"
BAINFOTMP="/.bainfotmp"
UNAME=`uname -r`
DEBIAN=wheezy
if [ -e /sbin/fdisk ]; then
   FDISK=/sbin/fdisk
else
   FDISK=/usr/sbin/sfdisk
fi
BAHOME=/media/ba
if [ ! -f /ba ]; then
      ln -sfn $BAHOME /ba  > /dev/null 2>&1
fi
SYNC=0
if [ `ls -al /usr/bin/du | grep alterna | wc -l` -gt 0 -o  `ls -al /usr/bin/du | grep busybox | wc -l` -gt 0 ]; then
   DLIMIT="-d 0"
else
   DLIMIT="--max-depth=0"
fi
BABOOT=$BAHOME/baboot.ini
BAPLUGIN=/usr/lib/enigma2/python/Plugins/Extensions
BAROOT=$BAHOME
BALOG=$BAHOME/.balog
BAIMAGE=$BAHOME/backup

if [ -d /media/hdd/backup ]; then
	BAIMAGE=/media/hdd/backup
else
	MOUNTS=`ls /media/`
	for MOUNT in $MOUNTS; 
	do
	if [ $BAIMAGE == $BAHOME/backup -a -d /media/$MOUNT/backup ]; then
		BAIMAGE=/media/$MOUNT/backup
	fi
	done
fi
if [ $BAIMAGE == $BAHOME/backup ]; then
if [ -d /media/net ]; then
	MOUNTS=`ls /media/net`
	for MOUNT in $MOUNTS; 
	do
	if [ $BAIMAGE  == $BAHOME/backup -a -d /media/net/$MOUNT/backup ]; then
		BAIMAGE=/media/net/$MOUNT/backup
	fi
	done
fi
fi
if [ $BAIMAGE == $BAHOME/backup ]; then
if [ -d /autofs ]; then
	MOUNTS=`ls /autofs`
	for MOUNT in $MOUNTS; 
	do
	if [ $BAIMAGE == $BAHOME/backup -a -d /autofs/$MOUNT/backup ]; then
		BAIMAGE=/autofs/$MOUNT/backup
	fi
	done
fi
fi
BAIMAGELIST=/tmp/.baimages
BAMAXIMAGES=13
BAMAXLEN=60
BAMINFREE=384
BADEBIANMINFREE=5120
INSTALLDIR=/tmp
BATMP=$INSTALLDIR/.batmp
BATMP2=$INSTALLDIR/.batmp2
BATMPSCRIPT=$INSTALLDIR/batmp.sh
BASWAPSIZE=512000
BAMINSWAPSIZE=512000
DREAMBOXUPDATEHOST=oozoon-dreamboxupdate.de
BANFIIMAGESTMP=$INSTALLDIR/.badownloads
BAUPDATECONFIG=".baupdate"
VERSION=$BAVERSION
DPKGSTATUS=/var/lib/dpkg/status
length=`echo $1 | wc -c | cut -c1-8`
length=`expr $length "-" 1`
ECHO="echo"
if [ -d /usr/lib/enigma2/python/Plugins/Extensions ]; then
   if [ ! -e /usr/lib/enigma2/python/Plugins/Extensions/BarryAllen ]; then
      ln -sfn /media/ba/BarryAllen /usr/lib/enigma2/python/Plugins/Extensions/BarryAllen 
   fi
fi
MTDBOOT="2"
MTDROOT="3"
BOXTYPE=unknown
if [ `uname -r | grep dm7080 | wc -l` -gt 0 ]; then   
	BOXTYPE=dm7080
fi
if [ `uname -r | grep dm820 | wc -l` -gt 0 ]; then   
	BOXTYPE=dm820
fi
if [ `uname -r | grep dm520 | wc -l` -gt 0 ]; then   
	BOXTYPE=dm520
fi
CACHED=""
CACHED=""
BLOCKSIZE=512
OPTIONS=" -e 0x4000 -n -l"
UBIOPTIONS="-m 512 -e 15KiB -c 3735 -F"
UBINIZE_OPTIONS="-m 512 -p 16KiB -s 512"
UBINIZECFG="/tmp/ubinize.cfg"
UBICOMPRESSION="zlib"
SUBDIR=$BOXTYPE
echo $LINE
echo "Barry Allen Version $BAVERSION on $BOXTYPE" 
PART1="1"                                                                    
PART2="2"                                                            
PART3="3"                                                            
PART4="4"                                                         
PART5="5"                                                                    
PART6="6"                                                                    
PART7="7"                                                                    
PART8="8"                                                                    
PART9="9"                                                                    
PART10="10"                                                                    
PART11="11"                                                                    
PART12="12"                                                                    
echo $LINE
if [ `id -un` != "root" ]; then
   $ECHO "not root user, sorry !"
   echo $LINE
   exit 1
fi
if [ -e $BAHOME/ba.sh ]; then
   if [ ! -f $BAHOME/.bafatcheck ]; then
      ln -sfn $BAHOME/ba.sh $BAHOME/.bafatcheck
   fi
   if [ ! -f $BAHOME/.bafatcheck ]; then
      $ECHO "link on Barry Allen device not possible - maybe FAT, sorry !"
      $ECHO "Or read only mounted because dirty filesystem, maybe try filesystemcheck."
      echo $LINE
      exit 1
   fi
   rm $BAHOME/.bafatcheck > /dev/null 2>&1
   
   if [ ! -e /ba ]; then
      ln -sfn $BAHOME /ba
   fi
   if [ ! -e /ba ]; then
      $ECHO "link in Flash not possible - maybe Flash full, sorry !"
      echo $LINE
      exit 1
   fi
fi
# check for missing bainit link
if [ ! -f /sbin/bainit ]; then
   cp $BAHOME/bin/bainit /sbin/bainit > /dev/null 2>&1
   if [ ! -f /$BAINFO  ]; then
      ln -sfn /sbin/bainit /sbin/init > /dev/null 2>&1
   fi
fi 
case "$1" in
settingsreset | settings_reset)
rm /etc/enigma2/* /etc/network/interfaces /etc/wpa_supplicant.conf > /dev/null 2>&1
$ECHO "enigma2 settings removed, restarting enigma2"
echo $LINE
killall -9 enigma2 > /dev/null 2>&1
;;
settingsbackup | settings_backup)
   if [ ! -d $BAHOME/backup ]; then
      mkdir $BAHOME/backup
   fi
   DATE=`date +"%Y-%m-%d"`
   BACKUP="$BAHOME/backup/"$DATE"-enigma2settingsbackup.tar.gz"
   $ECHO "doing enigma2 settings backup to $BACKUP"
   echo $LINE
   rm $BACKUP >	/dev/null 2>&1
   if [ -f /etc/wpa_supplicant.conf ]; then
      tar -czvf $BACKUP  /etc/enigma2/ /etc/wpa_supplicant.conf /etc/resolv.conf
   else
      tar -czvf $BACKUP  /etc/enigma2/ /etc/resolv.conf
   fi
   chmod 777 $BACKUP > /dev/null 2>&1
   echo $LINE
   $ECHO "Finished"
   echo $LINE
   ;;
settingsrestore | settings_restore)
   if [ ! -d $BAHOME/backup ]; then
      mkdir $BAHOME/backup
   fi
   DATE=`date +"%Y-%m-%d"`
   if [ $# -lt 2 ]; then
      if [ `ls $BAHOME/backup/*enigma2settingsbackup.tar.gz | wc -l` -gt 0 ]; then
         BACKUP=`ls $BAHOME/backup/*enigma2settingsbackup.tar.gz | tail -n 1`
      else
         BACKUP="$BAHOME/backup/"$DATE"-enigma2settingsbackup.tar.gz"
      fi > /dev/null 2>&1
   else
      BACKUP=$BAHOME/backup/$2.tar.gz
   fi
   if [ ! -f $BACKUP ]; then
      $ECHO "ERROR: Settings Backup $BACKUP not found"
      echo $LINE
      $ECHO "trying now at /media/hdd/backup"
      echo $LINE
      if [ $# -lt 2 ]; then
         if [ `ls /media/hdd/backup/*enigma2settingsbackup.tar.gz | wc -l` -gt 0 ]; then
            BACKUP=`ls /media/hdd/backup/*enigma2settingsbackup.tar.gz | tail -n 1`
         else
            BACKUP="/media/hdd/backup/"$DATE"-enigma2settingsbackup.tar.gz"
         fi > /dev/null 2>&1
      else
         BACKUP=/media/hdd/backup/$2.tar.gz
      fi
      if [ ! -f $BACKUP ]; then
         $ECHO "ERROR: Settings Backup $BACKUP not found"
         echo $LINE
         exit 1
      fi
   fi
   $ECHO "doing enigma2 settings restore from $BACKUP"
   echo $LINE
   cd /
   tar -xvzf $BACKUP
   echo $LINE
   $ECHO "Barry Allen restarts $ENIGMAVERSION now"
   echo $LINE
   killall -9 enigma2 > /dev/null 2>&1
   $ECHO "Finished"
   echo $LINE
   ;;
   "bootfont")
      if [ $# -lt 2 ]; then
         $ECHO "no new bootmanager font passed, using standard"
         echo $LINE
         cp $BAHOME/fonts/standard.ttf $BAHOME/fonts/barryallen.ttf
         exit 0
      fi
      NEWFONT=$2
      if [ $NEWFONT = "barryallen.ttf"  ]; then
         $ECHO "keeping current bootmanager font"
         echo $LINE
         exit 0
      fi
      if [ ! -f $BAHOME/fonts/$NEWFONT ]; then
         $ECHO "new bootmanager font $NEWFONT does not exist, using standard"
         cp $BAHOME/fonts/standard.ttf $BAHOME/fonts/barryallen.ttf
         echo $LINE
         exit 0
      fi
      $ECHO "new bootmanager font will be $NEWFONT"
      echo $LINE
      cp $BAHOME/fonts/$NEWFONT $BAHOME/fonts/barryallen.ttf
      ;;
   "bootlogo")
      if [ $# -lt 2 ]; then
         $ECHO "no new bootmanager logo passed, using no bootlogo"
         echo $LINE
	 rm $BAHOME/logos/barryallen.jpg > /dev/null 2>&1
         exit 0
      fi
      NEWLOGO=$2
      if [ $NEWLOGO = "barryallen.jpg" ]; then
         $ECHO "keeping current bootmanager logo"
         echo $LINE
         exit 0
      fi
      if [ ! -f $BAHOME/logos/$NEWLOGO ]; then
         $ECHO "new bootmanager logo $NEWLOGO does not exist, using standard"
         cp $BAHOME/logos/standard.jpg $BAHOME/logos/barryallen.jpg > /dev/null 2>&1
         echo $LINE
         exit 0
      fi
      $ECHO "new bootmanager logo will be $NEWLOGO"
      echo $LINE
      if [ `echo $NEWLOGO | cut -d"." -f 2 | grep jpg | wc -l` ]; then
	 cp $BAHOME/logos/$NEWLOGO > $BAHOME/logos/barryallen.jpg
      else
	      $ECHO "new bootmanager logo should be a jpg"
	      echo $LINE
      fi
      ;;
      bootmanager )
      OPTION=enable
      if [ $# -gt 1 ]; then
         OPTION=$2
      fi
      case $OPTION in 
      "enable")
         $ECHO "enabling bootmanager"
         rm $BAHOME/.banobootmanager > /dev/null 2>&1
         rm $BAHOME/.wwbootmanager > /dev/null 2>&1
         ;;
      "disable")
         $ECHO "disabling bootmanager"
         rm $BAHOME/.wwbootmanager > /dev/null 2>&1
         touch $BAHOME/.banobootmanager
         ;;
      "wobble")
	 if [ ! -d $BAHOME/boot ]; then
            $ECHO "Sorry, no bootmanager wobble without Wally West FAT Partition"
	    echo $LINE
            exit 0
         fi
         $ECHO "wobble bootmanager"
         touch $BAHOME/.banobootmanager
         touch $BAHOME/.wwbootmanager 
         ;;
      "progress")
	 $ECHO "enabling bootmanager timeout progress"
         touch $BAHOME/.baprogress 
         echo $LINE
         exit 0
         ;;
      "noprogress")
	 $ECHO "disabling bootmanager timeout progress"
         rm $BAHOME/.baprogress > /dev/null 2>&1
         echo $LINE
         exit 0
         ;;
      *)
         $ECHO "Invalid option, use only bootmanager enable|disable|wobble|progress|noprogress"
         echo $LINE
	 exit 0
      esac
      # make sure that FAT is properly filled
      $BAHOME/ba.sh boot Flash
      ;;
      enablebootlogo | enable_bootlogo )
      $ECHO "enabling bootlogo"
      echo $LINE
      rm $BAHOME/.banologo > /dev/null 2>&1
      ;;
      disablebootlogo | disable_bootlogo )
      $ECHO "disabling bootlogo"
      echo $LINE
      touch $BAHOME/.banologo 
      ;;
      enablebapostinst | enable_bapostinst )
   if [ $# -lt 2 ]; then
      $ECHO "No bapostinst name passed  - bapostinst.template will be used"
      echo $LINE
      TARGET=bapostinst.template
   else
      TARGET=$2
      if [ ! -f $BAHOME/script/$TARGET ]; then
         $ECHO "ERROR: $BAHOME/script/$TARGET is not existing"
         echo $LINE
         exit 1
      fi
   fi
      $ECHO "enabling $TARGET"
      echo $LINE
      cp $BAHOME/scripts/$TARGET $BAHOME/script/bapostinst
      chmod 755 $BAHOME/bapostinst
      ;;
   disablebapostinst | disable_bapostinst )
      $ECHO "disabling bapostinst"
      echo $LINE
      rm $BAHOME/script/bapostinst > /dev/null 2>&1
      ;;
   "start" | "boot")
   if [ $# -lt 2 ]; then
      $ECHO "No Target Image passed  - Flash will be used"
      echo $LINE
      TARGET="Flash"
   else
      TARGET=$2
   fi

if [ $TARGET  != "Flash" ]; then
   if [ -f $BAHOME/.balocked ]; then
      if [ $# -lt 3 ]; then
         $ECHO "ERROR: no PIN passed"
         echo $LINE
         exit 1
      else
         if [ $# -gt 3 ]; then
            NEWPIN=`echo -n $4 | md5sum | cut -d" " -f 1`
         else 
            NEWPIN=`echo -n $3 | md5sum | cut -d" " -f 1`
         fi
         
         OLDPIN=`cat $BAHOME/.balocked`
         if [ $OLDPIN != $NEWPIN ]; then
            $ECHO "ERROR: PIN doesn't match"
            echo $LINE
            exit 1
         else
            $ECHO "PIN matches, continuing"
            echo $LINE
         fi
      fi
   fi
   if [ ! -d $BAHOME/ba/$TARGET ]; then
      $ECHO "ERROR: Target Image Directory $BAHOME/ba/$TARGET is not existing"
      echo $LINE
      exit 1
   fi
BAROOT=`mount | grep $BAHOME | grep -v swap | head -n 1 | cut -d" " -f 1`
echo $BAROOT > $BATMP 
sed -ie s!"1"!""!g $BATMP
sed -ie s!"2"!""!g $BATMP
sed -ie s!" "!""!g $BATMP
BAROOT=`cat $BATMP`
$FDISK -l > $BATMP 2>&1
if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART5 | wc -l` -gt 0 ]; then
   mkdir $BAHOME/ba/1 > /dev/null 2>&1
   mount $BAROOT$PART5 $BAHOME/ba/1 > /dev/null 2>&1
fi
if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART6 | wc -l` -gt 0 ]; then
   mkdir $BAHOME/ba/2 > /dev/null 2>&1
   mount $BAROOT$PART6 $BAHOME/ba/2 > /dev/null 2>&1
fi
if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART7 | wc -l` -gt 0 ]; then
   mkdir $BAHOME/ba/3 > /dev/null 2>&1
   mount $BAROOT$PART7 $BAHOME/ba/3 > /dev/null 2>&1
fi
if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART8 | wc -l` -gt 0 ]; then
   mkdir $BAHOME/ba/4 > /dev/null 2>&1
   mount $BAROOT$PART8 $BAHOME/ba/4 > /dev/null 2>&1
fi
if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART9 | wc -l` -gt 0 ]; then
   mkdir $BAHOME/ba/5 > /dev/null 2>&1
   mount $BAROOT$PART9 $BAHOME/ba/5 > /dev/null 2>&1
fi
if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART10 | wc -l` -gt 0 ]; then
   mkdir $BAHOME/ba/6 > /dev/null 2>&1
   mount $BAROOT$PART10 $BAHOME/ba/6 > /dev/null 2>&1
fi
if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART11 | wc -l` -gt 0 ]; then
   mkdir $BAHOME/ba/7 > /dev/null 2>&1
   mount $BAROOT$PART11 $BAHOME/ba/7 > /dev/null 2>&1
fi
if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART12 | wc -l` -gt 0 ]; then
   mkdir $BAHOME/ba/8 > /dev/null 2>&1
   mount $BAROOT$PART12 $BAHOME/ba/8 > /dev/null 2>&1
fi

   if [ -d $BAHOME/ba/$TARGET -a ! -f $BAHOME/ba/$TARGET/$BAINFO ]; then
      $ECHO "ERROR: Target Image Directory $BAHOME/ba/$TARGET is empty"
      echo $LINE
      exit 1
   fi
   if [ -d $BAHOME/ba/$TARGET -a ! -d $BAHOME/ba/$TARGET/boot ]; then
      $ECHO "ERROR: Target Image Directory $BAHOME/ba/$TARGET is empty"
      echo $LINE
      exit 1
   fi
fi
echo $TARGET > $BABOOT

# if WW is found there is some more work to be done
if [ `grep "$BAHOME " /proc/mounts | grep -v swap | grep -v /media/ba/ba | wc -l` -gt 0 ]; then
  echo $TARGET > $BATMP
  # get WW device
  WWDEVICE=`grep $BAHOME /proc/mounts | grep -v swap | grep -v /media/ba/ba | tail -n 1 | cut -d" " -f 1`
  if [ $WWDEVICE != "/dev/root" ]; then
     ln -sfn $WWDEVICE /dev/root
  fi
# check if WW formatted already       
WWDEVICE=`mount | grep $BAHOME | grep -v swap | head -n 1 | cut -d" " -f 1`
echo $WWDEVICE > $BATMP                        
sed -ie s!"2"!"1"!g $BATMP            
WWDEVICE=`cat $BATMP`          
export LD_LIBRARY_PATH=$BAHOME/bin
$BAHOME/bin/e2label $WWDEVICE > $BATMP 2>&1 
######### make WW check fail until supported
#if [ `grep BA $BATMP | wc -l` -eq 0 -a `grep ba $BATMP | wc -l` -eq 0 ]; then
if [ 1 -eq 0 ]; then
  $ECHO "Wally West FAT is on $WWDEVICE"
  mkdir $BAHOME/boot > /dev/null 2>&1
  mount -t vfat $WWDEVICE $BAHOME/boot > /dev/null 2>&1
  if [ `mount | grep $BAHOME/boot | wc -l` -eq 0 ]; then
     mount  -t msdos $WWDEVICE $BAHOME/boot > /dev/null 2>&1
     if [ `mount | grep $BAHOME/boot | wc -l` -eq 0 ]; then
        mount  $WWDEVICE $BAHOME/boot > /dev/null 2>&1
        if [ `mount | grep $BAHOME/boot | wc -l` -eq 0 ]; then
           $ECHO "sorry, can not mount FAT"
           echo $LINE
           exit 0
        fi
     fi
  fi
  WALLY=boot
  if [ $TARGET != "Flash" ]; then
  if [ -f $BAHOME/.wwbootmanager ]; then
     echo $LINE
     $ECHO "wobble Bootmanager is enabled ..."
     echo $LINE
     touch $BAHOME/.banobootmanager 
  fi
  if [ -f $BAHOME/.banobootmanager ]; then
     $ECHO "filling Wally West FAT with /boot from $TARGET ..."
     echo $LINE
     cp $BAHOME/ba/$TARGET/boot/bootlogo-$BOXTYPE.jpg $BAHOME/boot > /dev/null 2>&1
     cp $BAHOME/ba/$TARGET/boot/bootlogo-$BOXTYPE.elf.gz $BAHOME/boot > /dev/null 2>&1
     cp $BAHOME/ba/$TARGET/boot/vmlinux-$UNAME.gz $BAHOME/boot > /dev/null 2>&1
  else
     $ECHO "Bootmanager is enabled, Wally West FAT will stay empty ..."
     rm $BAHOME/boot/* > /dev/null 2>&1
     echo $LINE
  fi
fi
  if [ ! -f $BAHOME/.banobootmanager -o $TARGET = "Flash" ]; then
     umount /boot > /dev/null 2>&1
     mount /boot > /dev/null 2>&1
     # if bootmanager autorun.bat has to go
     rm $BAHOME/boot/auto*.bat > /dev/null 2>&1
     rm $BAHOME/boot/bootlogo*.elf > /dev/null 2>&1
     rm $BAHOME/boot/*.jpg > /dev/null 2>&1
     rm $BAHOME/boot/vmlinux*.gz > /dev/null 2>&1
  else
     BOOTCONSOLE="console=ttyS0,115200"
     ROOTDELAY=0
     if [ $TARGET = "1" -o $TARGET = "2" -o $TARGET = "3" -o $TARGET = "4" -o $TARGET = "5" -o $TARGET = "6" -o $TARGET = "7" -o $TARGET = "8" ]; then
        BAINIT="init=/sbin/bainit"
        if [ $BOXTYPE == "dm800" ]; then   
           BOOTFS="rootfstype=ext3"
        else
           BOOTFS="rootfstype=ext4"
        fi
        ROOTDELAY=10
        if [ -f $BAHOME/.barootdelay ]; then
           ROOTDELAY=`cat $BAHOME/.barootdelay`
        fi
        BOOTDELAY="rootdelay=$ROOTDELAY"
        PARTNUM=`expr $TARGET "+" 4`
        BOOTRW="rw"
        echo $WWDEVICE > $BATMP                        
        sed -ie s!"1"!""!g $BATMP            
        IMAGEDEVICE=`cat $BATMP`          
        gunzip -c $BAHOME/ba/$TARGET/boot/vmlinux-*dm*.gz > /tmp/vmlinux   
        if [ `grep Jumpin /tmp/vmlinux | wc -l` -gt 0 ]; then
           $ECHO "initramfs found, using label root mount"
           BOOTDEVICE="root=LABEL=$TARGET rootpart=$PARTNUM"
           touch  $BAHOME/ba/$TARGET/autoexec_$BOXTYPE.bat
        else
           # initramfs not found
           BOOTDEVICE="root=$IMAGEDEVICE$PARTNUM"
        fi
     else
        BAINIT="init=/sbin/init"
        BOOTDEVICE="root=/dev/mtdblock3"
        BOOTFS="rootfstype=jffs2"
        BOOTDELAY=""
        BOOTRW="rw"
     fi
     if [ $TARGET = "Flash" ]; then
        BOOTCONSOLE="console=ttyS0,115200"
        BAINIT=""
        BOOTDEVICE=""
        BOOTFS=""
        WALLY="flash"
        BOOTDELAY=""
        BOOTRW=""
     fi
     rm $BAHOME/boot/autoexec_*.bat > /dev/null 2>&1
     echo "/$WALLY/bootlogo-$BOXTYPE.elf.gz filename=/boot/bootlogo-$BOXTYPE.jpg" > $BAHOME/boot/autoexec_$BOXTYPE.bat
     UNAME=`uname -r`
     if [ `mount | grep $BAHOME/ba/1 | wc -l` -gt 0  ]; then
        echo "/$WALLY/vmlinux-$UNAME.gz $BOOTCONSOLE $BAINIT $BOOTDELAY $BOOTDEVICE $BOOTFS $BOOTRW" >>  $BAHOME/boot/autoexec_$BOXTYPE.bat
     else
        echo "/$WALLY/vmlinux-$UNAME.gz root=/dev/mtdblock3 rootfstype=jffs2 rw console=ttyS0,115200" >>  $BAHOME/boot/autoexec_$BOXTYPE.bat
     fi
     echo $LINE
     echo "autoexec_$BOXTYPE.bat"
     echo $LINE
     cat  $BAHOME/boot/autoexec_$BOXTYPE.bat
     echo $LINE
  fi
  chmod 777 $BAHOME/boot/autoexec_$BOXTYPE.bat > /dev/null 2>&1
  fi
fi
sync && echo 3 > /proc/sys/vm/drop_caches 
umount $BAHOME/boot > /dev/null 2>&1
cp /etc/enigma2/*auth*.bin $BAHOME/ba/$TARGET/etc/enigma2 > /dev/null 2>&1
cp /etc/enigma2/ci*.xml $BAHOME/ba/$TARGET/etc/enigma2 > /dev/null 2>&1
cp /*auth*.bin $BAHOME/ba/$TARGET > /dev/null 2>&1

if [ $# -gt 2 ]; then
   NOW="now$3"
   if [ $NOW = "nownow" ]; then
      if [ $TARGET != "Flash" ]; then
         $ECHO "Barry Allen boots Image $TARGET at $BAHOME/ba/$TARGET ..."
      else
         $ECHO "Barry Allen boots Flash ..."
      fi
      echo $LINE
      $ECHO "Barry Allen reboots Dreambox now ..."
      echo $LINE
      if [ -e /bin/systemctl ]; then
         sync && echo 3 > /proc/sys/vm/drop_caches 
         systemctl reboot > /dev/null 2>&1
      else
	 init 4 > /dev/null 2>&1
         sleep 5
         sync && echo 3 > /proc/sys/vm/drop_caches 
         shutdown -r now > /dev/null 2>&1
      fi
      exit 0
   fi
fi
if [ $TARGET != "Flash" ]; then
   $ECHO "Barry Allen boots Image $TARGET at $BAHOME/ba/$TARGET on next reboot ..."
else
   $ECHO "Barry Allen boots Flash on next reboot ..."
fi
echo $LINE
;;
  restart)
      $ECHO "Barry Allen restarts $ENIGMAVERSION now"
      echo $LINE
      if [ -e /bin/systemctl ]; then
         sync && echo 3 > /proc/sys/vm/drop_caches 
         systemctl restart enigma2 > /dev/null 2>&1
      else
	 init 4 > /dev/null 2>&1
         sleep 5
         sync && echo 3 > /proc/sys/vm/drop_caches 
	 init 3 > /dev/null 2>&1
      fi
      exit 0
  ;;
  shutdown | halt)
      $ECHO "Barry Allen halts Dreambox now ..."
      echo $LINE
      if [ -e /bin/systemctl ]; then
         sync && echo 3 > /proc/sys/vm/drop_caches 
         systemctl halt > /dev/null 2>&1
      else
	 init 4 > /dev/null 2>&1
         sleep 5
         sync && echo 3 > /proc/sys/vm/drop_caches 
         shutdown -h now > /dev/null 2>&1
      fi
      exit 0
  ;;
  reboot)
      $ECHO "Barry Allen reboots Dreambox now ..."
      echo $LINE
      sync
      sync
      if [ -e /bin/systemctl ]; then
         sync && echo 3 > /proc/sys/vm/drop_caches 
         systemctl reboot > /dev/null 2>&1
      else
	 init 4 > /dev/null 2>&1
         sleep 5
         sync && echo 3 > /proc/sys/vm/drop_caches 
         shutdown -h now > /dev/null 2>&1
      fi
      exit 0
  ;;
  extract )
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: no filename given for extracting from $BAIMAGE"
     echo $LINE
     exit 1
  else
     SOURCE=$2
     if [ $# -gt 2 ]; then
        TARGET=$3
     else
        TARGET=$2
     fi
  fi
  if [ ! -f $BAIMAGE/$SOURCE.tar.gz -a ! -f $BAIMAGE/$SOURCE.tar.xz ]; then
     $ECHO "ERROR: Image File $BAIMAGE/$SOURCE.*z is not existing"
     echo $LINE
     exit 1
  fi
  if [ $BOOTED = $TARGET ]; then
     $ECHO "ERROR: Image $BAHOME/ba/$TARGET currently booted, can't extract there"
     echo $LINE
     exit 1
  fi
  if [ $TARGET = "Flash" ]; then
     $ECHO "ERROR: can't extract to Flash, use standard WebIF Flashing or DreamUP or dFlash"
     echo $LINE
     exit 1
  fi
  if [ `ls -1 $BAHOME/ba | grep -v Flash | wc -l` -gt `expr $BAMAXIMAGES "-" 1` ]; then
     $ECHO "ERROR: maximum $BAMAXIMAGES images reached"
     echo $LINE
     exit 1
  fi
  if [ -d $BAHOME/ba/$TARGET -a -f $BAHOME/ba/$TARGET/$BAINFO ]; then
     $ECHO "Target $TARGET already exists, delete first"
     echo $LINE
     exit 1
  fi

  length=`echo $TARGET | wc -c | cut -c1-8`
  length=`expr $length "-" 1`
  if [ $length -gt $BAMAXLEN ]; then
     $ECHO "Target name $TARGET too long"
     echo $LINE
     exit 1
  fi

  df -m > $BATMP 2>&1
  DF=`grep $BAROOT $BATMP | grep -v "no such"`
  FREE=100
  NUMBER=1
  for ITEM in $DF; do
      if [ $NUMBER = 4 ]; then
         FREE=$ITEM
      fi
      if [ $NUMBER = 3 ]; then
         FREE2=$ITEM
      fi
      NUMBER=`expr $NUMBER "+" 1`
  done
  if [ `echo $FREE | grep "%" | wc -l` -gt 0 ]; then
     FREE=$FREE2
  fi
  if [ $FREE -lt $BAMINFREE ]; then 
     $ECHO "only $FREE MB free on $BAROOT, sorry"
     echo $LINE
     exit 1
  fi
if [ $SYNC -eq 1 ]; then
   mount -o remount,async $BAHOME
fi
mkdir $BAHOME/ba/$TARGET > /dev/null 2>&1
cd $BAHOME/ba/$TARGET
$ECHO "extracting $BAIMAGE/$SOURCE.tar.*z"
$ECHO "to $BAHOME/ba/$TARGET ..."
if [ -f $BAIMAGE/$SOURCE.tar.gz ]; then
   rm $BAIMAGE/$SOURCE.tar > /dev/null 2>&1
   $BAHOME/bin/pigz -d -k $BAIMAGE/$SOURCE.tar.gz  > /dev/null 2>&1
   tar -xf $BAIMAGE/$SOURCE.tar  > /dev/null 2>&1
#  tar -xzf $BAIMAGE/$SOURCE.tar.gz  > /dev/null 2>&1
else
   rm $BAIMAGE/$SOURCE.tar > /dev/null 2>&1
   $BAHOME/bin/xz -d -T 0 -k $BAIMAGE/$SOURCE.tar.xz  > /dev/null 2>&1
   tar -xf $BAIMAGE/$SOURCE.tar > /dev/null 2>&1
fi
rm $BAIMAGE/$SOURCE.tar > /dev/null 2>&1

mkdir dev proc sys media var tmp > /dev/null 2>&1
cd media
mkdir cf card cifs dvd hdd mmc1 net nfs ram realroot union usb > /dev/null 2>&1
mkdir -p $BAHOME/ba/$TARGET/sbin > /dev/null 2>&1
mkdir $BAHOME/ba/$TARGET/boot  > /dev/null 2>&1
cp $BAHOME/bin/bainit $BAHOME/ba/$TARGET/sbin
mkdir -p $BAHOME/ba/$TARGET/media > /dev/null 2>&1
rm $BAHOME/ba/$TARGET/$BAHOME > /dev/null 2>&1
mkdir -p $BAHOME/ba/$TARGET/$BAHOME > /dev/null 2>&1
cd $BAHOME/ba/$TARGET
#ln -sfn /media/hdd hdd > /dev/null 2>&1
#ln -sfn /media mnt > /dev/null 2>&1
mkdir -p $BAHOME/ba/$TARGET/var/volatile/tmp > /dev/null 2>&1
mkdir -p $BAHOME/ba/$TARGET/var/volatile/cache > /dev/null 2>&1
mkdir -p $BAHOME/ba/$TARGET/home > /dev/null 2>&1
mkdir -p $BAHOME/ba/$TARGET/home/root > /dev/null 2>&1
ln -sfn $BAHOME/ba.sh $BAHOME/ba/$TARGET/home/root/ba.sh > /dev/null 2>&1
ln -sfn $BAHOME/ba.sh $BAHOME/ba/$TARGET/sbin/ba.sh > /dev/null 2>&1
if [ -f $BAHOME/ba/$TARGET/var/lib/dpkg/status ]; then
   sed -ie s!"-barryallen"!"-nobarryallen"!g $BAHOME/ba/$TARGET/var/lib/dpkg/status 
fi
if [ -d $BAHOME/ba/$TARGET/usr/lib/enigma2/python/Plugins/Extensions ]; then
   if [ -d $BAHOME/ba/$TARGET/usr/lib/enigma2/python/Plugins/Extensions/BarryAllen ]; then
      rm -r $BAHOME/ba/$TARGET/usr/lib/enigma2/python/Plugins/Extensions/BarryAllen > /dev/null 2>&1
   fi
   ln -sfn $BAHOME/BarryAllen $BAHOME/ba/$TARGET/usr/lib/enigma2/python/Plugins/Extensions/BarryAllen 
fi
  rm $BAHOME/ba/$TARGET* > /dev/null 2>&1
  if [ $TARGET == "0" -o $TARGET == "1" -o $TARGET == "2" -o $TARGET == "3" -o $TARGET == "4" -o $TARGET == "5" -o $TARGET == "6" -o $TARGET == "7" -o $TARGET == "8" ]; then
     if [ $# -gt 3 ]; then
        TARGETNAME=$4
        $ECHO "naming image $TARGET as $TARGETNAME"
        echo $LINE
        echo $TARGETNAME > $BAHOME/ba/$TARGET/$BAINFO
     else
        echo $TARGET > $BAHOME/ba/$TARGET/$BAINFO 
     fi
  else
     echo $TARGET > $BAHOME/ba/$TARGET/$BAINFO 
  fi
  if [ -f $BAHOME/script/bapostinst ]; then
     $ECHO "executing bapostinst"
     echo $LINE
     sh $BAHOME/script/bapostinst $BAHOME/ba/$TARGET
     # make sure ...
     cd $BAHOME
     umount /media/ba/ba/$TARGET > /dev/null 2>&1
  fi
  if [ $SYNC -eq 1 ]; then
     mount -o remount,sync $BAHOME
  fi
  $ECHO "Extract finished"
  echo $LINE
  ;;
  restore_hdd)
  if [ -f /$BAINFO ]; then
     $ECHO "should be called when booted from Flash"
     echo $LINE
     exit 1
  fi
  if [ ! -d /media/hdd/ba ]; then
     $ECHO "nothing to restore from /media/hdd/ba, sorry"
     echo $LINE
     exit 1
  fi
  $ECHO "Erases all existing Barry Allen image at /media/ba/ba in 60 sec !"
  $ECHO "Press CTRL + C to interrupt this if unwanted NOW !"
  echo $LINE
  sleep 60
  $ECHO "Barry Allen stops $ENIGMAVERSION now"
  echo $LINE
  if [ -e /bin/systemctl ]; then
     systemctl stop enigma2 > /dev/null 2>&1
  else
     init 4 > /dev/null 2>&1
     sleep 5
  fi
  umount $BAHOME/ba/Flash > /dev/null 2>&1
  rm -r $BAHOME/ba >  /dev/null 2>&1
  cp -r -d /media/hdd/ba $BAHOME
  echo $LINE
  $ECHO "Barry Allen starts $ENIGMAVERSION now"
  if [ -e /bin/systemctl ]; then
     systemctl start enigma2 > /dev/null 2>&1
  else
     init 3 > /dev/null 2>&1
  fi
  echo $LINE
  $ECHO "Finished"
  echo $LINE
  ;;
  backup_hdd)
  if [ -f /$BAINFO ]; then
     $ECHO "should be called when booted from Flash"
     echo $LINE
     exit 1
  fi
  if [ -d /media/hdd/ba ]; then 
     $ECHO "Erases last Barry Allen backup at /media/hdd/ba in 60 sec !"
     $ECHO "Press CTRL + C to interrupt this if unwanted NOW !"
     echo $LINE
     sleep 60
  fi
  $ECHO "Barry Allen stops $ENIGMAVERSION now"
  echo $LINE
  if [ -e /bin/systemctl ]; then
     systemctl stop enigma2 > /dev/null 2>&1
  else
     init 4 > /dev/null 2>&1
  fi
  rm -r /media/hdd/ba > /dev/null 2>&1
  umount $BAHOME/ba/Flash > /dev/null 2>&1
  rm -r $BAHOME/ba/Flash > /dev/null 2>&1
  mkdir /media/hdd/ba > /dev/null 2>&1
  cp -r -d $BAHOME/ba/* /media/hdd/ba
  echo $LINE
  $ECHO "Barry Allen starts $ENIGMAVERSION now"
  if [ -e /bin/systemctl ]; then
     systemctl start enigma2 > /dev/null 2>&1
  else
     init 3 > /dev/null 2>&1
  fi
  echo $LINE
  $ECHO "Finished"
  echo $LINE
  ;;
  backup )
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: No source passed"
     echo $LINE
     exit 1
  else
     SOURCE=$2
     REALSOURCE=$BAHOME/ba/$SOURCE
  fi
  if [ $# -gt 2 ]; then
     TARGET=$3
  else
     TARGET=$2
  fi
  if [ -f $BAHOME/.balocked ]; then
     if [ $# -lt 3 ]; then
        $ECHO "ERROR: no PIN passed"
        echo $LINE
        exit 1
     else
        if [ $# -lt 4 ]; then
           NEWPIN=`echo -n $3 | md5sum | cut -d" " -f 1`
        else
           NEWPIN=`echo -n $4 | md5sum | cut -d" " -f 1`
        fi
        OLDPIN=`cat $BAHOME/.balocked`
        if [ $OLDPIN != $NEWPIN ]; then
           $ECHO "ERROR: PIN doesn't match"
           echo $LINE
           exit 1
        else
           $ECHO "PIN matches, continuing"
           echo $LINE
        fi
     fi
  fi 
  if [ $SOURCE = "booted" ]; then
     SOURCE="/"
     REALSOURCE="/"
     if [ $# -lt 3 ]; then
        TARGET="barryallenbackup"
     fi
     mkdir $BAHOME/ba/Flash > /dev/null 2>&1
     mount -o bind / $BAHOME/ba/Flash > /dev/null 2>&1
     REALSOURCE=$BAHOME/ba/Flash
  else
     if [ ! -d $BAHOME/ba/$SOURCE ]; then
        $ECHO "ERROR: Source Image $SOURCE not found"
        echo $LINE
        exit 1
     fi
  fi
  if [ -f $BAIMAGE/$TARGET.tar.gz ]; then
        $ECHO "ERROR: Target Image $BAIMAGE/$TARGET.tar.gz already exists, please rename"
        echo $LINE
        exit 1
     fi
  length=`echo $TARGET | wc -c | cut -c1-8`
  length=`expr $length "-" 1`
  if [ $length -gt $BAMAXLEN ]; then
     $ECHO "Target name $TARGET too long"
     echo $LINE
     exit 1
  fi
  $ECHO "Backup from $SOURCE to $BAIMAGE/$TARGET.tar.gz is running ..." 
  echo $LINE
  cd $REALSOURCE
  mv $BAINFO $BAINFOTMP > /dev/null 2>&1
  tar -cf $BAIMAGE/$TARGET.tar . > /dev/null 2>&1
  mv $BAINFOTMP $BAINFO > /dev/null 2>&1
  $BAHOME/bin/pigz $BAIMAGE/$TARGET.tar
  cd $BAHOME
  umount $BAHOME/ba/Flash > /dev/null 2>&1
  umount $BAHOME/ba/Flash > /dev/null 2>&1
  rmdir $BAHOME/ba/Flash > /dev/null 2>&1
  $ECHO "Backup from $SOURCE to $BAIMAGE/$TARGET.tar.gz is done" 
  echo $LINE
  du -h $BAIMAGE/$TARGET.tar.gz
  echo $LINE
  $ECHO "Finished"
  echo $LINE
  ;;
  rcmask | rc_mask | mask )
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: No RC mask passed"
     echo $LINE
     exit 1
  fi
  MASK=$2
  if [ $MASK -eq 0 ]; then
     $ECHO "removing RC mask"
     echo $LINE
     rm $BAHOME/.bamask > /dev/null 2>&1
  else
     $ECHO "changing RC mask to $MASK"
     echo $LINE
     echo $MASK > $BAHOME/.bamask 
     echo $MASK > /proc/stb/ir/rc/mask2
  fi
  ;;
  debian )
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: No target passed"
     echo $LINE
     exit 1
  fi
  TARGET=$2
  if [ -d $BAHOME/ba/$TARGET ]; then
     $ECHO "Target $TARGET already exists, delete first"
     echo $LINE
     exit 1
  fi

  length=`echo $TARGET | wc -c | cut -c1-8`
  length=`expr $length "-" 1`
  if [ $length -gt $BAMAXLEN ]; then
     $ECHO "Target name $TARGET too long"
     echo $LINE
     exit 1
  fi

  df -m > $BATMP 2>&1
  DF=`grep $BAROOT $BATMP | grep -v "no such"`
  FREE=100
  NUMBER=1
  for ITEM in $DF; do
      if [ $NUMBER = 4 ]; then
         FREE=$ITEM
      fi
      if [ $NUMBER = 3 ]; then
         FREE2=$ITEM
      fi
      NUMBER=`expr $NUMBER "+" 1`
  done
  if [ `echo $FREE | grep "%" | wc -l` -gt 0 ]; then
     FREE=$FREE2
  fi
  if [ $FREE -lt $BADEBIANMINFREE ]; then 
     $ECHO "only $FREE MB free on $BAROOT, sorry"
     echo $LINE
     exit 1
  fi
  if [ $SYNC -eq 1 ]; then
     mount -o remount,async $BAHOME
  fi
  DEBARCH=mipsel
  cd /
  $ECHO "extracting debootstrap ..."
  echo $LINE
  tar -xzf $BAHOME/bin/debootstrap-"$DEBARCH".tar.gz -C /
  $ECHO "executing debootstrap for preparing Debian ..."
  $ECHO "be patient - this normally runs quite long ..."
  $ECHO "but it is worth waiting !"
  echo $LINE
  debootstrap --arch $DEBARCH $DEBIAN $BAHOME/ba/$TARGET http://ftp.de.debian.org/debian
  echo $LINE
  cp -RP /lib/modules $BAHOME/ba/$TARGET/lib > /dev/null 2>&1
  if [ `grep  config.osd.language /etc/enigma2/settings | wc -l` -gt 0 ]; then
     grep  config.osd.language /etc/enigma2/settings > $BATMP
     sed -ie s!"config.osd.language="!""!g $BATMP
     ENIGMALANG=`cat $BATMP`
     echo "LANGUAGE=$ENIGMALANG.UTF-8" > $BATMP
     echo "LC_ALL=$ENIGMALANG.UTF-8" >> $BATMP
     echo "LANG=$ENIGMALANG.UTF-8" >> $BATMP
     echo "export LANGUAGE LC_ALL LANG" >> $BATMP
     cat $BAHOME/ba/$TARGET/etc/profile >> $BATMP
     cp $BATMP $BAHOME/ba/$TARGET/etc/profile 
  fi
  cp /etc/fstab $BATMP > /dev/null 2>&1
  sed -ie s!"usbdevs"!"#usbdevs"!g $BATMP
  sed -ie s!"tmpfs                /var"!"#tmpfs                /var"!g $BATMP
  cp $BATMP $BAHOME/ba/$TARGET/etc/fstab > /dev/null 2>&1
  # make showiframe work ...
  cp /usr/bin/showiframe $BAHOME/ba/$TARGET/usr/bin > /dev/null 2>&1
# make grab work ...
  cp /usr/bin/grab $BAHOME/ba/$TARGET/usr/bin/grab > /dev/null 2>&1
  cp /usr/lib/libpng16.so.16.10.0 $BAHOME/ba/$TARGET/usr/lib > /dev/null 2>&1
  ln -sfn /usr/lib/libpng16.so.16.10.0 $BAHOME/ba/$TARGET/usr/lib/usr/lib/libpng16.so.16 > /dev/null 2>&1
  # make bootlogo work ...
  cp $BAHOME/logos/debian.jpg $BAHOME/ba/$TARGET/boot/bootlogo.jpg > /dev/null 2>&1
  cd $BAHOME/ba/$TARGET
#  ln -sfn /media/hdd hdd 
#  ln -sfn /media mnt
  ln -sfn $BAHOME ba
  ln -sfn $BAHOME/ba.sh $BAHOME/ba/$TARGET/bin/ba.sh
  if [ -d /automount ]; then
     mkdir automount
  fi
  mkdir $BAHOME/ba/$TARGET/home > /dev/null 2>&1
  mkdir $BAHOME/ba/$TARGET/home/root > /dev/null 2>&1
  ln -sfn $BAHOME/ba.sh $BAHOME/ba/$TARGET/home/root/ba.sh
  cd $BAHOME/ba/$TARGET/media
  if [ -d /media/Upnp ]; then
     mkdir Upnp
  fi
  mkdir cf card cifs dvd hdd mmc1 net nfs ram realroot union usb > /dev/null 2>&1
  rmdir ba > /dev/null 2>&1
  rm ba > /dev/null 2>&1
  if [ `mount | grep /media/ba | wc -l` -eq 0 ]; then
     ln -sfn $BAROOT ba
  else
     mkdir ba > /dev/null 2>&1
  fi
  echo $TARGET > $BAHOME/ba/$TARGET/$BAINFO
  $ECHO "starting Debian post installation tasks on Dreambox !"
  echo "#!/bin/sh" > $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo adding locales" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo choose at least de_DE.UTF-8 UTF-8 if you run the Dreambox in German !!!!" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  cat $BAHOME/ba/$TARGET/etc/profile | head -n 4 >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes install locales" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "dpkg-reconfigure locales" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "exit 0" >> $BAHOME/ba/$TARGET/tmp/postinst
  chmod 755 $BAHOME/ba/$TARGET/tmp/postinst
  sync && echo 3 > /proc/sys/vm/drop_caches
  $BAHOME/ba.sh chroot $TARGET /tmp/postinst
  rm $BAHOME/ba/$TARGET/tmp/postinst > /dev/null 2>&1
  echo "#!/bin/sh" > $BAHOME/ba/$TARGET/tmp/postinst
  cat $BAHOME/ba/$TARGET/etc/profile | head -n 4 >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo adding telnet and telnetd" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes install telnet" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes install telnetd" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo adding ftp and ftpd" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes install ftp" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes install ftpd" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo adding ssh" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes install ssh" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "exit 0" >> $BAHOME/ba/$TARGET/tmp/postinst
  chmod 755 $BAHOME/ba/$TARGET/tmp/postinst
  sync && echo 3 > /proc/sys/vm/drop_caches
  $BAHOME/ba.sh chroot $TARGET /tmp/postinst
  rm $BAHOME/ba/$TARGET/tmp/postinst > /dev/null 2>&1
  echo "#!/bin/sh" > $BAHOME/ba/$TARGET/tmp/postinst
  cat $BAHOME/ba/$TARGET/etc/profile | head -n 4 >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo adding X11 and other stuff" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes install tasksel xorg xserver-xorg xdm xinit xen-tools docbook-xsl dbus synaptic udev autofs fluxbox sudo mc ntp bzip2 aspell-de" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes -f install" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "exit 0" >> $BAHOME/ba/$TARGET/tmp/postinst
  chmod 755 $BAHOME/ba/$TARGET/tmp/postinst
  sync && echo 3 > /proc/sys/vm/drop_caches
  $BAHOME/ba.sh chroot $TARGET /tmp/postinst
  rm $BAHOME/ba/$TARGET/tmp/postinst > /dev/null 2>&1
  echo "#!/bin/sh" > $BAHOME/ba/$TARGET/tmp/postinst
  cat $BAHOME/ba/$TARGET/etc/profile | head -n 4 >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo adding gnome" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes install gnome" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes -f install" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "exit 0" >> $BAHOME/ba/$TARGET/tmp/postinst
  chmod 755 $BAHOME/ba/$TARGET/tmp/postinst
  sync && echo 3 > /proc/sys/vm/drop_caches
  $BAHOME/ba.sh chroot $TARGET /tmp/postinst
  rm $BAHOME/ba/$TARGET/tmp/postinst > /dev/null 2>&1
  echo "#!/bin/sh" > $BAHOME/ba/$TARGET/tmp/postinst
  cat $BAHOME/ba/$TARGET/etc/profile | head -n 4 >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo adding development stuff" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes install gcc g++ libklibc-dev libpng12-dev libgif-dev make libfreetype6-dev libjpeg62 libjpeg8-dev liblzma-dev" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo --------------------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo adding user debian" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo ------------ --------------------------" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "useradd debian -m" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "apt-get -f -y --force-yes install sudo" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "chown debian:debian /home/debian" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "chown debian:users /var/tmp" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "chown debian:users /tmp" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo debian:dreambox | chpasswd" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "echo root:dreambox | chpasswd" >> $BAHOME/ba/$TARGET/tmp/postinst
  echo "exit 0" >> $BAHOME/ba/$TARGET/tmp/postinst
  chmod 755 $BAHOME/ba/$TARGET/tmp/postinst
  sync && echo 3 > /proc/sys/vm/drop_caches
  $BAHOME/ba.sh chroot $TARGET /tmp/postinst
  rm $BAHOME/ba/$TARGET/tmp/postinst > /dev/null 2>&1
  echo "Debianpost installation finished !" 
  echo "doing standard network config with DHCP !" 
  mkdir $BAHOME/ba/$TARGET/etc/network > /dev/null 2>&1
  echo "auto eth0" >> $BAHOME/ba/$TARGET/etc/network/interfaces 
  echo "allow-hotplug eth0" >> $BAHOME/ba/$TARGET/etc/network/interfaces 
  echo "iface eth0 inet dhcp" >> $BAHOME/ba/$TARGET/etc/network/interfaces 
  cp /etc/resolv.conf $BAHOME/ba/$TARGET/etc/resolv.conf
  cp /etc/hostname $BAHOME/ba/$TARGET/etc/hostname
  # make grab work ...
  cp /usr/bin/grab $BAHOME/ba/$TARGET/usr/bin/grab > /dev/null 2>&1
  # make X server work ...
  cp $BAHOME/bin/xorg.conf $BAHOME/ba/$TARGET/etc/X11/xorg.conf
  #
  if [ -f $BAHOME/script/debianpostinst ]; then
     chmod 755 $BAHOME/script/debianpostinst
     $ECHO "starting Debian user post installation tasks on Dreambox !"
     echo $LINE
     $BAHOME/script/debianpostinst
     echo $LINE
  fi
  echo $LINE
  echo ""
  echo "         Debian wheezy installation is now finished !!!!"
  echo ""
  echo $LINE
  echo ""
  echo "            ********* IMPORTANT **********"
  echo "   use user debian with password dreambox for logon"
  echo "       user root will also have password dreambox"
  echo ""
  echo "   do a ba.sh chroot $TARGET and then passwd debian and passwd root"
  echo "   if you want to change these passwords before first logon"
  echo "            ********* IMPORTANT **********"
  echo ""
  echo "    if you want also kde as desktop do an apt-get install kdm"
  echo "    if you want xfce as desktop do an apt-get install xfce4"
  echo ""
  if [ $SYNC -eq 1 ]; then
     mount -o remount,sync $BAHOME
  fi
  echo $LINE
  ;;
  copy)
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi
  if [ $# -lt 3 ]; then
     $ECHO "ERROR: No source and target passed"
     echo $LINE
     exit 1
  fi
  SOURCE=$2
  if [ -f $BAHOME/.balocked ]; then
     if [ $# -lt 4 ]; then
        $ECHO "ERROR: no PIN passed"
        echo $LINE
        exit 1
     else
        if [ $# -gt 4 ]; then
           NEWPIN=`echo -n $5 | md5sum | cut -d" " -f 1`
        else
           NEWPIN=`echo -n $4 | md5sum | cut -d" " -f 1`
        fi
        OLDPIN=`cat $BAHOME/.balocked`
        if [ $OLDPIN != $NEWPIN ]; then
           $ECHO "ERROR: PIN doesn't match"
           echo $LINE
           exit 1
        else
           $ECHO "PIN matches, continuing"
           echo $LINE
        fi
     fi
  fi 
  if [ $SOURCE != "booted" ]; then
     if [ ! -d $BAHOME/ba/$SOURCE ]; then
        $ECHO "ERROR: Source Image $SOURCE not found"
        echo $LINE
        exit 1
    fi
  fi
  TARGET=$3
  if [ $TARGET = "booted" ]; then
     $ECHO "ERROR: can't copy to booted"
     echo $LINE
     exit 1
  fi
  if [ $TARGET = "Flash" ]; then
     $ECHO "ERROR: can't copy to Flash"
     echo $LINE
     exit 1
  fi
  if [ $BOOTED = $TARGET ]; then
     $ECHO "ERROR: can't copy to booted"
     echo $LINE
     exit 1
  fi
  if [ -d $BAHOME/ba/$TARGET ]; then
     if [ -f $BAHOME/ba/$TARGET/$BAINFO ]; then
        $ECHO "Target $TARGET already exists, delete first"
        echo $LINE
        exit 1
     fi
  fi
  length=`echo $TARGET | wc -c | cut -c1-8`
  length=`expr $length "-" 1`
  if [ $length -gt $BAMAXLEN ]; then
     $ECHO "Target name $TARGET too long"
     echo $LINE
     exit 1
  fi
     
  rm -r $BAHOME/ba/copy > /dev/null 2>&1
  
df -m > $BATMP 2>&1
DF=`grep $BAROOT $BATMP | grep -v "no such"`
NUMBER=1
FREE=100
for ITEM in $DF; do
    if [ $NUMBER = 4 ]; then
       FREE=$ITEM
    fi
    if [ $NUMBER = 3 ]; then
       FREE2=$ITEM
    fi
    NUMBER=`expr $NUMBER "+" 1`
done
if [ `echo $FREE | grep "%" | wc -l` -gt 0 ]; then
   FREE=$FREE2
fi
if [ $FREE -lt $BAMINFREE ]; then 
   $ECHO "only $FREE MB free on $BAROOT, sorry"
   echo $LINE
   exit 1
fi
     
  if [ $SYNC -eq 1 ]; then
     mount -o remount,async $BAHOME
  fi
  $ECHO "Copying Source $SOURCE to Target $TARGET ..."
  echo $LINE
  if [ $SOURCE != "booted" ]; then
     du -h $DLIMIT $BAHOME/ba/$SOURCE
     echo $LINE
  fi
  $ECHO "Copy takes 3 min, be patient ..."
  mkdir $BAHOME/ba/$TARGET > /dev/null 2>&1
  if [ $SOURCE != "booted" ]; then
     cp -RP $BAHOME/ba/$SOURCE/* $BAHOME/ba/$TARGET
  else
     mkdir $BAHOME/ba/Flash  > /dev/null 2>&1
     mount -o bind / $BAHOME/ba/Flash
     cp -RP $BAHOME/ba/Flash/* $BAHOME/ba/$TARGET > /dev/null 2>&1
     umount $BAHOME/ba/Flash > /dev/null 2>&1
     rmdir $BAHOME/ba/Flash > /dev/null 2>&1
     cp $BAHOME/bin/bainit $BAHOME/ba/$TARGET/sbin
  fi
  if [ -f $BAHOME/ba/$TARGET/var/lib/dpkg/status ]; then
     sed -ie s!"-barryallen"!"-nobarryallen"!g $BAHOME/ba/$TARGET/var/lib/dpkg/status 
  fi
  echo $LINE
  du -h $DLIMIT $BAHOME/ba/$TARGET
  echo $LINE
  echo $TARGET > $BAHOME/ba/$TARGET/$BAINFO
  if [ $TARGET == "0" -o $TARGET == "1" -o $TARGET == "2" -o $TARGET == "3" -o $TARGET == "4" -o $TARGET == "5" -o $TARGET == "6" -o $TARGET == "7" -o $TARGET == "8" ]; then
     if [ $# -gt 3 ]; then
        TARGETNAME=$4
        $ECHO "naming image $TARGET as $TARGETNAME"
        echo $LINE
        echo $TARGETNAME > $BAHOME/ba/$TARGET/$BAINFO
     else
        echo $TARGET > $BAHOME/ba/$TARGET/$BAINFO
     fi
  else
     echo $TARGET > $BAHOME/ba/$TARGET/$BAINFO
  fi
  if [ $SYNC -eq 1 ]; then
     mount -o remount,sync $BAHOME
  fi
  $ECHO "Finished"
  echo $LINE
  ;;
  info )
  rm $BAHOME/ba/* > /dev/null 2>&1
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi
  $ECHO "You are booted from: $BOOTED"
  echo $LINE
  $ECHO "List of Installed Images at $BAHOME/ba"
  echo $LINE
  ls -1 $BAHOME/ba
  echo $LINE
  ;;
  image | images )
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi
  rm /media/ba/ba/* > /dev/null 2>&1
  rm /media/ba/ba/.* > /dev/null 2>&1
  $ECHO "You are booted from: $BOOTED"
  echo $LINE
  $ECHO -n "Kernel: "
  cat /proc/version | cut -d'(' -f1-2
  echo $LINE
  if [ `grep "/media/ba " /proc/mounts | grep -v swap | grep -v /media/ba/ba | wc -l` -gt 0 ]; then

  WWDEVICE=`mount | grep $BAHOME | grep -v swap | head -n 1 | cut -d" " -f 1`
  echo $WWDEVICE > $BATMP                        
  sed -ie s!"2"!"1"!g $BATMP            
  WWDEVICE=`cat $BATMP`          
  export LD_LIBRARY_PATH=$BAHOME/bin
  $BAHOME/bin/e2label $WWDEVICE > $BATMP 2>&1 
############ make WW test fail until supported
# if [ `grep BA $BATMP | wc -l` -eq 0 -a `grep ba $BATMP | wc -l` -eq 0 ]; then
  if [ 1 -eq 0 ]; then
     $ECHO "Wally West FAT is on $WWDEVICE"
     WALLY=boot
     echo $LINE
  fi
  fi
   BAROOT=`mount | grep $BAHOME | grep -v swap | head -n 1 | cut -d" " -f 1`
   echo $BAROOT > $BATMP 
   sed -ie s!"1"!""!g $BATMP
   sed -ie s!"2"!""!g $BATMP
   sed -ie s!" "!""!g $BATMP
   BAROOT=`cat $BATMP`
   $FDISK -l > $BATMP 2>&1
   if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART5 | wc -l` -gt 0 ]; then
      mkdir $BAHOME/ba/1 > /dev/null 2>&1
      mount $BAROOT$PART5 $BAHOME/ba/1 > /dev/null 2>&1
   fi
   if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART6 | wc -l` -gt 0 ]; then
      mkdir $BAHOME/ba/2 > /dev/null 2>&1
      mount $BAROOT$PART6 $BAHOME/ba/2 > /dev/null 2>&1
   fi
   if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART7 | wc -l` -gt 0 ]; then
      mkdir $BAHOME/ba/3 > /dev/null 2>&1
      mount $BAROOT$PART7 $BAHOME/ba/3 > /dev/null 2>&1
   fi
   if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART8 | wc -l` -gt 0 ]; then
      mkdir $BAHOME/ba/4 > /dev/null 2>&1
      mount $BAROOT$PART8 $BAHOME/ba/4 > /dev/null 2>&1
   fi
   if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART9 | wc -l` -gt 0 ]; then
      mkdir $BAHOME/ba/5 > /dev/null 2>&1
      mount $BAROOT$PART9 $BAHOME/ba/5 > /dev/null 2>&1
   fi
   if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART10 | wc -l` -gt 0 ]; then
      mkdir $BAHOME/ba/6 > /dev/null 2>&1
      mount $BAROOT$PART10 $BAHOME/ba/6 > /dev/null 2>&1
   fi
   if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART11 | wc -l` -gt 0 ]; then
      mkdir $BAHOME/ba/7 > /dev/null 2>&1
      mount $BAROOT$PART11 $BAHOME/ba/7 > /dev/null 2>&1
   fi
   if [ `grep /dev $BATMP | grep -v Disk | grep $BAROOT$PART12 | wc -l` -gt 0 ]; then
      mkdir $BAHOME/ba/8 > /dev/null 2>&1
      mount $BAROOT$PART12 $BAHOME/ba/8 > /dev/null 2>&1
   fi
  $ECHO "List of Installed Images at $BAHOME/ba"
  echo $LINE
  $ECHO "Size	Name"
  echo $LINE
  rm $BAIMAGELIST > /dev/null 2>&1
  touch $BAIMAGELIST > /dev/null 2>&1
  cd $BAHOME/ba
  IMAGES=`ls`
  for IMAGE in $IMAGES; do
     # info file repair from broken backups
     if [ -d $BAHOME/ba/$IMAGE/boot -a ! -f $BAHOME/ba/$IMAGE/$BAINFO -a ! $IMAGE = "Flash" ]; then
         echo $IMAGE > $BAHOME/ba/$IMAGE/$BAINFO 
         rm $BAHOME/ba/$IMAGE/$BAINFO.tmp > /dev/null 2>&1 
     fi
     if [ $1 = "image" -o $1 = "images" ]; then
        if [ $IMAGE != "Flash" ]; then
           cd $BAHOME/ba
           BASIZE=`du -h $DLIMIT $IMAGE`
           if [ $IMAGE = "1" -o $IMAGE = "2" -o $IMAGE = "3" -o $IMAGE = "4" -o $IMAGE = "5" -o $IMAGE = "6" -o $IMAGE = "7" -o $IMAGE = "8" ]; then
              if [ -f $BAHOME/ba/$IMAGE/$BAINFO ]; then
                 IMAGENAME=`cat $BAHOME/ba/$IMAGE/$BAINFO`
                 $ECHO "$BASIZE ($IMAGENAME)" 
              else
                 if [ $IMAGE = $BOOTED ]; then
                    $ECHO "	$IMAGE (booted)"
                 else
                    $ECHO "	$IMAGE (empty)"
                 fi
              fi
           else
              $ECHO "$BASIZE" 
           fi
           if [ $IMAGE != $BOOTED ]; then
              echo $IMAGE >> $BAIMAGELIST
           fi
        fi
     fi
  done
  if [ $1 = "image" -o $1 = "images" ]; then
     echo $LINE
     echo "Device                  Size    Used      Available %"
     df -h | grep $BAHOME  | head -n 1 > $BATMP
     sed -ie s!"/media/ba"!""!g $BATMP
     cat $BATMP
     echo $LINE
  else
     echo $LINE
  fi
  # installation cleanup
  if [ -d $BAHOME/usr ]; then
     rm -r $BAHOME/usr > /dev/null 2>&1
  fi
  ;;
  rename )
  if [ $# -lt 3 ]; then
     $ECHO "no old and new imagename passed for renaming"
     echo $LINE
     exit 1
  fi
  SOURCE=$2
  TARGET=$3
  if [ ! -f $BAIMAGE/$SOURCE.tar.gz -a  ! -f $BAIMAGE/$SOURCE.tar.xz ]; then
     $ECHO "old imagename $BAIMAGE/$SOURCE not existing for renaming"
     echo $LINE
     exit 1
  fi
  if [ -f $BAIMAGE/$SOURCE.tar.gz -a -f $BAIMAGE/$TARGET.tar.gz ]; then
     $ECHO "Target $BAIMAGE/$TARGET already exists, delete first"
     echo $LINE
     exit 1
  fi
  if [ -f $BAIMAGE/$SOURCE.tar.xz -a -f $BAIMAGE/$TARGET.tar.xz ]; then
     $ECHO "Target $BAIMAGE/$TARGET already exists, delete first"
     echo $LINE
     exit 1
  fi
  length=`echo $TARGET | wc -c | cut -c1-8`
  length=`expr $length "-" 1`
  if [ $length -gt $BAMAXLEN ]; then
     $ECHO "Target name $TARGET too long"
     echo $LINE
     exit 1
  fi
     
  if [ -f $BAIMAGE/$SOURCE.tar.gz ]; then
     mv $BAIMAGE/$SOURCE.tar.gz $BAIMAGE/$TARGET.tar.gz
  fi
  if [ -f $BAIMAGE/$SOURCE.tar.xz ]; then
     mv $BAIMAGE/$SOURCE.tar.xz $BAIMAGE/$TARGET.tar.xz
  fi
  $ECHO "image $SOURCE renamed to $TARGET"
  echo $LINE
  exit 0
  ;;
  "name" ) 
  if [ $# -lt 3 ]; then
     $ECHO "no old and new imagename passed for naming"
     echo $LINE
     exit 1
  fi
  SOURCE=$2
  TARGET=$3
  if [ -f $BAHOME/.balocked ]; then
     if [ $# -lt 4 ]; then
        $ECHO "ERROR: no PIN passed"
        echo $LINE
        exit 1
     else
        NEWPIN=`echo -n $4 | md5sum | cut -d" " -f 1`
        OLDPIN=`cat $BAHOME/.balocked`
        if [ $OLDPIN != $NEWPIN ]; then
           $ECHO "ERROR: PIN doesn't match"
           echo $LINE
           exit 1
        else
           $ECHO "PIN matches, continuing"
           echo $LINE
        fi
     fi
  fi 
  if [ $SOURCE = "booted" ]; then
     $ECHO "ERROR: can't name booted"
     echo $LINE
     exit 1
  fi
  if [ $TARGET = "booted" ]; then
     $ECHO "ERROR: can't name booted"
     echo $LINE
     exit 1
  fi
  if [ $TARGET = "Flash" ]; then
     $ECHO "ERROR: can't name Flash"
     echo $LINE
     exit 1
  fi
  if [ ! -d $BAHOME/ba/$SOURCE ]; then
        $ECHO "old imagename $SOURCE not existing for naming"
        echo $LINE
        exit 1
  fi
  if [  -d $BAHOME/ba/$SOURCE -a ! -f $BAHOME/ba/$SOURCE/$BAINFO ]; then
        $ECHO "old imagename $SOURCE is empty"
        echo $LINE
        exit 1
  fi
  if [ $SOURCE != "0" -a $SOURCE != "1" -a $SOURCE != "2" -a $SOURCE != "3" -a $SOURCE != "4" -a $SOURCE != "5" -a $SOURCE != "6" -a $SOURCE != "7" -a $SOURCE != "8" ]; then
     if [ -d $BAHOME/ba/$TARGET ]; then
        $ECHO "Target $TARGET already exists, delete first"
        echo $LINE
        exit 1
     fi
  fi
  length=`echo $TARGET | wc -c | cut -c1-8`
  length=`expr $length "-" 1`
  if [ $length -gt $BAMAXLEN ]; then
     $ECHO "Target name $TARGET too long"
     echo $LINE
     exit 1
  fi
     
 if [ $SOURCE = "0" -o $SOURCE = "1" -o $SOURCE = "2" -o $SOURCE = "3" -o $SOURCE = "4" -o $SOURCE = "5" -o $SOURCE = "6" -o $SOURCE = "7" -o $SOURCE = "8" ]; then
     echo $TARGET > $BAHOME/ba/$SOURCE/$BAINFO
  else
     # make sure ...
     cd $BAHOME
     umount /media/ba/ba/$SOURCE > /dev/null 2>&1
     mv $BAHOME/ba/$SOURCE $BAHOME/ba/$TARGET
     echo $TARGET > $BAHOME/ba/$TARGET/$BAINFO
  fi
  $ECHO "image $SOURCE named $TARGET"
  echo $LINE
  exit 0
  ;;
  list )
  rm $BAIMAGELIST > /dev/null 2>&1
  touch $BAIMAGELIST > /dev/null 2>&1
  $ECHO "List of available Images at $BAIMAGE"
  echo $LINE
  cd $BAIMAGE
  IMAGES=`ls *.tar.*z | grep -v enigma2settings`
  for IMAGE in $IMAGES; do
      du -h $IMAGE 
      echo $IMAGE >> $BAIMAGELIST
  done
  echo $LINE
  ;;
  list_ipk)
  rm $BAIMAGELIST > /dev/null 2>&1
  echo "update" > $BAIMAGELIST
  $ECHO "List of available ipk kits at $INSTALLDIR"
  echo $LINE
  cd $INSTALLDIR
  IMAGES=`ls *.ipk`
  for IMAGE in $IMAGES; do
      du -h $IMAGE 
      echo $IMAGE >> $BAIMAGELIST
  done
  echo $LINE
  $ECHO "List of available ipk kits at $BAIMAGE"
  echo $LINE
  cd $BAIMAGE
  IMAGES=`ls *.ipk`
  for IMAGE in $IMAGES; do
      du -h $IMAGE 
      if [ ! -f $INSTALLDIR/$IMAGE ]; then
         echo $IMAGE >> $BAIMAGELIST
      fi
  done
  echo $LINE
  ;;
  remove )
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: no Image name given for remove"
     echo $LINE
     exit 1
  else
     SOURCE=$2
  fi
  if [ ! -f $BAIMAGE/$SOURCE.tar.gz -a ! -f $BAIMAGE/$SOURCE.tar.xz  ]; then
     $ECHO "ERROR: Image $BAIMAGE/$SOURCE.tar.*z is not available for remove"
     echo $LINE
     exit 1
  fi
  if [ -f $BAIMAGE/$SOURCE.tar.gz ]; then
     $ECHO "Removing Image $BAIMAGE/$SOURCE.tar.gz"
     echo $LINE
     rm $BAIMAGE/$SOURCE.tar.gz
  fi
  if [ -f $BAIMAGE/$SOURCE.tar.xz ]; then
     $ECHO "Removing Image $BAIMAGE/$SOURCE.tar.xz"
     echo $LINE
     rm $BAIMAGE/$SOURCE.tar.xz
  fi
  $ECHO "Finished"
  echo $LINE
  echo 
  ;;
  delete)
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: no Image name given for delete"
     echo $LINE
     exit 1
  else
     SOURCE=$2
  fi
  if [ -f $BAHOME/.balocked ]; then
     if [ $# -lt 3 ]; then
        $ECHO "ERROR: no PIN passed"
        echo $LINE
        exit 1
     else
        NEWPIN=`echo -n $3$4 | md5sum | cut -d" " -f 1`
        OLDPIN=`cat $BAHOME/.balocked`
        if [ $OLDPIN != $NEWPIN ]; then
           $ECHO "ERROR: PIN doesn't match"
           echo $LINE
           exit 1
        else
           $ECHO "PIN matches, continuing"
           echo $LINE
        fi
     fi
  fi 
  if [ $SOURCE = "booted" ]; then
     $ECHO "ERROR: can't delete booted"
     echo $LINE
     exit 1
  fi
  if [ ! -d $BAHOME/ba/$SOURCE ]; then
     $ECHO "ERROR: Image $BAHOME/ba/$SOURCE is not installed"
     echo $LINE
     exit 1
  fi
  if [ $SOURCE = "Flash"  ]; then
     $ECHO "ERROR: can't delete Flash"
     echo $LINE
     exit 1
  fi
  if [ $BOOTED = $SOURCE ]; then
     $ECHO "ERROR: Image $BAHOME/ba/$SOURCE currently booted, can't delete"
     echo $LINE
     exit 1
  fi
  if [ `mount | grep /ba/$SOURCE/media | wc -l` -gt 0 ]; then
     $ECHO "ERROR: Image $BAHOME/ba/$SOURCE currently booted, can't delete"
     echo $LINE
     exit 1
  fi
  $ECHO "Deleting Image $SOURCE"
  echo $LINE
  # make sure ...
  cd $BAHOME
  umount $BAHOME/ba/$TARGET/proc > /dev/null 2>&1
  umount $BAHOME/ba/$TARGET/sys > /dev/null 2>&1
  umount $BAHOME/ba/$TARGET/dev > /dev/null 2>&1
  umount /media/ba/ba/$SOURCE/boot/  > /dev/null 2>&1
  rm -r $BAHOME/ba/$SOURCE > /dev/null 2>&1
  $ECHO "Finished"
  echo $LINE
  ;;
  chroot )
    cd $BAHOME
    if [ $# -lt 2 ]; then
       $ECHO "No Target Image passed  - Flash will be used"
       echo $LINE
       TARGET="Flash"
    else
       TARGET=$2
    fi
    if [ $TARGET = "Flash" -a ! -f /$BAINFO ]; then
        $ECHO "works only when NOT booted from Flash, sorry"
        echo $LINE
        exit 1
    fi
    if [ $TARGET = "Flash" ]; then
       mkdir -p $BAHOME/ba/$TARGET
       umount $BAHOME/ba/$TARGET > /dev/null 2>&1
       mount -t ext4 -o rw /dev/mmcblk0p1 $BAHOME/ba/$TARGET > /dev/null 2>&1
    else
       if [ ! -d  $BAHOME/ba/$TARGET ]; then
          $ECHO "ERROR: Target Image Directory $BAHOME/ba/$TARGET is not existing"
          echo $LINE
          exit 1
       fi
    fi
    if [ `mount | grep $TARGET/dev | wc -l` -lt 1 ]; then
       mount -o bind /proc $BAHOME/ba/$TARGET/proc
       mount -o bind /sys  $BAHOME/ba/$TARGET/sys
       mount -o bind /sys/kernel/security $BAHOME/ba/$TARGET/sys/kernel/security
       mount -o bind /sys/fs/cgroup  $BAHOME/ba/$TARGET/sys/fs/cgroup
       mount -o bind /dev  $BAHOME/ba/$TARGET/dev
       mount -o bind /dev/pts  $BAHOME/ba/$TARGET/dev/pts
       mount -o bind /run  $BAHOME/ba/$TARGET/run
    fi
    echo $BAHOME/ba/$TARGET
    echo $LINE
    ls $BAHOME/ba/$TARGET
    mount -o bind $BAHOME  $BAHOME/ba/$TARGET/$BAHOME > /dev/null 2>&1
    mount -o bind /media/hdd  $BAHOME/ba/$TARGET/media/hdd > /dev/null 2>&1
    echo $LINE
    if [ $# -lt 3 ]; then
       $ECHO "chroot now to $TARGET - use exit to return !"
       SCRIPT=""
    else
       SCRIPT=$3
       $ECHO "executing script $SCRIPT in chroot $TARGET !"
    fi
    echo $LINE
    sync && echo 3 > /proc/sys/vm/drop_caches
    chroot $BAHOME/ba/$TARGET $SCRIPT
    sync && echo 3 > /proc/sys/vm/drop_caches
    echo $LINE
    $ECHO "chroot from $TARGET exited !"
    echo $LINE
    cd $BAHOME

    CHROOTMOUNTS=`mount | grep /ba/$TARGET`
    ITEM=0
    for MOUNTS in $CHROOTMOUNTS; 
    do
       ITEM=`expr $ITEM "+" 1`
       if [ $ITEM -eq 3 ]; then
          umount $MOUNTS > /dev/null 2>&1
       fi
       if [ $ITEM -eq 6 ]; then
          ITEM=0
       fi
    done
    CHROOTMOUNTS=`mount | grep /ba/$TARGET`
    ITEM=0
    for MOUNTS in $CHROOTMOUNTS; 
    do
       ITEM=`expr $ITEM "+" 1`
       if [ $ITEM -eq 3 ]; then
          umount $MOUNTS > /dev/null 2>&1
       fi
       if [ $ITEM -eq 6 ]; then
          ITEM=0
       fi
    done
    CHROOTMOUNTS=`mount | grep /ba/$TARGET`
    ITEM=0
    for MOUNTS in $CHROOTMOUNTS; 
    do
       ITEM=`expr $ITEM "+" 1`
       if [ $ITEM -eq 3 ]; then
          umount $MOUNTS > /dev/null 2>&1
       fi
       if [ $ITEM -eq 6 ]; then
          ITEM=0
       fi
    done
    CHROOTMOUNTS=`mount | grep /ba/$TARGET`
    ITEM=0
    for MOUNTS in $CHROOTMOUNTS; 
    do
       ITEM=`expr $ITEM "+" 1`
       if [ $ITEM -eq 3 ]; then
          umount $MOUNTS > /dev/null 2>&1
       fi
       if [ $ITEM -eq 6 ]; then
          ITEM=0
       fi
    done
    bainit 900
    if [ $TARGET = "Flash" ]; then
       umount $BAHOME/ba/$TARGET > /dev/null 2>&1
       rmdir $BAHOME/ba/$TARGET > /dev/null 2>&1
    fi
    echo $LINE
    $ECHO "Finished"
    echo $LINE
  ;;
  imagemount | image_mount )
    cd $BAHOME
    if [ $# -lt 2 ]; then
       $ECHO "No Target Image passed  - Flash will be used"
       echo $LINE
       TARGET="Flash"
    else
       TARGET=$2
    fi
    if [ $TARGET = "Flash" -a ! -f /$BAINFO ]; then
        $ECHO "works only when NOT booted from Flash, sorry"
        echo $LINE
        exit 1
    fi
    if [ `mount | grep $TARGET | wc -l` -gt 0 ]; then
       echo $BAHOME/ba/$TARGET
       echo $LINE
       ls $BAHOME/ba/$TARGET
       echo $LINE
       $ECHO "Finished"
       echo $LINE
       exit 0
    fi
    if [ $TARGET = "Flash" ]; then
       mkdir -p $BAHOME/ba/Flash
       umount $BAHOME/ba/Flash > /dev/null 2>&1
       mount -t ext4 -o rw /dev/mmcblk0p1 $BAHOME/ba/$TARGET > /dev/null 2>&1
       echo $BAHOME/ba/$TARGET
       echo $LINE
       ls $BAHOME/ba/$TARGET
    else
       if [ ! -d  $BAHOME/ba/$TARGET ]; then
          $ECHO "ERROR: Target Image Directory $BAHOME/ba/$TARGET is not existing"
          echo $LINE
          exit 1
       fi
       echo $BAHOME/ba/$TARGET
       echo $LINE
       ls $BAHOME/ba/$TARGET
    fi
    echo $LINE
    $ECHO "Finished"
    echo $LINE
    ;;
  image_umount | imageumount | imageunmount | image_unmount )
    cd $BAHOME
    if [ $# -lt 2 ]; then
       $ECHO "No Target Image passed  - Flash will be used"
       echo $LINE
       TARGET="Flash"
    else
       TARGET=$2
    fi
    umount $BAHOME/ba/$TARGET >  /dev/null 2>&1
    if [ $TARGET = "Flash" ]; then
       rmdir $BAHOME/ba/$TAGET > /dev/null 2>&1
    fi
    $ECHO "Finished"
    echo $LINE
    ;;
   "free")
   cat /proc/meminfo
   echo $LINE
   free
   echo $LINE
   ;;
   "swapon")
   if [ `cat /proc/swaps | wc -l` -gt 1 ]; then
      $ECHO "swapping already enabled, sorry"
      echo $LINE
      exit 1
   fi
   SWAPDIR=$BAHOME
   if [ $# -gt 1 ]; then
      SWAPDIR=$2
   fi
   if [ $# -gt 2 ]; then
      if [ $3 -lt $BASWAPSIZE ]; then
         $ECHO "Swapsize smaller then $BASWAPSIZE, sorry"
         echo $LINE
         exit 0
      else
         BASWAPSIZE=$3
      fi
   fi
   if [ ! -d $SWAPDIR ]; then
      $ECHO "Swapdirectory $SWAPDIR doesn't exist"
      echo $LINE
      exit 0
   fi
   free
   echo $LINE
   $ECHO "creating $SWAPDIR/swapfile ..."
   if [ -f $SWAPDIR/swapfile ]; then
      swapoff $SWAPDIR/swapfile > /dev/null 2>&1
      rm $SWAPDIR/swapfile > /dev/null 2>&1
      echo $LINE
   fi
   dd if=/dev/zero of=$SWAPDIR/swapfile bs=1024 count=$BASWAPSIZE
   echo $LINE
   mkswap $SWAPDIR/swapfile
   echo $LINE
   $ECHO "swapon $SWAPDIR/swapfile"
   swapon $SWAPDIR/swapfile > /dev/null 2>&1
   echo $LINE
   free
   echo $LINE
   ;;
   "swapoff")
   SWAPDIR=$BAHOME
   if [  $# -gt 1 ]; then
      SWAPDIR=$2
   fi
   free
   echo $LINE
   $ECHO "swapoff $SWAPDIR/swapfile"
   swapoff $SWAPDIR/swapfile > /dev/null 2>&1
   rm $SWAPDIR/swapfile > /dev/null 2>&1
   echo $LINE
   free
   echo $LINE
   ;;
   lock)
      if [ $# -lt 2 ]; then
         $ECHO "ERROR: no PIN"
         echo $LINE
         exit 1
      else
         NEWPIN=`echo -n $2$3$4 | md5sum | cut -d" " -f 1`
      fi
      if [ -f $BAHOME/.balocked ]; then
         OLDPIN=`cat $BAHOME/.balocked`
         if [ $OLDPIN != $NEWPIN ]; then
            $ECHO "Sorry, PIN doesn't match"
            echo $LINE
            exit 1
         else
            rm $BAHOME/.balocked  > /dev/null 2>&1
            $ECHO "Images are now unlocked again"
            echo $LINE
         fi
      else
            echo $NEWPIN > $BAHOME/.balocked 
            $ECHO "Images are now locked with PIN"
            echo $LINE
      fi
   ;;
  "patch" | "plugin" )
# check for missing bainit link
if [ ! -f /sbin/bainit ]; then
   cp $BAHOME/bin/bainit /sbin/bainit > /dev/null 2>&1
fi 
if [ ! -f /$BAINFO ]; then
   ln -sfn /sbin/bainit /sbin/init
fi
mount /boot > /dev/null 2>&1
rm /boot/.testflash > /dev/null 2>&1
if [ ! -d $BAHOME ]; then
   rm $BAHOME > /dev/null 2>&1
   mkdir $BAHOME > /dev/null 2>&1
fi
if [ -d /usr/lib/enigma2/python/Plugins/Extensions ]; then
   ln -sfn $BAHOME/BarryAllen /usr/lib/enigma2/python/Plugins/Extensions
fi

  if [ -f $BAHOME/script/bapostinst -a ! -f /etc/enigma2/lamedb ]; then
     echo "bapostinst found, but no Settings"
      echo "So it will be nice and unpack now your"
     echo "last settings backup for you ..."
     $BAHOME/script/bapostinst /
  fi
  if [ -f $BAHOME/ba.sh ]; then
     $ECHO "Barry Allen restarts $ENIGMAVERSION now"
     echo $LINE
     if [ -e /bin/systemctl ]; then
        sync && echo 3 > /proc/sys/vm/drop_caches 
        systemctl restart enigma2 > /dev/null 2>&1
     else
        init 4 > /dev/null 2>&1 
	sleep 5
        sync && echo 3 > /proc/sys/vm/drop_caches 
        init 3 > /dev/null 2>&1 
     fi
  else
     $ECHO "Barry Allen reboots Dreambox now ..."
     echo $LINE
     if [ -e /bin/systemctl ]; then
        sync && echo 3 > /proc/sys/vm/drop_caches 
        systemctl reboot > /dev/null 2>&1
     else
	init 4 > /dev/null 2>&1
        sleep 5
        sync && echo 3 > /proc/sys/vm/drop_caches 
        shutdown -r now > /dev/null 2>&1
     fi
  fi
  exit 0
  ;;
  timeout)
  if [ $# -lt 2 ]; then
     $ECHO "using default timeout for bootmenu"
     echo $LINE
     rm $BAHOME/.batimeout > /dev/null 2>&1
     exit 1
  fi
  TIMEOUT=$2
  if [ $TIMEOUT -lt 2 -o $TIMEOUT -gt 30 ]; then
     $ECHO "only a bootmenu timeout of 2-30 sec is allowed !"
     echo $LINE
     exit 1
  fi
  $ECHO "setting bootmenu timeout to $TIMEOUT"
  echo $LINE
  echo $TIMEOUT > $BAHOME/.batimeout
  ;;
  uuid | reset_uuid )
  $ECHO "resetting UUID on Barry Allen device ..."
  echo $LINE
  $BAHOME/bin/tune2fs -U 00000000-0000-0000-0000-000000000000 /dev/disk/by-label/ba
  echo $LINE
  $ECHO "Done!"
  echo $LINE
  ;;
  rootdelay)
  if [ $# -lt 2 ]; then
     $ECHO "removing rootdelay for USB booting, so a default of 10 sec will be used"
     echo $LINE
     rm $BAHOME/.barootdelay > /dev/null 2>&1
     exit 1
  fi
  ROOTDELAY=$2
  if [ $ROOTDELAY = "show" ]; then
     $ECHO "showing rootdelay for USB booting"
     echo $LINE
     ROOTDELAY=10
     if [ -f $BAHOME/.barootdelay ]; then
        ROOTDELAY=`cat $BAHOME/.barootdelay`
     fi
     echo $ROOTDELAY
     echo $LINE
     exit 0
  fi 
  if [ $ROOTDELAY -lt 0 -o $ROOTDELAY -gt 15 ]; then
     $ECHO "impossible rootdelay, using 10 sec"
     ROOTDELAY=10
     echo $LINE
  fi
  $ECHO "setting rootdelay for USB booting to $ROOTDELAY sec"
  echo $LINE
  echo $ROOTDELAY > $BAHOME/.barootdelay
  ;;
  list_drivers)
  $ECHO "Listing drivers for $BOXTYPE"
  echo $LINE
  wget -q http://$DREAMBOXUPDATEHOST/opendreambox/2.0/experimental/$SUBDIR -O $BATMP
  echo "splitting lines, be patient ..."
  echo $LINE
  awk '{ RS = " ";{print $0;}}' $BATMP | grep dreambox-dvb-modules > $BATMP2
  cp $BATMP2 $BATMP
  sed -ie s!"</a>"!"\\n"!g $BATMP
  grep dreambox-dvb-modules $BATMP > $BATMP2
  grep -v dbg $BATMP2 > $BATMP
  sed -ie s!"<tr><td><a href='"!""!g $BATMP
  sed -ie s!"'>"!" "!g $BATMP
  sed -ie s!"</a></td><td></td></tr>"!" "!g $BATMP
  sed -ie s!"href=\""!" "!g $BATMP
  sed -ie s!"\">"!" "!g $BATMP
  KITS=`cat $BATMP` 
  OLDKIT=""
  for KIT in $KITS; do
      if [ "$KIT" != "$OLDKIT" ]; then
         echo $KIT
         OLDKIT=$KIT
      fi
  done
  echo $LINE
  ;;
  flash_softwareupdate)
  if [ ! -f /$BAINFO ]; then
     $ECHO "should be only called when NOT booted from Flash"
     echo $LINE
     exit 1
  fi
  $ECHO "doing Softwareupdate in Flash ..."
  sync && echo 3 > /proc/sys/vm/drop_caches
  $BAHOME/ba.sh chroot Flash "opkg update"
  $BAHOME/ba.sh chroot Flash "opkg upgrade"
  ;;
  kernel | check_kernel)
     $ECHO -n "Active Kernel:"
     cat /proc/version
     echo $LINE
     $ECHO "Image Kernel at /boot:"
     strings /boot/vmlinux.bin* | grep $BOXTYPE | grep Linux
     echo $LINE
  ;;
  drivers | check_drivers)
  if [ -f /$BAINFO ]; then
     if [ ! -d $BAHOME/ba/Flash ]; then
        mkdir $BAHOME/ba/Flash
     fi
     mount -t ext4 -o rw /dev/mmcblk0p1 $BAHOME/ba/Flash > /dev/null 2>&1
  fi
  PATCHLINE=`grep -n "Package: dreambox-dvb-modules" $DPKGSTATUS | head -n 1 | cut -d":" -f 1`
  LENGTH=`cat $DPKGSTATUS | wc -l`
  REMAIN=`expr $LENGTH "-" $PATCHLINE`
  MODULDATE=`tail -n $REMAIN $DPKGSTATUS | head -n 10 | grep Version | cut -d":" -f 2`
$ECHO "checking Image Driver Date"
echo $LINE
if [ -f /$BAINFO ]; then
   IMAGE=`cat /$BAINFO`
   echo "$MODULDATE - $IMAGE - booted"
else
   echo "$MODULDATE - Flash - booted"
fi
echo $LINE

IMAGES=`ls -1 /media/ba/ba`
for IMAGE in $IMAGES; do
if [ -f $BAHOME/ba/$IMAGE/$DPKGSTATUS ]; then
if [ `grep dreambox-dvb-modules $BAHOME/ba/$IMAGE/$DPKGSTATUS | wc -l` -gt 0 ]; then
   PATCHLINE=`grep -n "Package: dreambox-dvb-modules" $BAHOME/ba/$IMAGE/$DPKGSTATUS | head -n 1 | cut -d":" -f 1`
   LENGTH=`cat $BAHOME/ba/$IMAGE/$DPKGSTATUS | wc -l`
   REMAIN=`expr $LENGTH "-" $PATCHLINE "-" 5`
   MODULDATE=`tail -n $REMAIN $BAHOME/ba/$IMAGE/$DPKGSTATUS | head -n 10 | grep Version | cut -d":" -f 2`
   grep -n "Package: dreambox-dvb-modules" $BAHOME/ba/$IMAGE/$DPKGSTATUS | tail -n 1 > $BATMP 
   echo "$MODULDATE - $IMAGE"
fi
else
   echo " unknown  - $IMAGE"
fi

done

umount $BAHOME/ba/Flash > /dev/null 2>&1
rmdir $BAHOME/ba/Flash > /dev/null 2>&1
  echo $LINE
  ;;
  *)
    $ECHO "Usage: ba.sh boot <imagename> | info | list" 
    $ECHO "     | extract <imagename> [newname] | backup <imagename> [newname]" 
    $ECHO "     | name <oldname> <newnewname>   | delete <imagename>"
    $ECHO "     | rename <oldname> <newnewname> | remove <imagename>"
    $ECHO "     | copy <oldname> <newnewname>"
    echo $LINE
    exit 1
  ;;
esac
exit 0
