# -*- coding: utf-8 -*-
#
# Barry Allen by gutemine
#
barryallen_version = "12.36"
#
from enigma import quitMainloop, eActionMap, eSize, eConsoleAppContainer, iServiceInformation, fbClass, eRCInput, eDBoxLCD, getDesktop
from Screens.Screen import Screen
from Screens.MessageBox import MessageBox
from Screens.InputBox import InputBox
from Screens.ChoiceBox import ChoiceBox
from Components.ActionMap import ActionMap, NumberActionMap
from Components.ScrollLabel import ScrollLabel
from Components.Label import Label
from Components.GUIComponent import *
from Components.MenuList import MenuList
from Components.Input import Input
from Components.config import config, ConfigSubsection, ConfigText, ConfigBoolean, ConfigInteger, ConfigSelection, getConfigListEntry
from Components.ConfigList import ConfigListScreen
from Screens.Console import Console
from Plugins.Plugin import PluginDescriptor
from Components.Pixmap import Pixmap
from twisted.internet import reactor
import os
import hashlib
import gettext
barryallen_path = "/media/ba"
barryallen_script_path = "/media/ba/script"
barryallen_localedir="%s/locale" % barryallen_path
# add local language file                                                          
ba_sp=config.osd.language.value.split("_")                                         
ba_language = ba_sp[0]                                                             
global barryallen_userscripts_first
barryallen_userscripts_first=True
barryallen_userscripts_path = "/usr/script"                                                
if os.path.exists("%s/%s" % (barryallen_localedir, ba_language)) == True:          
   os.environ["LANGUAGE"] = ba_sp[0]                                               
else:
   os.environ['LANGUAGE']='en'                                                        
   ba_language='en'                                                                   
if ba_language == 'ar':                                                            
   ar="                                                                           "
   ar2=""                                                                          
else:                                                                              
   ar=""                                                                           
   ar2=""                                                                          
if os.path.exists("/media/ba/locale") == True:                                     
   _=gettext.Catalog('barryallen', '/media/ba/locale', ba_sp).gettext                     

f=open("/proc/stb/info/model")
baboxtype=f.read()
f.close() 
baboxtype=baboxtype.replace("\n","").replace("\l","")

yes_no_descriptions = {False: _("no"), True: _("yes")}                                                                        
config.plugins.barryallen = ConfigSubsection()
config.plugins.barryallen.lite = ConfigBoolean(default = False,  descriptions = yes_no_descriptions)
config.plugins.barryallen.withdate = ConfigBoolean(default = False,  descriptions = yes_no_descriptions)
config.plugins.barryallen.confirm = ConfigBoolean(default = False,  descriptions = yes_no_descriptions)
config.plugins.barryallen.locked = ConfigBoolean(default = False,  descriptions = yes_no_descriptions)
#config.plugins.barryallen.norestart = ConfigBoolean(default = False,  descriptions = yes_no_descriptions)
if os.path.exists("/media/ba/boot"):
	config.plugins.barryallen.mode = ConfigSelection(default = "enable", choices = [("enable", _("enable")), ("disable", _("disable")), ("wobble", _("wooble"))])
else:
	config.plugins.barryallen.mode = ConfigSelection(default = "enable", choices = [("enable", _("enable")), ("disable", _("disable"))])
m = open("/proc/mounts","r")
mounts = m.readline()
m.close()
config.plugins.barryallen.progress = ConfigBoolean(default = True,  descriptions = yes_no_descriptions)
#config.plugins.barryallen.squashfs = ConfigBoolean(default = False,  descriptions = yes_no_descriptions)
config.plugins.barryallen.timeout = ConfigInteger(default = 10, limits = (2, 30))
#config.plugins.barryallen.rootdelay = ConfigInteger(default = 10, limits = (5, 15))
bamask =[]
bamask.append(("0", _("none")))
bamask.append(("1", _("layer 1 = mask 1")))
bamask.append(("2", _("layer 2 = mask 2")))
bamask.append(("4", _("layer 3 = mask 4")))
bamask.append(("8", _("layer 4 = mask 8")))
config.plugins.barryallen.rclevel = ConfigSelection(default = "0", choices = bamask)
resolution = []
rf = open("/proc/stb/video/videomode_choices","r")
line =rf.readline()
rf.close()
resolutions=line.split(" ")
resolution.append(("none", _("none")))
for res in resolutions:
	resolution.append((str(res), str(res) ))
config.plugins.barryallen.resolution = ConfigSelection(default = "none", choices = resolution)
bapostinst = []
bapostinst.append(("none",_("none")))
for name in os.listdir(barryallen_script_path):
   if name.endswith(".template") and name.startswith("ba"): 
       bapostinst.append((name,name))
config.plugins.barryallen.bapostinst = ConfigSelection(default = "none", choices = bapostinst)
config.plugins.barryallen.scriptsave = ConfigBoolean(default = False, descriptions=yes_no_descriptions)
barryallenlist_options = []
barryallenlist_options.append(( "none",_("none") ))
barryallenlist_options.append(( "execute",_("Execute") ))
barryallenlist_options.append(( "install",_("Install") ))
barryallenlist_options.append(( "both",_("Execute")+" & "+_("Install") ))
#config.plugins.barryallen.list = ConfigSelection(default = "install", choices = barryallenlist_options)
barryallenshow_options = []
barryallenshow_options.append(( "plugin",_("Pluginlist") ))
barryallenshow_options.append(( "extension",_("Extension") ))
barryallenshow_options.append(( "both",_("Pluginlist")+" & "+_("Extension") ))
#config.plugins.barryallen.show = ConfigSelection(default = "both", choices = barryallenshow_options)
try:
	from twisted.web import resource, http
except:
	from twisted.web2 import server, resource, http
API_VERSION = "1.2"
import datetime
from os import statvfs
enigma_version="Enigma2"
barryallen_plugindir="/usr/lib/enigma2/python/Plugins/Extensions/BarryAllen" 
wallywest_plugindir="/usr/lib/enigma2/python/Plugins/Extensions/WallyWest"
barryallen_imagelist = "/tmp/.baimages"
barryallen_downloads = "/tmp/.badownloads"
barryallen_nobootmanager="%s/.banobootmanager" % barryallen_path
barryallen_wwbootmanager="%s/.wwbootmanager" % barryallen_path
barryallen_nobootlogo="%s/.banologo" % barryallen_path
barryallen_lite = "%s/.balite" % barryallen_path
barryallen_withdate = "%s/.bawithdate" % barryallen_path
barryallen_locked = "%s/.balocked" % barryallen_path
#barryallen_norestart = "%s/.banorestart" % barryallen_path
barryallen_progress = "%s/.baprogress" % barryallen_path
#barryallen_squashfs="%s/.basquashfs" % barryallen_path
barryallen_confirm = "%s/.baconfirm" % barryallen_path
barryallen_bootlogo = "%s/.babootlogo" % barryallen_path
title1_string=_("Barry Allen %s by gutemine on %s") % (barryallen_version,baboxtype)
title2_string=""
title3_string=_("Barry Allen kit download from www.oozoon.de")
title4_string=_("Thanks for the Documentation by romeo-golf")
title5_string=_("Thanks for the Language translations")
if os.path.exists("%s/plugin.pyc" % wallywest_plugindir ) == True:
   from Plugins.Extensions.WallyWest.plugin import *
if os.path.exists("%s/plugin.pyo" % wallywest_plugindir ) == True:
   from Plugins.Extensions.WallyWest.plugin import *
# path to the barryallen.sh
barryallen_script = "%s/ba.sh" % barryallen_path
barryallen_ksh = ""
# path to the tmpfiles
barryallen_tmpfile = "/tmp/.batmp" 
# name of the imageinfofile
barryallen_infofile = "/.bainfo"
booted_image="Flash"
if os.path.exists(barryallen_infofile) == True:
   f = open(barryallen_infofile)
   booted_image = f.read().rstrip("\n")
   f.close()
   
global barryallen_imagepath
barryallen_imagepath="/media/ba/backup"

if os.path.exists("/media/hdd/backup"):
	barryallen_imagepath = "/media/hdd/backup"
else:
        for mount in os.listdir("/media"):
            if barryallen_imagepath == "/media/ba/backup" and line.startswith(".") is False: 
		if os.path.exists("/media/%s/backup" % mount):
			barryallen_imagepath = "/media/%s/backup" % mount
if barryallen_imagepath == "/media/ba/backup":
	if os.path.exists("/media/net"):
	        for mount in os.listdir("/media/net"):
        	    if barryallen_imagepath == "/media/ba/backup" and line.startswith(".") is False: 
			if os.path.exists("/media/net/%s/backup" % mount):
				barryallen_imagepath = "/media/net/%s/backup" % mount
if barryallen_imagepath == "/media/ba/backup":
	if os.path.exists("/autofs"):
	        for mount in os.listdir("/autofs"):
        	    if barryallen_imagepath == "/media/ba/backup" and line.startswith(".") is False: 
			if os.path.exists("/autofs/%s/backup" % mount):
				barryallen_imagepath = "/autofs/%s/backup" % mount
	
global barryallen_fschecked
barryallen_fschecked=False

class BarryAllenMain(Screen):
    skin = """
           <screen position="center,center" size="560,400" title="Barry Allen Menu" >
	   <widget name="left" position="10,30" size="20,40" backgroundColor="background" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;32"/>
	   <widget name="right" position="530,30" size="20,40" backgroundColor="background" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;32"/>
	   <widget name="image" position="40,20" size="480,60" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;24"/>
           <widget name="menu" position="10,100" size="540,240" scrollbarMode="showOnDemand" />
           <ePixmap position="10,350" size="100,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/BarryAllen/barryallen.png" transparent="1" alphatest="on" />	
	   <widget name="buttonred" position="120,350" size="100,40" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	   <widget name="buttongreen" position="230,350" size="100,40" backgroundColor="green" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	   <widget name="buttonyellow" position="340,350" size="100,40" backgroundColor="yellow" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	   <widget name="buttonblue" position="450,350" size="100,40" backgroundColor="blue" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
           </screen>""" 
    def __init__(self, session, args = 0):
        self.skin = BarryAllenMain.skin
        self.session = session
        Screen.__init__(self, session)
        self.onShown.append(self.setWindowTitle)  
	self["left"] = Label("<")
	self["right"] = Label(">")
	self["image"] = Label(booted_image)
	self["buttonred"] = Label(_("Cancel"))
	self["buttongreen"] = Label(_("OK"))
	self["buttonyellow"] = Label("Setup")
	self["buttonblue"] = Label("About")
        self.menu = args
        list = []
        list.append((_("Wizard for installed Images"), "changewizardba"))
        list.append((_("Wizard for Images at backup"), "manipulatewizardba"))
        if os.path.exists(barryallen_lite) == False:
           list.append((_("Wizard for Tools"), "toolswizardba"))
        list.append((_("Wizard for Setup"), "setupwizardba"))
        if os.path.exists("%s/plugin.py" % wallywest_plugindir ) == True:
           list.append((_("Wally West"), "wallywestba"))
        self["menu"] = MenuList(list)
        self["actions"] = ActionMap(["SetupActions", "ColorActions"],{"ok": self.go, "cancel": self.leave, "red": self.close, "deleteForward": self.forward, "deleteBackward": self.backward, "0": self.reset, "green": self.go, "yellow": self.yellow, "blue": self.about, }, -1)

    def setWindowTitle(self):   
    	self.imagelist= self.bootableImages()
	self.imagelistlength=len(self.imagelist)
        x=0
	self.imageselected=0
        while (x < self.imagelistlength):
		print booted_image
                print self.imagelist[x][1]
		if booted_image==self.imagelist[x][2]:
			self.imageselected=x
			print self.imagelist[x][2]
		x=x+1
	self["image"].setText(self.imagelist[self.imageselected][0])

       	self.setTitle(title1_string)
	global barryallen_fschecked
	if os.path.exists("/media/ba/ba.sh") and not barryallen_fschecked:
		if os.path.exists("/media/ba/.bafatcheck"):
			try:
				os.remove("/media/ba/.bafatcheck")
			except:
				pass
		if os.path.exists("/media/ba/.bafatcheck"):
			barryallen_fschecked=True
               		self.session.open(MessageBox,_("Bootdevice seems to be read only mountet\nboot from Flash and do a Filesystemcheck!"), MessageBox.TYPE_ERROR)
		else:
			try:
				os.symlink("/media/ba/ba.sh","/media/ba/.bafatcheck")
			except:
				pass
			if os.path.exists("/media/ba/.bafatcheck"):
				os.remove("/media/ba/.bafatcheck")
			else:
				barryallen_fschecked=True
	               		self.session.open(MessageBox,_("Bootdevice seems to be read only mountet\nboot from Flash and do a Filesystemcheck!"), MessageBox.TYPE_ERROR)

    def bootableImages(self):
        imagesinstalled = []
        imagesinstalled2 = []
        imagesinstalled.append(( "Flash", "Flash", "Flash" ))
        for line in os.listdir("/media/ba/ba"):
            if line.startswith(".") is False: 
               if line != "Flash":
                  if line == "0" or line == "1" or line == "2" or line == "3" or line == "4" or line == "5" or line == "6" or line == "7" or line == "8":
                     if os.path.exists("/media/ba/ba/%s/.bainfo" % line):
                        bainfo=open("/media/ba/ba/%s/.bainfo" % line)
                        imagename=bainfo.read().rstrip()
                        bainfo.close()
                        imagesinstalled2.append(("%s (%s)" % (line,imagename), line,imagename ))
                  else:
                     imagesinstalled2.append(( line, line,line ))
        imagesinstalled2.sort()
        imagesinstalled = imagesinstalled + imagesinstalled2
        return imagesinstalled

    def reset(self):
	self.imageselected=0
	self["image"].setText(self.imagelist[self.imageselected][0])

    def forward(self):
	self.imageselected = self.imageselected+1
	if self.imageselected > self.imagelistlength-1:
		self.imageselected=0
	self["image"].setText(self.imagelist[self.imageselected][0])

    def backward(self):
	self.imageselected = self.imageselected-1
	if self.imageselected < 0:
		self.imageselected = self.imagelistlength-1
	self["image"].setText(self.imagelist[self.imageselected][0])

    def leave(self):
        self.close()

    def yellow(self):
	self.session.open(BarryAllenConfiguration)

    def about(self):
        self.session.open(AboutBarryAllen)

    def go(self):
	if self.imagelist[self.imageselected][2] != booted_image:
	     	self.boot=self.imageselected
	      	if config.plugins.barryallen.confirm.value:
                        self.session.openWithCallback(self.ImageBoot,MessageBox,_("boot image %s now ?") % self.imagelist[self.boot][0], MessageBox.TYPE_YESNO)
		else:
                        self.ImageBoot(True)
	      
	else:
	        returnValue = self["menu"].l.getCurrentSelection()[1]
	        if returnValue is not None:
           		if returnValue is "changewizardba":
                		self.session.open(ChangeWizardba)
           		elif returnValue is "manipulatewizardba":
                		self.session.open(ManipulateWizardba)
           		elif returnValue is "toolswizardba":
                		self.session.open(ToolsWizardba)
           		elif returnValue is "setupwizardba":
				self.session.open(BarryAllenConfiguration)
           		elif returnValue is "wallywestba":
                		self.session.open(WallyWestPlugin)

    def ImageBoot(self,answer):
	if answer is True:
		title = _("executing boot %s now") % self.imagelist[self.boot][1]
		cmd = "%s %s boot %s now" % (barryallen_ksh, barryallen_script,self.imagelist[self.boot][1] )
		self.session.open(Console,_(title),[cmd])
	else:
		# reset selected image to booted one
	        x=0
		self.imageselected=0
	        while (x < self.imagelistlength):
			print self.imagelist[x][0]
			if booted_image==self.imagelist[x][2]:
				self.imageselected=x
			x=x+1
		self["image"].setText(self.imagelist[self.imageselected][0])
		

class AboutBarryAllen(Screen):
    skin = """
	<screen position="center,center" size="560,400" title="Wizard for installed Images">
        <ePixmap position="10,350" size="100,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/BarryAllen/barryallen.png" transparent="1" alphatest="on" />	
        <ePixmap position="230,10" size="100,100" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/BarryAllen/g3icon_ba.png" transparent="0" alphatest="on" />	
	<widget name="about" position="10,120" size="540,220" backgroundColor="background" valign="center" halign="center" zPosition="2"  foregroundColor="white" font="Regular;18"/>
        <widget name="buttonred" position="120,350" size="100,40" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
        <widget name="buttongreen" position="230,350" size="100,40" backgroundColor="green" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
        <widget name="buttonyellow" position="340,350" size="100,40" backgroundColor="yellow" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
        <widget name="buttonblue" position="450,350" size="100,40" backgroundColor="blue" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	</screen>"""
    def __init__(self, session, args = 0):
        self.session = session
	self.skin = AboutBarryAllen.skin
	Screen.__init__(self, session)
        self.onShown.append(self.setWindowTitle)                                                            
        if ba_language == 'ar':
        	title="%s\n%s\n%s\n%s\n%s" % (title5_string, title4_string, title3_string, title2_string, title1_string)
        else:
                title="%s\n%s\n%s\n%s\n%s" % (title1_string, title2_string, title3_string,  title4_string, title5_string)     
	self["buttonred"] = Label(_("Cancel"))
	self["buttongreen"] = Label(_("OK"))
	self["buttonyellow"] = Label("---")
	self["buttonblue"] = Label("About")
	self["about"] = Label(title)
        self["actions"] = ActionMap(["WizardActions", "ColorActions"],{"ok": self.close, "cancel": self.close, "back": self.close, "red": self.close, "green": self.close, "yellow": self.yellow, "blue": self.close }, -1)

    def yellow(self):                                                                               
    	return

    def setWindowTitle(self):                                                                               
        self.setTitle(_("about Barry Allen Version %s") % barryallen_version)

class ManipulateWizardba(Screen):
    skin = """
	<screen position="center,center" size="560,400" title="Wizard for Images at backup">
	<widget name="menu" position="10,10" size="540,340" scrollbarMode="showOnDemand" />
        <ePixmap position="10,350" size="100,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/BarryAllen/barryallen.png" transparent="1" alphatest="on" />	
	<widget name="buttonred" position="120,350" size="100,40" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	<widget name="buttongreen" position="230,350" size="100,40" backgroundColor="green" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	<widget name="buttonyellow" position="340,350" size="100,40" backgroundColor="yellow" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	<widget name="buttonblue" position="450,350" size="100,40" backgroundColor="blue" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	</screen>"""
    def __init__(self, session, args = 0):
        self.session = session
	self.skin = ManipulateWizardba.skin
	Screen.__init__(self, session)
        self.onShown.append(self.setWindowTitle)                                                            
	self["buttonred"] = Label(_("Cancel"))
	self["buttongreen"] = Label(_("OK"))
	self["buttonyellow"] = Label("Installed")
	self["buttonblue"] = Label("About")
        self.menu = args
        change = []
        manipul = []
 	manipul.append((ar+_("extract Image from backup"),"extract"))
 	manipul.append((ar+_("remove Image from backup"),"remove"))
	if os.path.exists(barryallen_lite) == False:
        	manipul.append((ar+_("rename Image at backup"),"rename"))
        	manipul.append((ar+_("list Images at backup"),"list"))
        self["menu"] = MenuList(manipul)
	self["actions"] = ActionMap(["WizardActions", "ColorActions"], {"red": self.leave, "green": self.go, "yellow": self.yellow, "blue": self.about, "cancel": self.leave, "back": self.leave, "ok": self.go, }, -1) 

    def leave(self):
	self.close()

    def yellow(self):
        self.session.openWithCallback(self.close, ChangeWizardba)

    def about(self):
        self.session.open(AboutBarryAllen)

    def setWindowTitle(self):   
       	self.setTitle(_("Wizard for Images at backup"))

    def go(self):
        manipulation = self["menu"].l.getCurrentSelection()[1]
        if manipulation is None:
	    return
        else:
            self.manipulate = manipulation.rstrip()
            self.source = ""
            self.target = ""
            if self.manipulate == "list":
	       if config.plugins.barryallen.confirm.value:
                  self.session.openWithCallback(self.ImageManipulate,MessageBox,_("executing %s %s %s ?") %(self.manipulate,self.source,self.target),MessageBox.TYPE_YESNO)
	       else:
                  self.ImageManipulate(True)
            elif (self.manipulate == "rename") or (self.manipulate == "remove") or (self.manipulate == "extract"):
               self.session.openWithCallback(self.askForTarget,ChoiceBox,_("select SOURCE Image")+ar2+" "+barryallen_imagepath, self.getListImages())
        
    def askForTarget(self,source):
        if source is None:
            return
        else:
            self.source = source [1].rstrip()
            if self.manipulate == "remove":
               self.target = ""
	       if config.plugins.barryallen.confirm.value:
                  self.session.openWithCallback(self.ImageManipulate,MessageBox,_("executing %s %s %s ?") %(self.manipulate,self.source,self.target),MessageBox.TYPE_YESNO)
	       else:
               	  self.ImageManipulate(True)
            elif self.manipulate == "extract":
               if os.path.exists("/media/ba/ba/1") and not os.path.exists("/media/ba/ba/1/.bainfo"):
                  self.target="1 %s" % self.source
               elif os.path.exists("/media/ba/ba/2") and not os.path.exists("/media/ba/ba/2/.bainfo"):
                  self.target="2 %s" % self.source
               elif os.path.exists("/media/ba/ba/3") and not os.path.exists("/media/ba/ba/3/.bainfo"):
                  self.target="3 %s" % self.source
               elif os.path.exists("/media/ba/ba/4") and not os.path.exists("/media/ba/ba/4/.bainfo"):
                  self.target="4 %s" % self.source
               elif os.path.exists("/media/ba/ba/5") and not os.path.exists("/media/ba/ba/5/.bainfo"):
                  self.target="5 %s" % self.source
               elif os.path.exists("/media/ba/ba/6") and not os.path.exists("/media/ba/ba/6/.bainfo"):
                  self.target="6 %s" % self.source
               elif os.path.exists("/media/ba/ba/7") and not os.path.exists("/media/ba/ba/7/.bainfo"):
                  self.target="7 %s" % self.source
               elif os.path.exists("/media/ba/ba/8") and not os.path.exists("/media/ba/ba/8/.bainfo"):
                  self.target="8 %s" % self.source
               else:
  	          if os.path.exists(barryallen_withdate):
                     self.target = "%s_%s" % (self.source.replace(".tar.gz",""),datetime.date.today())
                  else:
                     self.target=self.source.replace(".tar.gz","")
	       self.session.openWithCallback(self.askForDoManipulation,InputBox, title=_("Please enter number and/or name for TARGET Image"), text="%s                              " % self.target, maxSize=35, type=Input.TEXT)
            else:
  	       if os.path.exists(barryallen_withdate):
               	  self.target = "%s_%s" % (self.source.replace("tar.gz",""),datetime.date.today())
	       else:
                  self.target=self.source.replace(".tar.gz","")
	       self.session.openWithCallback(self.askForDoManipulation,InputBox, title=_("Please enter name for TARGET Image"), text="%s                              " % self.target, maxSize=35, type=Input.TEXT)

    def askForDoManipulation(self,target):
        if target is None:
            return
        else:
            self.target = target.replace("_usb","").rstrip()
	    if config.plugins.barryallen.confirm.value:
            	if self.manipulate.find("extract_") is not -1:
               		self.session.openWithCallback(self.ImageManipulate,MessageBox,_("extract now image %s ?") % self.source,MessageBox.TYPE_YESNO)
            	else:
               		self.session.openWithCallback(self.ImageManipulate,MessageBox,_("executing %s %s %s ?") %(self.manipulate,self.source,self.target),MessageBox.TYPE_YESNO)
	    else:
               	self.ImageManipulate(True)
            
    def ImageManipulate(self,answer):
        if answer is None:
	    return
        if answer is False:
            return
        else:
            title = _("executing %s %s %s") %(self.manipulate,self.source,self.target)
            cmd = "%s %s %s %s %s" % (barryallen_ksh, barryallen_script,self.manipulate,self.source, self.target)
            self.session.open(Console,_(title),[cmd])
            
    def getListImages(self):
        baimagemap = []
        sname = []
        bname = []
	global barryallen_imagepath
	print "[BarryAllen] used imagepath: %s" % barryallen_imagepath
	# now it HAS to exist ...
        for name in os.listdir(barryallen_imagepath):
           if (name.endswith(".tar.gz") or name.endswith(".tar.xz")) and name.find("(") is -1 and name.find(")") is -1 and name.find("[") is -1 and name.find("]") is -1 and name.find("{") is -1 and name.find("}") is -1 and name.find("enigma2settingsbackup") is -1: 
              sname=name.split(".tar.")
              baimagemap.append(( sname[0], sname[0] ))
        baimagemap.sort() 
        return baimagemap 

class ToolsWizardba(Screen):
    skin = """
	  <screen position="center,center" size="560,400" title="Wizard for Tools">
       	  <widget name="menu" position="10,10" size="540,340" scrollbarMode="showOnDemand" />
	  <ePixmap position="10,350" size="100,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/BarryAllen/barryallen.png" transparent="1" alphatest="on" />	
  	  <widget name="buttonred" position="120,350" size="100,40" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	  <widget name="buttongreen" position="230,350" size="100,40" backgroundColor="green" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	  <widget name="buttonyellow" position="340,350" size="100,40" backgroundColor="yellow" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	  <widget name="buttonblue" position="450,350" size="100,40" backgroundColor="blue" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	  </screen>"""
    def __init__(self, session, args = 0):
        self.session = session
	self.skin = ToolsWizardba.skin
	Screen.__init__(self, session)
        self.onShown.append(self.setWindowTitle)                                                            
	self["buttonred"] = Label(_("Cancel"))
	self["buttongreen"] = Label(_("OK"))
	self["buttonyellow"] = Label("Setup")
	self["buttonblue"] = Label("About")
        self.menu = args
        batools = []
        batools.append((ar+_("Execute User Scripts"),"barryallenscript"))
        if os.path.exists(barryallen_lite) == False:
	        batools.append((ar+_("swap setup"),"swap"))
		if not os.path.exists(barryallen_infofile):
	        	batools.append((ar+_("boot device filesystemcheck"),"fsck"))
# 	        batools.append((ar+_("sharing and copy options"),"shared"))
   	        batools.append((ar+_("driver load"),"driver"))
                batools.append((ar+_("Debian installation"),"debian"))
                batools.append((ar+_("%s Settings backup") % enigma_version,"settings_backup"))
                batools.append((ar+_("%s Settings restore") % enigma_version,"settings_restore"))
                batools.append((ar+_("%s Settings reset") % enigma_version,"settings_reset"))
#               batools.append((ar+_("restart options"),"restart"))
        self["menu"] = MenuList(batools)
	self["actions"] = ActionMap(["WizardActions", "ColorActions"], {"red": self.leave, "green": self.go, "yellow": self.yellow, "blue": self.about, "cancel": self.leave, "back": self.leave, "ok": self.go, }, -1) 

    def leave(self):
	self.close()

    def yellow(self):
        self.session.openWithCallback(self.close, BarryAllenConfiguration)

    def about(self):
        self.session.open(AboutBarryAllen)

    def setWindowTitle(self):                                                                               
       	self.setTitle(_("Wizard for Tools"))

    def go(self):
        tools = self["menu"].l.getCurrentSelection()[1]
        if tools is None:
            return
        else:
            self.tools = tools.rstrip()
            if self.tools is "restart":
                self.session.openWithCallback(self.askForCommand,ChoiceBox,_("select restart command")+ar2,self.getRestartList())
            elif self.tools is "fsck":
                title = _("boot device filesystemcheck")
                cmd = "bainit 90" 
                self.session.open(Console,_(title),[cmd])
            elif self.tools is "squashfsrecovery":
                title = _("Squashfs recovery")
                cmd = "bainit 99" 
                self.session.open(Console,_(title),[cmd])
            elif self.tools is "remount":
                title = _("boot device remount")
                cmd = "bainit 900" 
                self.session.open(Console,_(title),[cmd])
            elif self.tools is "ipk_update":
                self.source = "ipk"
                self.kit = "update"
                self.session.openWithCallback(self.toolsCommand,MessageBox,_("are you sure to %s %s") %(self.source,self.kit), MessageBox.TYPE_YESNO)
            elif self.tools is "settings_backup":
                self.source = "settings_backup"
                self.kit = ""
                self.session.openWithCallback(self.toolsCommand,MessageBox,_("are you sure to %s") % self.source, MessageBox.TYPE_YESNO)
            elif self.tools is "settings_restore":
                self.source = "settings_restore"
                self.kit = ""
                self.session.openWithCallback(self.toolsCommand,MessageBox,_("are you sure to %s") % self.source, MessageBox.TYPE_YESNO)
            elif self.tools is "settings_reset":
                self.source = "settings_reset"
                self.kit = ""
                self.session.openWithCallback(self.toolsCommand,MessageBox,_("are you sure to %s") % self.source, MessageBox.TYPE_YESNO)
            elif self.tools is "swap":
                self.session.openWithCallback(self.askForCommand,ChoiceBox,_("select swap command")+ar2,self.getSwapList())
            elif self.tools is "barryallenscript":
                self.session.open(BarryAllenScripts)
            elif self.tools is "debian":
	        self.session.open(MessageBox,_("only extract in telnet supported with ba.sh debian <imagename>"), MessageBox.TYPE_WARNING)
            elif self.tools is "driver":
                self.session.openWithCallback(self.askForSetupCommand,ChoiceBox,_("select driver command")+ar2,self.getDriverList())
            elif self.tools is "shared":
                self.session.openWithCallback(self.askForSetupCommand,ChoiceBox,_("select shared command")+ar2,self.getSharedList())
#           elif self.tools is "language":
#               self.session.openWithCallback(self.askForSetupCommand,ChoiceBox,_("select language command")+ar2,self.getLanguageList())
            else:
	        if config.plugins.barryallen.confirm.value:
                   self.session.openWithCallback(self.setupCommand,MessageBox,_("are you sure to %s") % self.setupCommand, MessageBox.TYPE_YESNO)
		else:
                   self.setupCommand(True)

    def askForSetupCommand(self,setup):
        if setup is None:
	    return
        else:
            self.setup = setup[1].rstrip()
	    if config.plugins.barryallen.confirm.value:
               self.session.openWithCallback(self.setupCommand,MessageBox,_("are you sure to %s") % self.setup, MessageBox.TYPE_YESNO)
	    else:
               self.setupCommand(True)
            
    def setupCommand(self,answer):
        if answer is None:
            return
        if answer is False:
	    return
        else:
            self.kit=""
            title = _("executing command %s %s") %(self.setup,self.kit)
#           cmd = "%s %s %s %s"  % (barryallen_ksh, barryallen_script,self.setup,self.kit)
            cmd = "%s %s"  % (self.setup,self.kit)
            self.session.open(Console,_(title),[cmd])

    def getDriverList(self):
        badriver = []
#        badriver.append((ar+_("checking latest Image Driver"), "check_latest_driver"))
#        badriver.append((ar+_("installing latest Image Driver"), "get_latest_driver"))
#        if os.path.exists(barryallen_infofile) == False:
#           badriver.append((ar+_("checking latest Seconstage Loader"), "check_latest_loader"))
#           badriver.append((ar+_("installing latest Secondstage Loader"), "get_latest_loader"))
#        badriver.append((ar+_("list available Image Drivers"), "list_drivers"))
        badriver.append((ar+_("compare all Image Driver Dates"), "/media/ba/ba.sh check_drivers"))
#        if not os.path.exists("/sys/module/block2mtd/parameters"):
#	        badriver.append((ar+_("get nandsim"), "get_nandsim"))
#	        badriver.append((ar+_("check nandsim"), "check_nandsim"))
        badriver.append((ar+_("dmesg"),"dmesg"))
        badriver.append((ar+_("ifconfig"),"ifconfig"))
        badriver.append((ar+_("ifup"),"ifconfig eth0 up"))
        badriver.append((ar+_("ifdown"),"ifconfig eth0 down"))
        badriver.append((ar+_("netstat"),"netstat"))
        badriver.append((ar+_("lsmod"),"lsmod"))
        badriver.append((ar+_("udevd"),"systemctl status systemd-udevd.service"))
        badriver.append((ar+_("df"),"df -h"))
        badriver.append((ar+_("mounts"),"cat /proc/mounts"))
        badriver.append((ar+_("UUID reset"),"/media/ba/bin/tune2fs -U 00000000-0000-0000-0000-000000000000 /dev/disk/by-label/ba"))
        return badriver

    def getSharedList(self):
        bashared = []
        bashared.append((ar+_("copy automount.conf local to shared"),"copy_automount_local_to_shared"))
        bashared.append((ar+_("copy automount.conf shared to local"),"copy_automount_shared_to_local"))
        bashared.append((ar+_("copy timers.xml local to shared"),"copy_timers_local_to_shared"))
        bashared.append((ar+_("copy timers.xml shared to local"),"copy_timers_shared_to_local"))
        bashared.append((ar+_("enable shared timers.xml"),"enable_shared_timers"))
        bashared.append((ar+_("disable shared timers.xml"),"disable_shared_timers"))
#       bashared.append((ar+_("enable shared epg.dat"),"enable_shared_epg"))
#       bashared.append((ar+_("disable shared epg.dat"),"disable_shared_epg"))
        bashared.append((ar+_("backup all shared files"),"shared backup"))
        bashared.append((ar+_("restore all shared files"),"shared restore"))
        return bashared
        
    def getLanguageList(self):
        balanguage = []
        balanguage.append((ar+_("display current language"),"language"))
#       balanguage.append((ar+_("switch to language ar"),"language ar"))
        balanguage.append((ar+_("switch to language cs"),"language cs"))
        balanguage.append((ar+_("switch to language da"),"language da"))
        balanguage.append((ar+_("switch to language de"),"language de"))
        balanguage.append((ar+_("switch to language en"),"language en"))
        balanguage.append((ar+_("switch to language el"),"language el"))
        balanguage.append((ar+_("switch to language es"),"language es"))
        balanguage.append((ar+_("switch to language fa"),"language fa"))
        balanguage.append((ar+_("switch to language hu"),"language hu"))
        balanguage.append((ar+_("switch to language fr"),"language fr"))
        balanguage.append((ar+_("switch to language it"),"language it"))
        balanguage.append((ar+_("switch to language nl"),"language nl"))
        balanguage.append((ar+_("switch to language no"),"language no"))
        balanguage.append((ar+_("switch to language pl"),"language pl"))
        balanguage.append((ar+_("switch to language pt"),"language pt"))
        balanguage.append((ar+_("switch to language ru"),"language ru"))
        balanguage.append((ar+_("switch to language sr"),"language sr"))
        balanguage.append((ar+_("switch to language sv"),"language sv"))
        balanguage.append((ar+_("switch to language tr"),"language tr"))
        return balanguage

    def askForCommand(self,source):
        if source is None:
	    return
        else:
            self.source = source[1].rstrip()
            self.kit = ""
	    if config.plugins.barryallen.confirm.value:
            	self.session.openWithCallback(self.toolsCommand,MessageBox,_("are you sure to %s") % self.source, MessageBox.TYPE_YESNO)
	    else:
            	self.toolsCommand(True)
            
    def toolsCommand(self,answer):
        if answer is None:
            return
        if answer is False:
	    return
        else:
            if os.path.exists("/.bainfo") == True:
               os.system("cp /media/ba/bainit /sbin/bainit")
            if self.source is "restart":
               quitMainloop(3)
            elif self.source is "timerwrite":
                self.session.nav.RecordTimer.saveTimer()
                self.session.open(MessageBox,_("Timers were written to Flash") , MessageBox.TYPE_INFO)
            elif self.source is "filesystemcheck":
               title = _("executing BA Device Filesystemcheck")
               cmd = "/sbin/bainit 90" 
               self.session.open(Console,_(title),[cmd])
            elif self.source is "remount":
               title = _("executing BA Device remount")
               cmd = "/sbin/bainit 900" 
               self.session.open(Console,_(title),[cmd])
            else:
               title = _("executing command %s %s" %(self.source,self.kit))
               cmd = "%s %s %s %s"  % (barryallen_ksh, barryallen_script,self.source,self.kit)
               self.session.open(Console,_(title),[cmd])
            
    def getKitList(self):
        installkit = []
        
        if os.path.exists(barryallen_imagelist) is True:
           balist = open(barryallen_imagelist,"r")
           for line in balist:
              installkit.append(( line, line ))
           balist.close()

        return installkit

    def getRestartList(self):
        barestart = []
        barestart.append((ar+_("reboot Dreambox"),"reboot"))
        barestart.append((ar+_("halt Dreambox"),"halt"))
        barestart.append((ar+_("restart %s on Dreambox") % enigma_version,"restart"))
        barestart.append((ar+_("only write Timers to Flash") ,"timerwrite"))
#       barestart.append((ar+_("enable WebIF flashing"),"webflash"))
        return barestart

    def getSwapList(self):
        baswap = []
        baswap.append((ar+_("show memory"),"free"))
        es512="%s %s" %(ar+_("enable swapfile"),"512MB")
        es1024="%s %s" %(ar+_("enable swapfile"),"1024MB")
        es2048="%s %s" %(ar+_("enable swapfile"),"2048MB")
        baswap.append((es512,"swapon /media/ba 512000"))
        baswap.append((es1024,"swapon /media/ba 1024000"))
        baswap.append((es2048,"swapon /media/ba 2048000"))
        baswap.append((ar+_("disable swapfile"),"swapoff"))
        return baswap

class ChangeWizardba(Screen):
    skin = """
	  <screen position="center,center" size="560,400" title="Wizard for installed Images">
	  <widget name="menu" position="10,10" size="540,340" scrollbarMode="showOnDemand" />
	  <ePixmap position="10,350" size="100,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/BarryAllen/barryallen.png" transparent="1" alphatest="on" />	
  	  <widget name="buttonred" position="120,350" size="100,40" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	  <widget name="buttongreen" position="230,350" size="100,40" backgroundColor="green" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	  <widget name="buttonyellow" position="340,350" size="100,40" backgroundColor="yellow" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	  <widget name="buttonblue" position="450,350" size="100,40" backgroundColor="blue" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
	  </screen>"""

    def __init__(self, session, args = 0):
        self.session = session
	self.skin = ChangeWizardba.skin
	Screen.__init__(self, session)
        self.onShown.append(self.setWindowTitle)                                                            
	self["buttonred"] = Label(_("Cancel"))
	self["buttongreen"] = Label(_("OK"))
	self["buttonyellow"] = Label("Extract")
	self["buttonblue"] = Label("About")
        self.menu = args
        change = []
        change.append((ar+_("installed Images info"), "info"))
        if not os.path.exists(barryallen_lite):
	        change.append((ar+_("installed Images full info"), "image"))
        change.append((ar+_("select installed Image for booting"), "boot"))
        change.append((ar+_("delete installed Image"),"delete"))
       	change.append((ar+_("backup Image to backup"),"backup"))
        if os.path.exists(barryallen_lite) == False:
        	change.append((ar+_("rename installed Image"),"name"))
        	change.append((ar+_("copy installed Image"),"copy"))
        self["menu"] = MenuList(change)
        self["actions"] = ActionMap(["WizardActions", "ColorActions"],{"ok": self.go, "back": self.leave, "red": self.close, "green": self.leave, "yellow": self.yellow, "blue": self.about, }, -1)

    def leave(self):
	self.close()

    def yellow(self):
        self.session.openWithCallback(self.close, ManipulateWizardba)

    def about(self):
        self.session.open(AboutBarryAllen)

    def setWindowTitle(self):                                                                               
       	self.setTitle(_("Wizard for installed Images"))

    def go(self):
        change = self["menu"].l.getCurrentSelection()[1]
        if change is None:
	    return
        else:
            self.change = change.rstrip()
            self.source = ""
            self.target = ""
            self.passwd = ""
            if self.change == "info" or self.change == "image":
	       if config.plugins.barryallen.confirm.value:
                  self.session.openWithCallback(self.ImageChange,MessageBox,_("executing %s %s %s ?") %(self.change,self.source,self.target),MessageBox.TYPE_YESNO)
	       else:
                  self.ImageChange(True)
            else:
               if os.path.exists(barryallen_locked) == True:
   	          self.session.openWithCallback(self.askForPassword,InputBox, title=_("Please enter PIN"), text="    ", maxSize=4, type=Input.PIN)
	       else:
                  self.session.openWithCallback(self.askForTarget,ChoiceBox,_("select SOURCE Image")+ar2,self.getListInstalledImages())
            
    def askForPassword(self,passwd):
        if passwd is None:
	   return
        else:
           newpasswd = str(hashlib.md5(passwd))
	   m = hashlib.md5()
	   m.update(passwd)
	   newpasswd=m.hexdigest()
           print "Entered PIN encrypted %s" % newpasswd
	   fp = open(barryallen_locked,"r")
	   oldpasswd =fp.readline().rstrip().rstrip("\n")
	   fp.close()
           print "Correct PIN encrypted %s" % oldpasswd
           if newpasswd == oldpasswd:
    	      self.passwd=passwd
              self.session.openWithCallback(self.askForTarget,ChoiceBox,_("select SOURCE Image")+ar2,self.getListInstalledImages())
           else:
	      self.session.open(MessageBox, "Sorry, PIN doesn't match", MessageBox.TYPE_ERROR)
               
    def askForTarget(self,source):
        if source is None:
	    return
        else:
            self.source = source[1].rstrip()
            if self.change == "boot":
               self.session.openWithCallback(self.ImageBoot,MessageBox,_("reboot ?"), MessageBox.TYPE_YESNO)
            elif (self.change == "delete") or (self.change == "image_mount") or (self.change == "image_umount"):
	       if config.plugins.barryallen.confirm.value:
                  self.session.openWithCallback(self.ImageChange,MessageBox,_("executing %s %s %s ?") %(self.change,self.source, self.target),MessageBox.TYPE_YESNO)
               else:
                  self.ImageChange(True)
            else:
               if self.source == "booted": 
  	          if os.path.exists(barryallen_withdate):
                     target = "barryallenbackup_%s" % datetime.date.today()
                  else:
                     target = "barryallenbackup"
               else:
  	          if os.path.exists(barryallen_withdate):
                     target = "%s_%s" % (self.source,datetime.date.today())
		  else:
                     target = self.source
               if self.source.rstrip() == "0" or self.source.rstrip() == "1" or self.source.rstrip() == "2" or self.source.rstrip() == "3" or self.source.rstrip() == "4" or self.source.rstrip() == "5" or self.source.rstrip() == "6" or self.source.rstrip() == "7" or self.source.rstrip() == "8":
                  if os.path.exists("/media/ba/ba/%s/.bainfo" % self.source):
                     bainfo=open("/media/ba/ba/%s/.bainfo" % self.source)
                     imagename=bainfo.read().rstrip()
                     bainfo.close()
     	             if os.path.exists(barryallen_withdate):
                        target="%s_%s" % (imagename,datetime.date.today())
                     else:
                        target=imagename
               question=_("Please enter name for TARGET Image")
               self.target=target.replace("_usb","").rstrip()
               if self.change == "copy":
                  question=_("Please enter number and/or name for TARGET Image")
                  if os.path.exists("/media/ba/ba/0") and not os.path.exists("/media/ba/ba/0/.bainfo") and not os.path.exists("/media/ba/ba/0/.bainfo"):
                     self.target="0 %s" % target
                  elif os.path.exists("/media/ba/ba/1") and not os.path.exists("/media/ba/ba/1/.bainfo"):
                     self.target="1 %s" % target
                  elif os.path.exists("/media/ba/ba/2") and not os.path.exists("/media/ba/ba/2/.bainfo"):
                     self.target="2 %s" % target
                  elif os.path.exists("/media/ba/ba/3") and not os.path.exists("/media/ba/ba/3/.bainfo"):
                     self.target="3 %s" % target
                  elif os.path.exists("/media/ba/ba/4") and not os.path.exists("/media/ba/ba/4/.bainfo"):
                     self.target="4 %s" % target
                  elif os.path.exists("/media/ba/ba/5") and not os.path.exists("/media/ba/ba/5/.bainfo"):
                     self.target="5 %s" % target
                  elif os.path.exists("/media/ba/ba/6") and not os.path.exists("/media/ba/ba/6/.bainfo"):
                     self.target="6 %s" % target
                  elif os.path.exists("/media/ba/ba/7") and not os.path.exists("/media/ba/ba/7/.bainfo"):
                     self.target="7 %s" % target
                  elif os.path.exists("/media/ba/ba/8") and not os.path.exists("/media/ba/ba/8/.bainfo"):
                     self.target="8 %s" % target
                  else:
                     question=_("Please enter name for TARGET Image")
               self.session.openWithCallback(self.processingChange,InputBox, title=question, text="%s                              " % self.target, maxSize=35, type=Input.TEXT)
            
    def processingChange(self,target):
        if target is None:
           return
        else:
           self.target= target.replace("_usb","").rstrip()
	   if config.plugins.barryallen.confirm.value:
           	if self.change.startswith("backup_"):
              		self.session.openWithCallback(self.ImageChange,MessageBox,_("backup now image %s ?") % self.source,MessageBox.TYPE_YESNO)
           	else:
              		self.session.openWithCallback(self.ImageChange,MessageBox,_("executing %s %s %s ?") %(self.change,self.source,self.target),MessageBox.TYPE_YESNO)
	   else:
              	self.ImageChange(True)
              
    def ImageBoot(self,reboot):
        if reboot is None:
	   return
        if reboot is False:
           self.target= ""
        else:
           self.target= "now"
        if config.plugins.barryallen.confirm.value:
           self.session.openWithCallback(self.ImageChange,MessageBox,_("executing %s %s %s ?") %(self.change,self.source,self.target),MessageBox.TYPE_YESNO)
	else:
           self.ImageChange(True)

    def ImageChange(self,answer):
        if answer is None:
	    return
        if answer is False:
	    return
        else:
            title = _("executing %s %s %s") %(self.change,self.source,self.target)
            cmd = "%s %s %s %s %s %s" % (barryallen_ksh, barryallen_script,self.change,self.source,self.target,self.passwd)
            self.session.open(Console,_(title),[cmd])
            
    def getListInstalledImages(self):
        imagesinstalled = []
        imagesinstalled2 = []
        if self.change == "copy":
            imagesinstalled.append(( "booted", "booted" ))
        elif (self.change == "boot") or (self.change == "image_mount") or (self.change == "image_umount"):
            imagesinstalled.append(( "Flash", "Flash" ))
        elif (self.change.startswith("backup_")):
            imagesinstalled.append(( "booted", "booted" ))
        for line in os.listdir("/media/ba/ba"):
            if line.startswith(".") is False: 
               if line != "Flash":
                  if line == "0" or line == "1" or line == "2" or line == "3" or line == "4" or line == "5" or line == "6" or line == "7" or line == "8":
                     if os.path.exists("/media/ba/ba/%s/.bainfo" % line):
                        bainfo=open("/media/ba/ba/%s/.bainfo" % line)
                        imagename=bainfo.read().rstrip()
                        bainfo.close()
                        imagesinstalled2.append(("%s (%s)" % (line,imagename), line ))
                     else:
                        if (self.change != "copy") and (self.change != "name") and (self.change != "boot") and (self.change != "delete") and (not self.change.startswith("backup_")):
                           imagename=_("empty")
                           imagesinstalled2.append(("%s (%s)" % (line,imagename), line ))
                  else:
                     imagesinstalled2.append(( line, line ))
        imagesinstalled2.sort()
        imagesinstalled = imagesinstalled + imagesinstalled2
        return imagesinstalled

config.plugins.userscripts = ConfigSubsection()                                                                                 
config.plugins.userscripts.confirm = ConfigBoolean(default = False, descriptions=yes_no_descriptions)
config.plugins.userscripts.scriptsave = ConfigBoolean(default = False, descriptions=yes_no_descriptions)
userscriptlist_options = []
userscriptlist_options.append(( "none",_("none") ))
userscriptlist_options.append(( "execute",_("Execute") ))
userscriptlist_options.append(( "install",_("Install") ))
userscriptlist_options.append(( "both",_("Execute")+" & "+_("Install") ))
config.plugins.userscripts.list = ConfigSelection(default = "none", choices = userscriptlist_options)
userscriptshow_options = []
userscriptshow_options.append(( "plugin",_("Pluginlist") ))
userscriptshow_options.append(( "extension",_("Extension") ))
userscriptshow_options.append(( "both",_("Pluginlist")+" & "+_("Extension") ))
config.plugins.userscripts.show = ConfigSelection(default = "both", choices = userscriptshow_options)

class BarryAllenScripts(Screen, ConfigListScreen):
	skin = """
		<screen position="center,center" size="720,200" title="OoZooN's User Script Plugin">
		<widget name="config" position="10,60" size="700,130" scrollbarMode="showOnDemand" />
		<widget name="logo" position="10,10" size="100,40" transparent="1" alphatest="on" />
		<widget name="buttonred" position="120,10" size="140,40" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		<widget name="buttongreen" position="270,10" size="140,40" backgroundColor="green" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		<widget name="buttonyellow" position="420,10" size="140,40" backgroundColor="yellow" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		<widget name="buttonblue" position="570,10" size="140,40" backgroundColor="blue" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		</screen>"""
	def __init__(self, session):
		self.skin = BarryAllenScripts.skin
        	self.setup_title=(_("Barry Allen User Script Plugin"))
		Screen.__init__(self, session)
		global barryallen_userscripts_first
		if not barryallen_userscripts_first and config.plugins.userscripts.scriptsave.value:
			print "[USERSCRIPTS] using previous save value"
			oldscript=config.plugins.userscripts.script.value
			oldoption=config.plugins.userscripts.option.value
		else:
			oldscript="none"
			oldoption="none"
			if config.plugins.userscripts.scriptsave.value:
				# let's check settings too
				if os.path.exists("/etc/enigma2/settings") == True:
			   		f = open("/etc/enigma2/settings")
			   		line = f.readline()
			   		while (line):
						line = f.readline().replace("\n","")
						sp = line.split("=")
						if (sp[0] == "config.plugins.userscripts.script"):
							oldscript=sp[1]
						if (sp[0] == "config.plugins.userscripts.option"):
							oldoption=sp[1]
					f.close()
			barryallen_userscripts_first=False
		config.plugins.userscripts.script = ConfigSelection(default = "none", choices = self.getscripts(True))
		config.plugins.userscripts.option = ConfigSelection(default = "none", choices = self.getscriptoptions(True))
		config.plugins.userscripts.kit = ConfigSelection(default = "none", choices = self.getkits(True))
		config.plugins.userscripts.script.value=oldscript
		config.plugins.userscripts.option.value=oldoption

                self.list = []
		ConfigListScreen.__init__(self, self.list, session = self.session, on_change = self.changedEntry)
        	self.createSetup()    
	        self.onShown.append(self.setWindowTitle)                                                            
           	self.onLayoutFinish.append(self.byLayoutEnd)
	        self.OK=False
        	# explizit check on every entry                                                                     
        	self.onChangedEntry = []                                                                            
		self.onConfigEntryChanged = []
		self["buttonred"] = Label(_("Exit"))
		self["buttongreen"] = Label(_("Execute"))
		self["buttonyellow"] = Label(_("Install"))
		self["buttonblue"] = Label("Setup")
		self["logo"] = Pixmap()

		self["actions"] = ActionMap(["WizardActions", "ColorActions"], {"red": self.cancel, "green": self.script, "yellow": self.install, "blue": self.config, "back": self.cancel }, -1) 

	def createSetup(self):                                                                                        
                self.list = []
		if config.plugins.userscripts.list.value != "both":
			if config.plugins.userscripts.list.value != "execute" and config.plugins.userscripts.list.value != "both":
        	        	self.list.append(getConfigListEntry(_("select User Script"), config.plugins.userscripts.script))
 	        		self.list.append(getConfigListEntry(_("select User Script option"), config.plugins.userscripts.option))
			if config.plugins.userscripts.list.value != "install" and config.plugins.userscripts.list.value != "both":
        	        	self.list.append(getConfigListEntry(_("select deb kit"), config.plugins.userscripts.kit))
	        self["config"].list = self.list                                         
        	self["config"].l.setList(self.list)                                     
                                                                                
    	def changedEntry(self):                                                     
		self.createSetup()                

	def rcKeyPressed(self, key, flag):                                                                                        
		if (key == 352 or key == 28) and flag == 1 and self.OK:
	        	print "[USERSCRIPTS] key %i flag %i" % (key,flag)                                                                                           
			self.script()
		return 0

	def setWindowTitle(self):                                                                               
		self.addOK(True)
       		self["logo"].instance.setPixmapFromFile("%s/barryallen.png" % barryallen_plugindir)
        	self.setTitle(_("Barry Allen User Script Plugin"))

        def byLayoutEnd(self,status=None): 
		w=720
		if config.plugins.userscripts.list.value == "execute":
			h=100
		elif config.plugins.userscripts.list.value == "install":
			h=130
		elif config.plugins.userscripts.list.value == "none":
			h=200
		else:
			h=60
		self.instance.resize(eSize(*(w, h)))
		self.createSetup()

	def getscriptoptions(self,order):                                                                               
		userscripts_options = []
		if order:
			userscripts_options.append(( "none",_("none") ))
			userscripts_options.append(( "start",_("start") ))
			userscripts_options.append(( "stop",_("stop") ))
			userscripts_options.append(( "restart",_("restart") ))
			userscripts_options.append(( "info",_("info") ))
			userscripts_options.append(( "enable",_("enable autostart") ))
			userscripts_options.append(( "disable",_("disable autostart") ))	
			userscripts_options.append(( "enable & start",_("enable autostart")+" & "+_("start") ))
			userscripts_options.append(( "stop & disable",_("stop")+" & "+_("disable autostart") ))	
			userscripts_options.append(( "userdefined",_("userdefined:") ))
			# add further option here
			# userscripts_options.append(( "dummy",_("dummy") ))
		else:
			userscripts_options.append(( _("none"),"none" ))
			userscripts_options.append(( _("start"), "start" ))
			userscripts_options.append(( _("stop"), "stop" ))
			userscripts_options.append(( _("restart"), "restart" ))
			userscripts_options.append(( _("info"), "info" ))
			userscripts_options.append(( _("enable autostart"), "enable" ))
			userscripts_options.append(( _("disable autostart"), "disable" ))	
			userscripts_options.append(( _("start")+" & "+_("enable autostart"), "start & enable" ))
			userscripts_options.append(( _("stop")+" & "+_("disable autostart"), "stop & disable" ))	
			userscripts_options.append(( _("userdefined:"), "userefined" ))
			# add further option here
			# userscripts_options.append(( _("dummy"), "dummy" ))
		return userscripts_options

	def getlistoptions(self,order):                                                                               
		userscriptlist_options = []
		if order:
			userscriptlist_options.append(( "none",_("none") ))
			userscriptlist_options.append(( "execute",_("Execute") ))
			userscriptlist_options.append(( "install",_("Install") ))
			userscriptlist_options.append(( "both",_("Execute")+" & "+_("Install") ))
		else:
			userscriptlist_options.append(( _("none"), "none" ))
			userscriptlist_options.append(( _("Execute"), "execute" ))
			userscriptlist_options.append(( _("Install"), "install" ))
			userscriptlist_options.append(( _("Execute")+" & "+_("Install"), "both" ))
		return userscriptlist_options

	def getscripts(self,order):                                                                               
		userscripts = []
		if order:
			userscripts.append(( "none", _("none")))
		else:
			userscripts.append((  _("none"), "none" ))
		if os.path.exists(barryallen_userscripts_path) is True:
			for script in os.listdir(barryallen_userscripts_path):
				if script.endswith(".sh") and not script.startswith("."): 
					if order:
						userscripts.append(( "%s/%s" % (barryallen_userscripts_path,script), script.replace(".sh","") ))
					else:
						userscripts.append(( script.replace(".sh",""), "%s/%s" % (barryallen_userscripts_path,script) ))
		if os.path.exists("/media/ba/script") is True:
			for script in os.listdir("/media/ba/script"):
				if script.endswith(".sh") and not script.startswith("."): 
					if order:
						userscripts.append(( "/media/ba/script/%s" % script, script.replace(".sh","") ))
					else:
						userscripts.append(( script.replace(".sh",""), "/media/ba/script/%s" % script))
		return userscripts

	def getkits(self,order):                                                                               
		userkits = []
		if order:
			userkits.append(( "none",_("none") ))
		else:
			userkits.append(( _("none"), "none" ))
		for kitfile in os.listdir("/tmp"):
			if kitfile.endswith(".deb") is True: 
				if order:
					userkits.append(( "/tmp/%s" % kitfile, kitfile ))
				else:
					userkits.append(( kitfile, "/tmp/%s" % kitfile ))
		if os.path.exists("/media/hdd") is True:
			for kitfile in os.listdir("/media/hdd"):
				if kitfile.endswith(".deb") is True: 
					if order:
						userkits.append(( "/media/hdd/%s" % kitfile, kitfile))
					else:
						userkits.append(( kitfile, "/media/hdd/%s" % kitfile))
	
		if os.path.exists("/media/hdd/backup") is True:
			for kitfile in os.listdir("/media/hdd/backup"):
				if kitfile.endswith(".deb") is True: 
					if order:
						userkits.append(( "/media/hdd/backup/%s" % kitfile, kitfile))
					else:
						userkits.append(( kitfile, "/media/hdd/backup/%s" % kitfile))

		if os.path.exists("/media/ba/backup") is True:
			for kitfile in os.listdir("/media/ba/backup"):
				if kitfile.endswith(".deb") is True: 
					if order:
						userkits.append(( "/media/ba/backup/%s" % kitfile, kitfile))
					else:
						userkits.append(( kitfile, "/media/ba/backup/%s" % kitfile))
		return userkits

        def leave(self):
	      config.plugins.userscripts.script.save()
	      config.plugins.userscripts.option.save()
	      # doesn't make sense to save last kit and have it in the settings
	      config.plugins.userscripts.kit.value="none"
	      config.plugins.userscripts.kit.save()
	      self.removeOK()
              self.close(True)                                                                                              
                                                                        
    	def cancel(self):
    	      config.plugins.userscripts.script.cancel()
    	      config.plugins.userscripts.option.cancel()
	      self.removeOK()
              self.close(False)       
                                                                         
        def config(self):
	      self.removeOK()
              self.session.openWithCallback(self.byLayoutEnd,BarryAllenScriptsConfiguration)
	      self.OK=False

	def connectHighPrioAction(self):
		self.highPrioActionSlot = eActionMap.getInstance().bindAction('', -0x7FFFFFFF, self.rcKeyPressed)

	def disconnectHighPrioAction(self):
		self.highPrioAction = None

    	def addOK(self,status):
	      # thanks Dr. Best !         
              print "[USERSCRIPTS] add OK"                                                                                  
	      if not self.OK:
		self.OK=True
                self.onShow.append(self.connectHighPrioAction)                  
                self.onHide.append(self.disconnectHighPrioAction)     

    	def removeOK(self):
	      # thanks Dr. Best !         
              print "[USERSCRIPTS] remove OK"                                                                                  
	      if self.OK:
		 self.OK=False

        def script(self):
		self.removeOK()
		if config.plugins.userscripts.list.value == "execute" or config.plugins.userscripts.list.value == "both":
			options=self.getscripts(False)
			select=0
			i=0
			for option in options:
				print option
				if option[1]==config.plugins.userscripts.script.value:
					select=i
				i=i+1
			self.session.openWithCallback(self.doscript,ChoiceBox,_("select User Script"), options, None, select)
		else:
			self.doscript2(config.plugins.userscripts.script.value)

        def doscript(self,scriptname):
   	        self.removeOK()
        	if scriptname is None or scriptname[0] == "none" or scriptname[1] == "none":
			self.skipscript(_("script is none"))
        	else:
            		self.scriptname = scriptname[1]
			options=self.getscriptoptions(False)
			select=0
			i=0
			for option in options:
				print option
				if option[1]==config.plugins.userscripts.option.value:
					select=i
				i=i+1
			self.session.openWithCallback(self.dooption,ChoiceBox,_("select User Script option"), options, None, select)

        def dooption(self,scriptoption):
   	        self.removeOK()
		if scriptoption == None:
			self.skipscript(_("option is none"))
	        else:
			if scriptoption == "none":
				self.option=""
			else:
				self.option=scriptoption[1]
			if self.option == "userdefined":
				self.option="restart"
	       			self.session.openWithCallback(self.enteroption,InputBox, title=_("Please enter option for %s") % self.scriptname, text="%s                              " % self.option, maxSize=35, type=Input.TEXT)
    	   		else:
				if config.plugins.userscripts.confirm.value:
       					self.session.openWithCallback(self.execute,MessageBox,_("are you sure to %s %s ?") %(self.scriptname,self.option), MessageBox.TYPE_YESNO)
				else:
					self.execute(True)

        def doscript2(self,scriptname):
   	        self.removeOK()
		if scriptname == "none":
			self.skipscript(_("no user script selected"))
		else:
			self.scriptname=scriptname
			self.option=config.plugins.userscripts.option.value
			if self.option == "none":
				self.option=""
				if config.plugins.userscripts.confirm.value:
               				self.session.openWithCallback(self.execute,MessageBox,_("are you sure to %s %s ?") %(self.scriptname,self.option), MessageBox.TYPE_YESNO)
				else:
               				self.execute(True)
			elif self.option == "userdefined":
				self.option="restart"
		       		self.session.openWithCallback(self.enteroption,InputBox, title=_("Please enter option for %s") % self.scriptname, text="%s                              " % self.option, maxSize=35, type=Input.TEXT)
            		else:
				if config.plugins.userscripts.confirm.value:
               				self.session.openWithCallback(self.execute,MessageBox,_("are you sure to %s %s ?") %(self.scriptname,self.option), MessageBox.TYPE_YESNO)
				else:
					self.execute(True)

        def enteroption(self,option):
   	        self.removeOK()
        	if option is None:
			self.skipscript(_("option is none"))
        	else:
            		self.option = option.rstrip()
			if config.plugins.userscripts.confirm.value:
            			self.session.openWithCallback(self.execute,MessageBox,_("are you sure to %s %s ?") % (self.scriptname, self.option), MessageBox.TYPE_YESNO)
			else:
               			self.execute(True)
            
        def execute(self,answer):
   	        self.removeOK()
	        if answer is None:
	        	self.skipscript(_("answer is None"))
       		elif answer is False:
            		self.skipscript(_("you were not confirming"))
        	else:
            		title = _("executing User Script %s %s" %(self.scriptname,self.option))
			if self.option.find("&") is not -1:
				options=[]
				options=self.option.split("&")
				print options[0].rstrip().lstrip()
				print options[1].rstrip().lstrip()
            			cmd = "%s %s; %s %s"  % (self.scriptname,options[0],self.scriptname,options[1])
			else:
            			cmd = "%s %s"  % (self.scriptname,self.option)
			print "[USERSCRIPT] command %s" % cmd
			if config.plugins.userscripts.scriptsave.value:
				config.plugins.userscripts.script.value=self.scriptname
				config.plugins.userscripts.option.value=self.option
	            		self.session.openWithCallback(self.leave,Console,_(title),[cmd])
			else:
	            		self.session.openWithCallback(self.cancel,Console,_(title),[cmd])

	def skipscript(self,reason):
		self.removeOK()
		self.session.open(MessageBox,_("User Script was canceled, because %s") % reason, MessageBox.TYPE_ERROR)

	def install(self):
		self.removeOK()
		if config.plugins.userscripts.list.value == "install" or config.plugins.userscripts.list.value == "both":
			options=self.getkits(False)
			self.session.openWithCallback(self.doinstall,ChoiceBox,_("select deb kit"), options)
		else:
			self.doinstall2(config.plugins.userscripts.kit.value)

	def doinstall(self,userscriptkit):
   	        self.removeOK()
		if userscriptkit is None or userscriptkit[0] == "none" or userscriptkit[1] == "none":
			self.skipinstall(_("no kit selected"))
		else:
			self.kit=userscriptkit[1]
			if config.plugins.userscripts.confirm.value:
				self.session.openWithCallback(self.debinstall,MessageBox,_("install %s ?") % self.kit,MessageBox.TYPE_YESNO)
			else:
               			self.debinstall(True)

	def doinstall2(self,userscriptkit):
   	        self.removeOK()
		if userscriptkit == "none":
			self.skipinstall(_("no kit selected"))
		else:
			self.kit=userscriptkit
			if config.plugins.userscripts.confirm.value:
				self.session.openWithCallback(self.debinstall,MessageBox,_("install %s ?") % self.kit,MessageBox.TYPE_YESNO)
			else:
               			self.debinstall(True)

	def skipinstall(self,reason):
		self.removeOK()
        	self.session.open(MessageBox,_("deb install was canceled, because %s") % reason, MessageBox.TYPE_ERROR)
            
	def debinstall(self,answer):
   	        self.removeOK()
	        if answer is None:
	        	self.skipinstall(_("answer is None"))
        	elif answer is False:
            		self.skipinstall(_("you were not confirming"))
        	else:
			title = _("installing %s" %(self.kit))
			cmd = "apt-get update; dpkg -i %s; apt-get install -f -y --force-yes"  % (self.kit)
            		self.session.open(Console,_(title),[cmd])

class BarryAllenScriptsConfiguration(Screen, ConfigListScreen):
	skin = """
		<screen position="center,center" size="720,200" title="OoZooN's User Script Plugin">
		<widget name="config" position="10,60" size="700,130" scrollbarMode="showOnDemand" />
		<widget name="logo" position="10,10" size="100,40" transparent="1" alphatest="on" />
		<widget name="buttonred" position="120,10" size="140,40" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		<widget name="buttongreen" position="270,10" size="140,40" backgroundColor="green" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		<widget name="buttonyellow" position="420,10" size="140,40" backgroundColor="yellow" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		<widget name="buttonblue" position="570,10" size="140,40" backgroundColor="blue" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		</screen>"""
	def __init__(self, session):
		self.skin = BarryAllenScriptsConfiguration.skin
		Screen.__init__(self, session)
                self.list = []
                self.list.append(getConfigListEntry(_("select from list"), config.plugins.userscripts.list))
                self.list.append(getConfigListEntry(_("save script and option"), config.plugins.userscripts.scriptsave))
#               self.list.append(getConfigListEntry(_("show plugin"), config.plugins.userscripts.show))
                self.list.append(getConfigListEntry(_("confirm"), config.plugins.userscripts.confirm))
	        self.onShown.append(self.setWindowTitle)                                                            
		self.oldlist=config.plugins.userscripts.list.value
		self.oldshow=config.plugins.userscripts.show.value
		ConfigListScreen.__init__(self, self.list)
	        self.OK=False
        	# explizit check on every entry                                                                     
        	self.onChangedEntry = []                                                                            
		self["buttonred"] = Label(_("Exit"))
		self["buttongreen"] = Label(_("Save"))
		self["buttonyellow"] = Label(_("---"))
		self["buttonblue"] = Label("About")
		self["logo"] = Pixmap()
		self["actions"] = ActionMap(["WizardActions", "ColorActions"], {"red": self.cancel, "green": self.leave, "blue": self.about, "back": self.cancel  }, -1) 

	def setWindowTitle(self):                                                                               
		self.addOK()
       		self["logo"].instance.setPixmapFromFile("%s/barryallen.png" % barryallen_plugindir)
        	self.setTitle(_("Barry Allen User Script Plugin")+" "+_("Configuration"))

	def rcKeyPressed(self, key, flag):                                                                                        
		if (key == 352 or key == 28) and flag == 1:
	        	print "[USERSCRIPTS] config key %i flag %i" % (key,flag)                                                                                           
			self.leave()
		return 0

        def leave(self):
		self.removeOK()
		config.plugins.userscripts.confirm.save()
		config.plugins.userscripts.list.save()
		config.plugins.userscripts.scriptsave.save()
		config.plugins.userscripts.show.save()
		self.close(True)

	def connectHighPrioAction(self):
		self.highPrioActionSlot = eActionMap.getInstance().bindAction('', -0x7FFFFFFF, self.rcKeyPressed)

	def disconnectHighPrioAction(self):
		self.highPrioAction = None

    	def addOK(self):
	      # thanks Dr. Best !         
              print "[USERSCRIPTS] add config OK"                                                                                  
	      if not self.OK:
	        self.OK=True
                self.onShow.append(self.connectHighPrioAction)                  
                self.onHide.append(self.disconnectHighPrioAction)     

    	def removeOK(self):
	      # thanks Dr. Best !         
              print "[USERSCRIPTS] remove config OK"                                                                                  
	      if self.OK:
		 self.OK=False

    	def cancel(self):                                                                                                         
	      config.plugins.userscripts.confirm.cancel()
	      config.plugins.userscripts.list.cancel()
	      config.plugins.userscripts.scriptsave.cancel()
	      config.plugins.userscripts.show.cancel()
	      self.removeOK()
              self.close(False)       
                                                                         
        def about(self):
	      self.removeOK()
              title=_("Barry Allen User Scripts Plugin V%s") % (barryallen_version)
              self.session.open(MessageBox, title,  MessageBox.TYPE_INFO)

###############################################################################
# Barry Allen Webinterface by gutemine
###############################################################################

class BarryAllenChild(resource.Resource):
	def __init__(self,session):
		self.session = session
		self.putChild('barryallen',BarryAllen())

class BarryAllen(resource.Resource):
        f=open("/proc/stb/info/model")
        boxtype=f.read()
        f.close() 
        boxtype=boxtype.replace("\n","").replace("\l","")
	title = _("Barry Allen Webinterface by gutemine Version %s on %s") % (barryallen_version,boxtype)
	title = title + ": %s" % booted_image
	
	def render(self, req):
		req.setHeader('Content-type', 'text/html')
		req.setHeader('charset', 'UTF-8')
		if os.path.exists("/usr/lib/enigma2/python/Plugins/Extensions/WebInterface/web-data/img/barryallen.png") is False:
			if os.path.exists("%s/barryallen.png" % barryallen_plugindir):
				os.symlink("%s/barryallen.png" % barryallen_plugindir,"/usr/lib/enigma2/python/Plugins/Extensions/WebInterface/web-data/img/barryallen.png")

		global baresult

		""" rendering server response """
		command = req.args.get("cmd",None)

		info_string=_("installed Images info")
		full_info_string=_("installed Images full info")
		drivers_string=_("checking Image Driver Date")
		boot_string=_("select installed Image for booting")
		delete_string=_("delete installed Image")
		name_string=_("rename installed Image")
		copy_string=_("copy installed Image")
		image_mount_string=_("mount installed Image")
		image_umount_string=_("unmount installed Image")
		backup_string=_("backup to Image at backup")
		lock_string=_("switch Image lock")

		htmltasks = "<option value=\"info\" class=\"black\">%s</option>\n" % info_string
#		htmltasks += "<option value=\"image\" class=\"black\">%s</option>\n" % full_info_string
		htmltasks += "<option value=\"boot\" class=\"black\">%s</option>\n" % boot_string
		htmltasks += "<option value=\"delete\" class=\"black\">%s</option>\n" % delete_string
		htmltasks += "<option value=\"name\" class=\"black\">%s</option>\n" % name_string
		htmltasks += "<option value=\"copy\" class=\"black\">%s</option>\n" % copy_string
#		htmltasks += "<option value=\"copy\" class=\"black\">%s</option>\n" % drivers_string
		htmltasks += "<option value=\"backup\" class=\"black\">%s</option>\n" % backup_string

		htmlimages = "<option value=\"booted\">booted</option>\n"
		for name in os.listdir("/media/ba/ba"):
			if name.startswith(".") is False: 
				if name != "Flash":
					if name == "1" or name == "2" or name == "3" or name == "4" or name == "5" or name == "6" or name == "7" or name == "8":
						if os.path.exists("/media/ba/ba/%s/.bainfo" % name):
							bainfo=open("/media/ba/ba/%s/.bainfo" % name)
							imagename=bainfo.read()
							bainfo.close()
							htmlimages += "<option value=\"%s\">%s (%s)</option>\n" % (name,name,imagename)
						else:
							imagename=_("empty")
							htmlimages += "<option value=\"%s\">%s (%s)</option>\n" % (name,name,imagename)
					else:
						htmlimages += "<option value=\"%s\">%s</option>\n" % (name,name)
		if os.path.exists("/media/ba/ba/Flash") is False:	
			htmlimages += "<option value=\"Flash\" selected>Flash</option>\n"

		list_string=_("list Images at backup")
		extract_string=_("extract Image from backup")
		delete_extract_string=_("delete and extract Image from backup")
		remove_string=_("remove Image from backup")
		rename_string=_("rename Image at backup")
		list_tar_string=_("list bar Images at backup")
		extract_tar_string=_("extract bar Image from backup")
		remove_tar_string=_("remove bar Image from backup")
		rename_tar_string=_("rename bar Image at backup")
		htmlnfitasks = "<option value=\"list\" class=\"black\">%s</option>\n" % list_string
		htmlnfitasks += "<option value=\"extract\" class=\"black\">%s</option>\n" % extract_string
		htmlnfitasks += "<option value=\"rename\" class=\"black\">%s</option>\n" % rename_string
#		htmlnfitasks += "<option value=\"delete_extract\" class=\"black\">%s</option>\n" % delete_extract_string
		htmlnfitasks += "<option value=\"remove\" class=\"black\">%s</option>\n" % remove_string
#		htmlnfitasks += "<option value=\"list_tar\" class=\"black\">%s</option>\n" % list_tar_string
#		htmlnfitasks += "<option value=\"extract_tar\" class=\"black\">%s</option>\n" % extract_tar_string
#		htmlnfitasks += "<option value=\"rename_tar\" class=\"black\">%s</option>\n" % rename_tar_string
#		htmlnfitasks += "<option value=\"remove_tar\" class=\"black\">%s</option>\n" % remove_tar_string
		htmlnfi = "<br>\n"
		sname = []
		bname = []
		global barryallen_imagepath
		print "[BarryAllen] used imagepath: %s" % barryallen_imagepath
		# now it HAS to exist ...
		for name in os.listdir(barryallen_imagepath):
			if name.endswith(".tar.gz") and name.find("enigma2settings") is -1: 
				sname=name.split(".tar.gz")
				htmlnfi += "<option value=\"%s\" class=\"black\">%s</option>\n" % (sname[0],sname[0])
			elif name.endswith(".tar.xz"): 
				sname=name.split(".tar.xz")
				htmlnfi += "<option value=\"%s\" class=\"black\">%s</option>\n" % (sname[0],sname[0])
			else:
				pass
		reboot_string=_("reboot Dreambox")
		halt_string=_("halt Dreambox")
		restart_string=_("restart %s on Dreambox")% enigma_version
		free_string=_("show memory")
		swapon_string=_("enable swapfile")
		swapoff_string=_("disable swapfile")
		ifconfig_string=_("ifconfig")
		netstat_string=_("netstat")
		htmltools = "<option value=\"reboot\">%s</option>\n" % reboot_string
		htmltools += "<option value=\"halt\">%s</option>\n" %halt_string
		htmltools += "<option value=\"restart\">%s</option>\n" % restart_string
#		htmltools += "<option value=\"ifconfig\">%s</option>\n" % ifconfig_string
#		htmltools += "<option value=\"netstat\">%s</option>\n" % netstat_string
		htmltools += "<option value=\"free\" selected>%s</option>\n" % free_string
		htmltools += "<option value=\"swapon\">%s</option>\n" % swapon_string
		htmltools += "<option value=\"swapoff\">%s</option>\n" % swapoff_string
		htmluser = "<br>\n"
		if os.path.exists("/media/ba/script") is True:
			for name in os.listdir("/media/ba/script"):
				if name.endswith(".sh") is True: 
					htmluser += "<option value=\"/media/ba/script/%s\">%s</option>\n" % (name,name)
		if os.path.exists("/usr/script") == True:
			for name in os.listdir("/usr/script"):
				if name.endswith(".sh") is True: 
					htmluser += "<option value=\"/usr/script/%s\">%s</option>\n" % (name,name)

		mainmenu_string=_("Barry Allen Main Menu")
		mainmenurefresh_string=_("Refresh Barry Allen Main Menu")
	        f=open("/proc/stb/info/model")
	        boxtype=f.read()
	        f.close() 
	        boxtype=boxtype.replace("\n","").replace("\l","")
		header_string=_("Barry Allen Webinterface by gutemine Version %s on %s") % (barryallen_version,boxtype)
		header_string = header_string + ": %s" % booted_image
		notinstalled_string=_("Barry Allen is not installed")

		if command is None:
			if os.path.exists(barryallen_script) == False:
				html = "<html>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n		\"http://www.w3.org/TR/html4/loose.dtd\">\n<head>\n<title>%s</title>\n<link rel=\"shortcut icon\" type=\"/web-data/image/x-icon\" href=\"/web-data/img/favicon.ico\">\n<meta content=\"text/html; charset=UTF-8\" http-equiv=\"content-type\">\n" % self.title
				html += "<STYLE type=\"text/css\">\n"
				html += "OPTION.blue{background-color:white; color:blue}"
				html += "OPTION.black{background-color:white; color:black}"
				html += "OPTION.green{background-color:white; color:green}"
				html += "</STYLE>\n"
				html += "</head>\n<body bgcolor=\"red\">\n"
				html += "<font face=\"Tahoma, Arial, Helvetica\" color=\"yellow\">\n"
				html += "<font size=\"3 \" color=\"yellow\">\n"
				html += "\"%s\"" % notinstalled_string
				html += "</body>\n</html>\n"
			else:
				html  = "<html>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n		\"http://www.w3.org/TR/html4/loose.dtd\">\n<head>\n<title>%s</title>\n<link rel=\"shortcut icon\" type=\"/web-data/image/x-icon\" href=\"/web-data/img/favicon.ico\">\n<meta content=\"text/html; charset=UTF-8\" http-equiv=\"content-type\">\n" % self.title
				html += "<STYLE type=\"text/css\">\n"
				html += "OPTION.blue{background-color:white; color:blue}"
				html += "OPTION.black{background-color:white; color:black}"
				html += "OPTION.green{background-color:white; color:green}"
				html += "</STYLE>\n"
				html += "</head>\n<body bgcolor=\"red\">\n"
				html += "<font face=\"Tahoma, Arial, Helvetica\" color=\"yellow\">\n"
				html += "<font size=\"3 \" color=\"yellow\">\n"
				html += "<hr>\n"
				html += "%s" % header_string
				html += "<hr>\n"
				html += "<br><img src=\"/web-data/img/barryallen.png\" alt=\"Barry Allen ...\"/><br><br>\n"
				html += "<form method=\"GET\">\n"
				html += "<input type=\"hidden\" name=\"\">\n"
				html += "<input type=\"submit\" value=\"%s\">\n" % mainmenurefresh_string
				html += "</select>\n"
				html += "</form>\n"
				html += "<hr>\n"
				wizardinstalled_string=_("Wizard for installed Images")
				execute_string=_("Execute")
				reset_string=_("Reset")
				html += "%s" % wizardinstalled_string
				html += "<form method=\"GET\">\n"
				html += "<select name=\"cmd\">\n"
				html += "%s" % htmltasks
				html += "</select>\n"
				html += "<select name=\"sourceimage\">\n"
				html += "%s" % htmlimages
				html += "<input name=\"targetimage\" type=\"text\" size=\"60\" maxlength=\"60\">\n"
				html += "<input name=\"pin\" type=\"text\" size=\"4\" maxlength=\"4\">\n"
				html += "<br>\n<br>\n"
				html += "<input type=\"submit\" size==\"100px\" value=\"%s\">\n" % execute_string
				html += "<input type=\"reset\" size=\"100px\" value=\"%s\">\n" % reset_string
				html += "</form>\n"
				html += "<hr>\n"
				wizardmbimages_string=_("Wizard for Images at backup")
				html += "%s" % wizardmbimages_string
				html += "<form method=\"GET\">\n"
				html += "<select name=\"cmd\">\n"
				html += "%s" % htmlnfitasks
				html += "</select>\n"
				html += "<select name=\"sourceimage\">\n"
				html += "%s" % htmlnfi
				html += "<input name=\"targetimage\" type=\"text\" size=\"60\" maxlength=\"60\">\n"
				html += "<br>\n<br>\n"
				html += "<input type=\"submit\" size==\"100px\" value=\"%s\">\n" % execute_string
				html += "<input type=\"reset\" size=\"100px\" value=\"%s\">\n" %  reset_string
				html += "</form>\n"
				html += "<hr>\n"
				wizardtools_string=_("Wizard for Tools")
				html += "%s" % wizardtools_string
				html += "<form method=\"GET\">\n"
				html += "<select name=\"cmd\">\n"
				html += "%s" % htmltools
				html += "</select>\n"
				html += "<input type=\"submit\" size==\"100px\" value=\"%s\">\n" % execute_string
				html += "<input type=\"reset\" size=\"100px\" value=\"%s\">\n" % reset_string
				html += "</form>\n"
				html += "<hr>\n"
				user_script_string=_("Execute User Script from /media/ba/script and /usr/script and userspecific option")
				html += "%s" % user_script_string
				html += "<form method=\"GET\">\n"
				html += "<select name=\"cmd\">\n"
				html += "%s" % htmluser
				html += "<input name=\"arguments\" type=\"text\" size=\"60\" maxlength=\"60\">\n"
				html += "<input type=\"submit\" size==\"100px\" value=\"%s\">\n" % execute_string
				html += "<input type=\"reset\" size=\"100px\" value=\"%s\">\n" % reset_string
				html += "</form>\n"
				html += "<hr>\n"
				if os.path.exists("/usr/lib/enigma2/python/Plugins/Extensions/WebInterface/WebChilds/Uploader.py.disabled") == True:
					selected_string=_("selected") 
					fileupload_string=_("Upload %s file to backup") % selected_string
					html += "%s" % fileupload_string
					html += "<form method=\"GET\">\n"
					html += "<table cellPadding=0 cellSpacing=10>\n"
					html += "<tr>\n<td align=right>select File</td>\n<td>&nbsp;&nbsp;<input type=file name=file value=\"\">\n</td>\n</tr>\n"
					html += "<input type=\"hidden\" name=\"cmd\" value=\"upload\">\n"
					html += "<input type=\"submit\" value=\"%s\">\n</td>\n</tr>\n" % execute_string
					html += "</table>\n"
					html += "</form>\n"
					html += "</body>\n"
					html += "</html>\n"
					html += "<hr>\n"
				help_string=_("Help")
				about_string=_("about Barry Allen Version %s") % barryallen_version
				html += "%s" % help_string
				html += "<form method=\"GET\">\n"
				html += "<input type=\"hidden\" name=\"cmd\" value=\"about\">\n"
				html += "<input type=\"submit\" value=\"%s\">\n" % about_string
				html += "</select>\n"
				html += "</form>\n"
				html += "<hr>\n"
				html += "</body>\n"
				html += "</html>\n"
		elif command[0] ==  "upload":
			uploadfile = req.args.get("file",None)
			nameparts = []
			if uploadfile[0] is "":
				fileerror_string=_("ERROR: no file specified for Upload")
				html  = "<html>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n		\"http://www.w3.org/TR/html4/loose.dtd\">\n<head>\n<title>%s</title>\n<link rel=\"shortcut icon\" type=\"/web-data/image/x-icon\" href=\"/web-data/img/favicon.ico\">\n<meta content=\"text/html; charset=UTF-8\" http-equiv=\"content-type\">\n</head>\n<body bgcolor=\"red\">\n" % self.title
				html += "<font face=\"Tahoma, Arial, Helvetica\" color=\"yellow\">\n"
				html += "<font size=\"3 \" color=\"yellow\">\n"
				html += "<hr>\n"
				html += "%s" % header_string
				html += "<hr>\n"
				html += "%s" % fileerror_string
				html += "<hr>\n"
				html += "<form method=\"GET\">\n"
				html += "<input type=\"hidden\" name=\"\">\n"
				html += "<input type=\"submit\" value=\"%s\">\n" % mainmenu_string
				html += "</select>\n"
				html += "</form>\n"
				html += "<hr>\n"
				html += "</body>\n"
				html += "</html>\n"
			else:
				fileupload_string=_("Upload %s file to backup") % uploadfile[0]
				html  = "<html>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n		\"http://www.w3.org/TR/html4/loose.dtd\">\n<head>\n<title>%s</title>\n<link rel=\"shortcut icon\" type=\"/web-data/image/x-icon\" href=\"/web-data/img/favicon.ico\">\n<meta content=\"text/html; charset=UTF-8\" http-equiv=\"content-type\">\n</head>\n<body bgcolor=\"red\">\n" % title1_string
				html += "<font face=\"Tahoma, Arial, Helvetica\" color=\"yellow\">\n"
				html += "<font size=\"3 \" color=\"yellow\">\n"
				html += "<hr>\n"
				html += "<a href=\"/upload?path='/media/hdd/backup'&file='%s'\">%s</a>\n<p>\n" % (uploadfile[0],fileupload_string)
				html += "<hr>\n"
				html += "</body>\n"
				html += "</html>\n"
		elif command[0] ==  "about":
				html  = "<html>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n		\"http://www.w3.org/TR/html4/loose.dtd\">\n<head>\n<title>about %s</title>\n<link rel=\"shortcut icon\" type=\"/web-data/image/x-icon\" href=\"/web-data/img/favicon.ico\">\n<meta content=\"text/html; charset=UTF-8\" http-equiv=\"content-type\">\n</head>\n<body bgcolor=\"red\">\n" % self.title
				html += "<font face=\"Tahoma, Arial, Helvetica\" color=\"yellow\">\n"
				html += "<font size=\"3 \" color=\"yellow\">\n"
				html += "<hr>\n"
				html += "%s" % title1_string
				html += "<hr>\n"
#				html += "%s" % title2_string
#				html += "<hr>\n"
				html += "%s" % title3_string
				html += "<hr>\n"
				html += "%s" % title4_string
				html += "<hr>\n"
				html += "%s" % title5_string
				html += "<hr>\n"
				html += "</body>\n"
				html += "</html>\n"
		elif command[0] == "result":
#			req.setResponseCode(http.OK)
			req.setHeader('Content-type', 'text/html')
			return baresult
		elif command[0] == "reboot":
			rebooting_string=_("rebooting Dreambox now")
			html  = "<html>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n		\"http://www.w3.org/TR/html4/loose.dtd\">\n<head>\n<title>%s</title>\n<link rel=\"shortcut icon\" type=\"/web-data/image/x-icon\" href=\"/web-data/img/favicon.ico\">\n<meta content=\"text/html; charset=UTF-8\" http-equiv=\"content-type\">\n</head>\n<body bgcolor=\"red\">\n" % self.title
			html += "<font face=\"Tahoma, Arial, Helvetica\" color=\"yellow\">\n"
			html += "<font size=\"3 \" color=\"yellow\">\n"
			html += "<hr>\n"
			html += "%s" % header_string
			html += "<hr>\n"
			html += "%s" % rebooting_string
			html += "<hr>\n"
			html += "</body>\n</html>\n"
			os.system("reboot")
		else:
			arguments = req.args.get("arguments"," ")[0].rstrip().replace(" ","").replace("|","").replace(">\n","").replace("<","")
			sourcename = req.args.get("sourceimage"," ")[0].rstrip().replace(" ","").replace("|","").replace(">\n","").replace("<","")
			targetname = req.args.get("targetimage"," ")[0].rstrip().replace(" ","").replace("|","").replace(">\n","").replace("<","")
			pin = req.args.get("pin"," ")[0].rstrip().replace(" ","").replace("|","").replace(">\n","").replace("<","")
			executing_string=_("Barry Allen Version %s executing command %s") % (barryallen_version,command[0])
			html  = "<html>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n		\"http://www.w3.org/TR/html4/loose.dtd\">\n<head>\n<title>%s</title>\n<link rel=\"shortcut icon\" type=\"/web-data/image/x-icon\" href=\"/web-data/img/favicon.ico\">\n<meta content=\"text/html; charset=UTF-8\" http-equiv=\"content-type\">\n</head>\n<body bgcolor=\"red\">\n" % self.title
			html += "<font face=\"Tahoma, Arial, Helvetica\" color=\"yellow\">\n"
			html += "<font size=\"3 \" color=\"yellow\">\n"
			html += "<hr>\n"
			html += "%s" % executing_string
			html += "<hr>\n"
			html += "</body>\n</html>\n"
			extract_string=_("extract will restart %s and also the Webserver")% enigma_version
			flash_string=_("flash will restart %s and also the Webserver")% enigma_version
			checkinfo_string=_("check result in Main Menu with info option in 3 min")
			checkinfo_list=_("check result in Main Menu with list option in 3 min")
			result_string=_("show command result")
			if command[0] == "extract":
#				html += "%s" % extract_string
#				html += "<hr>\n"
				html += "%s" % checkinfo_string
				html += "<hr>\n"
				html += "<form method=\"GET\">\n"
				html += "<input type=\"hidden\" name=\"\">\n"
				html += "<input type=\"submit\" value=\"%s\">\n" % mainmenu_string
				html += "</select>\n"
				html += "</form>\n"
			elif command[0] == "delete_extract":
#				html += "%s" % delete_extract_string
#				html += "<hr>\n"
				html += "%s" % checkinfo_string
				html += "<hr>\n"
				html += "<form method=\"GET\">\n"
				html += "<input type=\"hidden\" name=\"\">\n"
				html += "<input type=\"submit\" value=\"%s\">\n" % mainmenu_string
				html += "</select>\n"
				html += "</form>\n"
			elif command[0] == "backup":
				html += "%s" % checkinfo_string
				html += "<hr>\n"
				html += "<form method=\"GET\">\n"
				html += "<input type=\"hidden\" name=\"\">\n"
				html += "<input type=\"submit\" value=\"%s\">\n" % mainmenu_string
				html += "</select>\n"
				html += "</form>\n"
			else:
				html += "<form method=\"GET\">\n"
				html += "<input type=\"hidden\" name=\"cmd\" value=\"result\">\n"
				html += "<input type=\"submit\" value=\"%s\">\n" %  result_string
				html += "</select>\n"
				html += "</form>\n"
				html += "<form method=\"GET\">\n"
				html += "<input type=\"hidden\" name=\"\">\n"
				html += "<input type=\"submit\" value=\"%s\">\n" % mainmenu_string
				html += "</select>\n"
				html += "</form>\n"
			self.container = eConsoleAppContainer()
			if not os.path.exists("/var/lib/opkg/status"):                          
 				self.container_appClosed_conn = self.container.appClosed.connect(self.runFinished)
              			self.container_dataAvail_conn = self.container.dataAvail.connect(self.dataAvail)
			else:
 				self.container.appClosed.append(self.runFinished)
              			self.container.datAvail.append(self.dataAvail)
			if command[0].endswith(".sh") == True:
				if (command[0].find(" ") is not -1) or (command[0].find(">\n") is not -1) or (command[0].find("<") is not -1) or (command[0].find("|") is not -1):
					# thanks 3c5x9 
					self.container.execute("echo unsupported command")
				else:
					self.container.execute("%s %s" %(command[0],arguments))
			else:
				if (command[0].find(" ") is not -1) or (command[0].find(">\n") is not -1) or (command[0].find("<") is not -1) or (command[0].find("|") is not -1):
					# thanks 3c5x9 
					self.container.execute("echo unsupported command")
				else:
					self.container.execute("%s %s %s %s %s %s" %(barryallen_ksh, barryallen_script,command[0],sourcename,targetname,pin))
				
			showing_result_string  = _("showing results of command")
			baresult  = "<html>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n		\"http://www.w3.org/TR/html4/loose.dtd\">\n<head>\n<title>%s %s %s</title>\n<link rel=\"shortcut icon\" type=\"/web-data/image/x-icon\" href=\"/web-data/img/favicon.ico\">\n<meta content=\"text/html; charset=UTF-8\" http-equiv=\"content-type\">\n</head>\n<body bgcolor=\"red\">\n" %(self.title,showing_result_string,command[0])
#		req.setResponseCode(http.OK)
		req.setHeader('Content-type', 'text/html')
		return html
				
	def runFinished(self, retval):
		global baresult
		mainmenu_string=_("Barry Allen Main Menu")
		finished_string=_("Command finished")
#		baresult += "<hr>\n"
		baresult += "%s" % finished_string
		baresult += "<hr>\n"
		baresult += "<form method=\"GET\">\n"
		baresult += "<input type=\"hidden\" name=\"\">\n"
		baresult += "<input type=\"submit\" value=\"%s\">\n" % mainmenu_string
		baresult += "</select>\n"
		baresult += "</form>\n"
		baresult += "</body>\n</html>\n"
			
	def dataAvail(self, str):
		global baresult
#		print "result: %s" % str[0]
		if str[0] is "-" or str[0] is "=":
			baresult += "<hr>\n"
		else:
			baresult += "%s\n" % str
			baresult += "<br>\n"

class BarryAllenConfiguration(Screen, ConfigListScreen):
	skin = """
		<screen position="center,center" size="560,400" title="Wizard for Setup">
		<widget name="config" position="10,10" size="540,440" scrollbarMode="showOnDemand" />
                <ePixmap position="10,350" size="100,40" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/BarryAllen/barryallen.png" transparent="1" alphatest="on" />	
		<widget name="buttonred" position="120,350" size="100,40" backgroundColor="red" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		<widget name="buttongreen" position="230,350" size="100,40" backgroundColor="green" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		<widget name="buttonyellow" position="340,350" size="100,40" backgroundColor="yellow" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		<widget name="buttonblue" position="450,350" size="100,40" backgroundColor="blue" valign="center" halign="center" zPosition="2"  foregroundColor="black" font="Regular;18"/>
		</screen>"""
	def __init__(self, session):
		self.skin = BarryAllenConfiguration.skin
		Screen.__init__(self, session)
		if os.path.exists("/media/ba/.wwbootmanager"):
			config.plugins.barryallen.mode.value="wobble"
		else:
			if os.path.exists("/media/ba/.banobootmanager"):
				config.plugins.barryallen.mode.value="disable"
			else:
				config.plugins.barryallen.mode.value="enable"

		if os.path.exists(barryallen_confirm):
			config.plugins.barryallen.confirm.value=True
		else:
			config.plugins.barryallen.confirm.value=False

		if os.path.exists(barryallen_withdate):
			config.plugins.barryallen.withdate.value=True
		else:
			config.plugins.barryallen.withdate.value=False

#		if os.path.exists("/media/ba/.barootdelay"):
#			fc=open("/media/ba/.barootdelay","r")
#			rc=fc.readline()
#			fc.close()
#			config.plugins.barryallen.rootdelay.value=int(rc)
#		else:
#			config.plugins.barryallen.rootdelay.value=10

		config.plugins.barryallen.bapostinst.value="none"
        	if os.path.exists("/media/ba/script/bapostinst"):
			bp=open("/media/ba/script/bapostinst")
                        postinst=bp.read()
                        bp.close()
			for name in os.listdir(barryallen_script_path):
   				if name.endswith(".template") and name.startswith("ba"): 
      					bp=open("/media/ba/script/%s" % name)
                        		content=bp.read()
                        		bp.close()
					if content == postinst:
						config.plugins.barryallen.bapostinst.value=name

		if os.path.exists(barryallen_progress):
			config.plugins.barryallen.progress.value=True
		else:
			config.plugins.barryallen.progress.value=False

#		if os.path.exists(barryallen_squashfs):
#			config.plugins.barryallen.squashfs.value=True
#		else:
#			config.plugins.barryallen.squashfs.value=False
			
		if os.path.exists("/media/ba/.batimeout"):
			fc=open("/media/ba/.batimeout","r")
			rc=fc.readline()
			fc.close()
			timeout=10
			try:
				batimeout=int(rc)
				if batimeout > 30:
					batimeout=30
				if batimeout < 2:
					batimeout=2
			except:
				batimeout=10
			config.plugins.barryallen.timeout.value=batimeout
		else:
			config.plugins.barryallen.timeout.value=10

		if os.path.exists("/media/ba/.bamask"):
			fc=open("/media/ba/.bamask","r")
			rc=fc.readline()
			fc.close()
			rc=str(int(rc))
			config.plugins.barryallen.rclevel.value=rc
		else:
			config.plugins.barryallen.rclevel.value="0"

		if os.path.exists("/media/ba/.baresolution"):
			fc=open("/media/ba/.baresolution","r")
			rc=fc.readline()
			fc.close()
			rc=rc.replace("\n","")
			config.plugins.barryallen.resolution.value=rc
		else:
			config.plugins.barryallen.resolution.value="none"

		if os.path.exists(barryallen_lite):
			config.plugins.barryallen.lite.value=True
		else:
			config.plugins.barryallen.lite.value=False

		if os.path.exists(barryallen_locked):
			config.plugins.barryallen.locked.value=True
		else:
			self.pin=""
			config.plugins.barryallen.locked.value=False

#		if os.path.exists(barryallen_norestart):
#			config.plugins.barryallen.norestart.value=True
#		else:
#			config.plugins.barryallen.norestart.value=False

                self.list = []
                self.list.append(getConfigListEntry(_("bootmanager mode"), config.plugins.barryallen.mode))
                self.list.append(getConfigListEntry(_("bootmanager progress"), config.plugins.barryallen.progress))
#               self.list.append(getConfigListEntry(_("select boot resolution"), config.plugins.barryallen.resolution))
                self.list.append(getConfigListEntry(_("boot menu timeout [sec]"), config.plugins.barryallen.timeout))
#		if os.path.exists("/media/ba/boot"):
#                	self.list.append(getConfigListEntry(_("kernel rootdelay for USB boot [sec]"), config.plugins.barryallen.rootdelay))
                self.list.append(getConfigListEntry(_("select RC mask for multiple RCs"), config.plugins.barryallen.rclevel))
#               self.list.append(getConfigListEntry(_("Squashfs"), config.plugins.barryallen.squashfs))
#               self.list.append(getConfigListEntry(_("no %s restart on extract and backup") % enigma_version, config.plugins.barryallen.norestart))
                self.list.append(getConfigListEntry(_("image lock with PIN"), config.plugins.barryallen.locked))
                self.list.append(getConfigListEntry(_("Barry Allen Lite Menu Mode"), config.plugins.barryallen.lite))
                self.list.append(getConfigListEntry(_("confirm commands"), config.plugins.barryallen.confirm))
                self.list.append(getConfigListEntry(_("add date to imagenames"), config.plugins.barryallen.withdate))
                self.list.append(getConfigListEntry(_("bapostinst script"), config.plugins.barryallen.bapostinst))
	        self.onShown.append(self.setWindowTitle)                                                            
		ConfigListScreen.__init__(self, self.list)
        	# explizit check on every entry                                                                     
        	self.onChangedEntry = []                                                                            
		self["buttonred"] = Label(_("Cancel"))
		self["buttongreen"] = Label(_("OK"))
		self["buttonyellow"] = Label("Skin")
		self["buttonblue"] = Label("About")
		self["actions"] = ActionMap(["SetupActions","WizardActions", "ColorActions"], {"red": self.leave, "green": self.saveConfig, "yellow": self.Usage, "blue": self.about, "cancel": self.leave, "ok": self.saveConfig, }, -1) 

        def leave(self):
		self.close()

	def setWindowTitle(self):                                                                               
        	self.setTitle(_("Wizard for Setup"))

	def Usage(self):
	        self.session.openWithCallback(self.chooseLogo,MessageBox,_("Choose Bootmenu Background with left right\nand font with up down,\nand press OK to confirm and Exit to cancel"))
	
	def chooseLogo(self,status):
		if status:
			self.session.open(BootmanagerSelection)

	def about(self):
        	self.session.open(AboutBarryAllen)

	def saveConfig(self):
		if config.plugins.barryallen.mode.value == "wobble":
			fc=open("/media/ba/.wwbootmanager","w")
			rc=fc.write("\n")
			fc.close()
			fc=open("/media/ba/.banobootmanager","w")
			rc=fc.write("\n")
			fc.close()
		else:
			if os.path.exists("/media/ba/.wwbootmanager"):
				os.remove("/media/ba/.wwbootmanager")
			if config.plugins.barryallen.mode.value == "enable":
				if os.path.exists("/media/ba/.banobootmanager"):
					os.remove("/media/ba/.banobootmanager")
				if os.path.exists("/media/ba/boot"):
					os.system("mount -t vfat /dev/disk/by-label/ww /media/ba/boot; rm /media/ba/boot/*; umount /media/ba/boot");
			else:
				fc=open("/media/ba/.banobootmanager","w")
				rc=fc.write("\n")
				fc.close()
		# reset to default as we don't really use config parameters with BA
		config.plugins.barryallen.mode.value="enable"

		if config.plugins.barryallen.bapostinst.value == "none":
			if os.path.exists("/media/ba/script/bapostinst"):
				os.remove("/media/ba/script/bapostinst")
		else:
			bp=open("/media/ba/script/%s" % config.plugins.barryallen.bapostinst.value,"r" )
                        postinst=bp.read()
                        bp.close()
                        oldpostinst=""
      			if os.path.exists("/media/ba/script/bapostinst"):
      				bp=open("/media/ba/script/bapostinst","r")
                        	oldpostinst=bp.read()
                        	bp.close()
			if postinst != oldpostinst:
      				bp=open("/media/ba/script/bapostinst","w")
                        	bp.write(postinst)
                        	bp.close()
		config.plugins.barryallen.bapostinst.value="none"

		if config.plugins.barryallen.confirm.value == True:
			fc=open(barryallen_confirm,"w")
			rc=fc.write("\n")
			fc.close()
		else:
			if os.path.exists(barryallen_confirm):
				os.remove(barryallen_confirm)
		# reset to default as we don't really use config parameters with BA
#		config.plugins.barryallen.norestart.confirm=True
#		if config.plugins.barryallen.norestart.value == True:
#			fc=open(barryallen_norestart,"w")
#			rc=fc.write("\n")
#			fc.close()
#		else:
#			if os.path.exists(barryallen_norestart):
#				os.remove(barryallen_norestart)
		# reset to default as we don't really use config parameters with BA
#		config.plugins.barryallen.norestart.value=False
		
		if config.plugins.barryallen.lite.value == True:
			fc=open(barryallen_lite,"w")
			rc=fc.write("\n")
			fc.close()
		else:
			if os.path.exists(barryallen_lite):
				os.remove(barryallen_lite)
		# reset to default as we don't really use config parameters with BA
		config.plugins.barryallen.lite.value=False

		if config.plugins.barryallen.withdate.value == True:
			fc=open(barryallen_withdate,"w")
			rc=fc.write("\n")
			fc.close()
		else:
			if os.path.exists(barryallen_withdate):
				os.remove(barryallen_withdate)
		# reset to default as we don't really use config parameters with BA
		config.plugins.barryallen.withdate.value=False

#		if config.plugins.barryallen.squashfs.value == True:
#			fc=open(barryallen_squashfs,"w")
#			rc=fc.write("\n")
#			fc.close()
#		else:
#			if os.path.exists(barryallen_squashfs):
#				os.remove(barryallen_squashfs)

		if config.plugins.barryallen.progress.value == True:
			fc=open(barryallen_progress,"w")
			rc=fc.write("\n")
			fc.close()
		else:
			if os.path.exists(barryallen_progress):
				os.remove(barryallen_progress)
		# reset to default as we don't really use config parameters with BA
		config.plugins.barryallen.progress.value=True

#		if config.plugins.barryallen.rootdelay.value == 10:
#			if os.path.exists("/media/ba/.barootdelay"):
#				os.remove("/media/ba/.barootdelay")
#		else:
#			fc=open("/media/ba/.barootdelay","w")
#			rc=fc.write("%s\n" % str(config.plugins.barryallen.rootdelay.value))
#			fc.close()
#		# reset to default as we don't really use config parameters with BA
#		config.plugins.barryallen.rootdelay.value=10

		if config.plugins.barryallen.timeout.value == 10:
			if os.path.exists("/media/ba/.batimeout"):
				os.remove("/media/ba/.batimeout")
		else:
			fc=open("/media/ba/.batimeout","w")
			rc=fc.write("%s\n" % str(config.plugins.barryallen.timeout.value))
			fc.close()
		# reset to default as we don't really use config parameters with BA
		config.plugins.barryallen.timeout.value=10

		if config.plugins.barryallen.rclevel.value == "0":
			if os.path.exists("/media/ba/.bamask"):
				os.remove("/media/ba/.bamask")
		else:
			fc=open("/media/ba/.bamask","w")
			rc=fc.write("%s\n" % config.plugins.barryallen.rclevel.value)
			fc.close()
		# reset to default as we don't really use config parameters with BA
		config.plugins.barryallen.rclevel.value="0"

		if config.plugins.barryallen.resolution.value == "none":
			if os.path.exists("/media/ba/.baresolution"):
				os.remove("/media/ba/.baresolution")
		else:
			fc=open("/media/ba/.baresolution","w")
			rc=fc.write("%s\n" % str(config.plugins.barryallen.resolution.value))
			fc.close()
		# reset to default as we don't really use config parameters with BA
		config.plugins.barryallen.resolution.value="none"

		if config.plugins.barryallen.locked.value == True:
                   if os.path.exists(barryallen_locked) == False:
	               self.session.openWithCallback(self.askForPassword,InputBox, title=_("Please enter PIN"), text="    ", maxSize=4, type=Input.PIN)
		   else:
			# reset to default as we don't really use config parameters with BA
			config.plugins.barryallen.locked.value=False
			self.leave()
		else:
                   if os.path.exists(barryallen_locked) == True:
	               self.session.openWithCallback(self.askForPassword,InputBox, title=_("Please enter PIN"), text="    ", maxSize=4, type=Input.PIN)
		   else:
			# reset to default as we don't really use config parameters with BA
			config.plugins.barryallen.locked.value=False
			self.leave()

        def askForPassword(self,passwd):
           if passwd is None:
	      self.leave()
           else:
              newpasswd = str(hashlib.md5(passwd))
	      m = hashlib.md5()
	      m.update(passwd)
	      newpasswd=m.hexdigest()
              print "New PIN encrypted %s\n" % newpasswd
              if os.path.exists(barryallen_locked) == True:
	         fp = open(barryallen_locked,"r")
	         oldpasswd =fp.readline().rstrip().rstrip("\n")
	         fp.close()
                 print "Old PIN encrypted %s\n" % oldpasswd
	         if newpasswd == oldpasswd:
   		    os.remove(barryallen_locked)
	            self.session.openWithCallback(self.close,MessageBox, "Images are now unlocked again", MessageBox.TYPE_WARNING)
		 else:
		    self.session.openWithCallback(self.close,MessageBox, "Sorry, PIN doesn't match", MessageBox.TYPE_ERROR)
	      else:
                 fp = open(barryallen_locked,"w")
                 fp.write(newpasswd)
                 fp.close()
	         self.session.openWithCallback(self.close,MessageBox, "Images are now locked with PIN", MessageBox.TYPE_INFO)

class BootmanagerSelection(Screen):
	skin = """
		<screen position="center,center" size="720,576" title="Bootmanager Select" flags="wfNoBorder" backgroundColor="#FFFFFFFF">
		</screen>"""
	def __init__(self, session):
		self.skin = BootmanagerSelection.skin
	        self.setup_title=(_("Bootmanager Select"))
		Screen.__init__(self, session)
        	# explizit check on every entry                                                                     
        	self.onChangedEntry = []                                                                            
                self.onConfigEntryChanged = []
		self.session = session
		self.altservice = session.nav.getCurrentlyPlayingServiceReference()
		session.nav.stopService()
		self.balogos = []
		self.bafonts = []
		self.currentlogo=0
		self.balogos=self.getBAlogos()
		self.numberlogos=len(self.balogos)
		self.currentfont=0
		self.bafonts=self.getBAfonts()
		self.numberfonts=len(self.bafonts)
		self["buttonred"] = Label(_("Cancel"))
		self["buttongreen"] = Label(_("OK"))
		self["buttonyellow"] = Label("Skin")
		self["buttonblue"] = Label("Info")
		self["actions"] = ActionMap(["WizardActions", "SetupActions"], {"cancel": self.goBack, "back": self.goBack, "ok": self.saveLogo,  "left": self.backward, "right": self.forward, "deleteForward": self.right, "deleteBackward": self.left, "up": self.up, "down":self.down, }, -1) 
		self.onLayoutFinish.append(self.byLayoutEnd)

	def goBack(self):
		self.container = eConsoleAppContainer()
		fbClass.getInstance().unlock()   
		self.session.nav.playService(self.altservice)
		self.close()

	def backward(self):
		self.currentlogo=self.currentlogo-1
		if self.currentlogo < 0:
			self.currentlogo=self.numberlogos-1
		print "Backward %i" % self.currentlogo
		self.showManager(self.balogos[self.currentlogo],self.bafonts[self.currentfont])

	def left(self):
		color=64
		if os.path.exists("/media/ba/.bacolor"):
			c=open("/media/ba/.bacolor","r")
			color=int(c.readline())
			c.close()
		color= color-16
		if color < 0:
			color=0
		print "[BARRYALLEN] color %d" % color
		c=open("/media/ba/.bacolor","w")
		c.write("%d\n" % color)
		c.close()
		self.showManager(self.balogos[self.currentlogo],self.bafonts[self.currentfont])

	def right(self):
		color=64
		if os.path.exists("/media/ba/.bacolor"):
			c=open("/media/ba/.bacolor","r")
			color=int(c.readline())
			c.close()
		color= color+16
		if color > 256:
			color=256
		print "[BARRYALLEN] color %d" % color
		c=open("/media/ba/.bacolor","w")
		c.write("%d\n" % color)
		c.close()
		self.showManager(self.balogos[self.currentlogo],self.bafonts[self.currentfont])

	def forward(self):
		self.currentlogo=self.currentlogo+1
		if self.currentlogo >= self.numberlogos:
			self.currentlogo=0
		print "Forward %i" % self.currentlogo
		self.showManager(self.balogos[self.currentlogo],self.bafonts[self.currentfont])

	def down(self):
		self.currentfont=self.currentfont-1
		if self.currentfont < 0:
			self.currentfont=self.numberfonts-1
		print "Down %i" % self.currentfont
		self.showManager(self.balogos[self.currentlogo],self.bafonts[self.currentfont])

	def up(self):
		self.currentfont=self.currentfont+1
		if self.currentfont >= self.numberfonts:
			self.currentfont=0
		print "Up %i" % self.currentfont
		self.showManager(self.balogos[self.currentlogo],self.bafonts[self.currentfont])


	def getBAfonts(self):
		ba_fonts = []
		if os.path.exists("/media/ba/fonts/barryallen.ttf"):
			ba_fonts.append("barryallen.ttf")
		else:
			ba_fonts.append("standard.ttf")
		for name in os.listdir("/media/ba/fonts"):
			if name.endswith(".ttf") is True:
				if name <> "barryallen.ttf":
					ba_fonts.append(name)
		return ba_fonts

	def getBAlogos(self):
		ba_logos = []
		if os.path.exists("/media/ba/logos/barryallen.jpg"):
			ba_logos.append("barryallen.jpg")
		else:
			ba_logos.append("standard.jpg")
		for name in os.listdir("/media/ba/logos"):
			if name.endswith(".jpg"):
				if name <> "barryallen.jpg" and name <> "debian.jpg":
					ba_logos.append(name)
		return ba_logos

	def byLayoutEnd(self):
		self.showManager(self.balogos[self.currentlogo],self.bafonts[self.currentfont])

	def showManager(self, logo_file, font_file):
 		self.container = eConsoleAppContainer()      
		if not os.path.exists("/var/lib/opkg/status"):                          
			self.container_appClosed_conn = self.container.appClosed.connect(self.showingDone)
		else:
 			self.container.appClosed.append(self.showingDone)
		fbClass.getInstance().lock()            
		if config.plugins.barryallen.progress.value:
			progress_show="progress"
		else:
			progress_show=""
		self.container.execute("/media/ba/bin/barryallen %s %s %s" % (logo_file,font_file,progress_show))

	def showingDone(self, status):
		fbClass.getInstance().unlock()   

	def saveLogo(self):
		print "[Bootmanager Select] saving logo %s" % (self.balogos[self.currentlogo])
		self.container = eConsoleAppContainer()      
		if not os.path.exists("/var/lib/opkg/status"):                          
	          	self.container_appClosed_conn = self.container.appClosed.connect(self.saveFont)
		else:
 			self.container.appClosed.append(self.saveFont)
		if self.balogos[self.currentlogo].endswith(".jpg") and self.balogos[self.currentlogo] <>  "barryallen.jpg":
			if os.path.exists("/media/ba/logos/barryallen.jpg"):
				os.remove("/media/ba/logos/barryallen.jpg")
			self.container.execute("cp /media/ba/logos/%s /media/ba/logos/barryallen.jpg" % self.balogos[self.currentlogo])
		elif self.balogos[self.currentlogo].endswith(".jpg") and self.balogos[self.currentlogo] <> "barryallen.jpg":
			self.container.execute("cp /media/ba/logos/%s /media/ba/logos/barryallen.jpg" % self.balogos[self.currentlogo])
		else:
			self.saveFont(True)

	def saveFont(self,status):
		print "[LAYOUTER] saving font %s" % (self.bafonts[self.currentfont])
		self.container = eConsoleAppContainer()
		if not os.path.exists("/var/lib/opkg/status"):                          
	          	self.container_appClosed_conn = self.container.appClosed.connect(self.finishedSave)
		else:
 			self.container.appClosed.append(self.finishedSave)
		if self.bafonts[self.currentfont] <> "barryallen.ttf":
			self.container.execute("cp /media/ba/fonts/%s /media/ba/fonts/barryallen.ttf" % self.bafonts[self.currentfont])
		else:
			self.finishedSave(True)
		
	def finishedSave(self,status):
		self.goBack()
