# -*- coding: utf-8 -*-
from gLocale import _
from gTools import  XML_QUICKBUTTON, pathExists, ctoolsclass, cleanexit
from WidgetVariableList import WidgetVariableList
from WidgetXmlList import WidgetXmlList

from Screens.MessageBox import MessageBox

#--------------------------------------------------------------------------------------------------------

class gMultiQuickButton(WidgetVariableList):
	def __init__(self, session, title=None, icon="icon_quickbutton.png", showMenuPix=None):
		list = [(_('red'), None, 'red'),
			(_('red') + " " + _('long'), None, 'red_long'),
			(_('green'), None, 'green'),
			(_('green') + " " + _('long'), None, 'green_long'),
			(_('yellow'), None, 'yellow'),
			(_('yellow') + " " + _('long'), None, 'yellow_long'),
			(_('blue'), None, 'blue'),
			(_('blue') + " " + _('long'), None, 'blue_long'),
			(_('TEXT'), None, 'text'),
			(_('TEXT') + " " + _('long'), None, 'text_long'),
			(_('HELP') + " " + _('long'), None, 'help_long'),
			(_('INFO'), None, 'info'),
			(_('INFO') + " " + _('long'), ctoolsclass.getSeperatorPic(), 'info_long'),
			(_('CONSOLE (DMM Keyboard)'), None, 'console'),
			('^ (DMM Keyboard) / F1 (Keyboard)', None, 'f1'),
			('F1 (DMM Keyboard) / F2 (Keyboard)', None, 'f2'),
			('F2 (DMM Keyboard) / F3 (Keyboard)', None, 'f3'),
			('WEB (DMM Keyboard) / WWW / F6 (Keyboard)', None, 'web'),
			('MAIL (DMM Keyboard) / Mail / F7 (Keyboard)', None, 'mail'),
			('M1 (DMM Keyboard) / F11 (Keyboard)', None, 'm1'),
			('M2 (DMM Keyboard) / F10 (Keyboard)', None, 'm2'),
			('PVR / Video / F8 (Keyboard)', None, 'pvr'),
			('PVR / Video / F8 (Keyboard)' + " " + _('long'), None, 'pvr_long'),
			('TV', None, 'tv'),
			('TV' + " " + _('long'), None, 'tv_long'),
			('RADIO / F9 (Keyboard)', None, 'radio'),
			('RADIO / F9 (Keyboard)' + " " + _('long'), None, 'radio_long'),
			]

		WidgetVariableList.__init__ (self, session, _("QuickButton"), icon=icon, showMenuPix=None, list=list, SepLine=True)
		self.skinName = [self.__class__.__name__,"VariableListNoButton_" + self.__class__.__name__,"VariableListNoButton"]
		self.onShown.append(self.selectionChanged)
		self.__icon=icon
		
	def KeyExit(self, val=None):
		self.close(val)
		cleanexit(__name__)

	def KeyOk(self):
		sel = self.getCurrentEntry()
        	if sel is None:
			return
		key=sel[2]
		path = '/etc/enigma2/gMultiQuickButton/quickbutton_' + key + '.xml'
		if pathExists(path):
			if len(key.split('_')) > 1:
				keyName = _(key.split('_')[0]) + " " + _(key.split('_')[1])
			else:
				keyName = _(key)
			self.session.open(WidgetXmlList, _("QuickButton: Key") + " " + keyName, path=path, type=XML_QUICKBUTTON, icon=self.__icon)
		else:
			self.session.open(MessageBox,(_("File '%s' not found!") % path),  MessageBox.TYPE_ERROR)
