# -*- coding: utf-8 -*-
from gLocale import _
from GeminiDef import *

from enigma import eTimer, iServiceInformation, eDVBResourceManager, iDVBFrontend
from gTools import libgeminimain, pathExists, gLoadPixmap, monthStrSmall #,weathermsn
from plugin import dbusNotifier, geventNotifier

from Components.Element import cached
from Components.Sources.Source import Source
from Components.config import config
from Components.FanControl import fancontrol
from Components.Sensors import sensors
from Components.NimManager import nimmanager
from Tools.Transponder import ConvertToHumanReadable

from os import statvfs
from os.path import splitext as splitext
from time import localtime, time as currtime

class Exsensor:
	def __init__(self):
		self.__value=""
		self.__poll=False
		
	def getValue(self):
		return str(self.__value), self.__poll
		
	def setValue(self, value="",poll=False):
		self.__value=value
		self.__poll=poll
		
exsensor = Exsensor()

#---------------------------------------------------------------------------------

class ResolutionIcon(Source):
	def __init__(self):
		Source.__init__(self)
		self.__value=2
		geventNotifier.append((EVENT_CHANNEL_SIZE, self.__SizeChanged))

	def __SizeChanged(self, what=None, val=None):
		if val is not None:
			self.__value=2

			xresol=val[0]
			yresol=val[1]
			aspect=val[2]
			if xresol>720:#HD
				self.__value=0
			elif aspect in (3, 4, 7, 8, 0xB, 0xC, 0xF, 0x10):#16:9
				self.__value=1

			self.changed((self.CHANGED_DEFAULT,))

	@cached
	def getPicture(self):
		return self.__value

	get_value = property(getPicture)

	def destroy(self):
		geventNotifier.remove((EVENT_CHANNEL_SIZE, self.__SizeChanged))
		Source.destroy(self)

#---------------------------------------------------------------------------------

class OnlineIcon(Source):
	def __init__(self):
		Source.__init__(self)
		self.__isOnline=False
		dbusNotifier.append(("gdaemon", self.__newOnlineTest))

	def __newOnlineTest(self, func, value):
		if func==1:
			if value=="ONLINE":
				self.__isOnline=True
			else:
				self.__isOnline=False
			self.changed((self.CHANGED_DEFAULT,))

	@cached
	def getBoolean(self):
		return self.__isOnline

	boolean = property(getBoolean)

	def destroy(self):
		dbusNotifier.remove(("gdaemon", self.__newOnlineTest))
		Source.destroy(self)

#-------------------------------------------------------------------------------

class CryptIcon(Source):
	def __init__(self):
		Source.__init__(self)
		self.caidlist=[]
		self.__onoff=False
		geventNotifier.append((EVENT_GEMINI_CONF, self.__newGeminiConf))
		geventNotifier.append((EVENT_CAID_LIST, self.__newCaidList))
	
	def __newGeminiConf(self, what, val):
		tmp_onoff = bool(val & CRYPT_ICON_SHOW)
		if tmp_onoff != self.__onoff:
			self.__onoff = tmp_onoff
			
			if self.__onoff:
				self.changed((self.CHANGED_DEFAULT,))
			else:
				self.caidlist=[]
				self.changed((self.CHANGED_CLEAR,))

	def __newCaidList(self, what=0, val=0):
		if self.__onoff:
			self.caidlist = libgeminimain.getPyList(GETCAIDLIST)
			self.changed((self.CHANGED_DEFAULT,))

	@cached
	def getList(self):
		return self.caidlist

	clist = property(getList)

	def destroy(self):
		geventNotifier.remove((EVENT_GEMINI_CONF, self.__newGeminiConf))
		geventNotifier.remove((EVENT_CAID_LIST, self.__newCaidList))
		Source.destroy(self)

#---------------------------------------------------------------------------------

class BGEventPicture(Source):
	def __init__(self):
		Source.__init__(self)
		self.__showBGEventPic = False
		geventNotifier.append((EVENT_BACKGROUND, self.__newBGEventPic))

	def __newBGEventPic(self, what=0, val=0):
		self.__showBGEventPic = False
		if val > (BG_BLINK + BG_SHOW):
			self.__showBGEventPic=True
		self.changed((self.CHANGED_DEFAULT,))

	@cached
	def getBoolean(self):
		return self.__showBGEventPic

	boolean = property(getBoolean)

	def destroy(self):
		geventNotifier.remove((EVENT_BACKGROUND, self.__newBGEventPic))
		Source.destroy(self)

#-------------------------------------------------------------------------------

class BGEvent(Source):
	def __init__(self):
		Source.__init__(self)
		self.__clock_timer = eTimer()
		self.__clock_timer_conn = self.__clock_timer.timeout.connect(self.poll)
		self.__eventstr=""
		self.__toggle=False
		self.__bgVal=0
		geventNotifier.append((EVENT_BACKGROUND, self.__newBGEvent))

	def __newBGEvent(self, what=0, val=0):
		self.__bgVal = val
		self.__eventstr=""

		if self.__bgVal & (BG_BLINK | BG_SHOW):
			if self.__bgVal & BG_UPDATE:
				self.__eventstr = "UPD"
			if self.__bgVal & BG_MAIL:
				self.__eventstr = "@"
			if self.__bgVal & BG_STREAM:
				self.__eventstr = "SRE"
			if self.__bgVal & BG_TORRENT:
				self.__eventstr = "TOR"
			if self.__bgVal & BG_RSYNC:
				self.__eventstr = "RSY"
			if self.__bgVal & (BG_DELETE | BG_COPYMOVE | BG_EXTRACT):
				self.__eventstr = "FAC"
			if self.__bgVal & BG_SWAP:
				self.__eventstr = "SWA"
			if self.__bgVal & BG_TERMIN:
				self.__eventstr = "CAL"
			if self.__bgVal & BG_MEDIASCAN:
				self.__eventstr = "MSC"
			if self.__bgVal & BG_JABBER:
				self.__eventstr = "#CH"
			if self.__bgVal & BG_TWITTER:
				self.__eventstr = "TWI"
			if self.__bgVal & BG_DBUS_ERR:
				self.__eventstr = "DBU"
			if self.__bgVal & BG_CACHE_ERR:
				self.__eventstr = "GCA"
			if self.__bgVal & BG_SYSTEM:
				self.__eventstr = "SYS"
			if self.__bgVal & BG_FACEBOOK:
				self.__eventstr = "FBO"
		
		#print "_______________________________________newBGEvent", self.__bgVal, self.__eventstr
		if self.__eventstr != "":
			self.changed((self.CHANGED_DEFAULT,))
		else:
			self.changed((self.CHANGED_CLEAR,))

	@cached
	def getEventStr(self):
		return self.__eventstr

	text = property(getEventStr)
	
	def poll(self):
		if self.__toggle:
			self.__toggle = False
			self.changed((self.CHANGED_CLEAR,))
		else:
			self.__toggle = True
			self.changed((self.CHANGED_DEFAULT,))
		

	def doSuspend(self, suspended):
		if suspended:
			self.__clock_timer.stop()
			self.changed((self.CHANGED_CLEAR,))
		elif bool(self.__bgVal & BG_BLINK) and self.__eventstr != "":
			self.__clock_timer.start(1000)
			self.poll()

	def destroy(self):
		geventNotifier.remove((EVENT_BACKGROUND, self.__newBGEvent))
		del self.__clock_timer
		Source.destroy(self)

#---------------------------------------------------------------------------------

class CoverPicture(Source):
	def __init__(self):
		Source.__init__(self)
		geventNotifier.append((EVENT_CHANNEL, self.__newMovieCover))
		self.picname=None

	def __newMovieCover(self, what=None, val=None):
		self.picname=None
		if val and val[3]:
			file = val[3].getPath()
			if file!="":
				from FileBrowser import B_CFILE
				mfile = libgeminimain.getPyList(GETFILEINFOS,file)
				fullCover = splitext(file)[0]+".jpg"
				if mfile is not None:
					if  pathExists(fullCover):
						self.picname=fullCover
						
					#if pathExists(mfile[B_CFILE]+".png"):
						#self.picname=mfile[B_CFILE]+".png"

		self.changed((self.CHANGED_DEFAULT,))

	@cached
	def getPixmap(self):
		if self.picname is not None:
			return gLoadPixmap(self.picname,cached=False)
		return gLoadPixmap("cover_default.png")
		
	pixmap = property(getPixmap)

	def destroy(self):
		geventNotifier.remove((EVENT_CHANNEL, self.__newMovieCover))
		Source.destroy(self)

#---------------------------------------------------------------------------------
class MovieDir(Source):
	def __init__(self):
		Source.__init__(self)
		self.__clock_timer = eTimer()
		self.__clock_timer_conn = self.__clock_timer.timeout.connect(self.poll)
		self.__resstr=""

	@cached
	def poll(self):
		self.__resstr=""
		try:
			stat = statvfs(config.movielist.last_videodir.value)
			self.__resstr = libgeminimain.getHumanSize(stat.f_bfree * stat.f_bsize) + " " + libgeminimain.getSize2Time(stat.f_bfree * stat.f_bsize) + _("free diskspace")
		except OSError:
			pass
		
		self.__clock_timer.start(15000)
		self.changed((self.CHANGED_DEFAULT,))
		#print "_________________________________", self.__resstr

	def getFreespace(self):
		return self.__resstr

	text = property(getFreespace)
	
	def doSuspend(self, suspended):
		if suspended:
			self.__clock_timer.stop()
		else:
			self.poll()

	def destroy(self):
		del self.__clock_timer
		Source.destroy(self)
		
#---------------------------------------------------------------------------------

class gServiceInfos(Source):
	def __init__(self):
		Source.__init__(self)
		self.__resstr=""
		self.__orbiposOnOff=False
		geventNotifier.append((EVENT_CHANNEL, self.__ChannelChanged))
		geventNotifier.append((EVENT_GEMINI_CONF, self.__newGeminiConf))

	def __newGeminiConf(self, what, val):
		self.__orbiposOnOff = bool(val & ORBITAL_POS_SHOW)

	def __ChannelChanged(self, what=None, val=None):
		self.__resstr=""
		if val and val[0]:
			info = val[0]
			#Name
			self.__resstr += info.getName().replace('\xc2\x86', '').replace('\xc2\x87', '')
			#Positon
			if self.__orbiposOnOff:
				transInfo = info.getInfoObject(iServiceInformation.sTransponderData)
				if isinstance(transInfo, dict):
					if transInfo.has_key("tuner_type"):
						if (transInfo["tuner_type"] == iDVBFrontend.feSatellite):
							orbital = int(transInfo["orbital_position"])
							if orbital > 1800:
								self.__resstr += " (" + str(float(3600-orbital)/10) + "\xc2\xb0W)"
							else:
								self.__resstr += " (" + str(float(orbital)/10) + "\xc2\xb0E)"

		#print "----------------",self.__orbiposOnOff,self.__resstr
		if self.__resstr=="":
			self.changed((self.CHANGED_CLEAR,))
		else:
			self.changed((self.CHANGED_DEFAULT,))

	@cached
	def getServiceInfos(self):
		return self.__resstr

	text = property(getServiceInfos)

	def destroy(self):
		geventNotifier.remove((EVENT_CHANNEL, self.__ChannelChanged))
		geventNotifier.remove((EVENT_GEMINI_CONF, self.__newGeminiConf))
		Source.destroy(self)

#---------------------------------------------------------------------------------

class gChannelNr(Source):
	def __init__(self):
		Source.__init__(self)
		self.__resstr=""
		self.__ChannelNrOnOff=False
		geventNotifier.append((EVENT_CHANNEL, self.__ChannelChanged))
		geventNotifier.append((EVENT_GEMINI_CONF, self.__gChannelNrGeminiConf))

	def __gChannelNrGeminiConf(self, what, val):
		self.__ChannelNrOnOff = bool(val & CHANNEL_NR_SHOW)

	def __ChannelChanged(self, what=None, val=None):
		self.__resstr=""
		if val and val[1] and self.__ChannelNrOnOff:
			self.__resstr = str(val[1])
		#print "----------------",self.__ChannelNrOnOff,self.__resstr
		if self.__resstr=="":
			self.changed((self.CHANGED_CLEAR,))
		else:
			self.changed((self.CHANGED_DEFAULT,))

	@cached
	def getChannelNr(self):
		return self.__resstr

	text = property(getChannelNr)

	def destroy(self):
		geventNotifier.remove((EVENT_CHANNEL, self.__ChannelChanged))
		geventNotifier.remove((EVENT_GEMINI_CONF, self.__gChannelNrGeminiConf))
		Source.destroy(self)

#---------------------------------------------------------------------------------

class gSensorData(Source):
	def __init__(self, SensorCount):
		Source.__init__(self)
		self.__SensorCount = SensorCount
		self.__clock_timer = eTimer()
		self.__clock_timer_conn = self.__clock_timer.timeout.connect(self.poll)
		self.__resstr=""
		self.__VideoSize=""
		self.__hddtemp=""
		self.__SoftCamdName=""
		self.__CryptStr=""
		self.__Expertstr=""
		self.__CurrChannelInfo=""
		self.__cgevent=None
		self.__TunerCount=0
		self.__Tuner_use_mask=0
		self.frontendUseMaskChanged_conn = None
		self.__gSensorConf(None,None)
		self.__polValue = (" H", " V", " CL", " CR")
		
		self.__CryptList=[]
		self.__CryptList.append([0x1700,"B",0])
		self.__CryptList.append([0x0600,"I",0])
		self.__CryptList.append([0x0100,"S",0])
		self.__CryptList.append([0x0500,"V",0])
		self.__CryptList.append([0x1800,"N",0])
		self.__CryptList.append([0x0D00,"CW",0])
		self.__CryptList.append([0x0900,"ND",0])
		self.__CryptList.append([0x0B00,"CO",0])
		self.__CryptList.append([0x4a00,"DC",0])
		self.__CryptList.append([0x2600,"BI",0])

		geventNotifier.append((EVENT_SENSORFIELD, self.__gSensorConf))
		geventNotifier.append((EVENT_CHANNEL_SIZE, self.__setVideoSize))
		dbusNotifier.append(("gdaemon", self.__newHddTemp))
		geventNotifier.append((EVENT_CAMD_SWITCH, self.__NewCamdName))
		geventNotifier.append((EVENT_EXPERT_STR, self.__NewExpertstr))
		geventNotifier.append((EVENT_CAID_LIST, self.__newCaids))
		geventNotifier.append((EVENT_CHANNEL, self.__Channel_Changed))
		
	def __Channel_Changed(self, what=None, val=None):
		self.__CurrChannelInfo=""
		if val and val[0] and self.__OnOff == 31:
			self.__CurrChannelInfo=val[0].getInfoString(iServiceInformation.sProvider)
			self.__clock_timer.start(300)
		elif val and val[0] and self.__OnOff == 33:
			audio = val[0].getInfoString(iServiceInformation.sTagAudioCodec)
			video = val[0].getInfoString(iServiceInformation.sTagVideoCodec)
			if audio!="":
				self.__CurrChannelInfo += "A: " + audio
				if video!="":
					self.__CurrChannelInfo += ", "
			if video!="":
				self.__CurrChannelInfo += "V: " + video
			self.__clock_timer.start(300)
		
	def __newCaids(self, what=0, val=0):
		self.__CryptStr=""
		if self.__OnOff == 30 and bool(val & CRYPT_LABEL_SHOW):
			for x in self.__CryptList:
				x[2]=0
			for x in libgeminimain.getPyList(GETCAIDLIST):
				for y in self.__CryptList:
					if (x[0] & 0xFF00) == y[0]:
						if x[1]>0:
							y[2]=2
						elif y[2]==0:
							y[2]=1
						break
			for x in self.__CryptList:
				if x[2]==1:
					self.__CryptStr += x[1] + " "
				elif x[2]==2:
					self.__CryptStr += "(" + x[1] + ") "
			self.__clock_timer.start(300)
		
	def __NewCamdName(self, what=0, val=0):
		self.__SoftCamdName=""
		if self.__OnOff == 28:
			for x in libgeminimain.getPyList(GETCAMDLIST):
				if x[1] == 1:
					self.__SoftCamdName=x[2]
					break
					
	def __NewExpertstr(self, what=0, val=0):
		self.__Expertstr=""
		if self.__OnOff == 29 and bool(val & EXPERT_LABEL_SHOW):
			self.__Expertstr = libgeminimain.getPyList(GETEXPERTSTR)
			self.__clock_timer.start(300)
		
	def __newHddTemp(self, func, value):
		if func == 3:#ATAHDDTEMP
			self.__hddtemp=value
		
	def __onTunerCount(self):
		res_mgr = eDVBResourceManager.getInstance()
		if res_mgr:
			self.frontendUseMaskChanged_conn = res_mgr.frontendUseMaskChanged.connect(self.__tunerUseMaskChanged)
		else:
			print "[ERROR]no res_mgr!!"
			
	def __offTunerCount(self):
		if self.frontendUseMaskChanged_conn:
			self.frontendUseMaskChanged_conn = None
			
	def __tunerUseMaskChanged(self, mask):
		self.__Tuner_use_mask = mask

	def __setVideoSize(self, what=None, val=None):
		#print "setVideoSize______________________________________", self.__SensorCount, self.__OnOff
		if self.__OnOff == 5 and val is not None:
			xresol=val[0]
			yresol=val[1]
			self.__VideoSize=""
			if xresol>0:
				self.__VideoSize=str(xresol)+' x '+str(yresol)
			self.changed((self.CHANGED_DEFAULT,))
		
	def __gSensorConf(self, what, val):
		if val is not None and isinstance(val, str):
			sensorvalue=val
		else:
			sensorvalue=libgeminimain.getStrConfig("SensorInfo","5")#VideoSize bei sensor0 als default
		
		if len(sensorvalue) < self.__SensorCount+1:
			self.__OnOff=0
		else:
			self.__OnOff=ord(sensorvalue[self.__SensorCount])-48

		if self.__OnOff == 5:#VideoSize
			self.__checkcgevent()
			if self.__cgevent is not None:
				self.__cgevent.getVideoSize()
		elif self.__OnOff == 19:
			self.__TunerCount = 0;
			for slot in range(nimmanager.getSlotCount()):
				if nimmanager.getNimType(slot) is not None:
					self.__TunerCount += 1
			self.__onTunerCount()
		elif self.__OnOff == 28:#Camdname
			self.__NewCamdName()
			
		if self.__OnOff != 19:
			self.__offTunerCount()
	
	def __checkcgevent(self):
		if self.__cgevent is None:
			from plugin import cgevent
			self.__cgevent = cgevent

	@cached
	def poll(self):
		self.__resstr=""
		try:
			if self.__OnOff == 1:#Temp
				self.__clock_timer.start(2000)
				templist = sensors.getSensorsList(sensors.TYPE_TEMPERATURE)
				templen = len(templist)
				maxtemp=0
				unit = ""
				for count in range(templen):
					if sensors.getSensorType(count) == sensors.TYPE_TEMPERATURE:
						temp = sensors.getSensorValue(count)
						if temp > maxtemp:
							maxtemp = temp
							unit = sensors.getSensorUnit(count)
				val = "%d\xc2\xb0%s" %(maxtemp,unit)
				self.__resstr += _("Temp: %s") % val
					
			elif self.__OnOff == 2 or self.__OnOff == 20:#Speed fan
				self.__clock_timer.start(2000)
				if fancontrol.getFanCount():
					maxspeed=0
					for count in range(fancontrol.getFanCount()):
						speed = fancontrol.getFanSpeed(count)
						if speed > maxspeed:
							maxspeed = speed
					if self.__OnOff == 2:
						self.__resstr += _("%d RPM") % maxspeed
					else:
						self.__resstr += _("%d RPM") % (maxspeed/2)
			elif self.__OnOff == 3:#CPU
				self.__clock_timer.start(2000)
				self.__resstr=_("CPU: %s") % libgeminimain.getPyList(GETCPULOAD)
			elif (self.__OnOff == 4 or self.__OnOff == 17) and self.__hddtemp != "":#HDD-TEMP und HDD-TEMP-FORCE
				self.__clock_timer.start(2000)
				if self.__hddtemp == "stby":
					self.__resstr=_("HDD: %s") % self.__hddtemp
				elif self.__hddtemp != "off":
					self.__resstr=_("HDD: %s\xc2\xb0C") % self.__hddtemp
					
			elif self.__OnOff == 6:#TUNER-SNR
				self.__clock_timer.start(1000)
				if self.__cgevent is not None:
					status = self.__cgevent.getTunerInfo()
					if status is not None:
						value = status.get("tuner_signal_quality")
						if value:
							self.__resstr="SNR: %d %%" % (value * 100 / 65536)
			elif self.__OnOff == 7:#TUNER-SNRdB
				self.__clock_timer.start(1000)
				if self.__cgevent is not None:
					status = self.__cgevent.getTunerInfo()
					if status is not None:
						value = status.get("tuner_signal_quality_db")
						if value:
							self.__resstr="SNR: %3.02f dB" % (value / 100.0)
			elif self.__OnOff == 8:#TUNER-BER
				self.__clock_timer.start(1000)
				if self.__cgevent is not None:
					status = self.__cgevent.getTunerInfo()
					if status is not None:
						value = status.get("tuner_bit_error_rate")
						if value is not None:
							self.__resstr="BER: %d" % (value)
						#else:
						#	self.__resstr="N/A"
			elif self.__OnOff == 9:#TUNER-AGC
				self.__clock_timer.start(2000)
				if self.__cgevent is not None:
					status = self.__cgevent.getTunerInfo()
					if status is not None:
						value = status.get("tuner_signal_power")
						if value:
							self.__resstr="AGC: %d %%" % (value * 100 / 65536)
			elif self.__OnOff == 18:#TUNER-Type
				self.__clock_timer.start(2000)
				if self.__cgevent is not None:
					status = self.__cgevent.getTunerInfo(True)
					if status is not None:
						value = status.get("tuner_type")
						if value == iDVBFrontend.feSatellite:
							self.__resstr="DVB-S"
						elif value == iDVBFrontend.feCable:
							self.__resstr="DVB-C"
						elif value == iDVBFrontend.feTerrestrial:
							self.__resstr="DVB-T"
			elif self.__OnOff == 19:#TUNER-Count
				self.__clock_timer.start(2000)
				if self.__cgevent is not None:
					status = self.__cgevent.getTunerInfo(True)
					if status is not None:
						value = status.get("slot_number")
						if value is not None:
							self.__resstr = nimmanager.getNimSlotInputName(value)
						if self.__Tuner_use_mask and self.__TunerCount:
							self.__resstr += " ("
							count=1
							for x in range(self.__TunerCount):
								if self.__Tuner_use_mask & count:
									self.__resstr += nimmanager.getNimSlotInputName(x)
								else:
									self.__resstr += "*"
								count = count*2
								if x < self.__TunerCount-1:
									self.__resstr += ", "
							self.__resstr += ")"
			elif self.__OnOff == 21 or self.__OnOff == 22:#TunerInfos
				self.__clock_timer.start(2000)
				if self.__cgevent is not None:
					transInfo = self.__cgevent.getTunerInfo(True)
					if transInfo is not None:
						if isinstance(transInfo, dict) and transInfo.has_key("tuner_type"):
							self.__resstr = str((transInfo.get("frequency") / 1000)) + _(" MHz  ")
							if transInfo.get("tuner_type") == iDVBFrontend.feSatellite or transInfo.get("tuner_type") == iDVBFrontend.feCable:
								tp_info = ConvertToHumanReadable(transInfo)
								satname=" "
								if transInfo.get("tuner_type") == iDVBFrontend.feSatellite:
									pol = transInfo.get("polarization")
									if isinstance(pol, int) and pol<len(self.__polValue):
										self.__resstr += self.__polValue[pol] + " "
									if self.__OnOff == 22:#Satname
										pos = int(transInfo.get("orbital_position"))
										if pos and pos>0:
											satname += nimmanager.getSatName(pos)
								elif transInfo.get("tuner_type") == iDVBFrontend.feCable:
									self.__resstr += str(tp_info["modulation"])+" "
								self.__resstr += str(tp_info["fec_inner"])+" "
								self.__resstr += str((transInfo.get("symbol_rate") / 1000))
								self.__resstr += satname
			elif self.__OnOff == 23 or self.__OnOff == 24:
				self.__clock_timer.start(2000)
				if self.__cgevent is not None:
					transInfo = self.__cgevent.getTunerInfo(True)
					if transInfo is not None:
						if isinstance(transInfo, dict) and transInfo.has_key("tuner_type"):
							tp_info = ConvertToHumanReadable(transInfo)
							if self.__OnOff==23:
								self.__resstr = "Mod: " + str(tp_info["modulation"])
							else:
								self.__resstr = str((transInfo.get("frequency") / 1000)) + _(" MHz  ")
#			elif self.__OnOff == 25 or self.__OnOff == 26 or self.__OnOff == 27:
#				self.__resstr = "? \xc2\xb0C"
#				if weathermsn:
#					from Plugins.Bp.geminiweather.plugin import WeatherPoll
					#print "____________________________________",WeatherPoll.InfobarTemp
#					if self.__OnOff == 25 and WeatherPoll.InfobarTemp[0] is not None:
#						self.__resstr = _("Temp: %s") %WeatherPoll.InfobarTemp[0]
#					elif self.__OnOff == 26 and WeatherPoll.InfobarTemp[1] is not None:
#						self.__resstr = WeatherPoll.InfobarTemp[1]
#					elif self.__OnOff == 27 and WeatherPoll.InfobarTemp[2] is not None:
#						self.__resstr = WeatherPoll.InfobarTemp[2]
#				else:
#					from gweathercore import gwtools
#					if gwtools.weatherdata and len(gwtools.weatherdata)>2:
#						if self.__OnOff == 25:
#							self.__resstr = _("Temp: %s") %gwtools.weatherdata[0][gwtools.TEMP][0]
#						elif self.__OnOff == 26:
#							self.__resstr = gwtools.weatherdata[1][gwtools.TEMP][1] + "   " + gwtools.weatherdata[1][gwtools.TEMP][2]
#						elif self.__OnOff == 27:
#							self.__resstr = gwtools.weatherdata[2][gwtools.TEMP][1] + "   " + gwtools.weatherdata[2][gwtools.TEMP][2]
			elif self.__OnOff == 28:
				self.__resstr = self.__SoftCamdName
			elif self.__OnOff == 29:
				self.__resstr = self.__Expertstr
			elif self.__OnOff == 30:
				self.__resstr = self.__CryptStr
			elif self.__OnOff == 31 or self.__OnOff == 33:#Provider oder Codec-Info
				self.__resstr = self.__CurrChannelInfo
			elif self.__OnOff == 32:#FlashExpander 32=P
				for x in libgeminimain.getPyList(GETMOUNTLIST):
					if x[PART_MPOINT] == "/usr":
						self.__resstr = _("%s in FE") %libgeminimain.getHumanSize(x[PART_F_SIZE])
						break
				if self.__resstr=="":
					self.__resstr = "FE " + _("deactivated")
			elif self.__OnOff == 34:#Datum
				tm = localtime(currtime())
				self.__resstr = "%d. %s" %(tm.tm_mday, monthStrSmall[tm.tm_mon-1])
			elif self.__OnOff == 36:#Uhr
				tm = localtime(currtime())
				self.__resstr = "%s:%s" %("0" + str(tm.tm_hour) if len(str(tm.tm_hour)) == 1 else str(tm.tm_hour),"0" + str(tm.tm_min) if len(str(tm.tm_min)) == 1 else str(tm.tm_min))
				self.__clock_timer.start(2000)
					
			elif self.__OnOff == 40:#Datum
				val, poll = exsensor.getValue()
				if len(val):
					if poll:
						self.__clock_timer.start(2000)
					self.__resstr = val
		except:
			pass
			
		#print "gSensorData_________________________________", self.__resstr
		if self.__resstr=="":
			self.changed((self.CHANGED_CLEAR,))
		else:
			self.changed((self.CHANGED_DEFAULT,))

	def getSensorText(self):
		if self.__OnOff == 5:
			return self.__VideoSize
		return self.__resstr

	text = property(getSensorText)
	
	def doSuspend(self, suspended):
		if suspended:
			self.__clock_timer.stop()
		else:
			self.__checkcgevent()
			if self.__OnOff != 5:#bei VideoSize nicht pollen
				self.poll()

	def destroy(self):
		self.__offTunerCount()
		geventNotifier.remove((EVENT_CHANNEL, self.__Channel_Changed))
		geventNotifier.remove((EVENT_CAID_LIST, self.__newCaids))
		geventNotifier.remove((EVENT_EXPERT_STR, self.__NewExpertstr))
		geventNotifier.remove((EVENT_CAMD_SWITCH, self.__NewCamdName))
		dbusNotifier.remove(("gdaemon", self.__newHddTemp))
		geventNotifier.remove((EVENT_CHANNEL_SIZE, self.__setVideoSize))
		geventNotifier.remove((EVENT_SENSORFIELD, self.__gSensorConf))
		del self.__clock_timer
		Source.destroy(self)

#---------------------------------------------------------------------------------
