# -*- coding: utf-8 -*-
from gLocale import _
from gTools import libgeminimain, pathExists, cleanexit

from Screens.Screen import Screen
from Screens.MessageBox import MessageBox
from Components.ActionMap import ActionMap
from Components.Sources.StaticText import StaticText
from Components.Sources.Progress import Progress
from Components.Pixmap import MultiPixmap, Pixmap
from Screens.ChoiceBox import ChoiceBox

class Cequalizer(Screen):
	BANDCOUNT=10
	MAXVALUE=26
	DEFAULT_TUNNING=[24,24,24,24,24,24,24,24,24,24]#24 ist 0db
	DISCO_TUNNING=[25,23,20,17,17,17,17,20,23,25]
	USERCONF="/etc/enigma2/gemini_Equalizer.conf"
	def __init__(self, session, val, libjukebox):
		Screen.__init__(self, session)
		self.__libjukebox = libjukebox
		self.skinName = []
		self.__selected = False
		self.skinName.append("Equalizer-HD")

		self["actions"] = ActionMap(["gActions"],
		{
			"exit": self.KeyExit,
			"left": self.KeyLeft,
			"right": self.KeyRight,
			"down": self.KeyDown,
			"up": self.KeyUp,
			"blue": self.KeyBlue,
			"green": self.KeyGreen,
			"yellow": self.KeyYellow,
			"red": self.KeyRed,
		}, -1)
		
		self.__index=4
		
		self["PixmapBlue"] = Pixmap()
		self["LabelBlue"] = StaticText(_("Setup"))
		self["PixmapGreen"] = Pixmap()
		self["LabelGreen"] = StaticText(_("Save"))
		self["PixmapYellow"] = Pixmap()
		self["LabelYellow"] = StaticText(_("Add"))
		self["PixmapRed"] = Pixmap()
		self["LabelRed"] = StaticText(_("Delete"))
		
		self["db0"] = StaticText("+2 dB")
		self["db1"] = StaticText("-10 dB")
		self["db2"] = StaticText("-24 dB")
		self["db3"] = StaticText("+2 dB")
		self["db4"] = StaticText("-10 dB")
		self["db5"] = StaticText("-24 dB")

		for x in range(self.BANDCOUNT):
			self["Progress" + str(x)] = Progress()
			self["PixmapGreen" + str(x)] = MultiPixmap()
			self["hz" + str(x)] = StaticText()
		
		self.__valList=self.DEFAULT_TUNNING
		bla = val.split(',')
		if len(bla)==self.BANDCOUNT:
			for x in range(self.BANDCOUNT):
				self.__valList[x]=int(bla[x])
				if self.__valList[x] > self.MAXVALUE:
					self.__valList[x] = self.MAXVALUE
					
		self.__getTunning()
		
		self.onLayoutFinish.append(self.__LayoutFinish)

	def KeyExit(self, val=None):
		if val:
			self.close(val)
		else:
			self.close("24,24,24,24,24,24,24,24,24,24")
		cleanexit(__name__)
		
	def createString(self):
		text=""
		for x in range(self.BANDCOUNT):
			text += str(self.__valList[x])
			if x<self.BANDCOUNT-1:
				text += ","
		return text
		
	def KeyGreen(self):
		self.KeyExit(self.createString())
		
	def SetEqualizer(self):
		self.__libjukebox.setEqualizer(self.createString())
		
	def __paintIndex(self):
		for x in range(self.BANDCOUNT):
			if self.__index == x:
				self["PixmapGreen" + str(x)].setPixmapNum(1)
			else:
				self["PixmapGreen" + str(x)].setPixmapNum(0)

	def __LayoutFinish(self):
		self.setTitle(_("Equalizer"))
		for x in range(self.BANDCOUNT):
			self["Progress" + str(x)].setRange(self.MAXVALUE)
			self["Progress" + str(x)].setValue(self.__valList[x])
		self.__paintIndex()
		
	def KeyLeft(self):
		self.__index -= 1
		if self.__index < 0:
			self.__index=self.BANDCOUNT-1
		self.__paintIndex()

	def KeyRight(self):
		self.__index += 1
		if self.__index > self.BANDCOUNT-1:
			self.__index=0
		self.__paintIndex()
		
	def KeyDown(self):
		self.__valList[self.__index] -= 1
		if self.__valList[self.__index]<0:
			self.__valList[self.__index]=0
		self["Progress" + str(self.__index)].setValue(self.__valList[self.__index])
		self.SetEqualizer()
	
	def KeyUp(self):
		self.__valList[self.__index] += 1
		if self.__valList[self.__index]>self.MAXVALUE:
			self.__valList[self.__index]=self.MAXVALUE
		self["Progress" + str(self.__index)].setValue(self.__valList[self.__index])
		self.SetEqualizer()
	
	def KeyBlue(self):
		self.session.openWithCallback(self.__menuCallback, ChoiceBox, title="", list=self.__menu)
		
	def KeyRed(self):
		self.session.openWithCallback(self.__removeCallback, ChoiceBox, title="", list=self.__menu)
		
	def KeyYellow(self):
		from WidgetConfig import WidgetInput
		self.session.openWithCallback(self.__addCallback, WidgetInput, title=_("Settings") + " " + _("Equalizer"), entryname=_("Name") + " :", default="My Settings")
		
	def __menuCallback(self, what=None):
		if what is None:
			return
		self.__valList = what[1]
		for x in range(self.BANDCOUNT):
			self["Progress" + str(x)].setValue(self.__valList[x])
		self.SetEqualizer()
		
	def __removeCallback(self, what=None):
		if what is None or what[1] == self.DEFAULT_TUNNING or what[1] == self.DISCO_TUNNING:
			return
		inx=0
		for entr in self.__menu:
			if entr == what:
				break
			inx +=1
		del self.__menu[inx]
		with open(self.USERCONF, "w") as file:
			file.write(str(self.__menu))
		
	def __getTunning(self):
		self.__menu = []
		if pathExists(self.USERCONF):
			with open(self.USERCONF, "r") as file:
				list=file.read()
				self.__menu = eval(list)
		else:
			self.__menu.append(("Disco", self.DISCO_TUNNING))#24 ist 0db
			self.__menu.append(("Neutral", self.DEFAULT_TUNNING))#24 ist 0db
		
	def __addCallback(self, val=None):
		if val is None:
			return
		else:
			if len([c for c in val if c not in "abcdefghijklmnopqrstuvwxyzäöüABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜ_-+0123456789 "]):
				msg = _("Name contains bad expression!\n") + val
				self.session.open(MessageBox,text=msg, type=MessageBox.TYPE_ERROR, timeout=5)
				return
		
			self.__menu.insert(0,(val, self.__valList))
			with open(self.USERCONF, "w") as file:
				file.write(str(self.__menu))
