# -*- coding: utf-8 -*-
from gLocale import _
from gTools import libgeminimain, cleanexit

from WidgetConfig import gConfigSelection, gConfigWindow, CONFIGSEPERATOR
from Components.config import config, NoSave, getConfigListEntry, ConfigText, ConfigInteger
from Screens.MessageBox import MessageBox

from enigma import eTimer

def getEntry(str):
	val = libgeminimain.getCfileEntry(str)
	split = val.rfind('\t')
	if split > 0:
		val = val[:split-1]
	return val

class Syslog(gConfigWindow):
	SYSLOGSCRIPT = "/etc/init.d/syslog.busybox"
	SYSLOGCONF = "/etc/syslog-startup.conf.busybox"
	
	def __init__(self, session, name=None):
		self.__running = False
		self.__fileopen = libgeminimain.openCfile(self.SYSLOGCONF)
		list=[]
		if self.__fileopen:
			config.bp.dest = NoSave(gConfigSelection(default=getEntry("DESTINATION"), choices=[("\"buffer\"", _("Buffer")), ("\"file\"", _("File")), ("\"remote\"", _("Remote"))]))
			markint = getEntry("MARKINT")
			if markint=="":
				markint="20"
			config.bp.interval = NoSave(ConfigInteger(default=int(markint), limits=(1, 60)))
			config.bp.red = NoSave(gConfigSelection(default=getEntry("REDUCE"), choices=[("no", _("no")),("yes", _("yes"))]))
			config.bp.buff = NoSave(ConfigInteger(default=int(getEntry("BUFFERSIZE")), limits=(16, 999)))
			config.bp.logfile = NoSave(ConfigText(default=getEntry("LOGFILE"), fixed_size=False))

			server = "127.0.0.1"
			port = 512
			tmp = getEntry("REMOTE")
			tmp = tmp.split(':')
			if len(tmp) == 2:
				server = tmp[0]
				port = int(tmp[1])
			config.bp.server = NoSave(ConfigText(default=server, fixed_size=False))
			config.bp.port = NoSave(ConfigInteger(default=port, limits=(0, 70000)))
			

			list.append(getConfigListEntry(_("Logfile"), config.bp.logfile))
			list.append(CONFIGSEPERATOR())
			list.append(getConfigListEntry(_("Remote Host"), config.bp.server))
			list.append(getConfigListEntry(_("Remote Port (default=514)"), config.bp.port))
			list.append(CONFIGSEPERATOR())
			list.append(getConfigListEntry(_("Logmode"), config.bp.dest))
			list.append(getConfigListEntry(_("Set mark after x minutes"), config.bp.interval))
			list.append(getConfigListEntry(_("Reduce-size logging"), config.bp.red))
			list.append(getConfigListEntry(_("Buffersize in kB"), config.bp.buff))
			
			self.__clock_timer = eTimer()
			self.__clock_timer_conn = self.__clock_timer.timeout.connect(self.__SetLabel)
			self.__clock_timer.start(300)
		gConfigWindow.__init__ (self, session, name or _("Sys/Kernel Log"), icon="icon_syslog.png", list=list)
		
	def __SetLabel(self):
		text = _("Syslog") + " "
		if libgeminimain.isRunning("syslogd"):
			text += _("running")
			self.__running = True
		else:
			text += _("not running")
			self.__running = False
		self.SetLabel(text)
		self.__clock_timer.start(3000)

	def KeyGreen(self):
		if self.__fileopen:
			if self.__running:
				self.session.open(MessageBox, _("Values stored") + _("\nRestart Syslog!"), MessageBox.TYPE_INFO, 3)
			else:
				self.session.open(MessageBox, _("Values stored") + _("\nStart Syslog!"), MessageBox.TYPE_INFO, 3)
			libgeminimain.setCfileEntry("DESTINATION", config.bp.dest.value)
			libgeminimain.setCfileEntry("MARKINT", str(config.bp.interval.value))
			libgeminimain.setCfileEntry("REDUCE", config.bp.red.value)
			libgeminimain.setCfileEntry("BUFFERSIZE", str(config.bp.buff.value))
			libgeminimain.setCfileEntry("REMOTE", config.bp.server.value + ":" + str(config.bp.port.value))
			libgeminimain.setCfileEntry("LOGFILE", config.bp.logfile.value)
			self.KeyExit(True)
		else:
			self.KeyExit()
		
	def KeyExit(self, val=False):
		if self.__fileopen:
			libgeminimain.closeCfile()
		if val:
			if self.__running:
				libgeminimain.sendDbus("gdaemon",0,self.SYSLOGSCRIPT + " restart")
			else:
				libgeminimain.sendDbus("gdaemon",0,self.SYSLOGSCRIPT + " start")
		self.close()
		cleanexit(__name__)
