# -*- coding: utf-8 -*-
from gLocale import _
from gTools import libgeminimain, cleanexit, BoxType, DEFAULT_HD_DMMSKIN
from plugin import cgevent, EVENT_SENSORFIELD, GETBLOCKLIST, DEV_DEVPATH, DEV_TYPE, GSENSERCOUNT
from DeviceManager import ATA_HDD, SCSI_HDD

from WidgetConfig import gConfigWindow, gConfigSelection
from Components.config import config, NoSave, getConfigListEntry

from Tools.Directories import resolveFilename, SCOPE_CURRENT_SKIN


class Sensorfields(gConfigWindow):
	ATAHDDTEMP=3
	def __init__(self, session, name=None):
		sensorvalue = cgevent.getConfig("SensorInfo","5")#VideoSize bei sensor0 als default
		self.__readSensorConf()
		list=[]
		
		self.__HddTempDevPath=None
		for x in libgeminimain.getPyList(GETBLOCKLIST):
			if x[DEV_TYPE] & (ATA_HDD | SCSI_HDD):
				self.__HddTempDevPath = x[DEV_DEVPATH]
				break
		
		menu = [("0", _("disable"))]
		if BoxType != "dm7025" and BoxType != "dm800" and BoxType != "dm7020hd":
			menu.append(("1", _("Temperature")))
			menu.append(("2", _("Speed Fan")))
			menu.append(("D", _("Speed Fan") + "(/2)"))
		menu.append(("3", _("CPU load")))
		if self.__HddTempDevPath is not None:
			menu.append(("4", _("HDD-Temperature")))
			menu.append(("A", _("HDD-Temperature") + " (" + _("always") + ")"))
		menu.append(("5", _("Video-Size")))
		menu.append(("6", _("Tuner (SNR in %)")))
		menu.append(("7", _("Tuner (SNR in dB)")))
		menu.append(("8", _("Tuner (BER)")))
		if BoxType != "dm520" and BoxType != "dm525":
			menu.append(("9", _("Tuner (AGC)")))
		menu.append(("B", _("Tuner (Type)")))
		menu.append(("C", _("Tuner (Overview)")))
		menu.append(("E", _("Tuner (Value)")))
		menu.append(("F", _("Tuner (Value)") + _(" + Satname")))
		menu.append(("G", _("Tuner (Modulation)")))
		menu.append(("H", _("Tuner (Frequency)")))
#		menu.append(("I", _("Weather") + " (" + _("current") + ")"))
#		menu.append(("J", _("Weather") + " (" + _("Today") + ")"))
#		menu.append(("K", _("Weather") + " (" + _("Tomorrow") + ")"))
		menu.append(("L", _("Camd") + " " + _("Name")))
		menu.append(("M", _("ECM-Infos")))
		menu.append(("N", _("Crypt-Infos")))
		menu.append(("O", _("Provider")))
		menu.append(("P", _("FlashExpander")))
		menu.append(("Q", _("Codec") + " - " + _("Information")))
		menu.append(("R", _("Date")))
		menu.append(("T", _("Time")))
		menu.append(("X", _("Sensorfield") + " " + _("external")))
		
		for x in range(GSENSERCOUNT):
			config.bp.val = NoSave(gConfigSelection(default=("0" if (len(sensorvalue) < x+1) else sensorvalue[x]), choices=menu))
			desc="(" + _("No description!") + ")"
			pic=None
			for y in self.__descList:
				if y[0]==x:
					if y[1]!="":
						desc="(" + y[1] + ")"
					pic=y[2]
			list.append(getConfigListEntry((_("Sensorfield Nr.%d %s") % (x+1,desc)), config.bp.val, pic))

		gConfigWindow.__init__ (self, session, _("Sensorfields") + " " + _("(only Gemini-Skins)"), list=list, icon="none.png")

	def KeyExit(self):
		self.close()
		cleanexit(__name__)
		
	def __readSensorConf(self):
		self.__descList=[]
		try:
			if config.skin.primary_skin.value in DEFAULT_HD_DMMSKIN:
				gfile="/usr/lib/enigma2/python/Plugins/Bp/geminimain/images/gSensorFields.conf"
			else:
				gfile=resolveFilename(SCOPE_CURRENT_SKIN, "gSensorFields.conf")
			with open(gfile, 'r') as f:
				for x in f.readlines():
					val = x.strip().split('=')
					if len(val)==2:
						self.__descList.append((int(val[0]), val[1], None))
					elif len(val)==3:
						self.__descList.append((int(val[0]), val[1], val[2]))
			f.closed
		except:
			pass
		
	def SelectionChangedNow(self):
		self.__newIcon()
		
	#def KeyUp(self):
	#	gConfigWindow.KeyUp(self)
		#self.__newIcon()

	#def KeyDown(self):
	#	gConfigWindow.KeyDown(self)
		#self.__newIcon()
		
	def __newIcon(self):
		if self.getCurrendValue():
			self.SetIcon(self.getCurrendEntry()[2])

	def KeyGreen(self):
		ret=""
		com=None
		for x in self.getConfList():
			ret += x[1].value
			if self.__HddTempDevPath is not None:
				if x[1].value=="4":
					com="smartctl -d ata -n standby -A "
				if x[1].value=="A":
					com="smartctl -d ata -A "
					
		if com is not None:
			libgeminimain.sendDbus("gdaemon",self.ATAHDDTEMP,com+self.__HddTempDevPath)
			cgevent.setConfig("gethddtemp",com+self.__HddTempDevPath)
		else:
			libgeminimain.sendDbus("gdaemon",self.ATAHDDTEMP,"off")
			cgevent.setConfig("gethddtemp","off")

		cgevent.setConfig("SensorInfo",ret)
		cgevent.setGevent(EVENT_SENSORFIELD,ret)
		self.KeyExit()
