# -*- coding: utf-8 -*-
from gLocale import _
from gTools import cleanexit, pathExists, ICONPACKAGES, gLoadPixmap, ctoolsclass

from WidgetConfig import gConfigSelection, gConfigWindow
from Components.config import config, NoSave, getConfigListEntry
from Components.Pixmap import Pixmap

from os import listdir as os_listdir

def getIconPackagesInfo(file):
	if pathExists(file+"/VERSION"):
		vfile = open(file+"/VERSION", 'r')
		if vfile:
			IconInfos=["","",""]
			IconInfos[0] = vfile.readline().strip()
			IconInfos[1] = vfile.readline().strip()
			IconInfos[2] = vfile.readline().strip()
			vfile.closed
			return IconInfos
	return None

class IconsFrame(gConfigWindow):
	I_DIR=0
	I_ICONLIST=1
	I_INFO=2
	I_FRAMELIST=3
	def __init__(self, session, name=None):
		gConfigWindow.__init__ (self, session, name or _("Icons and Frame"), list=[], icon="icon_iconsframe.png", setSkin="")
		
		self["PixmapIcon1"] = Pixmap()
		self["PixmapIcon2"] = Pixmap()
		self["PixmapIcon3"] = Pixmap()
		
		self.__actIconPackage = ctoolsclass.getCurrIconPackage()
		self.__actFramePicture = ctoolsclass.getCurrFramePicture()
		print self.__actFramePicture

		self.__currIndex=0
		self.__iconframelist=[]
		if pathExists(ICONPACKAGES):
			count=0
			for x in os_listdir(ICONPACKAGES):
				iconfile0 = ICONPACKAGES + x + "/icon_glogo.png"
				iconfile1 = ICONPACKAGES + x + "/icon_devicemanager.png"
				iconfile2 = ICONPACKAGES + x + "/icon_filebrowser.png"
				if pathExists(iconfile0) and pathExists(iconfile1) and pathExists(iconfile2):
					if x == self.__actIconPackage:
						self.__currIndex = count
					entry=[x,[iconfile0,iconfile1,iconfile2],getIconPackagesInfo(ICONPACKAGES + x),None]
					framedir = ICONPACKAGES + x + "/desktopframes"
					if pathExists(framedir):
						framelist=[]
						for x in os_listdir(framedir):
							if x.endswith(".png"):
								framelist.append((x,x[:len(x)-4]))
						if len(framelist):
							entry[self.I_FRAMELIST] = framelist
							self.__iconframelist.append(entry)
					count += 1
		self.onLayoutFinish.append(self.__fillist)

	def KeyExit(self,val=None):
		self.close(val)
		cleanexit(__name__)
		
	def __fillist(self):
		self.SetLabel()
		packages=[]
		count=0
		for x in self.__iconframelist:
			name = x[self.I_DIR]
			if x[self.I_INFO] is not None:
				name=x[self.I_INFO][0]
				if self.__currIndex == count:
					if x[self.I_INFO][2]!="":
						tstr = _("created by %s") %x[self.I_INFO][2]
						if x[self.I_INFO][1]!="":
							tstr += ", " + _("Version") + " " + x[self.I_INFO][1]
						self.SetLabel(tstr)
			packages.append((count, name))
			count += 1
		
		
		config.bp.packages = NoSave(gConfigSelection(default=self.__currIndex, choices=packages))
		config.bp.frame = NoSave(gConfigSelection(default=self.__actFramePicture,choices=self.__iconframelist[self.__currIndex][self.I_FRAMELIST]))
		
		list=[]
		list.append(getConfigListEntry(_("Please select one") + ":", config.bp.packages))
		list.append(getConfigListEntry(_("Frame") + ":", config.bp.frame))
		self.SetConfList(list)
		self.__paintIcon()

	def KeyRight(self):
		gConfigWindow.KeyRight(self)
		sel = self.getCurrendValue()
		if sel==config.bp.packages:
			self.__currIndex=config.bp.packages.value
			self.__fillist()
		elif sel==config.bp.frame:
			self.__paintIcon()
			
	def KeyLeft(self):
		gConfigWindow.KeyLeft(self)
		sel = self.getCurrendValue()
		if sel==config.bp.packages:
			self.__currIndex=config.bp.packages.value
			self.__fillist()
		elif sel==config.bp.frame:
			self.__paintIcon()
		
	def __paintIcon(self):
		iconlist = self.__iconframelist[self.__currIndex][self.I_ICONLIST]
		self.SetIcon(iconlist[0])
		self["PixmapIcon1"].instance.setPixmap(gLoadPixmap(iconlist[1], cached=False))
		self["PixmapIcon2"].instance.setPixmap(gLoadPixmap(iconlist[2], cached=False))
		frame = ICONPACKAGES + self.__iconframelist[self.__currIndex][self.I_DIR] + "/desktopframes/" + config.bp.frame.value
		self["PixmapIcon3"].instance.setPixmap(gLoadPixmap(frame, cached=False))
		
	def KeyGreen(self):
		#print self.__iconframelist[self.__currIndex][self.I_DIR]
		#print config.bp.frame.value + ".png"
		ctoolsclass.setIconAndFrame(self.__iconframelist[self.__currIndex][self.I_DIR],config.bp.frame.value)
		self.KeyExit(self.__class__.__name__)


