# -*- coding: utf-8 -*-
from gLocale import _
from gTools import getColorPic, cleanexit, pathExists
from plugin import cgevent
from WidgetVariableList import WidgetVariableList
from WidgetConfig import gConfigWindow, WidgetInput, CONFIGSEPERATOR, myConfigNothing, gConfigSelection, gConfigOnOff, gConfigDirectory

from FileBrowser import *

from Screens.MessageBox import MessageBox
from Screens.ParentalControlSetup import ParentalControlChangePin
from Components.config import config, NoSave, getConfigListEntry, ConfigText
from Tools.BoundFunction import boundFunction

from stat import S_IRUSR, S_IWUSR, S_IXUSR, S_IRGRP, S_IWGRP, S_IXGRP, S_IROTH, S_IWOTH, S_IXOTH

class eCommanderSetup(gConfigWindow):
	def __init__(self, session, startfromDM):
		self.__startfromDM = startfromDM
		
		if self.__startfromDM:
			menu = [(0,_("File Browser"))]
			menu.append((1, _("Favourites")))
			menu.append((2, "eCommander"))
			config.bp.favo = NoSave(gConfigSelection(default=cgevent.getConfig("Dmanager_startfirst",0), choices=menu))
		
		menu = [(SORT_NAME,_("Filename"))]
		menu.append((SORT_DATE_UP, _("Date") + " (9-1)"))
		menu.append((SORT_DATE_DOWN, _("Date") + " (1-9)"))
		menu.append((SORT_SIZE_UP, _("Size") + " (9-1)"))
		menu.append((SORT_SIZE_DOWN, _("Size") + " (1-9)"))
		config.bp.sortby = NoSave(gConfigSelection(default=cgevent.getConfig("ecomm_SortBy", SORT_NAME), choices=menu))
		
		config.bp.ask = NoSave(gConfigOnOff(default=cgevent.getConfig("Dmanager_ask",1)))
		config.bp.homedirl = NoSave(gConfigDirectory(default=cgevent.getConfig("ecomm_StartDir_l"," "), visible_width=35))
		config.bp.homedirr = NoSave(gConfigDirectory(default=cgevent.getConfig("ecomm_StartDir_r"," "), visible_width=35))
		config.bp.okIsGreen = NoSave(gConfigOnOff(default=cgevent.getConfig("Dmanager_ok_is_green",0)))
		config.bp.ts_help = NoSave(gConfigOnOff(default=cgevent.getConfig("ecomm_show_ts_help_files",1)))
		config.bp.hidden_file = NoSave(gConfigOnOff(default=cgevent.getConfig("ecomm_show_hidden_files",0)))
		config.bp.dirprop = NoSave(gConfigOnOff(default=cgevent.getConfig("ecomm_dirprop",0)))

		list = []
		list.append(getConfigListEntry(_("Sort files by"), config.bp.sortby))
		list.append(getConfigListEntry(_("Show TS-help-files"), config.bp.ts_help))
		list.append(getConfigListEntry(_("Show System-Files"), config.bp.hidden_file))
		list.append(getConfigListEntry(_("Ignore directory properties?"), config.bp.dirprop))
		list.append(CONFIGSEPERATOR())
		list.append(getConfigListEntry("%s (%s)" %(_("Home Directory"),_("left")), config.bp.homedirl))
		list.append(getConfigListEntry("%s (%s)" %(_("Home Directory"),_("right")), config.bp.homedirr))
		list.append(CONFIGSEPERATOR())
		if self.__startfromDM:
			list.append(getConfigListEntry(_("Which mode to start?"), config.bp.favo))
		list.append(getConfigListEntry(_("Key Ok = Key Green"), config.bp.okIsGreen))
		list.append(getConfigListEntry(_("Ask before delete, move or copy?"), config.bp.ask))

		gConfigWindow.__init__(self, session,list=list)
		
	def SelectionChangedNow(self):
		sel = self.getCurrendValue()
		if sel == config.bp.homedirl or sel == config.bp.homedirr:
			self.setRB(_("Delete"))
		else:
			self.setRB()
			
	def KeyRed(self):
		sel = self.getCurrendValue()
		if sel == config.bp.homedirl:
			config.bp.homedirl.setValue(" ")
			gConfigWindow.KeyUp(self)
			gConfigWindow.KeyDown(self)
		elif sel == config.bp.homedirr:
			config.bp.homedirr.setValue(" ")
			gConfigWindow.KeyUp(self)
			gConfigWindow.KeyDown(self)
		
	def KeyGreen(self):
		if self.__startfromDM:
			cgevent.setConfig("Dmanager_startfirst",config.bp.favo.value)
		cgevent.setConfig("ecomm_SortBy", config.bp.sortby.value)
		cgevent.setConfig("Dmanager_ask", config.bp.ask.value)
		cgevent.setConfig("ecomm_StartDir_l", config.bp.homedirl.value)
		cgevent.setConfig("ecomm_StartDir_r", config.bp.homedirr.value)
		cgevent.setConfig("Dmanager_ok_is_green", config.bp.okIsGreen.value)
		cgevent.setConfig("ecomm_show_ts_help_files",config.bp.ts_help.value)
		cgevent.setConfig("ecomm_show_hidden_files", config.bp.hidden_file.value)
		cgevent.setConfig("ecomm_dirprop", config.bp.dirprop.value)
		self.KeyExit()
		
	def KeyExit(self):
		self.close(self.ListChanged())
		cleanexit(__name__)

class BrowserSetup(gConfigWindow):
	def __init__(self, session, hidelist):
		gConfigWindow.__init__(self, session)
		self.__hidelist = hidelist
		self.__largeview=cgevent.getConfig("Dmanager_largeview",1)

		menu = [(str(SORT_NAME),_("Filename"))]
		menu.append((str(SORT_DATE_UP), _("Date") + " (9-1)"))
		menu.append((str(SORT_DATE_DOWN), _("Date") + " (1-9)"))
		menu.append((str(SORT_SIZE_UP), _("Size") + " (9-1)"))
		menu.append((str(SORT_SIZE_DOWN), _("Size") + " (1-9)"))
		config.bp.sortby = NoSave(gConfigSelection(default=str(cgevent.getConfig("Dmanager_SortBy", SORT_NAME)), choices=menu))
		
		menu = [(str(0),_("Filename"))]
		menu.append((str(1), "EPG-" + _("Name")))
		menu.append((str(2), "EPG-" + _("Name") + " + " + _("Description")))
		config.bp.ts_info = NoSave(gConfigSelection(default=str(cgevent.getConfig("Dmanager_show_ts_info",1)), choices=menu))
		
		menu = [(str(0),_("off"))]
		menu.append((str(1), _("Ask user")))
		menu.append((str(2), _("Immediate exit")))
		config.bp.exitbutton = NoSave(gConfigSelection(default=str(cgevent.getConfig("Dmanager_movie_exit",1)), choices=menu))

		config.bp.ts_help = NoSave(gConfigOnOff(default=cgevent.getConfig("Dmanager_show_ts_help_files",1)))
		config.bp.hidden_file = NoSave(gConfigOnOff(default=cgevent.getConfig("Dmanager_show_hidden_files",0)))
		
		menu = [(0,_("File Browser"))]
		menu.append((1, _("Favourites")))
		menu.append((2, "eCommander"))
		config.bp.favo = NoSave(gConfigSelection(default=cgevent.getConfig("Dmanager_startfirst",0), choices=menu))
		
		config.bp.homedir = NoSave(gConfigDirectory(default=cgevent.getConfig("Dmanager_StartDir"," "), visible_width=35))
		config.bp.ask = NoSave(gConfigOnOff(default=cgevent.getConfig("Dmanager_ask",1)))
		config.bp.okIsGreen = NoSave(gConfigOnOff(default=cgevent.getConfig("Dmanager_ok_is_green",0)))
		config.bp.largeView = NoSave(gConfigOnOff(default=self.__largeview))
		config.bp.myhidde = NoSave(gConfigSelection(choices=[_("Press red key for details")]))
		config.bp.folderpin = NoSave(gConfigSelection(choices=[" "]))
		
		self.__fillList()
	
	def __fillList(self):
		list = []
		list.append(getConfigListEntry(_("Sort files by"), config.bp.sortby))
		list.append(getConfigListEntry(_("Which mode to start?"), config.bp.favo))
		list.append(getConfigListEntry(_("Key Ok = Key Green"), config.bp.okIsGreen))
		list.append(getConfigListEntry(_("Large view"), config.bp.largeView))
		list.append(CONFIGSEPERATOR())
		list.append(getConfigListEntry(_("Show TS-help-files"), config.bp.ts_help))
		list.append(getConfigListEntry(_("Show at TS-files"), config.bp.ts_info))
		list.append(getConfigListEntry(_("Show System-Files"), config.bp.hidden_file))
		if config.ParentalControl.folderpin.value != PINCODEOFF:
			list.append(getConfigListEntry(_("remove pin code for folder/files"), config.bp.folderpin))
		list.append(getConfigListEntry(_("Hidden files/directorys"), config.bp.myhidde))
		list.append(CONFIGSEPERATOR())
		list.append(getConfigListEntry(_("EXIT key in movie mode"), config.bp.exitbutton))
		list.append(getConfigListEntry(_("Home Directory"), config.bp.homedir))
		list.append(getConfigListEntry(_("Ask before delete, move or copy?"), config.bp.ask))
		self.SetConfList(list)
		
	def SelectionChangedNow(self):
		sel = self.getCurrendValue()
		if sel == config.bp.homedir or sel == config.bp.folderpin:
			self.setRB(_("Delete"))
		elif sel == config.bp.myhidde:
			self.setRB(_("Edit"))
		else:
			self.setRB()
	
	def KeyRed(self):
		sel = self.getCurrendValue()
		if sel == config.bp.homedir:
			config.bp.homedir.setValue(" ")
			gConfigWindow.KeyUp(self)
			gConfigWindow.KeyDown(self)
		elif sel == config.bp.myhidde:
			self.session.openWithCallback(self.__EditHidden_Callback, EditHidden, self.__hidelist)
		elif sel == config.bp.folderpin:
			self.session.openWithCallback(self.__PinCode_Callback, WidgetInput, PinCode=config.ParentalControl.folderpin.value)
	
	def __EditHidden_Callback(self, val):
		self.__hidelist = val
		
	def __PinCode_Callback(self, val):
		if val:
			config.ParentalControl.folderpin.value = PINCODEOFF
			self.__fillList()
		
	def KeyGreen(self):
		cgevent.setConfig("Dmanager_show_ts_help_files",config.bp.ts_help.value)
		cgevent.setConfig("Dmanager_show_hidden_files", config.bp.hidden_file.value)
		cgevent.setConfig("Dmanager_SortBy", int(config.bp.sortby.value))
		cgevent.setConfig("Dmanager_show_ts_info", int(config.bp.ts_info.value))
		cgevent.setConfig("Dmanager_startfirst",config.bp.favo.value)
		cgevent.setConfig("Dmanager_movie_exit", int(config.bp.exitbutton.value))
		cgevent.setConfig("Dmanager_StartDir", config.bp.homedir.value)
		cgevent.setConfig("Dmanager_ask", config.bp.ask.value)
		cgevent.setConfig("Dmanager_ok_is_green", config.bp.okIsGreen.value)
		cgevent.setConfig("Dmanager_largeview", config.bp.largeView.value)
		
		if self.__largeview!=config.bp.largeView.value:
			#self.session.open(MessageBox, _("Restart %s") %_("File Browser"), MessageBox.TYPE_ERROR, timeout=5)
			self.KeyExit(True)
		self.KeyExit()
	
	def KeyExit(self, val=None):
		self.close(self.ListChanged(), self.__hidelist, val)
		cleanexit(__name__)

#-----------------------------------------------------------------------------------------------------

class FolderProp(gConfigWindow):
	def __init__(self, session, name, folder, prop):
		self.__Okselected=False
		self.__folder = folder[B_FULL]
		self.__prop = prop
		if len(self.__prop)!=8:
			self.__prop = ["bigext_folder.png",0,0,0,0,0,0,0]
			
		menu=[("bigext_folder.png",_("Default"))]
		menu.append(("bigext_folder_music.png",_("Music")))
		menu.append(("bigext_folder_movies.png",_("Movies") + " (1)"))
		menu.append(("bigext_folder_movies1.png",_("Movies") + " (2)"))
		menu.append(("bigext_folder_image.png",_("Pictures")))
		menu.append(("bigext_folder_children.png",_("Children")))
		menu.append(("bigext_folder_network.png",_("Network")))
		menu.append(("bigext_folder_dvd.png","DVD"))
		config.bp.icon = NoSave(gConfigSelection(default=self.__prop[0], choices=menu))
		config.bp.hide_files = NoSave(gConfigSelection(choices=[_("Press OK for details")]))
		config.bp.hidden_file = NoSave(gConfigOnOff(default=self.__prop[2]))
		config.bp.ts_help = NoSave(gConfigOnOff(default=self.__prop[3]))
		config.bp.largeView = NoSave(gConfigOnOff(default=(self.__prop[4]-1)))
		config.bp.subdir = NoSave(gConfigOnOff(default=0))
		config.bp.nomedia = NoSave(gConfigOnOff(default=self.__prop[7]))
		
		menu = [(str(SORT_NAME),_("Filename"))]
		menu.append((str(SORT_DATE_UP), _("Date") + " (9-1)"))
		menu.append((str(SORT_DATE_DOWN), _("Date") + " (1-9)"))
		menu.append((str(SORT_SIZE_UP), _("Size") + " (9-1)"))
		menu.append((str(SORT_SIZE_DOWN), _("Size") + " (1-9)"))
		config.bp.sortby = NoSave(gConfigSelection(default=str(self.__prop[5]), choices=menu))
		
		list=[]
		if folder[B_NAME] != "hdd" and folder[B_NAME] != "net" and folder[B_NAME] != "autofs":#//wegen Standby und automount
			list.append(getConfigListEntry(_("Picture (only large view)"), config.bp.icon))
		list.append(getConfigListEntry(_("Sort files by"), config.bp.sortby))
		list.append(getConfigListEntry(_("Hide Files..."), config.bp.hide_files))
		list.append(getConfigListEntry(_("Show System-Files"), config.bp.hidden_file))
		list.append(getConfigListEntry(_("Show TS-help-files"), config.bp.ts_help))
		#list.append(getConfigListEntry(_("Large view"), config.bp.largeView))
		list.append(getConfigListEntry(_("Folder does not scan"), config.bp.nomedia))
		list.append(CONFIGSEPERATOR())
		list.append(getConfigListEntry(_("Include subdirectories ?"), config.bp.subdir))
		gConfigWindow.__init__(self, session, name + " (" + folder[B_NAME] + ")", list=list)
		
	def SelectionChangedNow(self):
		gConfigWindow.SelectionChangedNow(self)
		self.__newIcon()

	def KeyLeft(self):
		gConfigWindow.KeyLeft(self)
		self.__newIcon()

	def KeyRight(self):
		gConfigWindow.KeyRight(self)
		self.__newIcon()

	def __newIcon(self):
		if self.getCurrendValue() == config.bp.icon:
			self.SetIcon(config.bp.icon.value)
		
		if self.getCurrendValue() == config.bp.hide_files:
			self.__Okselected=True
		else:
			self.__Okselected=False
			
	def KeyOk(self):
		if self.__Okselected:
			self.session.openWithCallback(self.__hideCallback, FolderHideFiles, self.__prop[1])

	def __hideCallback(self, val=None):
		if val is not None:
			self.__prop[1] = val
			self.KeyGreen()

	def KeyGreen(self):
		self.KeyExit((self.__folder, config.bp.subdir.value, config.bp.icon.value, self.__prop[1], config.bp.hidden_file.value, config.bp.ts_help.value, (config.bp.largeView.value + 1), int(config.bp.sortby.value), 0, int(config.bp.nomedia.value)))
	
	def KeyExit(self, val=None):
		self.close(val)
		cleanexit(__name__)

class FolderHideFiles(gConfigWindow):
	def __init__(self, session, prop):
		list=[]
		config.bp.val = NoSave(gConfigOnOff(default=bool(prop & FILTER_PICS)))
		list.append(getConfigListEntry(_("Pictures"), config.bp.val, FILTER_PICS))

		config.bp.val = NoSave(gConfigOnOff(default=bool(prop & FILTER_MOVIES)))
		list.append(getConfigListEntry(_("Movies"), config.bp.val, FILTER_MOVIES))
		
		config.bp.val = NoSave(gConfigOnOff(default=bool(prop & FILTER_TS)))
		list.append(getConfigListEntry(_("Movies") + " (*.ts)", config.bp.val, FILTER_TS))
		
		config.bp.val = NoSave(gConfigOnOff(default=bool(prop & FILTER_SOUND)))
		list.append(getConfigListEntry(_("Music"), config.bp.val, FILTER_SOUND))

		config.bp.val = NoSave(gConfigOnOff(default=bool(prop & FILTER_SCRIPTE)))
		list.append(getConfigListEntry(_("Scripts"), config.bp.val, FILTER_SCRIPTE))
		
		config.bp.val = NoSave(gConfigOnOff(default=bool(prop & FILTER_TXT)))
		list.append(getConfigListEntry(_("Text") + "-" + _("File(s)"), config.bp.val, FILTER_TXT))

		gConfigWindow.__init__ (self, session, _("Hide Files..."), list=list)
		
	def KeyGreen(self):
		val = 0
		for x in self.getConfList():
			if x[1].value:
				val |= x[2]
		self.close(val)
		
	def KeyExit(self):
		self.close()
		
#-----------------------------------------------------------------------------------------------------

class EditHidden(WidgetVariableList):
	def __init__(self, session, hidelist):
		list = []
		for x in hidelist:
			list.append((x,getColorPic(1),1))
		
		WidgetVariableList.__init__ (self, session, title=_("Hidden files/directorys"), ListIcon=(35,25), list=list)
		self.skinName = [self.__class__.__name__,"VariableListNoButton_" + self.__class__.__name__,"VariableListNoButton"]
	
	def KeyOk(self):
		sel = self.getCurrentEntry()
		if sel:
			val=1
			if sel[2]:
				val=0
			entry = (sel[0],getColorPic(val),val)
			self.editEntry(self.GetIndex(),entry)

	def KeyExit(self):
		list=[]
		for x in self.GetList():
			if x[2]:
				list.append(x[0])
		self.close(list)

#-----------------------------------------------------------------------------------------------------

class CopyMoveSetup(gConfigWindow):
	def __init__(self, session, name, func, filename, path):
		self.func = func

		if self.func == "copy":
			text = _("Copy source file")
			bla = cgevent.getConfig("Dmanager_last_copy", path)
		else:
			text = _("Move source file")
			bla = cgevent.getConfig("Dmanager_last_move", path)

		config.bp.sfile = NoSave(gConfigSelection(choices=[filename]))
		config.bp.dfile = NoSave(gConfigDirectory(default=bla, visible_width=35, filter=FILTER_DIR))
		config.bp.jump = NoSave(gConfigOnOff(default=cgevent.getConfig("Dmanager_jump_dest", 0)))
		
		list = []
		list.append(getConfigListEntry(text, config.bp.sfile))
		list.append(getConfigListEntry(_("Choose the destination directory"), config.bp.dfile))
		list.append(getConfigListEntry(_("Jump after finish to the destination directory"), config.bp.jump))
		gConfigWindow.__init__(self, session, name, greenbutton=_("Start"),list=list)
		
	def KeyGreen(self):
		cgevent.setConfig("Dmanager_jump_dest", config.bp.jump.value)
		if self.func == "copy":
			cgevent.setConfig("Dmanager_last_copy", config.bp.dfile.value)
		else:
			cgevent.setConfig("Dmanager_last_move", config.bp.dfile.value)

		self.close(config.bp.dfile.value, config.bp.dfile.value, config.bp.jump.value)
	
	def KeyExit(self):
		self.close()
		cleanexit(__name__)

#-----------------------------------------------------------------------------------------------------

class PackSetup(gConfigWindow):
	def __init__(self, session, name, path):
		self.path=path
		
		from WidgetTools import PACK_GZ, PACK_BZ2, PACK_ZIP, PACK_LZMA
		
		menu = [(PACK_GZ,"tar.gz")]
		menu.append((PACK_BZ2, "tar.bz2"))
		if pathExists("/usr/bin/zip"):
			menu.append((PACK_ZIP, "zip"))
		menu.append((PACK_LZMA, "tar.lzma"))
		config.bp.typ = NoSave(gConfigSelection(default=cgevent.getConfig("Dmanager_last_pack_type",PACK_GZ), choices=menu))

		if self.path:
			config.bp.dfile = NoSave(gConfigDirectory(default=cgevent.getConfig("Dmanager_last_pack", path), visible_width=35, filter=FILTER_DIR))
		
		list = []
		list.append(getConfigListEntry(_("Type") + ":", config.bp.typ))
		if self.path:
			list.append(getConfigListEntry(_("Choose the destination directory"), config.bp.dfile))
		gConfigWindow.__init__(self, session, name, greenbutton=_("Start"),list=list)
		
	def KeyGreen(self):
		cgevent.setConfig("Dmanager_last_pack_type", config.bp.typ.value)
		if self.path:
			cgevent.setConfig("Dmanager_last_pack", config.bp.dfile.value)
			self.close(config.bp.dfile.value, config.bp.typ.value)
		else:
			self.close(config.bp.typ.value)

	def KeyExit(self):
		self.close()
		cleanexit(__name__)

#-----------------------------------------------------------------------------------------------------

class SymlinkCreate(gConfigWindow):
	def __init__(self, session, name, file, path):

		list = []
		config.bp.val0 = NoSave(gConfigSelection(choices=[file]))
		config.bp.val1 = NoSave(gConfigDirectory(default=path, visible_width=35, filter=FILTER_DIR))
		config.bp.val2 = NoSave(ConfigText(default=file, fixed_size=False))

		list.append(getConfigListEntry(_("Source for %s") %"Symlink", config.bp.val0))
		list.append(CONFIGSEPERATOR())
		list.append(getConfigListEntry(_("destination directory"), config.bp.val1))
		list.append(getConfigListEntry(_("Name for %s") %"Symlink", config.bp.val2))

		gConfigWindow.__init__(self, session, title=name, greenbutton=_("Create"),list=list)

	def KeyGreen(self):
		if config.bp.val2.value and len(config.bp.val2.value):
			dirname = config.bp.val1.value + "/" + config.bp.val2.value
			if pathExists(dirname):
				self.session.open(MessageBox, _("Folder '%s' already exists!") %dirname, MessageBox.TYPE_ERROR, timeout=5)
			else:
				self.close(dirname)
	
	def KeyExit(self):
		self.close()
		cleanexit(__name__)

#-----------------------------------------------------------------------------------------------------

class PermSetup(gConfigWindow):
	def __init__(self, session, name, val):
		self.Mode = val[B_MODE]
		config.bp.val0 = NoSave(gConfigSelection(default=val[B_MODE] & S_IRUSR, choices=[(0, _("off")), (S_IRUSR, _("on"))]))
		config.bp.val1 = NoSave(gConfigSelection(default=val[B_MODE] & S_IWUSR, choices=[(0, _("off")), (S_IWUSR, _("on"))]))
		config.bp.val2 = NoSave(gConfigSelection(default=val[B_MODE] & S_IXUSR, choices=[(0, _("off")), (S_IXUSR, _("on"))]))
		config.bp.val3 = NoSave(gConfigSelection(default=val[B_MODE] & S_IRGRP, choices=[(0, _("off")), (S_IRGRP, _("on"))]))
		config.bp.val4 = NoSave(gConfigSelection(default=val[B_MODE] & S_IWGRP, choices=[(0, _("off")), (S_IWGRP, _("on"))]))
		config.bp.val5 = NoSave(gConfigSelection(default=val[B_MODE] & S_IXGRP, choices=[(0, _("off")), (S_IXGRP, _("on"))]))
		config.bp.val6 = NoSave(gConfigSelection(default=val[B_MODE] & S_IROTH, choices=[(0, _("off")), (S_IROTH, _("on"))]))
		config.bp.val7 = NoSave(gConfigSelection(default=val[B_MODE] & S_IWOTH, choices=[(0, _("off")), (S_IWOTH, _("on"))]))
		config.bp.val8 = NoSave(gConfigSelection(default=val[B_MODE] & S_IXOTH, choices=[(0, _("off")), (S_IXOTH, _("on"))]))
		
		list = []
		list.append(getConfigListEntry(_("User") + ' - ' + _("Read"), config.bp.val0))
		list.append(getConfigListEntry(_("User") + ' - ' + _("Write"), config.bp.val1))
		list.append(getConfigListEntry(_("User") + ' - ' + _("Execute"), config.bp.val2))
		list.append(CONFIGSEPERATOR())
		list.append(getConfigListEntry(_("Group") + " - " + _("Read"), config.bp.val3))
		list.append(getConfigListEntry(_("Group") + " - " + _("Write"), config.bp.val4))
		list.append(getConfigListEntry(_("Group") + " - " + _("Execute"), config.bp.val5))
		list.append(CONFIGSEPERATOR())
		list.append(getConfigListEntry(_("Other") + " - " + _("Read"), config.bp.val6))
		list.append(getConfigListEntry(_("Other") + " - " + _("Write"), config.bp.val7))
		list.append(getConfigListEntry(_("Other") + " - " + _("Execute"), config.bp.val8))
		
		gConfigWindow.__init__(self, session, name + " " + _("from") + " '" + val[B_NAME] + "'", list=list)
		
		from WidgetTools import getPermissionInt
		self.getPermissionInt = getPermissionInt
		self.onLayoutFinish.append(self.__setPerm)
		
	def KeyRight(self):
		gConfigWindow.KeyRight(self)
		self.__setPerm()

	def KeyLeft(self):
		gConfigWindow.KeyLeft(self)
		self.__setPerm()
		
	def __getPermStr(self):
		bla = ""
		for x in self.getConfList():
			if x[1] != myConfigNothing:
				if x[1].value == 0:
					bla += "0"
				else:
					bla += "1"
		return bla
		
	def __setPerm(self):
		self.SetLabel("%s %d" %(_("permissions"),self.getPermissionInt(self.__getPermStr())))
		
	def KeyGreen(self):
		self.close(self.__getPermStr())
		cleanexit(__name__)
	
	def KeyExit(self):
		self.close()
		cleanexit(__name__)

#-----------------------------------------------------------------------------------------------------

class RenameClass(gConfigWindow):
	def __init__(self, session, title, path):
		if path[B_EXT]!="":
			smallname=path[B_NAME][:len(path[B_NAME])-len(path[B_EXT])-1]
		else:
			smallname=path[B_NAME]
		self.__extension=path[B_NAME][len(smallname):]
		
		list = []
		config.bp.name = NoSave(ConfigText(default=smallname, fixed_size=False))
		list.append(getConfigListEntry(_("Name"), config.bp.name))

		gConfigWindow.__init__(self, session, title=title, text=_("new name is: '%s'") %path[B_NAME],list=list)
		self.onConfigEntryChanged.append(self.__update)
		
	def __update(self,val=""):
		val = self.getCurrendValue()
		if val==config.bp.name:
			self.SetLabel(_("new name is: '%s'") %(config.bp.name.value+self.__extension))

	def KeyGreen(self):
		self.close(config.bp.name.value+self.__extension)
	
	def KeyExit(self):
		self.close()
		cleanexit(__name__)
	
#-----------------------------------------------------------------------------------------------------

class ExtractSetup(gConfigWindow ):
	def __init__(self, session, path, directory):
		self.__isRar=False

		config.bp.path = NoSave(gConfigDirectory(default=directory, visible_width=35, filter=FILTER_DIR))
		list = []
		list.append(getConfigListEntry(_("extract to"), config.bp.path))
		if path[B_EXT] == "RAR":
			self.__isRar=True
			config.bp.passwd = NoSave(ConfigText(default = "", fixed_size=False))
			list.append(getConfigListEntry(_("Password"), config.bp.passwd))
		gConfigWindow.__init__  (self, session, title=_("Extract") + " '" + path[B_NAME] + "'", greenbutton=_("Start"),list=list)

	def KeyGreen(self):
		if self.__isRar:
			if pathExists("/usr/bin/unrar"):
				self.close((config.bp.path.value, config.bp.passwd.value))
			else:
				self.session.openWithCallback(self.__callbackMB, MessageBox, _("Package '%s' not installed!") %("geminiarchiver") + "\n" + _("Do you want to install the packages:\n\n"))
		else:
			self.close((config.bp.path.value, ""))
	
	def __callbackMB(self, val=False):
		if val==True:
			from WidgetIpkg import WidgetIpkg, IPKG_UPDATE, IPKG_INSTALL
			self.session.openWithCallback(self.__ipkgCallback, WidgetIpkg, cmdList=[(IPKG_UPDATE,""), (IPKG_INSTALL,"geminiarchiver")])
		else:
			self.close()
			
	def __ipkgCallback(self, val):
		if val[0]>0:
			self.SetLabel(_("Package '%s' not installed!")%pack)

	def KeyExit(self):
		self.close()
		cleanexit(__name__)
