# -*- coding: utf-8 -*-
from gLocale import _
from GeminiDef import *

from gTools import libgeminimain, cleanexit, gLoadPixmap, VDesktopfound
from WidgetVariableList import WidgetVariableList
from plugin import cgevent

from WidgetXmlList import XML_SEL, XML_NAME

from WidgetConfig import  gConfigWindow, gConfigSelection, gConfigDirectory, gConfigOnOff, ConfigInteger, CONFIGSEPERATOR
from Components.config import config, NoSave, getConfigListEntry, ConfigText

from skin import colorNames
from enigma import eTimer

#----------------------------------------------------------------------

class ConfigDeskEntry(gConfigWindow ):
	def __init__(self, session, name = "entry1", icon = "bla.png", shortcut = "", slist = []):
		list = []
		menu = slist

		if shortcut != "":
			self.shortcut = shortcut
			menu = [(self.shortcut,_(self.shortcut))] + menu
		else:
			self.shortcut = _("no")
			
		menu =  [("",_("no"))] + menu
		
		config.bp.name = NoSave(ConfigText(default = name, fixed_size = False))
		config.bp.icon = NoSave(gConfigDirectory(default = icon, visible_width=60, filter = FILTER_PNG))
		config.bp.shortcut = NoSave(gConfigSelection(default = self.shortcut, choices = menu))
		
		list.append(getConfigListEntry(_("Name") + ":", config.bp.name))
		list.append(getConfigListEntry(_("Icon") + ":", config.bp.icon))
		list.append(getConfigListEntry(_("Shortcut") + ":", config.bp.shortcut))
		
		self.__oldIcon = config.bp.icon.value

		self.__previewTimer = eTimer()
		self.__previewTimer_conn = self.__previewTimer.timeout.connect(self.__preview)
		self.__previewTimer.start(250)
		
		gConfigWindow.__init__ (self, session, _("Setup"), list = list)
		
	def __preview(self):
		if self.__oldIcon != config.bp.icon.value:
			self.__oldIcon = config.bp.icon.value
			self.SetIcon()
	
	def SetIcon(self):
		gConfigWindow.SetIcon(self, config.bp.icon.value)
		
	def KeyGreen(self):
		self.KeyExit((config.bp.name.value, config.bp.icon.value, config.bp.shortcut.value))

	def KeyExit(self, val=None):
		del self.__previewTimer
		self.close(val)
		cleanexit(__name__)
		
#----------------------------------------------------------------------

class BPSetup(gConfigWindow):
	def __init__(self, session, setColor):
		self.__setColor = setColor
		self.__selected=0
		if self.__setColor:
			menu=[]
			for key in colorNames.iterkeys():
				menu.append((key,_(key)))
			config.bp.color0 = NoSave(gConfigSelection(default=cgevent.getConfig("deskbackground_color", "background"), choices=menu))
			config.bp.color1 = NoSave(gConfigSelection(default=cgevent.getConfig("deskbackgroundtxt_color", "bptile"), choices=menu))
			config.bp.color2 = NoSave(gConfigSelection(default=cgevent.getConfig("deskforeground_color", "foreground"), choices=menu))
			config.bp.color3 = NoSave(gConfigSelection(default=cgevent.getConfig("deskbackgroundselected_color","bptileselect"), choices=menu))
			config.bp.color4 = NoSave(gConfigSelection(default=cgevent.getConfig("deskforegroundselected_color","foreground"), choices=menu))
			config.bp.color5 = NoSave(gConfigSelection(default=cgevent.getConfig("infobarbackground_color", "background"), choices=menu))
			config.bp.color6 = NoSave(gConfigSelection(default=cgevent.getConfig("infobarforeground_color", "foreground"), choices=menu))
			
		config.bp.page = NoSave(gConfigOnOff(default=cgevent.getConfig("desktop_pagenumber", 0)))
		config.bp.iconbar = NoSave(gConfigOnOff(default=cgevent.getConfig("desktop_iconbar", 0)))
		config.bp.iconzoom = NoSave(gConfigOnOff(default=cgevent.getConfig("desktop_iconzoom", 1)))
		config.bp.tiles = NoSave(gConfigOnOff(default=cgevent.getConfig("desktop_tiles", 1)))

		gConfigWindow.__init__ (self, session, _("Setup"), list=[])
		self.__setList()

	def __setList(self):
		list = []
		if self.__setColor & 1:
			list.append(getConfigListEntry(_("Set color %s %s") %(_("desktop"),_("background")), config.bp.color0))
			list.append(getConfigListEntry(_("Set color %s %s %s") %(_("desktop"),_("background"),"("+ _("Text")+")"), config.bp.color1))
			list.append(getConfigListEntry(_("Set color %s %s %s") %(_("desktop"),_("foreground"),"("+ _("Text")+")"), config.bp.color2))
			list.append(getConfigListEntry(_("Set color %s %s %s %s") %(_("desktop"),_("background"),_("selection"),"("+ _("Text")+")"), config.bp.color3))
			list.append(getConfigListEntry(_("Set color %s %s %s %s") %(_("desktop"),_("foreground"),_("selection"),"("+ _("Text")+")"), config.bp.color4))
		if self.__setColor & 2:
			list.append(getConfigListEntry(_("Set color %s %s") %(_("infobar"),_("background")), config.bp.color5))
			list.append(getConfigListEntry(_("Set color %s %s") %(_("infobar"),_("foreground")), config.bp.color6))
		if self.__setColor>0:
			list.append(CONFIGSEPERATOR())
		list.append(getConfigListEntry(_("Show Page-Numbers"), config.bp.page))
		list.append(getConfigListEntry(_("Show Desktops as Iconbar"), config.bp.iconbar))
		list.append(getConfigListEntry(_("Zoom Selection"), config.bp.iconzoom))
		if config.bp.iconzoom.value ==1:
			list.append(getConfigListEntry(_("Show background tiles"), config.bp.tiles))

		if VDesktopfound:
			config.bp.vdesk = NoSave(ConfigInteger(default=cgevent.getConfig("desktop_virtual",6), limits = (2,6)))
			list.append(CONFIGSEPERATOR())
			list.append(getConfigListEntry(_("Virtual Desktops"), config.bp.vdesk))
			
		self.SetConfList(list)
			
	def KeyLeft(self):
		if self.getCurrendValue() == config.bp.iconzoom:
			gConfigWindow.KeyLeft(self)
			self.__setList()
		else:
			gConfigWindow.KeyLeft(self)
		
	def KeyRight(self):
		if self.getCurrendValue() == config.bp.iconzoom:
			gConfigWindow.KeyRight(self)
			self.__setList()
		else:
			gConfigWindow.KeyRight(self)
		
	def KeyGreen(self):
		if self.__setColor:
			cgevent.setConfig("deskbackground_color", config.bp.color0.value)
			cgevent.setConfig("deskbackgroundtxt_color", config.bp.color1.value)
			cgevent.setConfig("deskforeground_color", config.bp.color2.value)
			cgevent.setConfig("deskbackgroundselected_color", config.bp.color3.value)
			cgevent.setConfig("deskforegroundselected_color", config.bp.color4.value)
			cgevent.setConfig("infobarbackground_color", config.bp.color5.value)
			cgevent.setConfig("infobarforeground_color", config.bp.color6.value)
		cgevent.setConfig("desktop_pagenumber", config.bp.page.value)
		cgevent.setConfig("desktop_iconbar", config.bp.iconbar.value)
		cgevent.setConfig("desktop_iconzoom", config.bp.iconzoom.value)
		cgevent.setConfig("desktop_tiles", config.bp.tiles.value)
		if VDesktopfound:
			cgevent.setConfig("desktop_virtual", config.bp.vdesk.value)
		self.KeyExit(True)

	def KeyExit(self,val=False):
		self.close(val)
		cleanexit(__name__)

#----------------------------------------------------------------------

class HotKeySelect(WidgetVariableList):
	def __init__(self, session, list=[]):
		WidgetVariableList.__init__ (self, session, title=_("Select a Hotkey:"), ListIcon=(65,30))
		self.skinName = ["VariableListNoButton_" + self.__class__.__name__,"VariableListNoButton"]
		keys = []
		for x in list:
			keys.append(( _("Key") + ": " + _(x), gLoadPixmap("buttons/key_" + x + ".png"), x))
		self.SetList(keys)
		
	def KeyOk(self):
		val = self.getCurrentEntry()
		if val is not None:
			self.KeyExit(val[2])

	def KeyExit(self, res=""):
		self.close(res)
		cleanexit(__name__)
		
#----------------------------------------------------------------------

class HotKeySort(WidgetVariableList):
	def __init__(self, session, qbList):
		self.__changed = False
		self.__qbList = qbList
		list = []
		for x in self.__qbList:
			if x[2][XML_SEL]:
				#print x[2]
				list.append((_(x[2][XML_NAME]), None, x[2]))
		list.sort(key = lambda p:p[2][XML_SEL])
		
		WidgetVariableList.__init__ (self, session, title=_("Change Order"), list=list)
		self.skinName = ["VariableListNoButton_" + self.__class__.__name__,"VariableListNoButton"]
		self.SwitchMode()
	
	def KeyOk(self):
		self.__changed=True
		if self.getSwitchMode():
			self.SwitchMoveMode()

	def KeyExit(self):
		count=0;
		for x in self.GetList():
			for y in range(len(self.__qbList)):
				if x[2] == self.__qbList[y][2]:
					count += 1
					val = list(self.__qbList[y][2])
					val[XML_SEL]=count
					self.__qbList[y] = (self.__qbList[y][0], self.__qbList[y][1], val)
					break

		self.close(self.__qbList, self.__changed)
		cleanexit(__name__)

