# -*- coding: utf-8 -*-
from gLocale import _
from GeminiDef import *

from enigma import eServiceReference, eServiceCenter, iServiceInformation
from gTools import libgeminimain, cleanexit, gLoadPixmap, getEntryString, getColorPic
from plugin import cgevent

from WidgetVariableList import WidgetVariableList
from WidgetConfig import gConfigSelection, gConfigWindow, gConfigOnOff, CONFIGSEPERATOR
from Components.config import config, NoSave, getConfigListEntry, ConfigInteger

class confCamd(gConfigWindow):
	R_CAMD=1
	R_EXPERT=2
	R_PRIO=3
	def __init__(self, session, name=None):
		self.selected=0
		camdlist = libgeminimain.getPyList(GETCAMDLIST)
		geminiconf = libgeminimain.getGeminiConf()
		
		menu = []
		currcamd=None
		for x in camdlist:
			tstr=""
			if x[1] == 1:
				currcamd=x
				tstr = " (" + _("activ") + ")"
			menu.append((x, x[2] + tstr))
			
		config.bp.camd = NoSave(gConfigSelection(choices=menu,default=currcamd))
		menu = []
		menu.append(("0", _("off")))
		menu.append((str(CRYPT_ICON_SHOW), _("Icons")))
		menu.append((str(CRYPT_LABEL_SHOW), _("Sensorfield")))
		config.bp.crypt_icons = NoSave(gConfigSelection(default=str(geminiconf & (CRYPT_ICON_SHOW | CRYPT_LABEL_SHOW)), choices=menu))
		menu = []
		menu.append(("0", _("off")))
		menu.append((str(EXPERT_LABEL_SHOW), _("Sensorfield")))
		menu.append((str(EXPERT_WINDOW_SHOW), _("Window")))
		config.bp.expert = NoSave(gConfigSelection(default=str(geminiconf & (EXPERT_LABEL_SHOW | EXPERT_WINDOW_SHOW)), choices=menu))
		config.bp.prio = NoSave(gConfigOnOff(default=bool(geminiconf & PRIO_LIST_ON)))
		
		list = []
		list.append(getConfigListEntry(_("select"), config.bp.camd))
		list.append(CONFIGSEPERATOR())
		list.append(getConfigListEntry(_("Show") + " " + _("Crypt-Infos"), config.bp.crypt_icons))
		list.append(getConfigListEntry(_("Show") + " " + _("ECM-Infos"), config.bp.expert))
		list.append(getConfigListEntry(_("Create Priolist"), config.bp.prio))
		gConfigWindow.__init__ (self, session, name or _("Setup-Camd"), list=list, icon="icon_camd.png")
		
	def SelectionChangedNow(self):
		gConfigWindow.SelectionChangedNow(self)
		self.__checkEntry()
		
	def KeyLeft(self):
		gConfigWindow.KeyLeft(self)
		self.__checkEntry()

	def KeyRight(self):
		gConfigWindow.KeyRight(self)
		self.__checkEntry()
		
	def __checkEntry(self):
		self.selected=0
		sel = self.getCurrendValue()
		if sel == config.bp.expert and int(config.bp.expert.value) == EXPERT_LABEL_SHOW:
			self.setRB(_("Edit"))
			self.selected=self.R_EXPERT
			return
		elif sel == config.bp.camd and config.bp.camd.value[1] == 1:#wenn camd aktiv ist
			self.setRB(_("Restart"))
			self.selected=self.R_CAMD
			return
		elif sel == config.bp.prio:
			self.setRB(_("Show List"))
			self.selected=self.R_PRIO
			return
		self.setRB()
		
	def KeyRed(self):
		if self.selected == self.R_EXPERT:
			self.session.open(ExpertInfobarSetup)
		elif self.selected == self.R_CAMD:
			libgeminimain.sendDbus("gdaemon",0,config.bp.camd.value[3] + " stop")
			libgeminimain.sendDbus("gdaemon",0,config.bp.camd.value[3] + " start")
			self.KeyExit()
		elif self.selected == self.R_PRIO:
			self.session.open(PrioListSetup)

	def KeyGreen(self):
		list = [config.bp.camd.value[0], int(config.bp.crypt_icons.value), int(config.bp.expert.value), int(config.bp.prio.value)]
		#print list
		libgeminimain.gFunktion(SETCAMDCONFIG,list)
		self.KeyExit()
	
	def KeyExit(self):
		self.close()
		cleanexit(__name__)
		
#-------------------------------Setup Expert Infobar-----------------------------------------

class ExpertInfobarSetup(gConfigWindow):
	def __init__(self, session):

		list = []
		for x in libgeminimain.getPyList(GETEXPERTLIST):
			config.bp.bla = NoSave(gConfigOnOff(default=bool(x[2])))
			list.append(getConfigListEntry(x[1], config.bp.bla, x[0]))
		gConfigWindow.__init__ (self, session, _("Setup") + " " + _("ECM-Infos") + " (" + _("Sensorfield") + ")", list=list)

	def KeyGreen(self):
		tmp=0
		for x in self.getConfList():
			if x[1].value==True:
				tmp += x[2]
		libgeminimain.gFunktion(SETEXPERTLINE, tmp)
		self.close()

	def KeyExit(self):
		self.close()

#-------------------------------Prio List-----------------------------------------

class PrioListSetup(WidgetVariableList):
	def __init__(self, session):
		self.index=0
		WidgetVariableList.__init__ (self, session, title=_("Priolist"), NameGreen = _("List write"), NameBlue = _("Setup"), ListIcon=(35,25))
		self.skinName = [self.__class__.__name__,"VariableList3Button_" + self.__class__.__name__,"VariableList3Button"]
		self.onLayoutFinish.append(self.__fillListe)
	
	def __fillListe(self):
		list = []
		for x in libgeminimain.getPyList(GETPRIOLIST):
			service = eServiceReference(x[0])
			info = eServiceCenter.getInstance().info(service)
			if info:
				strt = "SID %04X    ID %06X    CAID %04X\t%s" %(x[1],x[3],x[2], info.getName(service))
				list.append((strt, getColorPic(x[4]), x))
		self.SetList(list)
		self.SetIndex(self.index)

	def selectionChanged(self):
		sel = self.getCurrentEntry()
		if sel:
			self.SetLabel(_("Encryption") + ": " + sel[2][5])

	def KeyOk(self):
		sel = self.getCurrentEntry()
		if sel:
			libgeminimain.gFunktion(SETPRIOLIST, sel[2][0])
			self.index = self.GetIndex()
			self.__fillListe()

	def KeyBlue(self):
		self.session.open(PrioListSetting)
		
	def KeyGreen(self):
		libgeminimain.gFunktion(SETPRIOLIST,"SAVEPRIO")
		self.KeyExit()

	def KeyExit(self):
		self.close()


class PrioListSetting(gConfigWindow):
	def __init__(self, session):
		#menu = [(1,"CCcam")]
		#config.bp.priotyp = NoSave(gConfigSelection(default=cgevent.getConfig("PrioList_typ", 1), choices=menu))
		config.bp.prioauto = NoSave(gConfigOnOff(default=cgevent.getConfig("PrioList_autosave", 0)))
		
		list = []
		#list.append(getConfigListEntry(_("Save PrioList as"), config.bp.priotyp))
		list.append(getConfigListEntry(_("Save PrioList when you exit enigma2"), config.bp.prioauto))
		gConfigWindow.__init__ (self, session, _("Setup") + " " + _("Priolist"), list=list)

	def KeyGreen(self):
		#cgevent.setConfig("PrioList_typ", config.bp.priotyp.value)
		cgevent.setConfig("PrioList_autosave", config.bp.prioauto.value)
		self.close()

	def KeyExit(self):
		self.close()
