# -*- coding: utf-8 -*-
from enigma import ePixmap
from Screens.Screen import Screen

from Components.GUIComponent import GUIComponent
from skin import parseColor, applyAllAttributes

class WidgetScreen(Screen):
	def __init__(self, session, parent = None):
		Screen.__init__(self, session, parent)
		
	def createGUIScreen(self, parent, desktop, updateonly = False):
		for val in self.renderer:
			if isinstance(val, GUIComponent):
				if not updateonly:
					val.GUIcreate(parent)
				if not val.applySkin(desktop, self):
					print "warning, skin is missing renderer", val, "in", self

		for key in self:
			val = self[key]
			if isinstance(val, GUIComponent):
				if not updateonly:
					val.GUIcreate(parent)
				depr = val.deprecationInfo
				if val.applySkin(desktop, self):
					if depr:
						print "WARNING: OBSOLETE COMPONENT '%s' USED IN SKIN. USE '%s' INSTEAD!" % (key, depr[0])
						print "OBSOLETE COMPONENT WILL BE REMOVED %s, PLEASE UPDATE!" % (depr[1])
				elif not depr:
					print "warning, skin is missing element", key, "in", self

		for w in self.additionalWidgets:
			if not updateonly:
				w.instance = w.widget(parent)
				if w.widget == ePixmap:
					w.instance.setScale(0)
				# w.instance.thisown = 0
			applyAllAttributes(w.instance, desktop, w.skinAttributes, self.scale)
			
		# fix skin applet position
		for f in self.onLayoutFinish:
			if str(f).count("skin applet"):
				print "found skin applet in self.onLayoutFinish >>> ",str(f).count("skin applet")
				if type(f) is not type(self.close): # is this the best way to do this?
					exec(f) in globals(), locals()
				else:
					f()
				self.onLayoutFinish.remove(f)

		for f in self.onLayoutFinish:
			#print "self.onLayoutFinish >>> ",str(f)
			if type(f) is not type(self.close): # is this the best way to do this?
				exec(f) in globals(), locals()
			else:
				f()
