# -*- coding: utf-8 -*-
from enigma import eTimer, fontRenderClass, ePoint, eSize
from gTools import gLoadPixmap
from Screens.Screen import Screen

from Components.Sources.StaticText import StaticText
from Components.ActionMap import ActionMap
from Components.Pixmap import Pixmap
from Components.Label import Label

class gMessageBox(Screen):
	def __init__(self, session, text="", title=None, timeout=0, enableKeys=True, icon=None, newSkinName=""):
		Screen.__init__(self, session)
		self.skinName =[newSkinName,"gMultiMessageBox"]

		self["title"] = StaticText()
		self["text"] = Label()
		self["icon"] = Pixmap()

		self.__icon = icon
		self.__minheight = 45
		self.__iconsize = 0
		self.__Desktopsize = session.desktop.size()
		self.__lineheight = 14
		self.__labelposition = ePoint(10, 10)
		self.__windowposition = [0, 0]

		self.__timeout = timeout
		self.__timer = eTimer()
		self.__timer_conn = self.__timer.timeout.connect(self.__timerTick)
		self.__curr_text = text
		self.__TitleStr = title or _("Message")
		
		if enableKeys == True:
			self["actions"] = ActionMap(["gActions"],
			{
				"ok": self.Exit,
				"exit": self.Exit
			}, -1)
			
		self.onLayoutFinish.append(self.__LayoutFinish)
		
	def __LayoutFinish(self):
		self.__lineheight = int(fontRenderClass.getInstance().getLineHeight(self["text"].instance.getFont()))
		self.__labelposition = self["text"].instance.position()
		if self.skinAttributes:
			for (attrib, value) in self.skinAttributes:
				if attrib == "position":
					x, y = value.split(',')
					if x != "center":
						self.__windowposition[0] = int(x)
					if y != "center":
						self.__windowposition[1]  = int(y)
		
		if self.__icon and self["icon"].skinAttributes:
			iconposition = self["icon"].instance.position()
			iconsize = self["icon"].instance.size()
			self.setIconPixmap(self.__icon)
			self.__iconsize = iconposition.x() + iconsize.width() + iconposition.x()
			self.__minheight = iconposition.y() + iconsize.height() + iconposition.y()
			self["text"].instance.move(ePoint(self.__iconsize + (self.__labelposition.x()/2), self.__labelposition.y()))
			self.__iconsize = (self.__iconsize - (self.__labelposition.x()/2))
		
		self.setTitle(self.__TitleStr)
		self.setText(self.__curr_text, True)
		self.StartTimer(self.__timeout)
		
	def setText(self, text="", force=False, noWrap=0):
		if self.__curr_text != text or force:
			self.__curr_text = text

			self["text"].instance.setNoWrap(noWrap)
			self["text"].instance.resize(eSize(1030,400))
			self["text"].setText(text)
			textsize = self["text"].getSize()
			wsizex = (textsize[0] + (self.__lineheight/3))
			wsizey = (textsize[1] + (self.__lineheight/3))
			
			minwidth = self.__Desktopsize.width() - 100 - (self.__labelposition.x() *2)
			if minwidth < wsizex:
				wsizex = minwidth
	
			wsize = (wsizex, wsizey)
			self["text"].instance.resize(eSize(*wsize))
			wsize = (max((wsizex + (self.__labelposition.x()*2)) + self.__iconsize, 220), max(wsizey + (self.__labelposition.y()*2), self.__minheight))
			if self.__windowposition[0] == 0 or self.__windowposition[1] == 0:
				position_x =  self.__windowposition[0] or ((self.__Desktopsize.width() - (wsizex + (self.__labelposition.x() *2)))/2) - (self.__iconsize/2)
				position_y =  self.__windowposition[1] or ((self.__Desktopsize.height() - (wsizey + (self.__labelposition.y() *2)))/2)
				self.instance.move(ePoint(position_x, position_y))
			self.instance.resize(eSize(*wsize))
				
	def getText(self):
		return self.__curr_text

	def StartTimer(self, timeout):
		if timeout > 0:
			self.__timeout = timeout
			self.__timerTick()
			
	def __timerTick(self):
		if self.__timeout > 0:
			self.setTitle(self.__TitleStr + " (" + str(self.__timeout) + ")")
			self.__timer.start(1000, True)
			self.__timeout -= 1
		else:
			self.Exit()
		
	def setIconPixmap(self, icon):
		if icon and self["icon"].skinAttributes:
			self["icon"].instance.setPixmap(gLoadPixmap(icon, self.session.desktop))
		
	def Exit(self):
		self.__timer.stop()
		self.close()

