# -*- coding: utf-8 -*-
from gLocale import _
from WidgetVariableList import WidgetVariableList
from gTools import cleanexit, ctoolsclass, gLoadPixmap, getEntryString, pathExists, getColorPic, modulExists, getFilesystems

from Screens.MessageBox import MessageBox
from Tools.BoundFunction import boundFunction

#----------------------------------------------------------------------

class KernelModules(WidgetVariableList):
	def __init__(self, session):
		WidgetVariableList.__init__ (self, session, title = _("Kernel Module (Driver)") , ListIcon=(24,24), icon="icon_kernelmodules.png")
		self.skinName = [self.__class__.__name__,"VList3Button2Entry_" + self.__class__.__name__,"VList3Button2Entry"]
		self.onLayoutFinish.append(self.__fillList)
		
	def selectionChanged(self):
		self.SetGB()
		self.SetRB()
		val = self.getCurrentEntry()
		if val:
			if val[4]==0:
				self.SetGB(_("Install"))
			elif val[4]==2 or val[4]==3:
				self.SetRB(_("Remove"))

	def __fillList(self,val=None):
		self.__fsList = getFilesystems()
		index=self.GetIndex()
		list = []
		list.append(("", None, _("Filesystem"), None,None))
		list.append(self.checkModules("fs/ext2","ext2.ko", "kernel-module-ext2", "Unix"))
		list.append(self.checkModules("fs/ext3","ext3.ko", "kernel-module-ext3", "Unix"))
		list.append(self.checkModules("fs/ext4","ext4.ko", "kernel-module-ext4", "Unix"))
		list.append(self.checkModules("fs/reiserfs","reiserfs.ko", "kernel-module-reiserfs", "Unix"))
		list.append(self.checkModules("fs/xfs","xfs.ko", "kernel-module-xfs", "Unix"))
		list.append(self.checkModules("fs/ntfs","ntfs.ko", "kernel-module-ntfs", "Windows-NT readonly"))
		list.append(self.checkModules("bin","ntfs-3g", "ntfs-3g", "Windows-NT read/write"))
		list.append(self.checkModules("fs/vfat","vfat.ko", "kernel-module-vfat", "Windows/DOS"))
		list.append(self.checkModules("bin","exfat", "exfat", "Windows Vista/7"))
		list.append(self.checkModules("fs/hfs","hfs.ko", "kernel-module-hfs", "MacOS"))
		list.append(self.checkModules("fs/hfsplus","hfsplus.ko", "kernel-module-hfsplus", "MacOS", ctoolsclass.getSeperatorPic()))

		list.append(("", None, _("Filesystem") + " (CD/DVD)", None,None))
		list.append(self.checkModules("fs/isofs","isofs.ko", "kernel-module-isofs", "e.g. Video-DVD"))
		list.append(self.checkModules("fs/udf","udf.ko", "kernel-module-udf", "e.g. Video-DVD"))
		list.append(self.checkModules("fs/cdfs","cdfs.ko", "kernel-module-cdfs", "Audio-CD", ctoolsclass.getSeperatorPic()))

		list.append(("", None, _("Filesystem") + " (NET)", None,None))
		list.append(self.checkModules("fs/cifs","cifs.ko", "kernel-module-cifs", "Samba, Windows-Server"))
		#list.append(self.checkModules("fs/smbfs","smbfs.ko", "kernel-module-smbfs", "Samba, Windows-Server"))
		list.append(self.checkModules("fs/exportfs","exportfs.ko", "kernel-module-exportfs", "e.g. NFS-Kernel-Server"))
		list.append(self.checkModules("fs/nfsd","nfsd.ko", "kernel-module-nfsd", "NFS-Kernel-Server"))
		list.append(self.checkModules("fs/nfs","nfs.ko", "kernel-module-nfs", "NFS-Client", ctoolsclass.getSeperatorPic()))

		list.append(("", None, "USB-" + _("Devices"), None,None))
		list.append(self.checkModules("drivers/usb/class","usblp.ko", "kernel-module-usblp", "Printer"))
		kernel = ctoolsclass.getKernelVersion()
		if kernel and kernel[0]=='3':
			list.append(self.checkModules("drivers/hid/usbhid","usbhid.ko", "kernel-module-usbhid", "e.g. Keyboard, Mouse"))
			list.append(self.checkModules("drivers/bluetooth","btusb.ko", "kernel-module-btusb", "Bluetooth"))
			list.append(self.checkModules("sound/usb","snd-usb-audio.ko", "kernel-module-snd-usb-audio", "Audio", ctoolsclass.getSeperatorPic()))
		else:
			list.append(self.checkModules("drivers/usb/input","usbhid.ko", "kernel-module-usbhid", "e.g. Keyboard, Mouse"))
			list.append(self.checkModules("drivers/bluetooth","hci_usb.ko", "kernel-module-hci-usb", "Bluetooth", ctoolsclass.getSeperatorPic()))

		list.append(("", None, "USB-Serial-" + _("Devices"), None,None))
		list.append(self.checkModules("drivers/usb/serial","ftdi_sio.ko", "kernel-module-ftdi-sio", "e.g. Cardreader"))
		list.append(self.checkModules("drivers/usb/serial","pl2303.ko", "kernel-module-pl2303", "e.g. Cardreader", ctoolsclass.getSeperatorPic()))

		list.append(("", None, "WLAN-" + _("Devices"), None,None))
		list.append(self.checkModules("drivers/net/wireless/rt2x00","rt73usb.ko", "rt73usb", "Ralink driver"))
		list.append(self.checkModules("drivers/net/wireless/zd1211rw","zd1211rw.ko", "zd1211rw", "USB Dongles", ctoolsclass.getSeperatorPic()))
		list.append(("", None, _("Other"), None,None))
		list.append(self.checkModules("fs/fuse","fuse.ko", "kernel-module-fuse", "Filesystem in userspace"))
		list.append(self.checkModules("fs/autofs","autofs.ko", "kernel-module-autofs", "Automounter"))
		if kernel and kernel[0]=='3':
			list.append(self.checkModules("net/bluetooth","bluetooth.ko", "kernel-module-bluetooth", "Bluetooth"))
		else:
			list.append(self.checkModules("drivers/block","loop.ko", "kernel-module-loop", "Loop-Device"))
		list.append(self.checkModules("drivers/net","tun.ko", "kernel-module-tun", "TUN/TAP device driver"))
		list.append(self.checkModules("drivers/hid","hid-apple.ko", "kernel-module-hid-apple", "Apple hid driver"))
		self.SetList(list)
		self.SetIndex(index)
		
	def checkModules(self, path, what, modname, desc="", seperator=None):
		found=0
		tmpstr=what.split(".ko")[0]
		if modulExists(path + "/" + what):
			found=2
			tmpstr += " (Modules)"
		elif path[0:2]=="fs" and tmpstr in self.__fsList:
			found=1
			tmpstr += " (Kernel)"
		elif path=="fs/exportfs" and pathExists("/usr/sbin/exportfs"):
			found=1
			tmpstr += " (Binary)"
		elif path=="fs/fuse" and pathExists("/dev/fuse"):
			found=1
			tmpstr += " (Kernel)"
		elif what=="ntfs-3g" and pathExists("/usr/bin/ntfs-3g"):
			found=3
			tmpstr += " (Binary)"
		elif what=="exfat" and pathExists("/usr/bin/exfat"):
			found=3
			tmpstr += " (Binary)"
		elif path[0:2]=="fs" and tmpstr=="cdfs" and modulExists("../extra/cdfs.ko"):
			found=2
			tmpstr += " (Modules)"
		elif what=="btusb.ko" and pathExists("/sys/module/btusb/version"):
			found=1
			tmpstr += " (Kernel)"
		elif what=="bluetooth.ko" and pathExists("/sys/module/bluetooth/version"):
			found=1
			tmpstr += " (Kernel)"
		elif what=="tun.ko" and pathExists("/dev/net/tun"):
			found=1
			tmpstr += " (Kernel)"
		return (tmpstr, getColorPic(found),desc, seperator, found, modname)
		
	def KeyGreen(self):
		val = self.getCurrentEntry()
		if val and val[4]==0:
			from WidgetIpkg import  WidgetIpkg, IPKG_UPDATE, IPKG_INSTALL
			self.session.openWithCallback(self.__afterInstall, WidgetIpkg, cmdList=[(IPKG_UPDATE,""), (IPKG_INSTALL, val[5])])
			
	def __afterInstall(self,val):
		if val[0]==0:
			#if val[1]==True:
			#	from plugin import CONFIGFUNC
			#	from lib import libgeminimain
			#	libgeminimain.gFunktion(CONFIGFUNC,2)
			self.__fillList()
	
	def KeyRed(self):
		val = self.getCurrentEntry()
		if val and (val[4]==2 or val[4]==3):
			self.session.openWithCallback(boundFunction(self.__eraseCallback,val[5]), MessageBox, _("Attention!") + "\n" + _("Are you sure want to delete?\n\n") + _("Package") + ": " + val[5])
		
	def __eraseCallback(self, pack, ret=False):
		if ret:
			from WidgetIpkg import WidgetIpkg, IPKG_REMOVE
			self.session.openWithCallback(self.__afterInstall, WidgetIpkg, cmdList=[(IPKG_REMOVE, pack)])

	def KeyExit(self):
		self.close()
		cleanexit(__name__)
