# -*- coding: utf-8 -*-
from gLocale import _
from WidgetVariableList import WidgetVariableList
from gTools import libgeminimain, cleanexit, gLoadPixmap
from plugin import cgevent, geventNotifier
from atr import AtrList
from GeminiDef import *
#---------------------------------------------------------------------

class InfoHardware(WidgetVariableList):
	def __init__(self, session, name=None, icon=None):
		WidgetVariableList.__init__ (self, session, title = name or _("Hardware") , ListIcon=(66,66), LinesProEntry=4, icon="icon_devicesinfo.png", selectionEnabled=0)
		self.skinName = [self.__class__.__name__,"VariableListNoButton_" + self.__class__.__name__,"VariableListNoButton"]
		
		geventNotifier.append((EVENT_HARDWARE, self.__fillListe))
		from lib import libgtools
		self.libgtools = libgtools
		
		self.onLayoutFinish.append(self.__fillListe)
		
	def __fillListe(self, what=0, val=""):
		list = []
		#sys
		for x in self.libgtools.getSysList():
			tstr = None
			pic = None
			if len(x)==1:
				pic = "dev_cpu.png"
				tstr = x[0]
			elif len(x)==2:
				pic = "dev_flash.png"
				tstr = _("Type: Memory (Flash)")
				tstr += "\nMTD\t%s: %s" %(_("Size"), libgeminimain.getHumanSize(x[0]))
				tstr += "\nMMC\t%s: %s" %(_("Size"), libgeminimain.getHumanSize(x[1]))
			elif len(x)==6:
				pic = "dev_memory.png"
				tstr = _("Type: Memory (Ram)\n\ttotal\tused\tfree\n")
				tstr += "Mem:\t" + libgeminimain.getHumanSize(x[0]) + "\t" + libgeminimain.getHumanSize(x[1]) + "\t" + libgeminimain.getHumanSize(x[2]) + "\n"
				tstr += "Swap:\t" + libgeminimain.getHumanSize(x[3]) + "\t" + libgeminimain.getHumanSize(x[4]) + "\t" + libgeminimain.getHumanSize(x[5])
			if pic and tstr:
				list.append((tstr, gLoadPixmap(pic)))
		#net
		for x in self.libgtools.getNetworkList():
			#print x
			tstr = (_("Type: Network (%s)") % (x[NET_DEV]))
			if x[NET_AUTOIP]:
				tstr += " AutoIP"
			tstr += "\n" + x[NET_EXTRA]
			pic = x[NET_PIC] + ".png"
			if x[NET_ACTIVE]>0:
				pic = x[NET_PIC] + "_on.png"
			list.append((tstr, gLoadPixmap(pic)))
		
		#block
		for x in libgeminimain.getPyList(GETBLOCKLIST):
			#print x
			if x[DEV_TYPE] & DMAPPER:
				continue
			tstr = _("Type") + ": " + _(x[DEV_DESC]) + "\n"
			if x[DEV_MODEL]:
				tstr += _("Model") + ": " + x[DEV_MODEL] + "\n"
			if x[DEV_MANU]:
				tstr += _("Producer") + ": " + x[DEV_MANU] + "\n"
			if x[DEV_SIZE]:
				tstr += _("Size") + ": " + libgeminimain.getHumanSize(x[DEV_SIZE]) + " "
			if x[DEV_PARTS]:
				tstr += _("in %d Partition(s)") % (x[DEV_PARTS])
			if x[DEV_TYPE] & LOOPDEV:
				tstr += "\n" + _("File") + ": " + x[DEV_SNNR]
			list.append((tstr, gLoadPixmap(x[DEV_PIC])))
			
		#usb
		for x in self.libgtools.getUsbList(""):
			tstr = _("Type") + ": " + x[DEV_DESC] + "\n"
			if x[DEV_MODEL]:
				tstr += _("Model") + ": " + x[DEV_MODEL] + "\n"
			if x[DEV_MANU]:
				tstr += _("Producer") + ": " + x[DEV_MANU] + "\n"
			if x[DEV_SNNR]:
				tstr += "ID: " + x[DEV_SNNR]
			list.append((tstr, gLoadPixmap(x[DEV_PIC])))

		#SmartCard
		for x in self.libgtools.getSciList():
			#print x
			tmp_str = _("Type") + ": Smart Card Interface" + "\n" + _("Card") + ":\t"
			if x[0]==-1:
				tmp_str += _("other softcamd active")
			elif x[0]==0:
				tmp_str += _("not found")
			elif x[0]==-2 or x[0]==-3:
				tmp_str += _("defect") + "?"
			elif x[0]==2:
				if AtrList.has_key((x[2],x[3],x[4])):
					tmp_str += AtrList[(x[2],x[3],x[4])]
				else:
					tmp_str += _("unknown") + " ATR: %02x %02x %02x" %(x[2],x[3],x[4])
			
			tmp_str += "\n" + _("Device") + ":\t" + x[1]
			list.append((tmp_str, gLoadPixmap("dev_sci.png", cached=False)))
		
		#AudioDevices
		for x in self.libgtools.getAudioDevice():
			tstr = _("Type") + ": Audio "
			if x[0]==AUDIO_ALSA:
				tstr += "(Alsa)\n"
			else:
				tstr += "(Bluetooth)\n"
			tstr += _("Device") + ": " + x[2] + "\n"
			list.append((tstr, gLoadPixmap("dev_audio.png", cached=False)))

		#Bluetooth
		for x in self.libgtools.getBluetooth():
			list.append((_("Type")+": "+x[0]+"\n"+x[1]+"\n"+x[2]+"\n"+x[3], gLoadPixmap("dev_bluetooth.png", cached=False)))
			
		#Fan
		from Components.FanControl import fancontrol
		if fancontrol.getFanCount():
			for count in range(fancontrol.getFanCount()):
				tmp_str = _("Type: Fan %d\n") % (count + 1)
				tmp_str += _("Speed:  \t%d RPM\n") % (fancontrol.getFanSpeed(count))
				tmp_str += _("Voltage:\t%d\n") % (fancontrol.getVoltage(count))
				tmp_str += _("PWM:    \t%d") % (fancontrol.getPWM(count))
				list.append((tmp_str, gLoadPixmap("dev_fan.png", cached = False)))
					
		#Temp
		from Components.Sensors import sensors
		templist = sensors.getSensorsList(sensors.TYPE_TEMPERATURE)
		templen = len(templist)
		tmp_str = ""
		if templen:
			for count in range(4):
				if count > templen:
					break;
				if sensors.getSensorType(count) == sensors.TYPE_TEMPERATURE:
					tmp_str += str(sensors.getSensorValue(count)) + " " + sensors.getSensorUnit(count) + "        \t" + sensors.getSensorName(count) + "\n"
			if len(tmp_str):
				list.append((tmp_str, gLoadPixmap("dev_temp.png", cached=False)))
		if templen>4:
			tmp_str = ""
			for count in range(4,8):
				if count > templen:
					break;
				if sensors.getSensorType(count) == sensors.TYPE_TEMPERATURE:
					tmp_str += str(sensors.getSensorValue(count)) + " " + sensors.getSensorUnit(count) + "        \t" + sensors.getSensorName(count) + "\n"
			if len(tmp_str):
				list.append((tmp_str, gLoadPixmap("dev_temp.png", cached=False)))
		
		#Tuner
		from Components.NimManager import nimmanager
		for tuner in nimmanager.nimList():
			t = tuner.split(':', 1)
			if len(t) == 2:
				list.append((t[0]+"\n"+t[1], gLoadPixmap("dev_tuner.png", cached=False)))
		
		#Inputdevice
		for x in self.libgtools.getInputList():
			#print x
			tmp_str = _("Type") + ": Input"
			pic=None
			if x[0] & INPUT_KEYBOARD and bool(x[0] & INPUT_MOUSE)==False:
				if x[2].find("remote control")>0:
					pic="dev_if.png"
					tmp_str += " (IR)"
				else:
					pic="dev_keyboard.png"
					tmp_str += " (%s)" %_("Keyboard")
			if x[0] & INPUT_MOUSE:
				pic="dev_mouse.png"
				tmp_str += " (%s)" %_("Mouse")
			if x[0] & INPUT_JOYSTICK and bool(x[0] & INPUT_KEYBOARD)==False:
				pic="dev_unknown.png"
				tmp_str += " (Joystick)"

			if pic:
				tmp_str += "\n" + _("Name") + ":\t" + x[2]
				tmp_str += "\n" + _("Device") + ":\t" + x[3]
				list.append((tmp_str, gLoadPixmap(pic, cached=False)))

		self.SetList(list)
	
	def KeyUp(self):
		WidgetVariableList.KeyLeft(self)

	def KeyDown(self):
		WidgetVariableList.KeyRight(self)

	def KeyExit(self):
		geventNotifier.remove((EVENT_HARDWARE, self.__fillListe))
		del self.libgtools
		self.close()
		cleanexit(__name__)
