# -*- coding: utf-8 -*-
from gLocale import _
from GeminiDef import *

from gTools import libgeminimain, cleanexit, pathExists, Jukeboxfound, DVDplayerfound
from plugin import geventNotifier
from WidgetVariableList import WidgetVariableList

from enigma import eTimer

ATA=1
SCSI=2
USB=4
ATAPI_CD=8
ATAPI_CF=16
ATA_HDD=32
SCSI_STICK=64
SCSI_DVD=128
SCSI_HDD=256
AUDIO_CD=8192
VIDEO_DVD=16384

class HotplugScreen(WidgetVariableList):
	def __init__(self, session, device):
		WidgetVariableList.__init__ (self, session, title=" ")
		self.skinName = ["HotplugScreen"]

		self.counter = 15
		self.dev=None
		dlist = libgeminimain.getPyList(GETBLOCKLIST, device)
		if len(dlist) == 1:
			self.dev = list(dlist[0])
		else:
			self.counter = 1
			
		#print "_________________________________________",self.counter, device
		#print dlist

		self.StatusTimer = eTimer()
		self.StatusTimer_conn = self.StatusTimer.timeout.connect(self.__Autoclose)
		self.__Autoclose()
		self.onLayoutFinish.append(self.__fillListe)
		geventNotifier.append((EVENT_HARDWARE, self.__fillListe))
		
	def KeyExit(self, val=None):
		geventNotifier.remove((EVENT_HARDWARE, self.__fillListe))
		libgeminimain.setHWLock(0)#wegen automount
		self.close(val)
		cleanexit(__name__)
		
	def __Autoclose(self):
		if self.counter < 1:
			self.KeyExit()
		else:
			self.SetTitle(_("A new device, where open?") + " (" + str(self.counter) + ")")
			self.StatusTimer.start(1000,True)
		self.counter -= 1
		
	def __fillListe(self, what=0, val=""):
		if self.dev == None:
			return
		list=[]
		mountpoint=None
		if self.dev[DEV_TYPE] & (ATAPI_CD | SCSI_DVD):
			if not bool(self.dev[DEV_TYPE] & AUDIO_CD):
				libgeminimain.setHWLock(1)#wegen automount
				if pathExists("/autofs/" + self.dev[DEV_DEV] + "/VIDEO_TS") and DVDplayerfound:
					self.dev[DEV_PIC] = "dev_dvd_video.png"
					self.dev[DEV_TYPE] |= VIDEO_DVD
					list.append((_("DVD Player"),None, 3, "/autofs/" + self.dev[DEV_DEV]))

		text = _("Type") + ": " + _(self.dev[DEV_DESC]) + "\n"
		if self.dev[DEV_MODEL]:
			text += _("Model") + ": " + self.dev[DEV_MODEL] + "\n"
		if self.dev[DEV_MANU]:
			text += _("Producer") + ": " + self.dev[DEV_MANU] + "\n"
		if self.dev[DEV_SIZE]:
			text += _("Size") + ": " + libgeminimain.getHumanSize(self.dev[DEV_SIZE]) + " "
		if self.dev[DEV_PARTS]:
			text += _("in %d Partition(s)") % (self.dev[DEV_PARTS])
			
		for x in libgeminimain.getPyList(GETMOUNTLIST):
			if self.dev[DEV_DEV] == x[PART_DEV]:
				mountpoint = x[PART_MPOINT]
		
		if mountpoint:
			if bool(self.dev[DEV_TYPE] & AUDIO_CD) and Jukeboxfound:
				list.append((_("Jukebox"),None, 4, mountpoint))
			list.append((_("File Browser"),None, 0, mountpoint+"/.."))
			list.append((_("Picture-Browser"),None, 5, mountpoint+"/.."))
			list.append((_("Video-Browser"),None, 2, mountpoint+"/.."))
		list.append((_("Device Manager"),None, 1, None))
		
		self.SetIcon(self.dev[DEV_PIC])
		self.SetLabel(text)
		self.SetList(list)
	
	def KeyUp(self):
		WidgetVariableList.KeyUp(self)
		self.StatusTimer.stop()

	def KeyDown(self):
		WidgetVariableList.KeyDown(self)
		self.StatusTimer.stop()

	def KeyOk(self):
		sel = self.getCurrentEntry()
		if sel:
			self.KeyExit((sel[2],sel[3]))

