# -*- coding: utf-8 -*-
from gLocale import _
from GeminiDef import *

from gTools import libgeminimain, cleanexit, pathRemove, pathExists, Jukeboxfound, Torrentfound, PDFfound, ctoolsclass, geminiarchiver, DEFAULTGEMINICACHEDIR
from plugin import cgevent, geventNotifier
from WidgetColorList import myColorList
from FileBrowser import GMEDIASCAN
from WidgetConfig import WidgetInput
from WidgetTools import errorlist, C_DELETE, C_COPY, C_MOVE, C_EXTRACT, C_MAKE_ARCHIVE, BackGroundThread, searchMovieExtension, SetPermission, GetPermission, SetNewName, CreateSymlink, CreateDir, CreateFile, HumanSize, getPackInfo, getDirInfo, DVDBD_Player

from Screens.HelpMenu import HelpableScreen
from Screens.Screen import Screen
from Screens.ChoiceBox import ChoiceBox
from Screens.MessageBox import MessageBox
from Components.Console import Console as cConsole
from Components.Sources.StaticText import StaticText
from Components.ActionMap import ActionMap
from Components.Pixmap import MultiPixmap, Pixmap
from Tools.BoundFunction import boundFunction

from enigma import eTimer

from os import readlink, path as os_path

#-------------------------------------------------------

class eCommander(Screen, HelpableScreen):
	def __init__(self, session, path=None, startfromDM=False):
		Screen.__init__(self, session)
		HelpableScreen.__init__(self)
		
		self["actions"] = ActionMap(["gActions"],
		{
			"yellow": self.KeyUpdate,
			"red": self.KeyCommand,
			"blue": self.KeyMarked,
			"green": self.KeyStart,
			"up": self.KeyUp,
			"down": self.KeyDown,
			"left": self.PageUp,
			"right": self.PageDown,
			
			"0": self.Key0,
			"1": self.Key1,
			"2": self.Key2,
			"3": self.Key3,
			"4": self.Key4,
			"5": self.Key5,
			"6": self.Key6,
			"7": self.Key7,
			"8": self.Key8,
			
			"nextBouquet": self.SelLList,
			"historyNext": self.SelLList,
			"prevBouquet": self.SelRList,
			"historyBack": self.SelRList,
			"menu": self.KeyMenu,
			"info": self.KeyInfo,
			"exit": self.KeyExit,
			"ok": self.KeyOk
		}, -1)

		self["listl"] = myColorList([])
		self["listr"] = myColorList([])
		self["List0Selected"] = MultiPixmap()
		self["List1Selected"] = MultiPixmap()
		self["List0Path"] = StaticText()
		self["List1Path"] = StaticText()
		self["BG_action"] = Pixmap()
		self["MenuPic"] = Pixmap()
		self["InfoPic"] = Pixmap()
		
		self["RedButton"] = StaticText(_("Command"))
		self["GreenButton"] = StaticText("")
		self["YellowButton"] = StaticText(_("Update"))
		self["BlueButton"] = StaticText(_("Mark"))
		self["InfoLabel"] = StaticText()
		
		self.Console = cConsole()
		self.__ConsoleRunning = False
		self.__lastEvent=0
		self.__startfromDM = startfromDM
		self.path = path
		self.__currList = "listl"
		self.__lastpath = {"listl" : "/", "listr" : "/"}
		
		self.__loadConfig()

		self.ListTimer = eTimer()
		self.ListTimer_conn = self.ListTimer.timeout.connect(self.__UpdateEntry)
		
		geventNotifier.append((EVENT_BACKGROUND, self.__newBGEvent))
		
		self.onLayoutFinish.append(self.__firstStart)

	def KeyExit(self):
		geventNotifier.remove((EVENT_BACKGROUND, self.__newBGEvent))
		sel = self["listl"].getCurrent()
		if sel:
			if sel[0][B_FILTER] & FILTER_GOUP:
				cgevent.setConfig("ecomm_lastpath_l",self.__lastpath["listl"] + "/..")
			else:
				cgevent.setConfig("ecomm_lastpath_l",sel[0][B_FULL])
		sel = self["listr"].getCurrent()
		if sel:
			if sel[0][B_FILTER] & FILTER_GOUP:
				cgevent.setConfig("ecomm_lastpath_r",self.__lastpath["listr"] + "/..")
			else:
				cgevent.setConfig("ecomm_lastpath_r",sel[0][B_FULL])

		if cgevent.getConfig("Dmanager_startfirst",0)==0:
			self.close(self.__lastpath["listl"])

		self.Console.killAll()
		self.close()
		cleanexit(__name__)
		
	def __firstStart(self):
		self.helpList.append((self["actions"], "gActions", [("menu", _("Menu"))]))
		self.helpList.append((self["actions"], "gActions", [("nextBouquet", _("go to the right list"))]))
		self.helpList.append((self["actions"], "gActions", [("prevBouquet", _("go to the left list"))]))
		self.helpList.append((self["actions"], "gActions", [("historyNext", _("go to the right list"))]))
		self.helpList.append((self["actions"], "gActions", [("historyBack", _("go to the left list"))]))
		self.helpList.append((self["actions"], "gActions", [("info", _("Information"))]))
		
		self.helpList.append((self["actions"], "gActions", [("1", _("Delete"))]))
		self.helpList.append((self["actions"], "gActions", [("2", _("Copy"))]))
		self.helpList.append((self["actions"], "gActions", [("3", _("Move"))]))
		self.helpList.append((self["actions"], "gActions", [("4", _("Permission"))]))
		self.helpList.append((self["actions"], "gActions", [("5", _("Rename"))]))
		self.helpList.append((self["actions"], "gActions", [("6", _("Create Symlink"))]))
		self.helpList.append((self["actions"], "gActions", [("7", _("Create new directory"))]))
		self.helpList.append((self["actions"], "gActions", [("8", _("Create new file"))]))
		self.helpList.append((self["actions"], "gActions", [("exit", _("Exit"))]))

		self["listl"].onSelectionChanged.append(self.selectionChanged)
		self["listr"].onSelectionChanged.append(self.selectionChanged)
		self["List1Selected"].setPixmapNum(1)
		
		if libgeminimain.getBGstatus() & (BG_DELETE | BG_EXTRACT | BG_COPYMOVE):
			self["BG_action"].show()
		else:
			self["BG_action"].hide()
			
		startdir = cgevent.getConfig("ecomm_StartDir_l"," ")
		if startdir != " ":
			self.path=startdir + "/.."

		if self.path==None:
			self.__lastpath["listl"] = cgevent.getConfig("ecomm_lastpath_l","/")
		else:
			self.__lastpath["listl"] = self.path
		self.path = os_path.dirname(self.__lastpath["listl"])
		self.__filllist(self.path)
		self.__currList = "listr"
		self.path=None
		
		startdir = cgevent.getConfig("ecomm_StartDir_r"," ")
		if startdir != " ":
			self.path=startdir + "/.."
		
		if self.path==None:
			self.__lastpath["listr"] = cgevent.getConfig("ecomm_lastpath_r","/")
		else:
			self.__lastpath["listr"] = self.path
		self.path = os_path.dirname(self.__lastpath["listr"])
		self.__filllist(self.path)
		self.__currList = "listl"
		
	def selectionChanged(self):
		self.ListTimer.start(400,True)
		
	def __loadConfig(self):
		self.__SortBy = cgevent.getConfig("ecomm_SortBy", SORT_NAME)
		if self.__SortBy < SORT_NAME or self.__SortBy > SORT_SIZE_DOWN:
			self.__SortBy = SORT_NAME
		self.__ask = cgevent.getConfig("Dmanager_ask",1)
		self.__ok_is_green = cgevent.getConfig("Dmanager_ok_is_green",0)
		self.__show_ts_help_files = cgevent.getConfig("ecomm_show_ts_help_files",1)
		self.__show_system_files = cgevent.getConfig("ecomm_show_hidden_files",0)
		self.__ignore_dirprop = cgevent.getConfig("ecomm_dirprop",0)
		self.__media_scan = cgevent.getConfig("media_scan",1)
			
	def __newBGEvent(self, what=0, val=0):
		#print what,val
		if what == EVENT_BACKGROUND:
			if val & (BG_DELETE | BG_EXTRACT | BG_COPYMOVE):
				self["BG_action"].show()
				self.__lastEvent = val
			else:
				self["BG_action"].hide()
				#print errorlist
				if self.__lastEvent & (BG_COPYMOVE | BG_EXTRACT):
					self.KeyUpdate()
					self.__UpdateSite2()#anderes Fenster neu zeichnen
					self.__lastEvent = 0
				elif self.__lastEvent & BG_DELETE:
					index = self[self.__currList].getCurrentIndex()
					self.KeyUpdate()
					self.__lastEvent = 0
					self[self.__currList].SetIndex(index)

	def __UpdateSite2(self):#anderes Fenster aktualisieren
		currlist = self.__currList
		if currlist=="listr":
			self.__currList="listl"
		else:
			self.__currList="listr"
		
		sel = self[self.__currList].getCurrent()
		if sel:
			path = self.__lastpath[self.__currList]
			self.__lastpath[self.__currList] = sel[0][B_FULL]
			self.__filllist(path)
		#zurück setzen
		self.__currList = currlist
		
	def __filllist(self,path):
		if pathExists(path)==False:
			path="/"
		flist = libgeminimain.getPyList(GETFILELIST,(path, FILTER_NONE, self.__SortBy, self.__show_ts_help_files, self.__show_system_files, 1, self.__ignore_dirprop))
		
		#AutoScan Folder
		if self.__media_scan>0 and path and path!="/" and path!="/media/network" and pathExists(path+"/.nomedia")==False:
			self.__startConsole(MI_SCANDIR,path)
		
		self[self.__currList].list=[]
		index=0
		count=0
		for x in flist:
			if x[B_FULL] == self.__lastpath[self.__currList]:
				index = count
			self[self.__currList].list.append(self[self.__currList].ListEntry(x,len(flist)))
			count += 1
		self[self.__currList].SetList()
		self[self.__currList].SetIndex(index)
		
		self[self.__currList].markedlist=[]
		self.__lastpath[self.__currList]=path
		
		if self.__currList == "listl":
			self["List0Path"].setText(" " + self.__lastpath[self.__currList])
		else:
			self["List1Path"].setText(" " + self.__lastpath[self.__currList])
		
	def __UpdateEntry(self):
		self["GreenButton"].setText("")
		self["InfoLabel"].setText("")
		self["InfoPic"].hide()

		sel = self[self.__currList].getCurrent()
		if sel:
			val = sel[0]
			
			#Infoline
			text=""
			market=1
			if val[B_FILTER] & FILTER_GOUP:
				market=0
				
			if len(self[self.__currList].markedlist):
				market=len(self[self.__currList].markedlist)
			
			listlen=len(self[self.__currList].list)
			if self.__lastpath[self.__currList] != "/":
				listlen-=1
				
			if val[B_FILTER] & FILTER_LINK:
				text+="> " + readlink(val[B_FULL])
				
			elif val[B_FILTER] & FILTER_FILE:
				text += "%s, %s" %(libgeminimain.getHumanDate(3,val[B_DATE]), GetPermission(val[B_MODE]))
				if val[B_EXT]!="":
					text += ", *.%s" %val[B_EXT]
			self["InfoLabel"].setText(" (%d/%d) %s" %(market,listlen,text))
			
			#green and info button
			if val[B_FILTER] & (FILTER_ISO | FILTER_DVD):
				self["GreenButton"].setText(_("Start"))
				self["InfoPic"].show()
			elif val[B_FILTER] & FILTER_PICS:
				self["GreenButton"].setText(_("Show"))
				self["InfoPic"].show()
			elif val[B_FILTER] & FILTER_PL:
				if Jukeboxfound:
					self["GreenButton"].setText("Jukebox")
			elif val[B_FILTER] & FILTER_SOUND:
				if Jukeboxfound:
					self["GreenButton"].setText("Jukebox")
				self["InfoPic"].show()
			elif val[B_FILTER] & FILTER_DIR and not val[B_FILTER] & FILTER_GOUP:
				self["InfoPic"].show()
			elif val[B_FILTER] & FILTER_SCRIPTE:
				self["GreenButton"].setText(_("Execute"))
				if val[B_SIZE] < VIEWMAXSIZE:
					self["InfoPic"].show()
			elif val[B_FILTER] & FILTER_TXT:
				#if QTEditor:
				#	self["GreenButton"].setText(_("Edit"))
				if val[B_SIZE] < VIEWMAXSIZE:
					self["InfoPic"].show()
			elif val[B_FILTER] & FILTER_MOVIES:
				self["GreenButton"].setText(_("Play"))
				self["InfoPic"].show()
			elif val[B_FILTER] & FILTER_TORRENT:
				if Torrentfound:
					self["GreenButton"].setText("eTorrent")
			elif val[B_FILTER] & FILTER_IPK:
				self["GreenButton"].setText(_("Install"))
				self["InfoPic"].show()
			elif val[B_FILTER] & FILTER_PDF:
				if PDFfound:
					self["GreenButton"].setText(_("Show"))
			elif val[B_FILTER] & FILTER_MVI:
				self["GreenButton"].setText(_("Show"))
			elif val[B_FILTER] & FILTER_PACK:
				self["GreenButton"].setText(_("Extract"))
				if val[B_EXT] != "LZMA":
					if val[B_EXT]=="RAR":
						if geminiarchiver:
							self["InfoPic"].show()
					else:
						self["InfoPic"].show()
		
	def KeyUp(self):
		self[self.__currList].ListUp()
	
	def KeyDown(self):
		self[self.__currList].ListDown()
		
	def PageUp(self):
		self[self.__currList].PageUp()
	
	def PageDown(self):
		self[self.__currList].PageDown()
		
	def SelRList(self):
		self.__currList = "listl"
		self.selectionChanged()
		self["List0Selected"].setPixmapNum(0)
		self["List1Selected"].setPixmapNum(1)
	
	def SelLList(self):
		self.__currList = "listr"
		self.selectionChanged()
		self["List0Selected"].setPixmapNum(1)
		self["List1Selected"].setPixmapNum(0)
	
	def KeyMenu(self):
		sel = self[self.__currList].getCurrent()
		menu=[]
		#MediaIcon
		if sel and sel[0]:
			if sel[0][B_FILTER] & (FILTER_MOVIES | FILTER_SOUND | FILTER_PICS | FILTER_ISO):
				if pathExists(sel[0][B_CFILE] + ".png") or pathExists(sel[0][B_CFILE] + ".txt"):
					menu.append((_("Delete Media-Infos"), "deleteMediaInfo", sel[0]))
				elif self.__ConsoleRunning==False:
					menu.append((_("Search Media-Infos"), "createMediaInfo", sel[0]))
					if sel[0][B_FILTER] & (FILTER_MOVIES | FILTER_ISO):
						menu.append((_("Select Media-Icon, only JPG-Files"), "selectMediaPic", sel[0]))
			if sel[0][B_FILTER] & FILTER_DIR and not sel[0][B_FILTER] & FILTER_GOUP:
				menu.append((_("Search Media-Infos in Subdirectorys (in Background)"), "scanSubdirs", sel[0]))
			if not sel[0][B_FILTER] & FILTER_GOUP:
				menu.append((_("mark all files"), "markallfiles",None))
			if sel[0][B_FILTER] & FILTER_FILE and sel[0][B_EXT]!="":
				menu.append((_("mark all '*.%s' files") %sel[0][B_EXT], "markallext", sel[0]))
			if len(self[self.__currList].markedlist)>1:
				menu.append((_("remove all marks"), "removemarks",None))
			if len(menu):
				menu.append(("--", "",None))
			menu.append((_("Setup"), "setup", None))
			self.session.openWithCallback(self.__menuCallback, ChoiceBox, title="", list=menu)
		
	def __menuCallback(self, what=None):
		if what is None:
			return
		path = what[2]

		if what[1]=="setup":
			from confFileBrowser import eCommanderSetup
			self.session.openWithCallback(self.__setupCallback, eCommanderSetup, self.__startfromDM)
		elif what[1] == "deleteMediaInfo":
			pathRemove(path[B_CFILE]+".png")
			pathRemove(path[B_CFILE]+".txt")
			if path[B_FILTER] & FILTER_MOVIES:
				try:
					pos = (len(path[B_FULL]) - len(path[B_EXT]) -1)
					name = path[B_FULL][0:pos]
					pathRemove(name+".jpg")
					pathRemove(name+".info")
				except:
					pass
			self.KeyUpdate()
		elif what[1] == "createMediaInfo":
			if path[B_FILTER] & (FILTER_MOVIES | FILTER_ISO):
				searchstr = path[B_NAME]
				try:
					if path[B_FILTER] & FILTER_TS and path[B_DESC] != "":
						pos = path[B_DESC].find(" (")
						if pos>0:
							searchstr = path[B_DESC][0:pos]
						else:
							searchstr = path[B_DESC]
					else:
						pos = (len(path[B_NAME]) - len(path[B_EXT]) -1)
						searchstr =path[B_NAME][0:pos]
				except:
					pass
				self.session.openWithCallback(boundFunction(self.__movieSearchCallback,path), WidgetInput, title=what[0], entryname=_("search by"), greenbutton=_("Start"), default=searchstr)
			elif path[B_FILTER] & FILTER_SOUND:
				self.__startConsole(MI_SCANSOUND, path)
			elif path[B_FILTER] & FILTER_PICS:
				self.__startConsole(MI_SCANPICTURE, path)
		elif what[1] == "selectMediaPic":
			self.session.openWithCallback(boundFunction(self.__selectMI_Callback,path), gBrowser, setPath=path[B_FULL], filter=FILTER_JPEG)
		elif what[1] == "scanSubdirs":
			cmd = "%s '%s' '%s' %d %d ' ' &" %(GMEDIASCAN, path[B_FULL], DEFAULTGEMINICACHEDIR[:-1], 1, MI_SCANDIRRECURSIV)
			libgeminimain.sendDbus("gdaemon",0,cmd)
		elif what[1] == "markallfiles":
			self[self.__currList].markAll(True)
		elif what[1] == "markallext":
			self[self.__currList].markAll(True,path[B_EXT])
		elif what[1] == "removemarks":
			self[self.__currList].markAll(False)

#-----------------------------------------------------------------------------

	def __setupCallback(self, newsetup):
		if newsetup==True:
			self.__loadConfig()
			self.KeyUpdate()
			
	def __movieSearchCallback(self, path, searchstr):
		if searchstr is not None:
			from searchMediaInfo import MovieList
			self.session.openWithCallback(self.__callbackMovieList, MovieList, searchstr, path)
			
	def __callbackMovieList(self, ret):
		if ret:
			self.KeyUpdate()
			
	def __selectMI_Callback(self, path, file=None):
		if file is not None:
			self.__startConsole("selectMediaPic", path, file)
			
#-----------------------------------------------------------------------------
		
	def KeyOk(self):
		sel = self[self.__currList].getCurrent()
		if sel:
			if sel[0][B_FILTER] & FILTER_DIR:
				self.__filllist(sel[0][B_FULL])
			elif self.__ok_is_green==1:
				self.KeyStart()
				
	def KeyUpdate(self):
		sel = self[self.__currList].getCurrent()
		if sel:
			path = self.__lastpath[self.__currList]
			self.__lastpath[self.__currList] = sel[0][B_FULL]
			self.__filllist(path)
		
	def KeyMarked(self):
		self[self.__currList].invertEntry()
			
	def __getMarketList(self):
		if len(self[self.__currList].markedlist)==0:
			sel = self[self.__currList].getCurrent()
			if sel and sel[0][B_FILTER] & FILTER_GOUP:
				return ([], 0, 0)
			elif sel and sel[0][B_FILTER] & FILTER_DIR:
				return ([sel[0]],0,1)
			elif sel and sel[0][B_FILTER] & FILTER_FILE:
				return ([sel[0]],1,0)
		else:
			count_f=0
			count_d=0
			for x in self[self.__currList].markedlist:
				if x[B_FILTER] & FILTER_DIR:
					count_d += 1
				elif x[B_FILTER] & FILTER_FILE:
					count_f += 1
				
			return (self[self.__currList].markedlist,count_f,count_d)
		return ([], 0, 0)
		
	def __getPathOtherPage(self):
		if self.__currList == "listl":
			return self.__lastpath["listr"]
		return self.__lastpath["listl"]
		
	def Key0(self):
		self[self.__currList].SetIndex(0)
	def Key1(self):
		self.__commandCallback(("","delete"))
	def Key2(self):
		self.__commandCallback(("","copy"))
	def Key3(self):
		self.__commandCallback(("","move"))
	def Key4(self):
		self.__commandCallback((_("Permission"),"chmod"))
	def Key5(self):
		self.__commandCallback((_("Rename"),"rename"))
	def Key6(self):
		self.__commandCallback((_("Create symlink"),"symlink"))
	def Key7(self):
		self.__commandCallback((_("Create new directory"),"newdir"))
	def Key8(self):
		self.__commandCallback((_("Create new file"),"newfile"))

	def KeyCommand(self):
		menu=[]
		key=[]
		sel = self[self.__currList].getCurrent()
		if sel and not sel[0][B_FILTER] & FILTER_GOUP or len(self[self.__currList].markedlist):
			menu.append((_("Delete"), "delete"))
			key.append("1")
			menu.append((_("Copy"), "copy"))
			key.append("2")
			menu.append((_("Move"), "move"))
			key.append("3")
		if sel and not sel[0][B_FILTER] & FILTER_GOUP and not sel[0][B_FILTER] & FILTER_LINK:
			menu.append((_("Permission"), "chmod"))
			key.append("4")
			menu.append((_("Rename"), "rename"))
			key.append("5")
		if len(menu):
			menu.append(("--", ""))
			key.append("--")
		menu.append((_("Create symlink"), "symlink"))
		key.append("6")
		menu.append((_("Create new directory"), "newdir"))
		key.append("7")
		menu.append((_("Create new file"), "newfile"))
		key.append("8")
		menu.append(("--", ""))
		key.append("--")
		if sel and sel[0][B_FILTER] & FILTER_PACK:
			menu.append((_("Extract package"), "extractpackage"))
			key.append("9")
		else:
			menu.append((_("Create package"), "createpackage"))
			key.append("9")
		if sel and sel[0][B_FILTER] & FILTER_FILE and sel[0][B_SIZE] < VIEWMAXSIZE:
			menu.append((_("View as Text"), "showfile"))
			key.append("0")
		if sel and sel[0][B_FILTER] & FILTER_DIR:
			menu.append((_("Properties"), "properties"))
			key.append("red")
		
		self.session.openWithCallback(self.__commandCallback, ChoiceBox, title="", keys=key, list=menu)
		
	def __commandCallback(self, what=None):
		if what is None:
			return
		if what[1]=="delete":
			filelist, count_f, count_d = self.__getMarketList()
			if len(filelist) and (count_f>0 or count_d>0):
				kwargs={'func': C_DELETE, 'filelist': searchMovieExtension(filelist)}
				if self.__ask>0:
					BackGroundThread(kwargs, self.session, count_f, count_d)
				else:
					BackGroundThread(kwargs)
				index = self[self.__currList].getCurrentIndex()
				self.KeyUpdate()
				self[self.__currList].SetIndex(index)
		elif what[1]=="move":
			filelist, count_f, count_d = self.__getMarketList()
			if len(filelist) and (count_f>0 or count_d>0):
				kwargs={'func': C_MOVE, 'filelist': searchMovieExtension(filelist), 'destdir' : self.__getPathOtherPage()}
				if self.__ask>0:
					BackGroundThread(kwargs, self.session, count_f, count_d)
				else:
					BackGroundThread(kwargs)
				self.KeyUpdate()
		elif what[1]=="copy":
			filelist, count_f, count_d = self.__getMarketList()
			if len(filelist) and (count_f>0 or count_d>0):
				kwargs={'func': C_COPY, 'filelist': searchMovieExtension(filelist), 'destdir' : self.__getPathOtherPage()}
				if self.__ask>0:
					BackGroundThread(kwargs, self.session, count_f, count_d)
				else:
					BackGroundThread(kwargs)
		elif what[1]=="chmod":
			sel = self[self.__currList].getCurrent()
			if sel and not sel[0][B_FILTER] & FILTER_GOUP and not sel[0][B_FILTER] & FILTER_LINK:
				from confFileBrowser import PermSetup
				self.session.openWithCallback(boundFunction(self.__permCallback, sel[0][B_FULL]), PermSetup, what[0], sel[0])
		elif what[1]=="rename":
			sel = self[self.__currList].getCurrent()
			if sel and not sel[0][B_FILTER] & FILTER_GOUP:
				from confFileBrowser import RenameClass
				self.session.openWithCallback(boundFunction(self.__renameCallback, sel[0]), RenameClass, what[0], sel[0])
		elif what[1]=="symlink":
			sel = self[self.__currList].getCurrent()
			if sel and not sel[0][B_FILTER] & FILTER_GOUP:
				from confFileBrowser import SymlinkCreate
				self.session.openWithCallback(boundFunction(self.__symlinkCallback, sel[0][B_FULL]), SymlinkCreate, what[0], sel[0][B_NAME], self.__getPathOtherPage())
		elif what[1]=="newdir":
			self.session.openWithCallback(self.__newdirCallback, WidgetInput, title=what[0], entryname=_("Name"), greenbutton=_("Create"))
		elif what[1]=="newfile":
			self.session.openWithCallback(self.__newfileCallback, WidgetInput, title=what[0], entryname=_("Name"), greenbutton=_("Create"))
		elif what[1]=="extractpackage":
			filelist, count_f, count_d = self.__getMarketList()
			if len(filelist) and (count_f>0 or count_d>0):
				kwargs={'func': C_EXTRACT, 'filelist': filelist, 'destdir' : self.__getPathOtherPage(), 'password' : ""}
				BackGroundThread(kwargs)
		elif what[1]=="createpackage":
			filelist, count_f, count_d = self.__getMarketList()
			packagename=None
			if len(filelist):
				from confFileBrowser import PackSetup
				self.session.openWithCallback(boundFunction(self.__createpackageCallback, filelist), PackSetup, what[0], None)
		elif what[1]=="showfile":
			sel = self[self.__currList].getCurrent()
			if sel and sel[0]:
				from ShowFileList import ShowFileList
				self.session.open(ShowFileList, sel[0][B_FULL], selectlast=True)
		elif what[1]=="properties":
			sel = self[self.__currList].getCurrent()
			if sel and sel[0]:
				from confFileBrowser import FolderProp
				self.session.openWithCallback(self.__FolderPropCallback, FolderProp, what[0], sel[0], libgeminimain.getPyList(GETFOLDERPROP, sel[0][B_FULL]))

#----------------------------------------------------------------------------------------------

	def __FolderPropCallback(self, val):
		if val is not None:
			libgeminimain.getPyList(SETFOLDERPROP, val)

	def __createpackageCallback(self, filelist, typ=None):
		if typ is not None:
			if len(filelist)==1:
				packagename = self.__getPathOtherPage() + "/" + filelist[0][B_NAME]
			else:
				packagename = self.__getPathOtherPage() + "/" + os_path.basename(self.__lastpath[self.__currList])
			kwargs={'func': C_MAKE_ARCHIVE, 'filelist': filelist, 'package' : packagename, 'type' : typ, 'sourcedir' : self.__lastpath[self.__currList]}
			BackGroundThread(kwargs)
	
	def __permCallback(self, path, val=None):
		if val is not None:
			SetPermission(val,path)
			self.KeyUpdate()
			
	def __renameCallback(self, path, val=None):
		if val is not None and val != "":
			if path[B_NAME] != val:
				SetNewName(path, val)
				index = self[self.__currList].getCurrentIndex()
				self.KeyUpdate()
				self[self.__currList].SetIndex(index)
			
	def __symlinkCallback(self, path, val=None):
		if val is not None:
			CreateSymlink(path,val)
			self.__UpdateSite2()#anderes Fenster neu zeichnen
			
	def __newdirCallback(self, val=None):
		if val is not None and val != "":
			path = self.__lastpath[self.__currList] + "/" + val
			CreateDir(path)
			self.__lastpath[self.__currList]=path#gleich rein wechseln
			self.KeyUpdate()
			
	def __newfileCallback(self, val=None):
		if val is not None and val != "":
			path = self.__lastpath[self.__currList] + "/" + val
			CreateFile(path)
			self.KeyUpdate()
			
	def KeyInfo(self):
		sel = self[self.__currList].getCurrent()
		if sel and sel[0] and not sel[0][B_FILTER] & FILTER_GOUP:
			sel = sel[0]
			if sel[B_FILTER] & FILTER_DIR:
				self["InfoLabel"].setText(getDirInfo(sel,self.__lastpath[self.__currList]))
			elif sel[B_FILTER] & (FILTER_PICS | FILTER_MOVIES | FILTER_SOUND):
				from searchMediaInfo import BrowserFileInfos
				self.session.open(BrowserFileInfos, [sel])
			elif sel[B_FILTER] & FILTER_IPK:
				from WidgetIpkg import ipkFileInfo
				info = ipkFileInfo(sel[B_FULL])
				if len(info)>0:
					tmpstr = ""
					for x in info:
						tmpstr += x
					if tmpstr!="":
						self.session.open(MessageBox, tmpstr,MessageBox.TYPE_INFO)
			elif sel[B_FILTER] & (FILTER_TXT | FILTER_SCRIPTE):
				from ShowFileList import ShowFileList
				self.session.open(ShowFileList, sel[B_FULL])
			elif sel[B_FILTER] & FILTER_PACK:
				size = getPackInfo(sel)
				if size>0:
					self.session.open(MessageBox, _("Needed %s disk space.") %HumanSize(size), MessageBox.TYPE_INFO, timeout=5)
			
	def KeyStart(self):
		sel = self[self.__currList].getCurrent()
		if sel and sel[0] and not sel[0][B_FILTER] & FILTER_GOUP:
			self.__startFile(sel[0])
			
	def __startFile(self,val):
		try:
			if val[B_FILTER] & (FILTER_DVD | FILTER_ISO):
				DVDBD_Player(self.session,val)
			elif val[B_FILTER] & (FILTER_SOUND | FILTER_PL):
				if Jukeboxfound:
					from Plugins.Bp.geminijukebox.jukebox import JukeBox
					self.session.open(JukeBox, setPath=val[B_FULL])
			elif val[B_FILTER] & FILTER_PICS:
				piclist=[]
				picindex=0
				index=-1
				for x in self[self.__currList].list:
					if x[0][B_FILTER] & FILTER_PICS:
						index += 1
						piclist.append((x[0][B_NAME],x[0][B_FULL]))
						if x[0][B_FULL] == val[B_FULL]:
							picindex = index

				from WidgetShowPicture import gPicPlayer, gPicPlayerThumb
				if len(piclist):
					self.session.openWithCallback(boundFunction(self.__picplayCallback,val), gPicPlayer, piclist, picindex)
			elif val[B_FILTER] & FILTER_SCRIPTE:
				from ShowFileList import ShowFileList
				self.session.open(ShowFileList, cmdlist = [val[B_FULL]])
			#elif val[B_FILTER] & FILTER_TXT:
			#	if QTEditor:
			#		from Plugins.Bp.geminiqteditor.editor import Editor
			#		self.session.open(Editor, opt=val[B_FULL])
			elif val[B_FILTER] & FILTER_MOVIES:
				from gMoviePlayer import ExMoviePlayer
				self.session.openWithCallback(self.__movieCallback, ExMoviePlayer, val)
			elif val[B_FILTER] & FILTER_TORRENT:
				if Torrentfound:
					from Plugins.Bp.geminictorrent.etorrent import etorrent
					self.session.open(etorrent, path=val[B_FULL])
			elif val[B_FILTER] & FILTER_IPK:
				from WidgetIpkg import WidgetIpkg,IPKG_UPDATE,IPKG_INSTALL_LOCAL
				self.session.open(WidgetIpkg, cmdList=[(IPKG_UPDATE,""), (IPKG_INSTALL_LOCAL,val[B_FULL])])
			elif val[B_FILTER] & FILTER_PDF:
				if PDFfound:
					from Plugins.Bp.geminipdf.gpdf import Cpdf
					self.session.open(Cpdf, path=val[B_FULL], name=val[B_NAME])
				else:
					self.session.open(MessageBox, _("Package '%s' not installed!") %("geminipdf"), MessageBox.TYPE_INFO, timeout=5)
			elif val[B_FILTER] & FILTER_MVI:
				from ShowMVI import ShowMVI
				self.session.open(ShowMVI, val[B_FULL])
			elif val[B_FILTER] & FILTER_PACK:
				self.__commandCallback((_("Extract package"), "extractpackage"))
			else:
				print "keine Start"
		except Exception, e:
			print "[%s] <%s>"%(__name__,e)
			
#---------------------------------------------------------------------------------------

	def __movieCallback(self,val=None):
		self.KeyUpdate()
			
	def __picplayCallback(self, path, ret=None):
		if ret:
			if ret != path[B_FULL]:
				index=0
				for x in self[self.__currList].list:
					if x[0][B_FULL]==ret:
						self[self.__currList].SetIndex(index)
						break
					index += 1
#--------------------------------

	def __startConsole(self, func, path, search=" "):
		if self.__ConsoleRunning == False:
			cmd = None
			if func == MI_SCANPICTURE  or func == MI_SCANSOUND:
				cmd = "%s '%s' '%s' %d %d '%s'" %(GMEDIASCAN, path[B_FULL], path[B_CFILE], 1, func, search)
			elif func == MI_SCANDIR:
				cmd = "%s '%s' '%s' %d %d ' '" %(GMEDIASCAN, path, DEFAULTGEMINICACHEDIR[:-1], 1, func)
			elif func == "selectMediaPic":
				cmd = "%s '%s' '%s' %d %d ' '" %(GMEDIASCAN, search, path[B_CFILE], 0, MI_SCANPICTURE)
			if cmd:
				self.__ConsoleRunning = True
				self.Console.ePopen(cmd, boundFunction(self.__FinishedConsole,path))

	def __FinishedConsole(self, path, result, retval, extra_args = None):
		#print "__________________________FinishedConsole",path
		if self.__ConsoleRunning and path is not None:
			val = self[self.__currList].getCurrent()
			if val and val[0] and val[0]==path:
				self.KeyUpdate()
		self.__ConsoleRunning = False
#--------------------------------