# -*- coding: utf-8 -*-
CjukeboxEventNotifier=[]

class CjukeboxEvent:
	JUKEBOX_STATUS=0
	JUKEBOX_ERROR=1
	JUKEBOX_TIME_URL=2
	JUKEBOX_TITLE=3

	def __init__(self):
		self.clean()
		
	def clean(self):
		self.PlayTitle=""
		self.LastError=""
		self.LastStatus=""
		self.CurrSource=""
		self.TotalTime=0
		self.PlayTime=0
		self.Percent=0
		
	def JBEvent(self, func, value):
		for callback in CjukeboxEventNotifier:
			try:
				callback(func,value)
			except AttributeError:
				CjukeboxEventNotifier.remove(callback)

		if func==self.JUKEBOX_STATUS:
			self.LastStatus=value
		elif func==self.JUKEBOX_TIME_URL:
			val = value.split(' ',2)
			if len(val)==3:
				self.Percent=0
				self.TotalTime = int(val[0])
				self.PlayTime = int(val[1])
				self.CurrSource = val[2]
				
				if self.TotalTime > 0 and self.PlayTime >= 0:
					prozvalue = self.PlayTime*100/self.TotalTime
					if prozvalue >= 0 and prozvalue <= 100:
						self.Percent=prozvalue
				#print self.Percent,self.TotalTime,self.PlayTime,self.CurrSource
		elif func==self.JUKEBOX_TITLE:
			self.PlayTitle=value
		elif func==self.JUKEBOX_ERROR:
			self.LastError=value
		
cjukeboxevent = CjukeboxEvent()
