# -*- coding: utf-8 -*-

from Plugins.Bp.geminimain.gLocale import _
from Components.config import config
from Screens.HarddiskSetup import HarddiskDriveSelection
from Screens.MessageBox import MessageBox
from Plugins.Plugin import PluginDescriptor
from Components.config import config, ConfigSubsection, ConfigYesNo

config.plugins.bp = ConfigSubsection()
config.plugins.bp.devicemanager = ConfigYesNo(default=False)

title =""
desc =""

def managerstart(session, **kwargs):
	try:
		from Plugins.Bp.geminimain.DeviceManager import DeviceManager
		session.open(DeviceManager)
	except Exception, e:
		err = _("Unexpected error:")
		session.open(MessageBox, text="%s\n\n%s"%(err, e), type=MessageBox.TYPE_ERROR, timeout=5)
	
def harddiskstart(session, **kwargs):
	session.open(HarddiskDriveSelection)

def DeviceMenu(menuid, **kwargs):
	global title, desc
	if config.plugins.bp.devicemanager.value:
		title = _("Storage devices")
		desc = _("Set up your storage devices like harddisks and flash memory cards.")
		return [(title, harddiskstart, "hardisk_selection", 2)] if menuid == "devices" else []
	else:
		title = _("Device Manager")
		desc = _("Device Manager by GeminiTeam")
		return [(title, managerstart, "hardisk_selection", 2)] if menuid == "devices" else []

def Plugins(**kwargs): 
	 return [PluginDescriptor(name = title, description = desc, where = PluginDescriptor.WHERE_MENU, fnc = DeviceMenu)]
