# -*- coding: utf-8 -*-
from Converter import Converter
from Components.Element import cached


class CryptIcon(Converter, object):
	
	def __init__(self, type):
		Converter.__init__(self, type)
		if type == "betacrypt":
			self.caid = 0x1700
		elif type == "irdeto":
			self.caid = 0x0600
		elif type == "seca":
			self.caid = 0x0100
		elif type == "via":
			self.caid = 0x0500
		elif type == "nagra":
			self.caid = 0x1800
		elif type == "cw":
			self.caid = 0x0D00
		elif type == "nds":
			self.caid = 0x0900
		elif type == "conax":
			self.caid = 0x0B00
		else:
			self.caid = int(type,16)

	@cached
	def getValue(self):
		ret=0
		for x in self.source.clist:
			if self.caid == (x[0] & 0xFF00):
				if x[1]:
					ret=2
					break
				ret=1
		return ret

	get_value = property(getValue)
