# -*- coding: utf-8 -*-

import sys,time
import urllib,os,re
import xbmc,xbmcplugin,xbmcgui
import urlparse,threading

from resources.lib import mal,common,library
from resources.lib.sites import burningweb as burning
from resources.lib.sites import genx, tavernakoma, world24, tube, amvnews, anisearch, proxer, randaris, proxer, streams4me, flow

pluginhandle = int(sys.argv[1])

addon = common.get_addon()
image = common.get_image()
clear_cache = addon.getSetting('clear_cache') == 'true'
cache_time_animes = 24*7
cache_time_episodes = 6
cache_time_mirror = 24
cache_time_info = 24*30
select_hoster = addon.getSetting('select_hoster') == 'true'
prefer_ihosts = addon.getSetting('prefer_ihosts') == 'true'

if clear_cache:
    try:
        common.clear_cache()
        xbmc.executebuiltin('Notification(Cache Deleted,)')
    except:
        xbmc.executebuiltin('Notification(Error While Deleting Cache,)')
    addon.setSetting(id='clear_cache', value='false')

_sites = [(genx, addon.getSetting('genx')), (randaris, addon.getSetting('randaris')), (tube, addon.getSetting('tube')), (anisearch, addon.getSetting('anisearch')), (world24, addon.getSetting('world24')), (tavernakoma, addon.getSetting('tavernakoma')), (proxer, addon.getSetting('proxer')), (flow, addon.getSetting('flow')), (streams4me, addon.getSetting('streams4me')), (burning, addon.getSetting('burning'))]
sites = [i[0] for i in _sites if i[1] == 'true']

def root():
    addDir('Neu','neu','get_anime_list','')
    addDir('Airing Anime','airing','list_airing_anime','')
    addDir('Serien','tv','list_alphabet','')
    addDir('Filme','movie','list_alphabet','')
    addDir('OVAs und Specials','ova','list_alphabet','')
    addDir('Genres','genres','list_genres','')
    addDir('Top 100','top100','get_anime_list','')
    addDir('AMV TV','amvtv','play_amv','')
    addDir('Suche','search','list_search','')
    addDir('Meine Anime','myanime','list_my_anime','')
    xbmcplugin.endOfDirectory(pluginhandle)

def list_my_anime():
    my_anime_list = []
    entries = mal.get_my_anime_entries()
    if entries:
        for entry in entries:
            for site in _sites:
                if entry['site'] in str(site[0]):
                    id = entry['id']
                    try: type = entry['type']
                    except: type = 'tv'
                    anime = site[0].get_anime_info(type,id,cache_time=cache_time_info)
                    my_anime_list.append(anime)
        list_anime(my_anime_list)

def add_to_mal():
    id = args['url'][0]
    site = args['site'][0]
    type = args['type'][0]
    try: mal.add_to_mal(type,site,id)
    except: pass

def remove_from_mal():
    id = args['url'][0]
    site = args['site'][0]
    try: mal.remove_from_mal(site,id)
    except: pass
    
def list_airing_anime():
    anime_list = genx.get_airing_anime_list()
    if anime_list: list_anime(anime_list)

def show_similar():
    name = args['name'][0]
    anime_list = anisearch.get_similar(name)
    anime_list = common.remove_duplicates(anime_list)
    for anime in anime_list:
        cover = anime['cover']
        name = anime['name']
        name = common.clean(name)
        addDir(name,'','list_search',cover)
    xbmcplugin.endOfDirectory(pluginhandle) 

def list_search():
    name = args['name'][0]
    if name == 'Suche':
        search_string = common.enter_string(title='Suche')
        if search_string:
            anime_list = anisearch.get_search_list(search_string)
    else:
        anime_list = anisearch.get_search_list(name)
    list_anime(anime_list)

def list_genres():
    genres = common.get_genres()
    for genre in genres:
        addDir(genre,'genre','get_anime_list','')
    xbmcplugin.endOfDirectory(pluginhandle)

def list_alphabet():
    url = args['url'][0]
    alphabet = common.get_alphabet()
    for abc in alphabet:
        addDir(abc,url,'get_anime_list','')
    xbmcplugin.endOfDirectory(pluginhandle)
    
def get_anime_list():
    url = args['url'][0]
    name = args['name'][0]
    anime_list = None
    if url == 'neu': 
        anime_list = get_new_list()
    elif url == 'tv' or url == 'movie' or url == 'ova':
        anime_list = get_abc_list(url,name)
    elif url == 'top100': 
        anime_list = genx.get_top100_anime_list()
    elif url == 'genre':
        anime_list = genx.get_genre_anime_list(name)
    if anime_list: list_anime(anime_list)

def get_new_list():
    anime_list = []
    threads = []
    for site in sites: threads.append(threading.Thread(target=new_thread, args=(site,anime_list)))
    [i.start() for i in threads]
    [i.join() for i in threads]
    anime_list = common.sort_anime_list_by_site(sites, anime_list)
    anime_list = common.remove_duplicates(anime_list)
    return anime_list

def new_thread(site,anime_list):
    start_time = time.time()
    new_list = site.get_new_series(cache_time=cache_time_episodes)
    for anime in new_list:
        anime_list.append(anime)
    complete_time = time.time() - start_time
    site = str(site).split("'")[1]
    print '[plugin.video.animeanime] getting new list from %s in %ss' % (site,complete_time)
    return anime_list

def get_abc_list(type, abc):
    anime_list = []
    threads = []
    for site in sites: threads.append(threading.Thread(target=abc_thread, args=(site,anime_list,type,abc)))
    [i.start() for i in threads]
    [i.join() for i in threads]
    anime_list = common.sort_anime_list_by_site(sites, anime_list)
    anime_list = common.remove_duplicates(anime_list)
    return anime_list
    
def abc_thread(site,anime_list,type,abc):
    start_time = time.time()
    abc_list = site.get_abc_list(type,abc,cache_time=cache_time_animes)
    for anime in abc_list:
        anime_list.append(anime)
    complete_time = time.time() - start_time
    site = str(site).split("'")[1]
    print '[plugin.video.animeanime] getting anime list from %s in %ss' % (site,complete_time)
    return anime_list
    
def list_anime(anime_list):
    for anime in anime_list:
        if anime:
            try:
                aid = anime['id']
                site = anime['site']
                name = anime['name']
                name = common.clean(name)
                try: type = anime['type']
                except: type = 'tv'
                plot = anime['plot']
                try: plot = plot.encode('utf-8')
                except: plot = plot
                episodes = anime['episodes']
                final_genres = ''
                genres = anime['genre']
                for genre in genres:
                    try: genre = genre.encode('utf-8')
                    except: genre = genre
                    final_genres += genre+' '
                episodes_aired = anime['episodes_aired']
                year = anime['year']
                cover = anime['cover']
                cm = []
                if args['name'][0] == 'Meine Anime':
                    u=sys.argv[0]+"?url="+urllib.quote_plus(str(aid))+"&mode="+urllib.quote_plus('remove_from_mal')+"&site="+urllib.quote_plus(str(site))
                    cm.append( ('Delete From My Anime', "XBMC.RunPlugin(%s)" % u) )
                else:
                    u=sys.argv[0]+"?url="+urllib.quote_plus(str(aid))+"&mode="+urllib.quote_plus('add_to_mal')+"&site="+urllib.quote_plus(str(site))+"&type="+urllib.quote_plus(type)
                    cm.append( ('Add To My Anime', "XBMC.RunPlugin(%s)" % u) )
                addAnime(site,type,name,aid,'list_episodes',cover,plot,final_genres,year,episodes,episodes_aired,cm)
            except Exception, e:
                print '[plugin.video.animeanime] list_anime error', anime, e
    if not args['name'][0] == 'Top 100':
        xbmcplugin.addSortMethod(pluginhandle, xbmcplugin.SORT_METHOD_TITLE)
        xbmcplugin.addSortMethod(pluginhandle, xbmcplugin.SORT_METHOD_STUDIO)
        xbmcplugin.addSortMethod(pluginhandle, xbmcplugin.SORT_METHOD_VIDEO_YEAR)
    xbmcplugin.endOfDirectory(pluginhandle)

def list_episodes():
    type = args['type'][0]
    id = args['url'][0]
    name = args['name'][0]
    anime = name
    cover = args['iconimage'][0]
    common.get_ani_alt_list(name,cache_only=False)
    episodes = None
    if 'burning' in str(sites) and type == 'tv':
        start_time = time.time()
        list_burning_seasons(name)
        complete_time = time.time() - start_time
        print '[plugin.video.animeanime] getting season list from burning in %ss' % (complete_time)
    episodes = get_episodes(type,name)
    most_episodes = common.get_most_episodes(episodes)
    if episodes:
        for e in range(1,most_episodes+1):
            episode = str(e)
            if type == 'movie': name = '%s %s' % (anime,episode)
            else: name = 'Episode %s' % episode
            addEpisode(type,anime,episode,name,'get_mirrors')
    xbmcplugin.addSortMethod(pluginhandle, xbmcplugin.SORT_METHOD_TITLE)
    xbmcplugin.endOfDirectory(pluginhandle)

def get_episodes(type,name):
    episodes = []
    threads = []
    for episode_site in sites: threads.append(threading.Thread(target=episodes_thread, args=(episode_site,type,name,episodes)))
    [i.start() for i in threads]
    [i.join() for i in threads]
    return episodes
            
def episodes_thread(episode_site,type,name,episodes):
    start_time = time.time()
    episode_list = episode_site.get_episode_list(type,name,cache_time=cache_time_episodes)
    episodes.append(episode_list)
    complete_time = time.time() - start_time
    site = str(episode_site).split("'")[1]
    print '[plugin.video.animeanime] getting episode list from %s in %ss' % (site,complete_time)
    return episodes

def list_burning_seasons(name):
    start_time = time.time()
    burning_seasons = burning.get_burning_seasons(name,cache_time=cache_time_episodes)
    for season in burning_seasons:
        _name = season['name']
        try: _name = _name.encode('utf-8')
        except: pass
        bid = season['id']
        cover = season['cover']
        addDir(_name,bid,'list_burning_episodes',cover)
    
def list_burning_episodes():
    id = args['url'][0]
    episodes = burning.get_episodes(id,cache_time=cache_time_episodes)
    for episode in episodes:
        n = episode['episode']
        name = 'Episode %s' % n
        addEpisode('',id,n,name,'play_burning')
    xbmcplugin.addSortMethod(pluginhandle, xbmcplugin.SORT_METHOD_TITLE)
    xbmcplugin.endOfDirectory(pluginhandle)

def play_burning():
    id = args['anime'][0]
    episode = args['episode'][0]
    hoster_list = burning.get_hoster_list(id,episode)
    play(hoster_list)

def get_mirrors():
    type = args['type'][0]
    anime = args['anime'][0]
    episode = args['episode'][0]
    hoster_list = []
    threads = []
    for mirror_site in sites: threads.append(threading.Thread(target=mirror_thread, args=(mirror_site,type,anime,episode,hoster_list)))
    [i.start() for i in threads]
    [i.join() for i in threads]
    play(hoster_list)
    
def mirror_thread(mirror_site,type,anime,episode,hoster_list):
    start_time = time.time()
    mirror_list = mirror_site.get_mirror(type,anime,episode,cache_time=cache_time_mirror)
    for mirror in mirror_list:
        hoster_list.append(mirror)
    complete_time = time.time() - start_time
    site = str(mirror_site).split("'")[1]
    print '[plugin.video.animeanime] getting mirror list from %s in %ss' % (site,complete_time)
    print '[plugin.video.animeanime] Mirror List: %s' % str(mirror_list)
    return hoster_list
    
def play(hoster_list):
    hoster_list = sort_hoster_list(hoster_list)
    print '[plugin.video.animeanime] Hoster Liste: %s' % str(hoster_list)
    if select_hoster and hoster_list:
        dialog = common.get_dialog()
        ret = dialog.select('Select Hoster', hoster_list)
        if ret >= 0:
            hoster_list = [hoster_list[ret]]
            print '[plugin.video.animeanime] Selected Hoster: %s' % str(hoster_list)
        else: 
            hoster_list = []
    from resources.lib import resolver
    file = resolver.get_file(hoster_list)
    set_resolved(file)
    
def set_resolved(file):
    if file:
        listitem = xbmcgui.ListItem(path=file)
        if (file.startswith('rtmpe') and 'crunchyroll' in file) or ('openload' in file):
            try:
                subtitle = common.get_subtitle()
                listitem.setSubtitles([subtitle])
            except:
                xbmc.executebuiltin('Notification(Kodi Required For Subtitles,)')
        xbmcplugin.setResolvedUrl(pluginhandle, True, listitem)
    else:
        xbmc.executebuiltin('Notification(No Stream Found,)')
        
def play_amv():
    name = args['name'][0]
    if name == 'AMV TV':
        playlist = xbmc.PlayList(xbmc.PLAYLIST_VIDEO)
        playlist.clear()
        id = amvnews.select_category()
        if id:
            playlist = amvnews.get_playlist(playlist,id)
            xbmc.Player().play(playlist)
    else:
        amv = amvnews.get_amv(name)
        if amv:
            file = amv['url']
            name = amv['name']
            li = xbmcgui.ListItem(name)
            xbmc.Player().play(file, listitem=li)
        else:
            xbmc.executebuiltin('Notification(No AMV Available,)')
            
def play_trailer():
    name = args['name'][0]
    trailer = anisearch.get_trailer(name)
    if trailer:
        from resources.lib import resolver
        file = resolver.get_file([trailer])
        li = xbmcgui.ListItem(name)
        xbmc.Player().play(file, listitem=li)
    else:
        xbmc.executebuiltin('Notification(No Trailer Available,)')

def sort_hoster_list(links):
    hoster_list = []
    for n, link in enumerate(links):
        if 'redirect' in link and 'anisearch' in link:
            from resources.lib import resolver
            url = resolver.get_redirected_url(link)
            links[n] = url
        elif 'adf.ly' in link:
            from resources.lib import unshortenit
            url = unshortenit.unshorten_adfly(link)
            links[n] = url
    if prefer_ihosts: list = ['ihost1','ihost2','ihost3','ihost4','ihost5','ihost6','ihost7','ihost8','ihost9','ihost10','ihost11','ihost12','ihost13','ehost1','ehost2','ehost3','ehost4','ehost5','ehost6','ehost7','ehost8','ehost9','ehost10','ehost11','ehost12','ehost13','ehost14']
    else: list = ['ehost1','ehost2','ehost3','ehost4','ehost5','ehost6','ehost7','ehost8','ehost9','ehost10','ehost11','ehost12','ehost13','ehost14','ihost1','ihost2','ihost3','ihost4','ihost5','ihost6','ihost7','ihost8','ihost9','ihost10','ihost11','ihost12','ihost13',]
    for host in list:
        hoster = []
        try:
            hoster = [i for i in links if addon.getSetting(host) in i]
        except:
            pass
        for url in hoster:
            hoster_list.append(url)
    return hoster_list

def add_to_library():
    type = args['type'][0]
    anime = args['anime'][0]
    mode = 'get_mirrors'
    episodes = get_episodes(type,anime)
    most_episodes = common.get_most_episodes(episodes)
    library.add_to_library(type,anime,most_episodes,mode)

def addEpisode(type,anime,episode,name,mode):
    u = common.build_url({'type': type, 'anime': anime, 'episode': episode, 'mode': mode})
    item=xbmcgui.ListItem(name, iconImage="DefaultVideo.png", thumbnailImage='')
    item.setInfo( type="Video", infoLabels={ "Title": name } )
    item.setProperty('IsPlayable', 'true')
    xbmcplugin.addDirectoryItem(pluginhandle,url=u,listitem=item)

def addAnime(site,type,name,url,mode,iconimage,plot,genre,year,episodes,episodes_aired,cm):
    if not iconimage: iconimage = image
    u = common.build_url({'site': site, 'type': type, 'mode': mode, 'name': name, 'url': url, 'iconimage': iconimage})
    item=xbmcgui.ListItem(name, iconImage="DefaultFolder.png", thumbnailImage=iconimage)
    item.setInfo( type="Video", infoLabels={ "Title": name, "Plot": plot, "Genre": genre, "Year": year, "Episode": episodes, "Studio": site } )
    library_uri = common.build_url({'type': type, 'mode': 'add_to_library', 'anime': name})
    cm.append( ('Add To Library', "XBMC.RunPlugin(%s)" % library_uri) )
    amv_uri=common.build_url({'mode': 'play_amv', 'name': name})
    cm.append( ('Play AMV', "XBMC.RunPlugin(%s)" % amv_uri) )
    trailer_uri=common.build_url({'mode': 'play_trailer', 'name': name})
    cm.append( ('Play Trailer', "XBMC.RunPlugin(%s)" % trailer_uri) )
    similar_uri=common.build_url({'mode': 'show_similar', 'name': name})
    cm.append( ('Show Similar', "Container.Update(%s)" % similar_uri) )
    item.addContextMenuItems( cm )
    xbmcplugin.addDirectoryItem(pluginhandle,url=u,listitem=item,isFolder=True)

def addDir(name,url,mode,iconimage):
    if not iconimage: iconimage = image
    u = common.build_url({'mode': mode, 'name': name, 'url': url, 'iconimage': iconimage})
    item=xbmcgui.ListItem(name, iconImage="DefaultFolder.png", thumbnailImage=iconimage)
    xbmcplugin.addDirectoryItem(pluginhandle,url=u,listitem=item,isFolder=True)

args = urlparse.parse_qs(sys.argv[2][1:])
mode = args.get('mode', None)
print 'Arguments: '+str(args)

if mode==None:
    root()
else:
    exec '%s()' % mode[0]