#!/usr/bin/python
# -*- coding: utf-8 -*-
from urllib2 import urlopen
from Components.MenuList import MenuList
from Components.Label import Label

from Screens.Screen import Screen
from Screens.MessageBox import MessageBox
from Components.ActionMap import NumberActionMap
from Components.Input import Input
from Components.Pixmap import Pixmap
from Components.FileList import FileList
from Screens.ChoiceBox import ChoiceBox
from Screens.InfoBarGenerics import *
from Screens.InfoBar import MoviePlayer, InfoBar
from Screens.Console import Console
from Components.ServiceEventTracker import ServiceEventTracker, InfoBarBase
from Plugins.Plugin import PluginDescriptor
from Components.ActionMap import ActionMap
from Components.Button import Button
from Components.SelectionList import SelectionList, SelectionEntryComponent
from Components.ScrollLabel import ScrollLabel
import Components.PluginComponent
from Screens.InputBox import InputBox

from twisted.web.client import getPage, downloadPage

import os, re
from Screens.InfoBar import MoviePlayer
from enigma import eServiceReference
from enigma import eServiceCenter
from enigma import getDesktop
from Plugins.Extensions.IPTVworld.lib.Utils import RSList, showlist
from Tools.Directories import fileExists
import urllib2

######################################################################
#                                                                    #
#   IPTVworld v.r0 : Coded by pcd@i-have-a-dreambox, January 2016.   #
#   This is free software; you can redistribute it and/or modify it. #
#   However, you are politely requested to retain these 3 lines.     #
#                                                                    #
######################################################################

THISPLUG = "/usr/lib/enigma2/python/Plugins/Extensions/IPTVworld"
path = THISPLUG + "/channels/"
DESKHEIGHT = getDesktop(0).size().height()

def getUrl(url):
    pass#print "Here in client2 getUrl url =", url
    try:
	req = urllib2.Request(url)
	req.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.9.0.3) Gecko/2008092417 Firefox/3.0.3')
	response = urllib2.urlopen(req)
	link=response.read()
	response.close()
	return link
    except:
        return ""	

class FullHD(Screen):
    skin = """
                <screen position="center,center" size="1056,831" title="IPTVworld" flags="wfNoBorder" backgroundColor="transparent">
                <eLabel position="center,center" zPosition="1" size="1050,825" backgroundColor="#000000" /> 
                <eLabel position="center,center" zPosition="-1" size="1056,831" backgroundColor="#ffffff" /> 

                        <eLabel text="IPTVworld" font="Regular;50" position="500,750" size="500,75" zPosition="4" halign="center"  foregroundColor="blue" backgroundColor="#000000" transparent="1"/> 

			<widget name="list" position="120,80" size="900,600" zPosition="4" scrollbarMode="showOnDemand" />
			<eLabel position="105,150" zPosition="-1" size="150,103" backgroundColor="#222222" />
			<widget name="info" position="75,712" zPosition="4" size="450,37" font="Regular;27" foregroundColor="#ffffff" transparent="1" halign="center" valign="center" />
		        <ePixmap name="red"    position="0,750"   zPosition="2" size="210,60" pixmap="skin_default/buttons/red.png" transparent="1" alphatest="on" />
	                <ePixmap name="green"  position="210,750" zPosition="2" size="210,60" pixmap="skin_default/buttons/green.png" transparent="1" alphatest="on" />
	                <!--ePixmap name="yellow" position="420,525" zPosition="2" size="210,60" pixmap="skin_default/buttons/yellow.png" transparent="1" alphatest="on" /> 
	                <ePixmap name="blue"   position="630,525" zPosition="2" size="210,60" pixmap="skin_default/buttons/blue.png" transparent="1" alphatest="on" /--> 

	                <widget name="key_red" position="0,750" size="210,60" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;30" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" /> 
	                <widget name="key_green" position="210,750" size="210,60" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;30" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" /> 
	                <!--widget name="key_yellow" position="420,525" size="210,60" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;30" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" />
	                <widget name="key_blue" position="630,525" size="210,60" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;30" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" /-->
                </screen>"""


class HD(Screen):
    skin = """
		<screen position="center,center" size="704,554" title="IPTVworld" flags="wfNoBorder" backgroundColor="transparent">
                <eLabel position="center,center" zPosition="1" size="700,550" backgroundColor="#000000" /> 
                <eLabel position="center,center" zPosition="-1" size="704,554" backgroundColor="#ffffff" /> 

                        <eLabel text="IPTVworld" font="Regular;33" position="333,500" size="333,50" zPosition="4" halign="center"  foregroundColor="blue" backgroundColor="#000000" transparent="1"/> 

			<widget name="list" position="80,53" size="600,400" zPosition="4" scrollbarMode="showOnDemand" />
			<eLabel position="70,100" zPosition="-1" size="100,68" backgroundColor="#222222" />
			<widget name="info" position="50,474" zPosition="4" size="300,24" font="Regular;18" foregroundColor="#ffffff" transparent="1" halign="center" valign="center" />
		        <ePixmap name="red"    position="0,500"   zPosition="2" size="140,40" pixmap="skin_default/buttons/red.png" transparent="1" alphatest="on" />
	                <ePixmap name="green"  position="140,500" zPosition="2" size="140,40" pixmap="skin_default/buttons/green.png" transparent="1" alphatest="on" />
	                <!--ePixmap name="yellow" position="280,350" zPosition="2" size="140,40" pixmap="skin_default/buttons/yellow.png" transparent="1" alphatest="on" /> 
	                <ePixmap name="blue"   position="420,350" zPosition="2" size="140,40" pixmap="skin_default/buttons/blue.png" transparent="1" alphatest="on" /--> 

	                <widget name="key_red" position="0,500" size="140,40" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;20" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" /> 
	                <widget name="key_green" position="140,500" size="140,40" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;20" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" /> 
	                <!--widget name="key_yellow" position="280,350" size="140,40" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;20" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" />
	                <widget name="key_blue" position="420,350" size="140,40" valign="center" halign="center" zPosition="4"  foregroundColor="#ffffff" font="Regular;20" transparent="1" shadowColor="#25062748" shadowOffset="-2,-2" /-->
                </screen>"""

class IPTVworld(Screen):

    def __init__(self, session):
                if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin
		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
        	#############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
                self.icount = 0
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):
           self.names = []
           self.names.append("User m3u files")
           self.names.append("Webcam")
           self.names.append("Kodilive")
           self.names.append("HDF")
           self.names.append("Servers (updated daily)")
           self["info"].setText("")
           showlist(self.names, self["list"])
           

    def okClicked(self):
	   idx = self["list"].getSelectionIndex()
           if idx is None:
                  return
           else:
                  if idx == 0:
                         self.session.open(Userm3u1)
                  elif idx == 1:
                         self.session.open(Webcam1)
                  elif idx == 2:
                         self.session.open(Kodilive1)
                  elif idx == 3:
                         self.session.open(HDF1)
                  elif idx == 4:
                         self.session.open(Servers1)
                       
    def cancel(self):
                Screen.close(self, False)


class Userm3u1(Screen):
    def __init__(self, session):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin

		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
		self["info"].setText("User m3u files location")
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
	self.names = []
        self.names.append("/IPTVworld/playlists")
        self.names.append("/media/usb")
        self.names.append("/media/hdd")
        showlist(self.names, self["list"])
                
    def okClicked(self):
    	   idx = self["list"].getSelectionIndex()
    	   if idx is None:
                return
    	   else:
                name = self.names[idx]
                if name == "/IPTVworld/playlists":
                       name = THISPLUG + "/playlists"
    	        self.session.open(Userm3u2, name)
                
    def cancel(self):
                Screen.close(self, False)

class Userm3u2(Screen):
    def __init__(self, session, name):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin

		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
		self.name = name
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
	       self.names = []
	       path = self.name
	       pass#print "In Userm3u2 path =", path
               for root, dirs, files in os.walk(path):
	              for name in files:
                              if not ".m3u" in name: continue
                              pass#print "In Userm3u2 name =", name
                              self.names.append(name)
               pass#print "In Userm3u2 self.names =", self.names
               showlist(self.names, self["list"])
                
    def okClicked(self):
    	   idx = self["list"].getSelectionIndex()
    	   if idx is None:
                return
    	   else:
                name = self.name + "/" + self.names[idx]
                self.session.open(Userm3u3, name)
    	        
               
    def cancel(self):
                Screen.close(self, False)

class Userm3u3(Screen):
    def __init__(self, session, name):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin

		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
		self.name = name
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
	   self.names = []
           self.urls = []
           
           f1=open(self.name,"r+")
           fpage = f1.read()
           regexcat = 'EXTINF.*?,(.*?)\\n(.*?)\\n'
           match = re.compile(regexcat,re.DOTALL).findall(fpage)
           for name, url in match:
                  url = url.replace(" ", "")
                  url = url.replace("\\n", "")
                  self.names.append(name)
                  self.urls.append(url)
           showlist(self.names, self["list"])

                
    def okClicked(self):
    	   idx = self["list"].getSelectionIndex()
    	   if idx is None:
                return
    	   else:
                name = self.names[idx]
    	        url = self.urls[idx]
    	        self.session.open(Playstream1, name, url)
                
    def cancel(self):
                Screen.close(self, False)


class Webcam1(Screen):
    def __init__(self, session):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin

		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
	self.names = []
	self.urls = []
        content = getUrl("https://www.skylinewebcams.com/en.html")
	pass#print "content A =", content
        n1 = content.find('menu-title text-center"', 0)
        n2 = content.find('id="cams-category', n1)
        content = content[n1:n2]
	regexvideo = '><a href="(.*?)" class="menu-item">(.*?)&'
	match = re.compile(regexvideo,re.DOTALL).findall(content)
        pass#print "match =", match
       
        for url, name in match:
               url1 = "https://www.skylinewebcams.com" + url
               self.names.append(name)
               self.urls.append(url1)
        showlist(self.names, self["list"])
                
    def okClicked(self):
    	   idx = self["list"].getSelectionIndex()
    	   if idx is None:
                return
    	   else:
                name = self.names[idx]
                url = self.urls[idx]
    	        self.session.open(Webcam2, name, url)
                
    def cancel(self):
                Screen.close(self, False)

class Webcam2(Screen):
    def __init__(self, session, name, url):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin

		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
		self.name = name
		self.url = url
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
	self.names = []
	self.urls = []
        content = getUrl(self.url)
	pass#print "content B =", content

	regexvideo = 'li class="webcam"><a href="(.*?)".*?alt="(.*?)"'
	match = re.compile(regexvideo,re.DOTALL).findall(content)
        pass#print "match =", match
        for url, name in match:
                 url1 = "https://www.skylinewebcams.com" + url
                 self.names.append(name)
                 self.urls.append(url1)
        showlist(self.names, self["list"])
                
    def okClicked(self):
       idx = self["list"].getSelectionIndex()
       if idx is None:
               return
       else:
               url1 = self.urls[idx]
    	       name = self.names[idx]
    	       content = getUrl(url1)
	       pass#print "content C =", content

	       regexvideo = "url:'(.*?)'"
	       match = re.compile(regexvideo,re.DOTALL).findall(content)
               pass#print "match =", match
               url = match[0]
               self.session.open(Playstream1, name, url)
               
    def cancel(self):
                Screen.close(self, False)

class HDF1(Screen):
    def __init__(self, session):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin

		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
	       self.names = []
               file1 = THISPLUG + "/userbouquet.hdf.tv"
               f1=open(file1,"r+")
               content = f1.read()
               
               regexcat = 'SERVICE 1\:64.*?DESCRIPTION (.*?)\\n'
               match = re.compile(regexcat,re.DOTALL).findall(content)
               pass#print "match =", match
               for name in match:
                        self.names.append(name)
               showlist(self.names, self["list"])
                
    def okClicked(self):
    	   idx = self["list"].getSelectionIndex()
    	   if idx is None:
                return
    	   else:
                name = self.names[idx]
    	        self.session.open(HDF2, name)
                
    def cancel(self):
                Screen.close(self, False)

class HDF2(Screen):
    def __init__(self, session, name):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin

		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
		self.name = name
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
               self.names = []
               self.urls = []
               file1 = THISPLUG + "/userbouquet.hdf.tv"
               f1=open(file1,"r+")
               content = f1.read()
               n1 = content.find(self.name, 0)
	       n2 = content.find("SERVICE 1:64", n1)
	       if n2 > -1:
                       content2 = content[n1:n2]
               else:          
                       content2 = content[n1:]
	       regexvideo = 'SERVICE 4097\:0\:1\:0\:0\:0\:0\:0\:0\:0\:(.*?)\:(.*?)\\n'
	       match = re.compile(regexvideo,re.DOTALL).findall(content2)
               pass#print "match =", match
               for url, name in match:
                      name = name.replace('"', '')
                      url = url.replace("%3a", ":")
                      self.names.append(name)
                      self.urls.append(url)
               showlist(self.names, self["list"])
                
    def okClicked(self):
    	   idx = self["list"].getSelectionIndex()
    	   if idx is None:
                return
    	   else:
                name = self.names[idx]
    	        url = self.urls[idx]
    	        self.session.open(Playstream1, name, url)
                
    def cancel(self):
                Screen.close(self, False)

                
class Kodilive1(Screen):
    def __init__(self, session):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin

		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
	       self.names = []
               for root, dirs, files in os.walk(path):
	              for name in files:
                              name = name.replace(".txt", "")
                              self.names.append(name)
               
               showlist(self.names, self["list"])
                
    def okClicked(self):
    	   idx = self["list"].getSelectionIndex()
    	   if idx is None:
                return
    	   else:
                name = self.names[idx]
    	        url = path
    	        self.session.open(Kodilive2, name, url)
                
    def cancel(self):
                Screen.close(self, False)

class Kodilive2(Screen):
    def __init__(self, session, name, url):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin

		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
		self.name = name
                self.url = url
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
               self.names = []
               self.urls = []
               file1 = path + self.name + ".txt"
               f1=open(file1,"r+")
               txt1 = f1.read()
               if "radio" in self.name:
                   regexcat = 'COLOR.*?\](.*?)\[/COL.*?\\n(.*?)\\n'
                   match = re.compile(regexcat,re.DOTALL).findall(txt1)
                   for name, url in match:
                        self.names.append(name)
                        self.urls.append(url)
               else:
                   regexcat = 'group-title="(.*?)".*?COLOR.*?\](.*?)\[/COL.*?\\n(.*?)\\n'
                   match = re.compile(regexcat,re.DOTALL).findall(txt1)
                   for name1, name2, url in match:
                        name = name1 + "-" + name2
                        self.names.append(name)
                        self.urls.append(url)              
               showlist(self.names, self["list"])
                
    def okClicked(self):
    	   idx = self["list"].getSelectionIndex()
    	   if idx is None:
                return
    	   else:
                name = self.names[idx]
    	        url = self.urls[idx]
    	        self.session.open(Playstream1, name, url)
                
    def cancel(self):
                Screen.close(self, False)



class Servers1(Screen):
    def __init__(self, session):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin

		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
	        self.names = []
	        self.urls = []
                content = getUrl("http://www.m3uliste.pw/")
                pass#print "content A =", content
                n1 = content.find("Update", 0)
                n2 = content.find("Update", (n1+2))
                n3 = content.find("Update", (n2+2))
                content = content[n1:n3]
                regexcat = 'style="text-align.*?font color=.*?">(.*?)</'
                match = re.compile(regexcat,re.DOTALL).findall(content)
                pass#print "match =", match
                for url in match:
                        pic = " "
                        if not "type=m3u" in url: continue
                        url = url.replace("&amp;", "&")
                        name = url
                        n1 = name.find("http://", 0)
                        n2 = name.find("/", (n1+10))
                        n3 = name.find("usern", (n2+1))
                        n4 = name.find("=", (n3+1))
                        n5 = name.find("&", (n4+1))
                        nam1 = name[(n1+7):(n2)]
                        nam2 = name[(n4+1):n5]
                        name1 = nam1 + "###" + nam2
                        ##pass#pass#print "Here in Showcontent url1 =", url1
                        self.names.append(name1)               
                        self.urls.append(url)
                
                showlist(self.names, self["list"])
                
    def okClicked(self):
    	   idx = self["list"].getSelectionIndex()
    	   if idx is None:
                return
    	   else:
                name = self.names[idx]
    	        url = self.urls[idx]
    	        self.session.open(Servers2, name, url)
                
    def cancel(self):
#                self.session.nav.stopService()
#                self.session.nav.playService(self.srefOld)
                Screen.close(self, False)

               		
		
class Servers2(Screen):

    def __init__(self, session, name, url):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin
		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
                self.name = name
                self.url = url
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
	        self.names = []
	        self.urls = []
                content = getUrl(self.url)
                pass#print "content B =", content
                regexcat = '\#EXTINF\:(.*?)\\n(.*?)\\n'
                match = re.compile(regexcat,re.DOTALL).findall(content)
                pass#print "match =", match
                for name, url in match:
                        url1 = url[:-1]
                        items = name.split(",")
                        name1 = items[1][:-1]
                        
                        self.names.append(name1)               
                        self.urls.append(url1)
                
                showlist(self.names, self["list"])
                
    def okClicked(self):
    	   idx = self["list"].getSelectionIndex()
    	   if idx is None:
                return
    	   else:
                name = self.names[idx]
    	        url = self.urls[idx]
    	        self.session.open(Playstream1, name, url)
                
    def cancel(self):
#                self.session.nav.stopService()
#                self.session.nav.playService(self.srefOld)
                Screen.close(self, False)

##################################

class Playstream1(Screen):

    def __init__(self, session, name, url):
		if DESKHEIGHT > 1000:
		       self.skin = FullHD.skin
		else:
                       self.skin = HD.skin
		Screen.__init__(self, session)

#        	self["list"] = MenuList([])
                #############################################                
		self.list = []                
#                self["list"] = List(self.list)
                self["list"] = RSList([])
                #############################################
		self["info"] = Label()
		self["key_red"] = Button(_("Exit"))
		self["key_green"] = Button(_("Select"))
                self["setupActions"] = ActionMap(["SetupActions", "ColorActions", "TimerEditActions"],
		{
			"red": self.close,
			"green": self.okClicked,
			"cancel": self.cancel,
			"ok": self.okClicked,
		}, -2)
                self.name1 = name
                self.url = url
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):	
                url = self.url
	        self.names = []
	        self.urls = []
                self.names.append("Play")
                self.urls.append(url)
                self.names.append("Play-Method2")
                url2 = url.replace(".ts", ".m3u8")
                self.urls.append(url2)
                self.names.append("Play-Method3")
                url3 = url.replace(".ts", ".m3u8")
                self.urls.append(url3)
                self.names.append("Play with Vlc")
                self.urls.append(url)
                showlist(self.names, self["list"])
                
    def okClicked(self):
    	   idx = self["list"].getSelectionIndex()
    	   if idx is None:
                return
           elif idx == 2: 
                self.name = self.names[idx]
    	        self.url = self.urls[idx]
                if "m3u8" in self.url:
                            try:os.remove("/tmp/hls.avi")
                            except:pass                          
                            cmd = 'python "/usr/lib/enigma2/python/Plugins/Extensions/IPTVworld/lib/hlsclient.py" "' + self.url + '" "1" &'
                            os.system(cmd)
                            os.system('sleep 3')
                            self.url = '/tmp/hls.avi'                
                self.play()

           elif idx == 3: 
                self.name = self.names[idx]
    	        self.url = self.urls[idx] 
                try:
                      from Plugins.Extensions.VlcPlayer.VlcServerConfig import vlcServerConfig
                      self.serverList = vlcServerConfig.getServerlist()
		      if len(self.serverList) == 0:
		             self.session.open(MessageBox, "No server configured in VlcPlayer Plugin!", MessageBox.TYPE_ERROR)
		      elif len(self.serverList) == 1:
		             self.playfile(0)
		      else:
		             self.playfile(0)
                except:
                      txt = _("Plugin VlcPlayer is not installed.\nPlease install it and set it up.")
                      self.session.open(MessageBox, "Plugin VlcPlayer is not installed!", MessageBox.TYPE_ERROR)
                
    	   else:
                self.name = self.names[idx]
    	        self.url = self.urls[idx]
    	        self.play()

    def playfile(self, serverint):
#          print "In playfile self.url =", self.url
#          print "In playfile self.name =", self.name
 	  self.serverList[serverint].play(self.session, self.url, self.name)
    	        
    def play(self):
               desc = " "
               url = self.url
               name = self.name
               self.session.open(Playstream2, self.name1, url)
    	        
                
    def cancel(self):
#                self.session.nav.stopService()
#                self.session.nav.playService(self.srefOld)
                Screen.close(self, False)

##################################


           		
class Playstream2(Screen, InfoBarMenu, InfoBarBase, InfoBarSeek, InfoBarNotifications, InfoBarShowHide):
    
    def __init__(self, session, name, url):
		
		Screen.__init__(self, session)
                self.skinName = "MoviePlayer"
		title = "Play"
        	self["list"] = MenuList([])
		InfoBarMenu.__init__(self)
		InfoBarNotifications.__init__(self)
		InfoBarBase.__init__(self)
		InfoBarShowHide.__init__(self)
		self["actions"] = ActionMap(["WizardActions", "MoviePlayerActions", "EPGSelectActions", "MediaPlayerSeekActions", "ColorActions", "InfobarShowHideActions", "InfobarActions"],
		{
			"leavePlayer":		        self.cancel,
			"back":				self.cancel,
		}, -1)

		self.allowPiP = False
		InfoBarSeek.__init__(self, actionmap = "MediaPlayerSeekActions")
		url = url.replace(":", "%3a")
                self.url = url
                self.name = name
                self.srefOld = self.session.nav.getCurrentlyPlayingServiceReference()
                self.onLayoutFinish.append(self.openTest)

    def openTest(self):                
                url = self.url
                ref = "4097:0:1:0:0:0:0:0:0:0:" + url
                sref = eServiceReference(ref)
		sref.setName(self.name)
		self.session.nav.stopService()
		self.session.nav.playService(sref)
           

    def cancel(self):
                if os.path.exists("/tmp/hls.avi"):
                       os.remove("/tmp/hls.avi")
                self.session.nav.stopService()
                self.session.nav.playService(self.srefOld)
                self.close()

    def keyLeft(self):
		self["text"].left()
	
    def keyRight(self):
		self["text"].right()
	
    def keyNumberGlobal(self, number):
		self["text"].number(number)	

_session = ""
newvers = ""

def findmax(match = []):
                A = []
                B = []
                C = []
                D = []
                E = []
                for item in match:
                        item = item.replace("%7E", "~")
                        x = item.split(".")
                        pass#pass#print "x =", x
                        A.append(int(x[0]))
                lx = len(x)        
                Amax = max(A) 
                maxitem = str(Amax)
                if lx > 1:
                    for item in match:        
                        x = item.split(".")
                        if int(x[0]) == int(Amax):
                                B.append(int(x[1]))
                        else:
                                continue         
                    Bmax = max(B) 
                    maxitem = str(Amax) + "." + str(Bmax)
                    if lx > 2:
                      for item in match:        
                        x = item.split(".")
                        if (int(x[0]) == int(Amax)) and (int(x[1]) == int(Bmax)):
                                C.append(int(x[2]))
                      Cmax = max(C) 
                      maxitem = str(Amax) + "." + str(Bmax) + "." + str(Cmax)                         
                return maxitem        
                
	

def checkvers():
                pass#print  "In checkvers 1"
                name = "plugin.video.kodilivetv"
#            try:
                url2 = "http://vaniarupeni.altervista.org/repo/"
                pass#print  "In checkvers 2 url2 =", url2
                fpage = urllib2.urlopen(url2, timeout=10).read()

                pass#print "In newvers fpage =", fpage
                rx = name + '-(.*?).zip'
                match = re.compile(rx,re.DOTALL).findall(fpage)
                pass#print  "match =", match
                latest = findmax(match) 
                pass#print  "latest =", latest
                return latest
#            except:    
#                pass

def main(session,**kwargs):
        global _session
        _session = session
##############################   
        upd1 = ""
        if fileExists("/etc/kdlive"): 
		 myfile = file(r"/etc/kdlive")
                 icount = 0
                 for line in myfile.readlines():
                         pass#print  "In main line =", line
                         if icount == 0:
                                 upd1 = line
                                 break
                                 icount = icount+1
                                 myfile.close()
        else:   
                 upd1 = ""
        version = upd1
        pass#print "In main version = ", version
        global newvers
        newvers = checkvers()
        if newvers != version:
                       pass#print "In main newvers != version =", newvers
                       dest = "/tmp/kdlive.zip"
                       xfile = "http://vaniarupeni.altervista.org/repo/plugin.video.kodilivetv-" + newvers + ".zip" 
                       downloadPage(xfile, dest).addCallback(getdone).addErrback(showError)
        else:       
                       finish()        
def showError(error):
                pass#print "ERROR :", error
                upd_done1()
        
def getdone(fplug): 
                       tfile = path
                       cmd1 = "rm -rf " + tfile
                       fdest = "/tmp/"
                       plug = "plugin.video.kodilivetv"
                       cmd2 = "unzip -o -q '/tmp/kdlive.zip' -d " + fdest
                       cmd3 = "cp -rf '/tmp/plugin.video.kodilivetv/resources/channels' " + THISPLUG
                       cmd4 = "rm '/tmp/kdlive.zip'"
                       cmd5 = "rm -rf '/tmp/plugin.video.kodilivetv'"
                       cmd = cmd1 + " && " + cmd2 + " && " + cmd3 + " && " + cmd4 + " && " + cmd5
                       os.system(cmd)
                       file1 = "/etc/kdlive"
                       f1=open(file1,"w")
                       txt = newvers + "\n"
                       f1.write(txt)
                       f1.close()
                       upd_done1()
                       #################        
        
###########################  
def upd_done1():      
                session = _session
                dest = THISPLUG + "/userbouquet.hdf.tv"
                xfile = "https://github.com/pixbox-hdf/HDFreaks/raw/master/IPTV/userbouquet.iptv.tv" 
                downloadPage(xfile, dest).addCallback(getdone2).addErrback(showError2)
                
def showError2(error):
                pass#print "ERROR :", error
                session = _session
                session.open(IPTVworld)
                
def getdone2(res):                
                session = _session
                session.open(IPTVworld)
		

def Plugins(**kwargs):
	return PluginDescriptor(name="IPTVworld", description="IPTV stream player", where = PluginDescriptor.WHERE_PLUGINMENU, fnc=main)
