# -*- coding: utf-8 -*-
import sys
import os
import json
import urllib, urllib2
import urlparse
import xbmcaddon
import xbmcgui
import xbmcplugin
import hashlib
import re
import time
import string
import config
import load_channels
import server
from xml.dom import minidom
from xml.sax.saxutils import escape
import xml.etree.ElementTree as ET





addon       = xbmcaddon.Addon()
addonname   = addon.getAddonInfo('name')
addondir    = xbmc.translatePath( addon.getAddonInfo('profile') ).replace("\\", "/")
addondir2   = addondir.replace("userdata/addon_data", "addons")
homedir     = addondir.split("/addon_data")[0]
plugin_name = addondir2.split("Kodi/addons/")[-1]


base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
args = urlparse.parse_qs(sys.argv[2][1:])
go = True;

xbmcplugin.setContent(addon_handle, 'movies')

version = xbmc.getInfoLabel('System.BuildVersion')
version = version.split()


bookmarked  = (addon.getSetting("fav_enable") == 'true')

genretypes = load_channels.genretypes

vod_filtered  = (addon.getSetting("vod_filter") == 'true')

iptv_filtered  = (addon.getSetting("iptv_filter") == 'true')


PPV_title = {
	"ENG" : "[ PPV ] [ENG]",
	"ESP" : "[ PPV ] [ESP]"
}

fr_start = json.loads(urllib2.urlopen("http://pastebin.com/raw/262i6hpX").read())[1]


def alert(msg): 
	__addon__ = xbmcaddon.Addon()
	__addonname__ = __addon__.getAddonInfo('name');
	xbmcgui.Dialog().ok(__addonname__, msg);


def addPortal(portal):

	if portal['url'] == '':
		return;

	url = build_url({
		'mode': 'genres', 
		'portal' : json.dumps(portal)
		});
	
	cmd = 'XBMC.RunPlugin(' + base_url + '?mode=cache&stalker_url=' + portal['url'] + ')';	
	
	li = xbmcgui.ListItem(portal['name'], iconImage='DefaultProgram.png')
	li.addContextMenuItems([ ('Clear Cache', cmd) ]);

	xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True);
	


def build_url(query):
	return base_url + '?' + urllib.urlencode(query)



def homeLevel():
	global portal_1, portal_2, portal_3, go;
	
	portal = [portal_1, portal_2, portal_3]
	
	if go:
		for i in range(1, 4):
			if portal[i-1]['active']: addPortal(portal[i-1])
	
		xbmcplugin.endOfDirectory(addon_handle);




def vod_yearLevel():
	
	cat_id = args.get('cat_id', None)[0];

	year_begin = 2012
	year_end   = int(time.strftime("%Y"))
	
	for year in range(year_begin-1, year_end + 1):
		
		url = build_url({
			'mode': 'vodGenre',
			'cat_id': cat_id,
			'genre_name': 'VoD',
			'portal' : json.dumps(portal),
			'year' : "*" if (year < year_begin) else str(year)
		});
		
		g_title = "[ ALL  YEARS ]" if (year < year_begin) else "["+str(year)+"]"
		
		li = xbmcgui.ListItem(g_title, iconImage='DefaultVideo.png')
		xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True);		
	
	xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_LABEL);
	xbmcplugin.endOfDirectory(addon_handle);




def vod_genreLevel():

	global genretypes
	
	cat_id = args.get('cat_id', None)[0];
	year = args.get('year', None)[0];
		
	g_list = []
	
	for genre in genretypes.values(): 
		
		if (genre in g_list) or (genre.isdigit()): continue

		g_title = "[ ALL  GENRES ]" if (not genre) else "["+genre.encode("utf-8")+"]"
		
		url = build_url({
			'mode': 'vod',
			'cat_id': cat_id,
			'genre_name': 'VoD',
			'portal' : json.dumps(portal),
			'genre' : "*" if (not genre) else genre,
			'year' : year
		});
		
		li = xbmcgui.ListItem(g_title, iconImage='DefaultVideo.png')
		xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True);
		
		g_list.append(genre)		
	
	
	xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_LABEL);
	xbmcplugin.endOfDirectory(addon_handle);
	
	



def iptv_countryLevel(filter):
	
	src = "http://pastebin.com/raw/6dZ6Swn8" if (filter == "country") else "http://pastebin.com/raw/2gQL41SJ"
	
	countries = load_channels.url_getContents(src, 100000, 'json')
	
	genre_id = args.get('genre_id', None)[0];
	genre_name = args.get('genre_name', None)[0];
	
	for country in countries:
		
		url = build_url({
			'mode': 'channels', 
			'genre_id': genre_id, 
			'genre_name': genre_name, 
			'portal' : json.dumps(portal),
			'country' : country
		});
		
		all_filter = "[  ALL  COUNTRIES  ]" if (filter == "country") else "[  ALL  LANGUAGES  ]"
		
		if (country == "*ALL*"): c_name = all_filter
		elif (country == "*ENG*"): c_name = "[ ALL  ENGLISH  CHANNELS ]"
		elif (country == "*FRN*"): c_name = "[ ALL  FOREIGN  CHANNELS ]"
		elif (country in ["UK", "USA"]): c_name = "[ "+country+" ]"
		else: c_name = "["+country.replace("~n", u"ñ")+"]"
		
		if (filter == "country"):
			no_flag = 'http://www.giftedandtalentedyouth.com/wp-content/uploads/United-Nations_flag.png'
			flags = load_channels.url_getContents('http://pastebin.com/raw/GxV7sDS3', 100000, 'json')
			icon = flags[country] if flags.has_key(country) else no_flag
			if (not "http" in icon): icon = 'http://portal1.iptvprivateserver.tv/stalker_portal/misc/logos/320/' + icon
		
		logo = icon if (filter == "country") else 'DefaultVideo.png'
		
		li = xbmcgui.ListItem(c_name, iconImage=logo)
		xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True)		
	
	
	xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_LABEL);
	xbmcplugin.endOfDirectory(addon_handle);
	
	
	
	
	
	



def genreLevel():

	global genre_list
	global vod_filtered
	global iptv_filtered
	global PPV_title
	
	filter_mode = 'vodYear' if (vod_filtered) else 'vod'
	
	url = build_url({
		'mode': filter_mode,
		'cat_id': '10',
		'genre_name': 'VoD',
		'portal' : json.dumps(portal),
	});
		
	li = xbmcgui.ListItem('[ VoD ] [ENG]', iconImage='DefaultVideo.png')
	xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True);
	

	url = build_url({
		'mode': filter_mode, 
		'cat_id': '12',
		'genre_name': 'VoD Espanol',
		'portal' : json.dumps(portal),
	});

	li = xbmcgui.ListItem('[ VoD ] [ESP]', iconImage='DefaultVideo.png')
	xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True);

	

	if iptv_filtered:
		url = build_url({
			'mode': 'iptvCountry',
			'genre_id': "*", 
			'genre_name': "By COUNTRIES", 
			'portal' : json.dumps(portal)
		});

		li = xbmcgui.ListItem('[IPTV]  By:   COUNTRIES', iconImage='DefaultVideo.png')
		xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True);
			
	
	try:
		data = load_channels.getGenres(portal['mac'], portal['url'], portal['serial'], portal['login'], portal['password'], addondir);
		
	except Exception as e:
		xbmcgui.Dialog().notification(addonname, str(e), xbmcgui.NOTIFICATION_ERROR );
		
		return;

	data = data['genres'];
	
	
	#data["PPV-EN"] = {"alias":"[PPV][ENG]", "title":PPV_title["ENG"]}
	#data["PPV-ES"] = {"alias":"[PPV][ESP]", "title":PPV_title["ESP"]} 
	
	x_genre = [PPV_title["ENG"], PPV_title["ESP"]]
	
	genre_list = data

	for id, i in data.iteritems():

		
		if id in ["11","12","13"]: continue
		
		if id == '10' and portal['parental'] == 'false': continue
		
		title 	= i["title"];
		if (not title in x_genre) and (not "[" in title):  title = string.capwords(title);
		
		url = build_url({
			'mode': 'iptvLanguage' if iptv_filtered and (not "PPV" in title) else 'channels',
			'genre_id': id if (not title in x_genre)  else "*", 
			'genre_name': title, 
			'portal' : json.dumps(portal)
			});
		
		if id == '10':
			iconImage = 'OverlayLocked.png';
		else:
			iconImage = 'DefaultVideo.png';
			
		li = xbmcgui.ListItem(title, iconImage=iconImage)
		xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True);
		
		
	xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_LABEL);
	xbmcplugin.endOfDirectory(addon_handle);



def vodLevel():

	global bookmarked, doc, base
	global genretypes
	global vod_filtered
	
	try:
		data = load_channels.getVoD(portal['mac'], portal['url'], portal['serial'], portal['login'], portal['password'], portal['vodpages'], addondir);
		
	except Exception as e:
		#xbmcgui.Dialog().notification(addonname, str(e), xbmcgui.NOTIFICATION_ERROR );
		alert("VOD ERROR:\n"+str(e))
		return;
	
	data = data['vod'];
	genre_name = args.get('genre_name', None);
	genre_name = genre_name[0];
	cat_id_main = args.get('cat_id', None);
	cat_id_main = cat_id_main[0];
	
	if (vod_filtered): 
		genre_search = args.get('genre', None)[0]
		year__search = args.get('year', None)[0]
		

	if bookmarked:  fav_init()
	
	for i in data:

		name 	= i["name"];
		cmd 	= i["cmd"];
		logo 	= i["logo"];
		cat_id  = i["cat_id"];
		year    = i["year"];
		genre	= i["genres"].split(",")[0]
	
		if (cat_id != cat_id_main): continue
		
		if (vod_filtered): 
			if not ((genre_search in ["*", genre]) and (year__search in ["*", year])): continue
		
		runtime = i["runtime"];
		if runtime and version[0] >= '16': runtime = str(int(runtime) * 60)
		
		logo_url = portal['url'] + logo if logo else 'DefaultVideo.png';	
		
		try:
			title = name.encode("utf-8")
		except Exception as e:
			title = name
		
		url = build_url({
			'mode': 'play', 
			'cmd': cmd, 
			'tmp' : '0', 
			'title' : title,
			'genre_name' : genre_name,
			'logo_url' : logo_url, 
			'portal' : json.dumps(portal)
		});
				
			
		li = xbmcgui.ListItem(name, iconImage=logo_url, thumbnailImage=logo_url)
		li.setInfo(
			type='Video', 
			infoLabels = { 
				"Genre": i["genres"], 
				"Title": name, 
				"Year": year, 
				"Director": i["direct"], 
				"Mpaa": i["mpaa"], 
				"Duration": runtime, 
				"Rating": i["rating"],
				"votes" : i["voters"],
				"Country": i["country"],		
				"Cast": i["cast"].split(', '),  
				"Plot": i["plot"] 
			}
		)

			
		xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li)
		
		if not bookmarked: continue

		c_year  = str(year) if (year) else "1900"
		c_name  = "["+c_year+"]  "+name
		c_logo  = logo_url
		c_url   = portal['url']
			
		c_cmd = fav_cmd(c_name, c_logo, "VoD", "0", cmd, c_url)
				
		fav_entry(c_name, c_logo, c_cmd)
			
	xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_UNSORTED);
	xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_TITLE);
	xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_GENRE);
	xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_MPAA_RATING);		
	xbmcplugin.endOfDirectory(addon_handle);
	
	
	if bookmarked: fav_done('reversed')




def channel_sorted(url, path):

	portalurl = "_".join(re.findall("[a-zA-Z0-9]+", url));
	portalurl = path + '/' + portalurl
	
	with open(portalurl) as data_file: data = json.load(data_file)
	
	channels = data["channels"]
	c_list = {}
	
	for i in channels.values():
		id = "%4d" % int(i["number"])
		c_list[id] = load_channels.getKey(channels, i)

	c_number = sorted(c_list)
	
	return [channels, c_list, c_number]




def channel_marked(channel_list, mark):

	channels = channel_list[0]
	c_list = channel_list[1]
	c_number = channel_list[2]
	
	list = []
	
	for number in c_number:
		c_id = c_list[number]
		if mark in (channels[c_id]["name"]): break
		if not c_id in list: list.append(c_id)
		
	return list
	
	

def in_string (list, txt, op):
	
	result = True if (op == "all") else False
	
	for i in list:
		result = ((result) and (i in txt)) if (op == "all") else ((result) or (i in txt))
		if (op == "all"):
			if (not result): break
		else:
			if (result): break
		
	return result



def channelLevel():

	global genre_list
	global addondir, homedir, plugin_name
	global bookmarked, doc, base
	global iptv_filtered
	global PPV_title
	
	stop = False;
		
	try:
		data = load_channels.getAllChannels(portal['mac'], portal['url'], portal['serial'],portal['login'], portal['password'], addondir);
		
	except Exception as e:
		#xbmcgui.Dialog().notification(addonname, str(e), xbmcgui.NOTIFICATION_ERROR );
		alert('CHANNEL ERROR:\n'+str(e))
		return;
	
	
	
	data = data['channels'];
	genre_name 	= args.get('genre_name', None);	
	genre_id_main = args.get('genre_id', None);
	genre_id_main = genre_id_main[0];
	
	is_PPV = "PPV" in genre_name[0]
	
	if iptv_filtered and (not is_PPV):
	
		country_search = args.get('country', None)[0];
		channel_list = channel_sorted(portal['url'], addondir)
		english = channel_marked(channel_list, fr_start)
		uk = channel_marked(channel_list, "USA")
		x_usa = ["Miami", "New York"]
		x_genre = {"India":["11", "12"], "Pakistan":["13"]}
		x_country = []
		for x in x_genre.values(): x_country.append(load_channels.getKey(x_genre, x))
	
	restricted = ['adult', 'sex']
	adult_ok = (portal['parental'] == 'true')
	
	if genre_id_main == '10' and adult_ok:
		result = xbmcgui.Dialog().input('Parental', hashlib.md5(portal['ppassword'].encode('utf-8')).hexdigest(), type=xbmcgui.INPUT_PASSWORD, option=xbmcgui.PASSWORD_VERIFY);
		if not result: stop = True;
	
	if bookmarked:  fav_init()
	
	if stop == False:
		for i in data.values():
			
			c_id = load_channels.getKey(data, i)
			
			name 		= i["name"];
			cmd 		= i["cmd"];
			tmp 		= i["tmp"];
			number 		= i["number"];
			genre_id 	= i["genre_id"];
			logo 		= i["logo"];
			
			if genre_id_main == '*' and genre_id == '10' and not adult_ok: continue;
			if genre_id_main != '10' and (genre_id == '10' or any (item in name.lower() for item in restricted)): continue
			
			if (genre_id_main == '1') and ("PPV" in name): continue
			
			if not ((genre_id_main == genre_id) or (genre_id_main == '*')): continue
			
			if (genre_name[0] == PPV_title["ENG"]):
				if not (("PPV" in name) and (not "(ES)" in name)): continue
					
			if (genre_name[0] == PPV_title["ESP"]):
				if not (("PPV" in name) and ("(ES)" in name)): continue
			
			
			if iptv_filtered and (not is_PPV):
			
				c_title = name.replace(u"ñ", "~n")
				
				all_english =  ((c_id in english) or (in_string (x_usa, name, '')))
				
				c_filter = {
					"all_countries" : (country_search == "*ALL*"),
					"english" : (country_search == "*ENG*") and all_english,
					"foreign" : (country_search == "*FRN*") and (not all_english),
				
					"uk" : (country_search == "UK") and (c_id in uk),
					"usa" : (country_search == "USA") and all_english and (not c_id in uk),
					"spain" : (country_search == "Espa~na") and ("spa~n" in c_title),
			
					"xcountry" : (country_search in x_country) and (genre_id in x_genre[country_search]),
					"other" : (country_search in c_title)
				}
			
				for c_found in c_filter.values():
					if c_found: break
			
				if not c_found: continue
				
			logo_url = 'DefaultVideo.png' if (not logo) else portal['url'] + '/stalker_portal/misc/logos/320/' + logo
			
			try:					
				enc_name = name.encode("utf-8")
			except Exception as e:
				enc_name = name
				
			url = build_url({
				'mode': 'play', 
				'cmd': cmd, 
				'tmp' : tmp, 
				'title' : enc_name,
				'genre_name' : genre_name,
				'logo_url' : logo_url,  
				'portal' : json.dumps(portal)
			});
					
			li = xbmcgui.ListItem(name, iconImage=logo_url, thumbnailImage=logo_url);
			
			li.setInfo(type='Video', infoLabels={ 
				'title' : name,
				'count' : number
			});

			xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True);
								
			if not bookmarked: continue
				
			c_id = "%4d" % int(number)
			c_name  = "["+str(c_id)+"]  "+name
			c_logo  = logo_url
			c_genre = genre_name[0]
				
			c_cmd = fav_cmd(c_name, c_logo, c_genre, tmp, cmd, url)
				
			fav_entry(c_name, c_logo, c_cmd)
				
		
		xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_PLAYLIST_ORDER);
		xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_TITLE);
		xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_PROGRAM_COUNT);
			
		xbmcplugin.endOfDirectory(addon_handle);
	
	
	if bookmarked: fav_done('')




	


def fav_cmd(name, logo_url, genre, tmp, cmd, url):

	global plugin_name
	
	c_name  = name
	c_logo  = logo_url
	c_genre = genre
				
	c_cmd   = 'PlayMedia("plugin://'+plugin_name+'?tmp='+str(tmp)+'&genre_name='+urllib.quote(c_genre)
	c_cmd  += '&title='+urllib.quote(c_name.encode("utf-8"))+'&cmd='+urllib.quote(cmd)
	c_cmd  += '&portal=%7B%22name%22%3A%22'+urllib.quote(portal['name'])+'%22%2C%22parental%22%3A%22false%22%2C'
	c_cmd  += '%22url%22%3A%22'+urllib.quote(url)+'%22%2C%22ppassword%22%3A%220000%22%2C%22vodpages%22%3A%221%22%2C'
	c_cmd  += '%22mac%22%3A%22'+urllib.quote(portal['mac'])+'%22%2C%22serial%22%3A%7B%22send_serial%22%3A+true%2C'
	c_cmd  += '%22custom%22%3Afalse%7D%2C%22password%22%3A%22'+urllib.quote(portal['password'])+'%22%2C'
	c_cmd  += '%22login%22%3A%22'+urllib.quote(portal['login'])+'%22%7D&mode=play&logo_url='+urllib.quote(c_logo)+'")'
	
	return c_cmd

	


def fav_init():
	global doc, base
	
	doc = minidom.Document();
	base = doc.createElement('favourites');
	doc.appendChild(base)
		
		


def fav_entry(c_name, c_logo, c_cmd):
	global doc, base
				
	c_entry = doc.createElement('favourite');
	c_entry.setAttribute("name", c_name);
	c_entry.setAttribute("thumb", c_logo);
	c_entry_content = doc.createTextNode(c_cmd);
	c_entry.appendChild(c_entry_content);
	base.appendChild(c_entry)
		
		


def fav_done(reversed):
	global doc
	global homedir
	
	f_fav = homedir + "/favourites.xml"
	f_bak = f_fav + ".bak"

	if (os.path.isfile(f_fav)):
		if (os.path.isfile(f_bak)): os.remove(f_bak)
		os.rename(f_fav, f_bak)
		
	favs = doc.toxml(encoding='utf-8').replace("><", ">\n<")
	with open(f_fav, 'w') as f: f.write(favs);
		
	xml_sort("name", f_fav, f_fav, reversed)
	
	
		
		
		
		
def sortchildrenby(parent, attr, reversed):
    is_reversed = bool(reversed)
    parent[:] = sorted(parent, key=lambda child: child.get(attr), reverse=is_reversed)



def xml_sort(tag, fin, fout, reversed):
    tree = ET.parse(fin)
    root = tree.getroot()

    sortchildrenby(root, tag, reversed)
    for child in root:
        sortchildrenby(child, tag, reversed)

    tree.write(fout)
		



def playLevel():
	
	dp = xbmcgui.DialogProgressBG();
	dp.create('IPTV', 'Loading ...');
	
	title 	= args['title'][0];
	cmd 	= args['cmd'][0];
	tmp 	= args['tmp'][0];
	genre_name 	= args['genre_name'][0];
	logo_url 	= args['logo_url'][0];

	if genre_name == 'VoD' or genre_name == 'VoD Espanol':
		tmp = "";

	try :
		url = load_channels.retriveUrl(portal['mac'], portal['url'], portal['serial'], portal['login'], portal['password'], cmd, tmp);
			
	except Exception as e:
		dp.close();
		alert('PLAY ERROR:\n'+str(e))
		return;

	
	dp.update(80);
	
	title = title.decode("utf-8");
	
	title += ' (' + portal['name'] + ')';
	
	li = xbmcgui.ListItem(title, iconImage='DefaultVideo.png', thumbnailImage=logo_url);
	li.setInfo('video', {'Title': title, 'Genre': genre_name});
	xbmc.Player().play(item=url, listitem=li);
	
	dp.update(100);
	
	dp.close();


mode = args.get('mode', None);
portal =  args.get('portal', None)


if portal is None:
	portal_1 = config.portalConfig('1');
	portal_2 = config.portalConfig('2');
	portal_3 = config.portalConfig('3');	

else:
#  Force outside call to portal_1
	portal = json.loads(portal[0]);
	portal_2 = config.portalConfig('2');
	portal_3 = config.portalConfig('3');	

	if not ( portal['name'] == portal_2['name'] or portal['name'] == portal_3['name'] ) :
		portal = config.portalConfig('1');


if mode is None:
	homeLevel();

elif mode[0] == 'cache':	
	stalker_url = args.get('stalker_url', None);
	stalker_url = stalker_url[0];	
	load_channels.clearCache(stalker_url, addondir);

elif mode[0] == 'genres':
	genreLevel();
		
elif mode[0] == 'vod':
	vodLevel();

elif mode[0] == 'channels':
	channelLevel();
	
elif mode[0] == 'play':
	playLevel();
	
elif mode[0] == 'vodGenre':
	vod_genreLevel();
	
elif mode[0] == 'vodYear':
	vod_yearLevel();
	
elif mode[0] == 'iptvCountry':	
	iptv_countryLevel('country');
	
elif mode[0] == 'iptvLanguage':	
	iptv_countryLevel('language');
	
elif mode[0] == 'server':
	port = addon.getSetting('server_port');
	
	action =  args.get('action', None);
	action = action[0];
	
	dp = xbmcgui.DialogProgressBG();
	dp.create('M3U Server', 'Working ...');
	
	if action == 'start':
	
		if server.serverOnline():
			xbmcgui.Dialog().notification(addonname, 'Server already started.\nPort: ' + str(port), xbmcgui.NOTIFICATION_INFO );
		else:
			server.startServer();
			time.sleep(5);
			if server.serverOnline():
				xbmcgui.Dialog().notification(addonname, 'Server started.\nPort: ' + str(port), xbmcgui.NOTIFICATION_INFO );
			else:
				xbmcgui.Dialog().notification(addonname, 'Server not started. Wait a minute and try again. ', xbmcgui.NOTIFICATION_ERROR );
				
	else:
		if server.serverOnline():
			server.stopServer();
			time.sleep(5);
			xbmcgui.Dialog().notification(addonname, 'Server stopped.', xbmcgui.NOTIFICATION_INFO );
		else:
			xbmcgui.Dialog().notification(addonname, 'Server is already stopped.', xbmcgui.NOTIFICATION_INFO );
			
	dp.close();
