import sys
import json
import urllib
import urlparse
import xbmcplugin
import xbmcaddon
from xbmcgui import ListItem
from xbmcplugin import addDirectoryItem, endOfDirectory

addon = xbmcaddon.Addon()
addon_handle = int(sys.argv[1])
args = urlparse.parse_qs(sys.argv[2][1:])
menu = args.get('menu', None)
list_size = int(addon.getSetting('list_size'))
lang = addon.getLocalizedString

def url(pQuery):
    return sys.argv[0] + '?' + urllib.urlencode(pQuery)

def jsonrpc(query):
    return json.loads(xbmc.executeJSONRPC(json.dumps(query, encoding='utf-8')))

def list_items(items, type):
    xbmcplugin.setContent(addon_handle, type)
    for item in items:
        if type=='movies': id = item['movieid']
        elif type=='episodes': id = item['episodeid']
        elif type=='musicvideos': id = item['musicvideoid']
        elif type=='songs': id = item['songid']
        li = ListItem(label=item['title'])
        li.setProperty('idx', str(id))
        addDirectoryItem(addon_handle, item['file'], li, False, len(items))
    endOfDirectory(addon_handle)
	
def get_items(pMethod, pResult):
    query = { "jsonrpc": "2.0", "method": pMethod, "id": 1,
        "params": { "properties": ["title", "file" ], "sort": { "order": "descending", "method": "lastplayed" },  "limits": {"start" : 0, "end" : list_size } }
    }
    items = jsonrpc(query)['result'].get(pResult, [])
    return items
	
if menu is None:
    xbmcplugin.setContent(addon_handle, "menu")
    imgPath=xbmc.translatePath(xbmcaddon.Addon().getAddonInfo('path')).decode('utf-8')
    addDirectoryItem(addon_handle, url({'menu': 'movies'}), ListItem(lang(30002), iconImage=imgPath+'/resources/movies.png'), True)
    addDirectoryItem(addon_handle, url({'menu': 'episodes'}), ListItem(lang(30003), iconImage=imgPath+'/resources/episodes.png'), True)
    addDirectoryItem(addon_handle, url({'menu': 'musicvideos'}), ListItem(lang(30004), iconImage=imgPath+'/resources/musicvideos.png'), True)
    addDirectoryItem(addon_handle, url({'menu': 'songs'}), ListItem(lang(30005), iconImage=imgPath+'/resources/songs.png'), True)
    endOfDirectory(addon_handle)
elif menu[0] == 'movies':
    list_items(get_items("VideoLibrary.GetMovies","movies"),'movies')
elif menu[0] == 'episodes':
    list_items(get_items("VideoLibrary.GetEpisodes","episodes"),"episodes")
elif menu[0] == 'musicvideos':
    list_items(get_items("VideoLibrary.GetMusicVideos","musicvideos"),"musicvideos")
elif menu[0] == 'songs':
    list_items(get_items("AudioLibrary.GetSongs","songs"),"songs")
