from xbmcswift2 import Plugin
import urllib2
from cookielib import CookieJar
import resources.lib.utils as utils
import resources.lib.scraper as scraper

plugin = Plugin()
cj = CookieJar()
opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cj))
urllib2.install_opener(opener)

@plugin.cached_route('/')
def index():
  shows = scraper.get_shows()
  return utils.create_listitems(shows)

@plugin.cached_route('/shows/<show>')
def list_seasons(show):
  seasons = scraper.get_seasons(show)
  return utils.create_listitems(seasons)

@plugin.cached_route('/shows/<show>/seasons/<season>')
def list_episodes(show, season):
  episodes = scraper.get_episodes(show, season)
  if len(episodes) > 0:
    return utils.create_listitems(episodes)
  else:
    plugin.redirect(plugin.url_for('play_episode', show=show, season=season, episode='1'))

@plugin.route('/shows/<show>/seasons/<season>/episodes/<episode>')
def play_episode(show, season, episode):
  video_urls = scraper.get_video_urls(show, season, episode)
  if not video_urls:
    email = plugin.get_setting('email')
    password = plugin.get_setting('password')
    login_result = scraper.do_login(email, password)
  if video_urls or (login_result and login_result.group(0) == "success"):
    video_urls = video_urls or scraper.get_video_urls(show, season, episode)
    if video_urls:
      use_hd_streams = plugin.get_setting('use_hd_streams')
      if use_hd_streams:
        video_url = video_urls['hd']
      else:
        video_url = video_urls['sd']
      return plugin.set_resolved_url(video_url)
    else:
      plugin.notify("Error finding video stream URL")
  elif login_result and login_result.group(0) == "Invalid":
    plugin.notify("Invalid email or password")
  else:
    plugin.notify("Unknown error on log in")
  return False

if __name__ == '__main__':
  plugin.run()
