import re

# create xbmcswift2 listitems from a scraped list
def create_listitems(my_list):
  listitems = []
  for item in my_list:
    listitem = {
        'label': item['name'],
        'path': 'plugin://plugin.video.swearnet' + item['path'],
    }
    if item.has_key('playable'):
      listitem['is_playable'] = True
    if item.has_key('thumbnail'):
      listitem['thumbnail'] = item['thumbnail']
    if item.has_key('info'):
      listitem['info'] = item['info']
    listitems.append(listitem)

  return listitems

def extract_thumbnail_from_background(style):
  match = re.match("background-image:url\((.+)\);", style)
  if match:
    return match.group(1)
  else:
    return ''
