from BeautifulSoup import BeautifulSoup
from cookielib import CookieJar
import re
from urlparse import urljoin
from urllib import urlencode, quote_plus
import urllib2
import utils

SWEARNET_BASE_URL = "https://www.swearnet.com"
USER_AGENT = "Mozilla/5.0 (Windows NT 6.3; Trident/7.0; rv:11.0) like Gecko"

# Get list of shows
def get_shows():
  tree = __get_tree(SWEARNET_BASE_URL)
  shows = []
  container = tree.find('div', {'class': 'flex-container home_shows'})
  for a in container.findAll('a'):
    shows.append({
      'path': a['href'],
      'name': a['title'],
      'thumbnail': a.img['src']
  })

  # plots aren't shown on home page
  plot_tree = __get_tree(urljoin(SWEARNET_BASE_URL, '/shows'))
  container = plot_tree.find('div', {'class': 'flex-container'})
  plot_map = {}
  for div in container.findAll('div', {'class': 'child'}):
    plot_map[div.a['href']] = div.div.contents[0].strip()
  for show in shows:
    show['info'] = { 'plot': plot_map[show['path']] }

  return shows

# Get list of seasons for a show
def get_seasons(show):
  # shows with only one season redirect to the season detail page
  show_url = urljoin(SWEARNET_BASE_URL, '/shows/' + show)
  response = __get_html(show_url)
  if response.geturl() != show_url:
    return get_episodes(show, '1')

  seasons = []
  tree = BeautifulSoup(response, convertEntities=BeautifulSoup.HTML_ENTITIES)
  for div in tree.findAll('div', {'class': 'child'}):
    seasons.append({
      'path': div.a['href'],
      'name': div.div.a.h.contents[0].strip(),
      'thumbnail': utils.extract_thumbnail_from_background(div['style']),
      'info': {
        'plot': div.div.contents[2].strip()
      }
    })

  return seasons

# Get list of episodes for a season of a show
def get_episodes(show, season):
  season_url = urljoin(SWEARNET_BASE_URL, '/shows/' + show + '/seasons/' + season)
  response = __get_html(season_url)
  tree = BeautifulSoup(response, convertEntities=BeautifulSoup.HTML_ENTITIES)
  episodes = []

  if tree.find('div', {'class': 'video_embed'}):
    episodes.append({
      'path': '/shows/' + show + '/seasons/' + season + '/episodes/1',
      'name': tree.find('div', {'id': 'show_info'}).h3.contents[0].strip(),
      'info': {
        'plot': tree.find('div', {'id': 'show_desc'}).contents[0].strip()
      },
      'playable': True
    })
  else:
    for div in tree.findAll('div', {'class': 'child large'}):
      episodes.append({
        'path': div.a['href'],
        'name': div.a.div.h4.contents[0].strip(),
        'thumbnail': utils.extract_thumbnail_from_background(div['style']),
        'info': {
          'plot': div.a.div.p.contents[0].strip()
        },
        'playable': True
      })

  return episodes

def get_video_urls(show, season, episode):
  # scrape episode page to find external id and create player iframe url
  episode_path = '/shows/' + show + '/seasons/' + season + '/episodes/' + episode
  episode_url = urljoin(SWEARNET_BASE_URL, episode_path)
  episode_tree = __get_tree(episode_url)
  external_id = ''
  video_urls = {}

  video_embed = episode_tree.find('div', {'class': 'video_embed'})

  if video_embed and video_embed.script:
    match = re.search('var externalid = "(.+)";', video_embed.script.contents[0])
    if match:
      external_id = match.group(1)
      player_iframe_url = "https://play.vidyard.com/" + external_id + \
                          ".html?type=inline&v=2.2&referring_url=" + \
                          quote_plus(episode_url) + "&"

      # request iframe html (remember to set referer!)
      player_iframe_tree = __get_tree(player_iframe_url, referer=episode_url)
      if not player_iframe_tree:
        return {}
      player_iframe_body = player_iframe_tree.find('body')

      # scrape iframe html to find media URLs
      player_iframe_script = player_iframe_body.script.contents[0]
      sd_match = re.search("'sd_url': '(.*)'", player_iframe_script)
      if sd_match:
        video_urls['sd'] = sd_match.group(1)
      hd_match = re.search("'hd_url': '(.*)'", player_iframe_script)
      if hd_match:
        video_urls['hd'] = hd_match.group(1)

  return video_urls

def do_login(email, password):
  success = False
  login_form_tree = __get_tree(urljoin(SWEARNET_BASE_URL, '/users/sign_in'))
  formdata = urlencode({
    'user[email]': email,
    'user[password]': password,
    'user[remember_me]': True,
    'authenticity_token': login_form_tree.find('meta', {'name': 'csrf-token'})['content']
  })
  login_url = urljoin(SWEARNET_BASE_URL, '/users/sign_in')
  tree = __get_tree(login_url, data=formdata)
  alerts = tree.find(id='alerts')
  if alerts and alerts.div and len(alerts.div.contents) > 1:
    s = re.search("(Invalid|success)", alerts.div.contents[1])
    if s:
      return s
  return False

def __get_tree(url, referer=None, data=None):
  html = __get_html(url, referer, data)
  return BeautifulSoup(html, convertEntities=BeautifulSoup.HTML_ENTITIES)

def __get_html(url, referer=None, data=None):
  req = urllib2.Request(url)
  req.add_header('Accept', 'text/html,application/xhtml+xml')
  req.add_header('User-Agent', USER_AGENT)
  if referer:
    req.add_header('Referer', referer)
  return urllib2.urlopen(req, data)
