#!/usr/bin/python
# -*- coding: utf-8 -*-

import urllib, urllib2
import xbmcplugin, xbmcaddon, xbmcgui, xbmc
import sys, os, re, json, base64, operator, datetime, time

pluginhandle = int(sys.argv[1])
addon = xbmcaddon.Addon()
settings = xbmcaddon.Addon( id = "plugin.video.onf" )
addon_path = xbmc.translatePath(os.path.join(xbmc.translatePath(os.path.join(xbmc.translatePath(os.path.join("special://","home")),"addons")),"plugin.video.onf"))
logo_path = os.path.join(addon_path,"icon.png")
fanart_path = os.path.join(addon_path,"fanart.jpg")
useragent = "Mozilla/5.0 (X11; Linux x86_64; rv:40.0) Gecko/20100101 Firefox/40.0"
base_url = "https://www.onf.ca"

def parameters_string_to_dict(parameters):
    paramDict = {}
    if parameters:
        paramPairs = parameters[1:].split("&")
        for paramsPair in paramPairs:
            paramSplits = paramsPair.split('=')
            if (len(paramSplits)) == 2:
                paramDict[paramSplits[0]] = paramSplits[1]
    return paramDict
    
def translation(id):
    return addon.getLocalizedString(id).encode('utf-8','ignore')

def get_code(url,refer):
    hdr = {'User-Agent': useragent, 'Referer': refer}
    req = urllib2.Request(url, headers=hdr)
    page = urllib2.urlopen(req)
    return page.read()

def addDir(name, url, mode, iconimage, fanart, desc, genre, duration, director, year):
    u = sys.argv[0]+"?url="+urllib.quote_plus(url)+"&mode="+str(mode)+"&title="+str(name)
    xbmcplugin.setContent(pluginhandle, 'movies')
    ok = True
    liz = xbmcgui.ListItem(name, iconImage=logo_path, thumbnailImage=fanart)
    if ( fanart != '' ):
        liz.setProperty("Fanart_Image", fanart)
    liz.setInfo(type="video", infoLabels={"Title": name, "Plot": desc, "Duration": duration, "Year": year, "Director" : director, "Genre": genre})
    ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u, listitem=liz, isFolder=True)
    return ok
    
def play_video(url,title):
    page = get_code(url,url)
    mp4list = re.findall('<url>mp4:(.*?)</url>', page)
    vid_url = "http://pstream.nfb.ca/"+mp4list[-1]
    liz = xbmcgui.ListItem(title, iconImage=logo_path, thumbnailImage=logo_path)
    xbmc.Player().play(vid_url,listitem=liz)

def video_list(url):
    page = get_code(url,url)
    sublist = re.findall('<a href="(.*?)" class="titre ">(.*?)</a>', page)
    fanart_list = re.findall('<img src="(.*?)" class=', page)
    info_list = re.findall('              (.*?) <span class="dash">|</span> (.*?) min', page)
    genre = re.findall('<h1 class="h2">(.*?) <span class=', page)
    itemid = 0
    for subject in sublist:
        if "spacer-thumbnails.jpg" not in fanart_list[itemid]:
            url2 = base_url+subject[0]+"/player_config"
            try:
                page = get_code(url2,url2)
                desc = re.findall('<description>(.*?)</description>', page)
                if desc:
                    descrip = desc[0].replace("&#39;","'")
                    p = re.compile(r'&lt;.*?&gt;')
                    descrip = p.sub('', descrip)
                else:
                    descrip =  "N/A"
                author = re.findall('<author>(.*?)</author>', page)
                if author:
                    director =  author[0].replace("&#39;","'")
                else:
                    director =  "N/A"
                addDir(subject[1].replace("&#39;","'"), url2, "video", logo_path, fanart_list[itemid], descrip, genre[0], int(info_list[(2*itemid)+1][1])*60, director, int(info_list[2*itemid][0]))
            except:
                pass
        itemid += 1
    xbmcplugin.endOfDirectory(pluginhandle)

def category(url):
    page = get_code(url,url)
    sublist = re.findall('<li id="sub_subject-(.*?)">\n                        <a href="/sujets/(.*?)" rel="tag">(.*?)</a></li>', page)
    for subject in sublist:
        title = subject[2].replace("&#39;","'")
        addDir(title, base_url+"/sujets/"+subject[1], "video_list", fanart_path, logo_path, "", "", "", "", "")
    xbmcplugin.endOfDirectory(pluginhandle)

def index(url):
    page = get_code(url,url)
    sublist = re.findall('<li id="subject-(.*?)"><a href="/sujets/(.*?)/" rel="tag">(.*?)</a></li>', page)
    for subject in sublist:
        title = subject[2].replace("&#39;","'")
        addDir(title, url+"/"+subject[1]+"/", "category", fanart_path, logo_path, "", "", "", "", "")
    xbmcplugin.endOfDirectory(pluginhandle)
    
params = parameters_string_to_dict(sys.argv[2])
mode = urllib.unquote_plus(params.get('mode', ''))
url = urllib.unquote_plus(params.get('url', ''))
title = urllib.unquote_plus(params.get('title', ''))

if mode == 'category':
    category(url)
elif mode == 'video_list':
    video_list(url)
elif mode == 'video':
    play_video(url,title)
else:
    index(base_url+"/sujets/")
