import base64
from os.path import join as pathjoin
from urlparse import urljoin
from resources.lib.common import diritem, action_url, profile_dir

base_url = 'http://icdrama.se'
cache_file = pathjoin(profile_dir, 'cache.pickle')
tracking_id = base64.b64decode('VUEtNzgwNTA2NTItMg==')

def rel2abs(relpath):
    return urljoin(base_url, relpath)

index_items = [
    diritem(33000, action_url('recent_updates', url=rel2abs('/recently-updated/'))),
    diritem(33001, action_url('shows', url=rel2abs('/hk-drama/'))),
    # the trailing forward slash is necessary
    # without it, page urls will be wrong (icdrama bug)
    diritem(33002, action_url('shows', url=rel2abs('/hk-movie/'))),
    diritem(33003, action_url('shows', url=rel2abs('/hk-show/'))),
    diritem(33004, action_url('shows', url=rel2abs('/chinese-drama/'))),
    diritem(33005, action_url('shows', url=rel2abs('/taiwanese-drama/'))),
    diritem(33006, action_url('shows', url=rel2abs('/korean-drama/'))),
    diritem(33007, action_url('shows', url=rel2abs('/korean-show/'))),
    diritem(33008, action_url('shows', url=rel2abs('/japanese-drama/'))),
    diritem(33009, action_url('shows', url=rel2abs('/movies/')))
]
