import sys
import xbmc
import xbmcgui
import xbmcaddon
import xbmcplugin
import urlresolver
from os.path import abspath, dirname
from urlresolver.hmf import HostedMediaFile
from urllib import urlencode

_plugin_url = sys.argv[0]
_handle = int(sys.argv[1])
_addon = xbmcaddon.Addon()
_dialog = xbmcgui.Dialog()

addon_name = _addon.getAddonInfo('name')
addon_id = _addon.getAddonInfo('id')
addon_version = _addon.getAddonInfo('version')
profile_dir = xbmc.translatePath(_addon.getAddonInfo('profile'))
get_string = _addon.getLocalizedString

def debug(s):
    xbmc.log(str(s), xbmc.LOGDEBUG)

def error(s):
    xbmc.log(str(s), xbmc.LOGERROR)

def action_url(action, **action_args):
    action_args['action'] = action
    for k, v in action_args.items():
        if type(v) is unicode:
            action_args[k] = v.encode('utf8')
    qs = urlencode(action_args)
    return _plugin_url + '?' + qs

def add_item(diritem):
    xbmcplugin.addDirectoryItem(**diritem)

def end_dir():
    xbmcplugin.endOfDirectory(_handle)

def diritem(label_or_stringid, url, image='', isfolder=True):
    if type(label_or_stringid) is int:
        label = get_string(label_or_stringid)
    else:
        label = label_or_stringid
    listitem = xbmcgui.ListItem(label, iconImage=image)
    # this is unpackable for xbmcplugin.addDirectoryItem
    return dict(
        handle   = _handle,
        url      = url,
        listitem = listitem,
        isFolder = isfolder
    )

def popup(s):
    try:
        # Gotham (13.0) and later
        _dialog.notification(addon_name, s)
    except AttributeError:
        _dialog.ok(addon_name, s)

def select(heading, options):
    return _dialog.select(heading, options)

def resolve(url):
    # import the resolvers so that urlresolvers pick them up
    import resources.lib.resolvers
    hmf = HostedMediaFile(url)
    return hmf.resolve()

def sleep(ms):
    xbmc.sleep(ms)

def back_dir():
    # back one directory
    xbmc.executebuiltin('Action(ParentDir)')

def run_plugin(url):
    xbmc.executebuiltin('RunPlugin(%s)' % url)

class _BusyIndicator():
    def __enter__(self):
        xbmc.executebuiltin('ActivateWindow(busydialog)')
    def __exit__(self, exc_type, exc_value, traceback):
        xbmc.executebuiltin('Dialog.Close(busydialog)')
busy_indicator = _BusyIndicator()
