import re
from resources.lib import settings, common

def show(eng, orig):
    if not orig.strip(' -'):
        return eng
    elif not eng.strip(' -'):
        return orig
    elif settings.title_lang == 1:
        return eng
    elif settings.title_lang == 2:
        return orig
    else:
        return ('%s - %s' % (eng, orig)).strip(' -')

def page(page):
    match = re.match(r'Page (\d+)', page)
    if match:
        page = common.get_string(33102) % match.group(1)
    elif 'First' in page:
        page = common.get_string(33103)
    elif 'Last' in page:
        page = common.get_string(33104)
    return '[I][ %s ][/I]' % page

def episode(episode):
    match = re.match(r'Episode (\d+)', episode)
    if match:
        return common.get_string(33105) % match.group(1)
    return episode

def mirror(mirror, part):
    match = re.match(r'(\d+)', part)
    if match:
        part = common.get_string(33106) % match.group(1)
    elif part == 'Full':
        part = common.get_string(33107)
    return '[B]%s[/B] : %s' % (mirror, part)
