import sys
import os
import urllib
import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon
import logging
from operator import itemgetter

def show_tags():
  tag_handle = int(sys.argv[1])
  xbmcplugin.setContent(tag_handle, 'tags')

  for tag in tags:
    iconPath = os.path.join(home, 'resources', 'media', tag['icon'])
    li = xbmcgui.ListItem(tag['name'], iconImage=iconPath)
    url = sys.argv[0] + '?tag=' + str(tag['id'])
    xbmcplugin.addDirectoryItem(handle=tag_handle, url=url, listitem=li, isFolder=True)

  xbmcplugin.endOfDirectory(tag_handle)


def show_streams(tag):
  stream_handle = int(sys.argv[1])
  xbmcplugin.setContent(stream_handle, 'streams')
  logging.warning('TAG show_streams!!!! %s', tag)
  for stream in streams[str(tag)]:
    logging.debug('STREAM HERE!!! %s', stream['name'])
    iconPath = os.path.join(home, 'resources', 'media', stream['icon'])
    li = xbmcgui.ListItem(stream['name'], iconImage=iconPath)
    xbmcplugin.addDirectoryItem(handle=stream_handle, url=stream['url'], listitem=li)

  xbmcplugin.endOfDirectory(stream_handle)


def get_params():
  """
  Retrieves the current existing parameters from XBMC.
  """
  param = []
  paramstring = sys.argv[2]
  if len(paramstring) >= 2:
    params = sys.argv[2]
    cleanedparams = params.replace('?', '')
    if params[len(params) - 1] == '/':
      params = params[0:len(params) - 2]
    pairsofparams = cleanedparams.split('&')
    param = {}
    for i in range(len(pairsofparams)):
      splitparams = {}
      splitparams = pairsofparams[i].split('=')
      if (len(splitparams)) == 2:
        param[splitparams[0]] = splitparams[1]
  return param


def lower_getter(field):
  def _getter(obj):
    return obj[field].lower()

  return _getter


addon = xbmcaddon.Addon()
username = addon.getSetting('username')
password = addon.getSetting('password')
home = xbmc.translatePath(addon.getAddonInfo('path'))

tags = [
{
    'name': 'DISCLAIMER',
    'id': 'DISCLAIMER',
    'icon': 'DISCLAIMER.png'
  }, {
    'name': 'support_vodpass',
    'id': 'support_vodpass',
    'icon': 'twitter_logo.png'
  }, {
    'name': 'vodpass',
    'id': 'vodpass',
    'icon': 'vodpass_main.png'
  }
]

DISCLAIMER = [{
  'name': 'Disclaimer: vodpass contain only links',
  'url': 'http://',
  'icon': 'DISCLAIMER.png',
  'disabled': False
  }, {
  'name': 'We do not host any films, media files(avi, mov, flv, mpg, mpeg, divx, dvd rip, mp3, mp4, torrent',
  'url': 'http://',
  'icon': 'DISCLAIMER.png',
  'disabled': False
  }, {
  'name': 'Any issues please contact the appropriate media file owners or host sites.',
  'url': '',
  'icon': 'DISCLAIMER.png',
  'disabled': False
}]

support_vodpass = [{
  'name': 'support vodpass via PayPal',
  'url': 'http://',
  'icon': 'twitter_logo.png',
  'disabled': False
  }, {
  'name': 'Vodpass Fan Video',
  'url': 'https://drive.google.com/uc?export=download&id=0B45uuNRPxIO1SWZ1RjFvTjUtcTA',
  'icon': 'twitter_logo.png',
  'disabled': False
  }, {
  'name': 'follow us @vodpass on twitter',
  'url': 'http://',
  'icon': 'twitter_logo.png',
  'disabled': False
  }, {
  'name': 'Report dead links to teamvodpass@gmail.com',
  'url': 'http://',
  'icon': 'twitter_logo.png',
  'disabled': False
}]

vodpass = [{
  'name': 'vodpass_iptv',
  'url': 'https://sites.google.com/site/vodpassplaylist/playlist-updates/vodpass_iptv.m3u',
  'icon': 'iptv.png',
  'disabled': False
  }, {
  'name': 'vodpass_iptv_sports',
  'url': 'https://sites.google.com/site/vodpassplaylist/playlist-updates/vodpass_iptv_sports.m3u',
  'icon': 'iptv_sports.png',
  'disabled': False
  }, {
  'name': 'vodpass_kids',
  'url': 'https://sites.google.com/site/vodpassplaylist/playlist-updates/vodpass_kids.m3u',
  'icon': 'kids.png',
  'disabled': False
  }, {
  'name': 'vodpass_movies',
  'url': 'https://sites.google.com/site/vodpassplaylist/playlist-updates/vodpass_movies.m3u',
  'icon': 'movies.png',
  'disabled': False
  }, {
  'name': 'vodpass_shows',
  'url': 'https://sites.google.com/site/vodpassplaylist/playlist-updates/vodpass_shows.m3u',
  'icon': 'shows.png',
  'disabled': False
  }, {
  'name': 'add name',
  'url': 'https://',
  'icon': '.png',
  'disabled': True
  }, {
  'name': 'add name',
  'url': 'https://',
  'icon': '.png',
  'disabled': True
  }, {
  'name': 'add name',
  'url': 'https://',
  'icon': '.png',
  'disabled': True
  }, {
  'name': 'add name',
  'url': 'https://',
  'icon': '.png',
  'disabled': True
  }, {
  'name': 'add name',
  'url': 'https://',
  'icon': '.png',
  'disabled': True
  }, {
  'name': 'add name',
  'url': 'https://',
  'icon': '.png',
  'disabled': True
}]



streams = {
  'DISCLAIMER': sorted((i for i in DISCLAIMER if not i.get('disabled', False)), key=lower_getter('name')),
  'support_vodpass': sorted((i for i in support_vodpass if not i.get('disabled', False)), key=lower_getter('name')),
  'vodpass': sorted((i for i in vodpass if not i.get('disabled', False)), key=lower_getter('name')),
  
  
  # 'DISCLAIMER': sorted(DISCLAIMER, key=lower_getter('name')),
  # 'support_vodpass': sorted(support_vodpass, key=lower_getter('name')),
  # 'vodpass': sorted(vodpass, key=lower_getter('name')),
}

PARAMS = get_params()
TAG = None
logging.warning('PARAMS!!!! %s', PARAMS)

try:
  TAG = PARAMS['tag']
except:
  pass

logging.warning('ARGS!!!! sys.argv %s', sys.argv)

if TAG == None:
  show_tags()
else:
  show_streams(TAG)
