# -*- coding: utf-8 -*-
#------------------------------------------------------------
# smytvshow
# service pack update manager
# http://smystero.dlinkddns.org/smytvwhow/
#------------------------------------------------------------

import os
import json

import xbmc

from xbmcutils import logger


class Updater(object):

    def __init__(self):
        logger.debug("start...")

        self.is_error = 0

        try:
            from xbmcutils import config as config
            try:
                self.version = config.get_version()
                self.temp_path = config.get_plugin_dir()
                self.target_path = config.get_plugin_path()
                self.icon = config.get_plugin_icon()
                self.msg_hd_check = config.get_localized_string(30120)
                self.msg_hd_update = config.get_localized_string(30121)
                self.msg_start = config.get_localized_string(30122)
                self.msg_end = config.get_localized_string(30123)
            finally:
                del config
        except Exception, e:
            self.version = "0.0.0"
            self.target_path = ""
            self.temp_path = ""
            self.icon = ""
            self.msg_hd_check = ""
            self.msg_hd_update = ""
            self.msg_start = ""
            self.msg_end = ""

            self.is_error = 1
            logger.error(e.message)

        try:
            import service_pack as sp
            try:
                self.sp_id = sp.sp
            finally:
                del sp
        except Exception, e:
            logger.error(e.message)
            self.sp_id = 0

        try:
            from smtvsinterface import smtvs_api
            try:
                sm = smtvs_api.smtvs()
                try:
                    self.url = sm.base
                finally:
                    del sm
            finally:
                del smtvs_api
        except Exception, e:
            logger.error(e.message)
            self.url = 'http://www.smytvshow.info/api'

        logger.debug("end...")


    def check_service_pack(self):
        logger.debug("start...")

        sps = []

        if (self.is_error == 0):
            self.notification(self.msg_hd_check, self.msg_start)
            url = '%s/getServicePack.php?ver=%s' % (self.url, self.version)
            try:
                from core import scrapertools as st
                try:
                    data = st.cache_page(url)
                    json_res = json.loads(data)
                    if (json_res["success"] == 1):
                        json_updates = json_res["updates"]
                        for json_update in json_updates:
                            sp_id = int(json_update["id"])
                            sp_url = json_update["url"]
                            if (sp_id > self.sp_id):
                                sps.append({"id": sp_id, "url": sp_url})
                finally:
                    del st
            except Exception, e:
                logger.error(e.message)
                pass

            self.notification(self.msg_hd_check, self.msg_end)

        logger.debug("end...")
        return sps

    def update(self):
        sps = self.check_service_pack()
        try:
            for sp in sps:

                self.notification(self.msg_hd_update, self.msg_start)
                logger.info("Applying service pack [%d] to version [%s]..." % (sp["id"], self.version))

                try:
                    file_path = os.path.join(self.temp_path, "temp")
                    if not os.path.exists(file_path):
                        os.makedirs(file_path, 0777)

                    file_name = os.path.join(file_path, ("sp%d.zip" % (sp["id"])))

                    if os.path.exists(file_name):
                        os.remove(file_name)

                    try:
                        from core import downloadtools as dt
                        try:
                            logger.info("Downloading [%s] from [%s]..." % (sp["url"], file_name))
                            dl_ret = dt.downloadfile(sp["url"], file_name)
                            if (dl_ret < 1):
                                logger.info(dl_ret)
                        finally:
                            del dt

                        if (dl_ret == 1):
                            from core import ziptools as zt
                            try:
                                unzipper = zt.ziptools()
                                try:
                                    logger.info("Installing [%s] to [%s]..." % (file_name, self.target_path))
                                    unzipper.extract(file_name, self.target_path)
                                finally:
                                    del unzipper
                            finally:
                                del zt
                    finally:
                        if os.path.exists(file_name):
                            os.remove(file_name)

                    self.notification(self.msg_hd_update, self.msg_end)

                except Exception, e:
                    self.notification(self.msg_hd_update, e.message)
                    raise

        except Exception, e:
            logger.error(e.message)

    def notification(self, header, message, time=2000):
        xbmc.executebuiltin("XBMC.Notification(%s,%s,%i,%s)" % (header, message, time, self.icon))

