# -*- coding: utf-8 -*-
#------------------------------------------------------------
# smytvshow
# VIDEOTT server connector
# http://smystero.dlinkddns.org/smytvwhow/
#------------------------------------------------------------

import re, random

from core import common as c
from xbmcutils import logger

SERVER_NAME = "[VideoTT]"
SERVER_ID = "videott"


def find_videos(data):
    logger.debug("start...")

    found = set()

    url_list = []

    # http://video.tt/video/vHDKmK32U
    patron = 'video.tt/video/([A-Za-z0-9]+)'
    matches = re.compile(patron, re.DOTALL).findall(data)

    for match in matches:
        url = "http://video.tt/e/"+match
        if url not in found:
            url_list.append([SERVER_ID, SERVER_NAME, url, match[0]])
            found.add(url)

    logger.debug("end...")
    return url_list


def get_video_url(page_url):
    logger.debug("start...")

    video_urls = []

    # URL
    try:
        video_id = c.find_single_match(page_url,"video.tt/e/([A-Za-z0-9]+)")
        timestamp=str(random.randint(1000000000,9999999999))
        hex_string = c.get_sha1(page_url) + c.get_sha1(page_url) + c.get_sha1(page_url) + c.get_sha1(page_url)
        hex_string = hex_string[:96]

        flv = "http://gs.video.tt/s?v=%s&r=1&t=%s&u=&c=%s&start=0" % (video_id, timestamp, hex_string)
        video_urls.append(['.mp4', flv])

    except:
        logger.error("Probably video [%s] has been removed." % page_url)
        pass

    logger.debug("end...")
    return video_urls
