# -*- coding: utf-8 -*-
#------------------------------------------------------------
# smytvshow
# MOVSHARE server connector
# http://smystero.dlinkddns.org/smytvwhow/
#------------------------------------------------------------

import re

from core import scrapertools, common as c
from xbmcutils import logger
from util import unwise

SERVER_NAME = "[MovShare]"
SERVER_ID = "movshare"


def find_videos(data):
    logger.debug("start...")

    found = set()

    url_list = []

    #<a href="http://www.nowvideo.eu/video/3695bce6e6288" target="_blank">1° Tempo</a>
    patron = 'movshare.ag/video/([a-z0-9]+)'
    matches = re.compile(patron, re.DOTALL).findall(data)

    for match in matches:
        url = "http://www.wholecloud.net/video/%s" % match
        if url not in found :
            url_list.append([SERVER_ID, SERVER_NAME, url, match])
            found.add(url)

    #<a href="http://www.nowvideo.eu/video/3695bce6e6288" target="_blank">1° Tempo</a>
    patron = "movshare.net/embed/([a-z0-9]+)"
    matches = re.compile(patron, re.DOTALL).findall(data)

    for match in matches:
        url = "http://www.wholecloud.net/video/%s" % match
        if url not in found :
            url_list.append([SERVER_ID, SERVER_NAME, url, match])
            found.add(url)

    #<a href="http://www.nowvideo.eu/video/3695bce6e6288" target="_blank">1° Tempo</a>
    patron = "movshare.net/embed.php\?v\=([a-z0-9]+)"
    matches = re.compile(patron, re.DOTALL).findall(data)

    for match in matches:
        url = "http://www.wholecloud.net/video/%s" % match
        if url not in found :
            url_list.append([SERVER_ID, SERVER_NAME, url, match])
            found.add(url)

    patron = 'movshare.sx/video/([a-z0-9]+)'
    matches = re.compile(patron, re.DOTALL).findall(data)

    for match in matches:
        url = "http://www.wholecloud.net/video/%s" % match
        if url not in found :
            url_list.append([SERVER_ID, SERVER_NAME, url, match])
            found.add(url)

    logger.debug("end...")
    return url_list


def get_video_url(page_url):
    logger.debug("start...")

    video_urls = []

    try:
        data = scrapertools.cache_page(page_url)

        patron = 'name="stepkey" value="([^"]+)"'
        stepkey = c.find_single_match(data, patron)
        post = "stepkey=%s&submit=submit" % stepkey

        data = scrapertools.cache_page(page_url,post)

        video_id = c.find_single_match(data, 'flashvars\.file\s*=\s*"([^"]+)')
        filekey = c.find_single_match(data, 'flashvars\.file[_]*key\s*=\s*([^;]+)')
        filekey = filekey.replace(".", "%2E").replace("-", "%2D")

        # get stream url from api
        url = 'http://www.wholecloud.net/api/player.api.php?key=%s&file=%s' % (filekey, video_id)
        data = scrapertools.cache_page(url)
        media_url = c.find_single_match(data, 'url=([^&]+)')

        if media_url == "":
            raise ValueError(data)

        video_urls.append([scrapertools.get_filename_from_url(media_url)[-4:], media_url])

    except:
        logger.error("Probably video [%s] has been removed." % page_url)
        pass

    logger.debug("end...")
    return video_urls
