# -*- coding: utf-8 -*-
# ------------------------------------------------------------
# smytvshow
# Utilities for pushers
# http://smystero.dlinkddns.org/smytvwhow/
#------------------------------------------------------------

from core import items, servertools
from xbmcutils import gui, plugin, config, logger

if config.use_mysql:
    from mysqlinterface import sql_manager as sql
else:
    from sql import sql_manager as sql


def get_fav_list(pusher, item):
    logger.debug("start...")

    item_list = []

    s = sql.SqlManager()

    rows = s.list_show_by_pusher(pusher.__object_name__)
    if len(rows) > 0:
        if config.get_setting("favorites_apart") == "true":
            item_list.append(items.MenuItem(pusher, config.get_localized_string(30103), "list_favorites",
                                            thumbnail="[favorite]"))
        else:
            item_list.append(items.MenuItem(pusher, config.get_localized_string(30103), "null",
                                            folder=False, playable=False, thumbnail="[favorite]"))
            inc = 100 / len(rows)
            progress = 0
            dlg = gui.progress_dialogBG(None, config.get_localized_string(30104))
            try:
                for row in rows:
                    gui.progress_dialogBG(dlg, row[1], progress)
                    progress += inc
                    item_list.append(items.ShowItem(pusher, item, row[0], row[1], row[3], items.url_decode(row[2]), row[4], row[5]))
            finally:
                gui.progress_dialogBG(dlg, config.get_localized_string(30105), 100)
                del dlg

    logger.debug("end...")
    return item_list


def list_favorites(pusher, item):
    logger.debug("start...")
    plugin.set_content_to_tv_shows()

    item_list = []

    s = sql.SqlManager()

    rows = s.list_show_by_pusher(pusher.__object_name__)
    if len(rows) > 0:
        inc = 100 / len(rows)
        progress = 0
        dlg = gui.progress_dialogBG(None, config.get_localized_string(30104))
        try:
            for row in rows:
                gui.progress_dialogBG(dlg, row[1], progress)
                progress += inc
                item_list.append(items.ShowItem(pusher, item, row[0], row[1], row[3], items.url_decode(row[2]), row[4], row[5]))
        finally:
            gui.progress_dialogBG(dlg, config.get_localized_string(30105), 100)
            del dlg

    gui.render_items(item_list, gui.def_view_favorites)

    logger.debug("end...")
    return


def route_call(action, item):
    item.item_info["action"] = action[:-4]
    gui.update_url(item.build_url())


def add_collect_item(item_list, item):
    logger.debug("start...")

    s = sql.SqlManager()
    try:
        rows = s.list_pushers_by_show(int(item.item_info["show_id"]))
        if (rows):
            if(len(rows)) > 1:
                show_id = int(item.item_info["show_id"])
                season = int(item.item_info["item_season"])
                episode = int(item.item_info["item_episode"])
                subbed = int(item.item_info["subbed"])
                item_list.append(items.MenuItem(None, config.get_localized_string(30958), "collect_episodes_videos",
                                                {
                                                    "show_id": show_id,
                                                    "season": season,
                                                    "episode": episode,
                                                    "subbed": subbed
                                                },
                                                thumbnail="[search]"))
    finally:
        del s

    logger.debug("end...")
    return

def show_urls(pusher, item):
    logger.debug("start...")

    media_item = servertools.get_video_url(pusher, item)
    if media_item is not None:
        gui.play_media(media_item)

    logger.debug("end...")
    return