# -*- coding: utf-8 -*-
# ------------------------------------------------------------
# smytvshow
# Pusher for smytvshow
# http://smystero.dlinkddns.org/smytvwhow/
#------------------------------------------------------------

from core import items
from core.pushers_manager import Manager

from smtvsinterface import smtvs_api
from tvdb import tvdb_api

from xbmcutils import plugin, gui, logger, config

if config.use_mysql:
    from mysqlinterface import sql_manager as sql
else:
    from sql import sql_manager as sql

__class_name__ = "SMyTvShow"


class SMyTvShow():
    __object_type__ = "P"
    __object_name__ = "p_smytvshow"

    def __init__(self):
        return

    def main(self, item):
        logger.debug("start...")
        plugin.set_content_to_tv_shows()

        item_list = []

        s = smtvs_api.smtvs()
        try:
            series = s.get_top()
            try:
                inc = 100 / len(series)
            except ZeroDivisionError:
                inc = 100

            progress = 0
            dlg = gui.progress_dialogBG(None, config.get_localized_string(30104))
            try:
                for show_id in series:
                    gui.progress_dialogBG(dlg, config.get_localized_string(30104), progress)
                    si = items.ShowItem(self, None, show_id, "", "pusher", from_chart=True)
                    item_list.append(si)
                    progress += inc
            finally:
                gui.progress_dialogBG(dlg, config.get_localized_string(30105), 100)
                del dlg
        finally:
            del s

        gui.render_items(item_list, gui.def_view_chart)

        logger.debug("end...")
        return

    def pusher(self, item):
        logger.debug("start...")
        plugin.set_content_to_tv_shows()

        item_fanart = item.item_info["fanart"]
        show_id = int(item.item_info["show_id"])
        item_list = []

        found = set()
        fav = set()

        s = sql.SqlManager()
        try:
            rows = s.list_pushers_by_show(show_id)
            for row in rows:
                fav.add(row[1])
        finally:
            del s

        s = smtvs_api.smtvs()
        try:
            pushers = s.get_pushers(show_id)
            for pusher in pushers:
                pi = Manager.get_pusher(pusher["pusher"])
                if pi is not None:
                    if pi not in found:
                        extra = {"show_id":show_id, "url": pusher["url"], "action": pusher["action"],
                                 "target_type":pusher["target_type"], "target": pusher["target"]}
                        item_list.append(items.PusherShowItem(self, pi, show_id, pusher["pusher"] in fav,
                                                              "jump_to_pusher",
                                                              extra=extra,
                                                              fanart=item_fanart,
                                                              target_type=SMyTvShow.__object_type__,
                                                              target=SMyTvShow.__object_name__ ))
                        found.add(pi)
        finally:
            del s

        gui.render_items(item_list, gui.def_view_pushers)

        logger.debug("end...")
        return

    def build_search_item(self, item):
        return items.MenuItem(self, config.get_localized_string(30100), "global_search",
                                folder=False, playable=False, thumbnail="[search]")

    def global_search(self, item):
        # item.item_info["extra.url"] = item.item_info["extra.url"]
        item.item_info["action"] = "null"
        return self.fill_series(item)

    def fill_series(self, item):
        logger.debug("start...")

        text = item.item_info["extra.url"]
        item_list = []

        found = set()

        max_results = int(config.get_setting("max_result")) + 1

        s = smtvs_api.smtvs()
        try:
            tv_db = tvdb_api.TvDb()
            search_results = tv_db.search(text)
            for result in search_results:
                show_id = result["id"]
                if (str(show_id) not in found) & (len(found) < max_results):
                    pushers = s.get_pushers(show_id)
                    if len(pushers) > 0:
                        si = items.ShowItem(self, None, show_id, "", "pusher", from_chart=True)
                        item_list.append(si)
                        found.add(str(show_id))
        finally:
            del s

        logger.debug("end...")
        return item_list

    def jump_to_pusher(self, item):
        logger.debug("start...")

        item_show_id = int(item.item_info["extra.show_id"])
        item_url = item.item_info["extra.url"]
        item_action = item.item_info["extra.action"]
        item_target_type = item.item_info["extra.target_type"]
        item_target = item.item_info["extra.target"]

        dlg = gui.progress_dialogBG(None, config.get_localized_string(30104))
        try:
            run_item = items.ShowItem(self, item, item_show_id, '', item_action,
                                  items.url_decode(item_url), item_target_type, item_target)
            gui.progress_dialogBG(dlg, config.get_localized_string(30104), 50)
        finally:
            gui.progress_dialogBG(dlg, config.get_localized_string(30105), 100)
            del dlg

        gui.update_url(run_item.build_url())

        logger.debug("end...")
        return
