# -*- coding: utf-8 -*-
#------------------------------------------------------------
# smytvshow
# Parameter handler
# http://smystero.dlinkddns.org/smytvwhow/
#------------------------------------------------------------

from xbmcutils import logger
from core import items


class Param(dict):

    def __init__(self, args):
        logger.debug("args = [%s]" % args)

        dict.__init__(self)
        for key, value in args.iteritems():
            self[key] = value[0]

        if ("caller" not in self) or (self["caller"] == ""):
            self["caller"] = "unknown"

        if ("source_type" not in self) or (self["source_type"] == ""):
            self["source_type"] = "I"

        if ("source" not in self) or (self["source"] == ""):
            self["source"] = "default"

        if ("target_type" not in self) or (self["target_type"] == ""):
            self["target_type"] = "M"

        if ("target" not in self) or (self["target"] == ""):
            self["target"] = "main_menu"

        if ("action" not in self) or (self["action"] == ""):
            self["action"] = "main"

        self.caller_item = items.CallerItem(self)

    def get_caller_item(self):
        return self.caller_item

    def get_value(self, key):
        if key in self:
            return self[key]
        else:
            return ""