# -*- coding: utf-8 -*-
# ------------------------------------------------------------
# smytvshow
# Tools for file downloading
# http://smystero.dlinkddns.org/smytvwhow/
# ------------------------------------------------------------

import urllib2, urllib
import os
import re
import socket

from xbmcutils import logger

DEBUG_LEVEL = 0


def downloadfile(url, filename, headers=[], recover=False):
    logger.debug('start...')

    try:
        if os.path.exists(filename) and recover:
            existSize = os.path.getsize(filename)
            f = open(filename, 'r+b')
            f.seek(existSize)

        elif os.path.exists(filename) and not recover:
            return 0

        else:
            existSize = 0
            f = open(filename, 'wb')

        if "|" in url:
            additional_headers = url.split("|")[1]
            if "&" in additional_headers:
                additional_headers = additional_headers.split("&")
            else:
                additional_headers = [ additional_headers ]

            for additional_header in additional_headers:
                name = re.findall( "(.*?)=.*?" , additional_header )[0]
                value = urllib.unquote_plus(re.findall( ".*?=(.*?)$" , additional_header )[0])
                headers.append( [ name,value ] )

            url = url.split("|")[0]

        socket.setdefaulttimeout(60)

        h=urllib2.HTTPHandler(debuglevel=DEBUG_LEVEL)
        request = urllib2.Request(url)
        for header in headers:
            request.add_header(header[0],header[1])

        if existSize > 0:
            request.add_header('Range', 'bytes=%d-' % (existSize, ))

        opener = urllib2.build_opener(h)
        urllib2.install_opener(opener)
        try:
            connexion = opener.open(request)
        except urllib2.HTTPError,e:
            f.close()
            if e.code == 416:
                return 0
            else:
                return -2

        blocksize = 100*1024

        buffer = connexion.read(blocksize)

        while len(buffer)>0:
            try:
                f.write(buffer)

            except Exception, e:
                logger.error( e.message )
                f.close()
                return -2

            buffer = connexion.read(blocksize)

    except Exception, e:
        logger.error( e.message )

    try:
        f.close()
    except:
        pass

    logger.debug('End...')

    return 1
