# -*- coding: utf-8 -*-
#------------------------------------------------------------
# smytvshow
# Config
# http://smystero.dlinkddns.org/smytvwhow/
#------------------------------------------------------------

import sys
import urlparse

import xbmc, xbmcaddon


def get_setting(name):
    return get_add_on().getSetting(name)


def set_setting(name,value):
    try:
        get_add_on().setSetting(name,value)
    except:
        pass


def get_localized_string(code):
    dev = get_add_on().getLocalizedString( code )

    try:
        dev = dev.encode ("utf-8") #This only aplies to unicode strings. The rest stay as they are.
    except:
        pass

    return dev


def get_version():
    version = get_add_on().getAddonInfo('version')
    return version


def get_add_on():
    return xbmcaddon.Addon()


def get_base():
    return sys.argv[0]


def get_handle():
    return int(sys.argv[1])


def get_args():
    return urlparse.parse_qs(sys.argv[2][1:])


def get_plugin_dir():
    return xbmc.translatePath(get_add_on().getAddonInfo('profile')).decode('utf-8')


def get_plugin_path():
    return xbmc.translatePath(get_add_on().getAddonInfo('path')).decode('utf-8')


def get_plugin_icon():
    return xbmc.translatePath(get_add_on().getAddonInfo('icon')).decode('utf-8')


def get_name():
    return get_add_on().getAddonInfo('name')

plugin_dir = get_plugin_dir()
plugin_path = get_plugin_path()

language_enum = get_setting("language")
lang_list = [get_localized_string(30013),get_localized_string(30014)]
try:
    language = lang_list[int(language_enum)]
except:
    language = lang_list[0]

use_mysql = get_setting("mysql_enabled") == "true"
