# -*- coding: utf-8 -*-
# ------------------------------------------------------------
# smytvshow
# wrapper to sqlite3
# http://smystero.dlinkddns.org/smytvwhow/
# ------------------------------------------------------------

import urllib
import json
from core import scrapertools
from xbmcutils import config, logger


class smtvs:

    def __init__(self):
        self.base = 'http://www.smytvshow.info/api'
        pass

    def new_install(self):
        logger.debug("start...")

        import uuid
        id = str(uuid.uuid4())
        try:
            url = '%s/addNewInstall.php?id=%s&ver=%s' % (self.base, id, config.get_version())
            data = scrapertools.cache_page(url)
            json_res = json.loads(data)
            if (json_res["success"] == 1):
                config.set_setting("smtvs_id", id)
                config.set_setting("smtvs_ver", config.get_version())

        except Exception, e:
            logger.error(e.message)
            pass

        logger.debug("end...")

    def upd_install(self):
        logger.debug("start...")

        id = config.get_setting("smtvs_id")
        try:
            url = '%s/updInstall.php?id=%s&ver=%s' % (self.base, id, config.get_version())
            data = scrapertools.cache_page(url)
            json_res = json.loads(data)
            if (json_res["success"] == 1):
                config.set_setting("smtvs_ver", config.get_version())

        except Exception, e:
            logger.error(e.message)
            pass

        logger.debug("end...")

    def get_updateable_version(self):
        logger.debug("start...")

        ver = ""

        if config.get_setting("new_share") == "true":

            cur_ver = config.get_version()
            val_cur_ver = 0

            new_ver = ""
            val_new_ver = 0

            split_ver = cur_ver.split(".")
            if len(split_ver) > 0:
                multiplier = 10 ** (len(split_ver) - 1)
                for val in split_ver:
                    try:
                        val_cur_ver += (int(val) * multiplier)
                    except:
                        pass
                    multiplier /= 10

            url = '%s/getLastVersion.php' % (self.base)
            try:
                data = scrapertools.cache_page(url)
                json_res = json.loads(data)
                if (json_res["success"] == 1):
                    new_ver = json_res["version"]
                    split_ver = new_ver.split(".")
                    if len(split_ver) > 0:
                        multiplier = 10 ** (len(split_ver) - 1)
                        for val in split_ver:
                            try:
                                val_new_ver += (int(val) * multiplier)
                            except:
                                pass
                            multiplier /= 10
            except Exception, e:
                logger.error(e.message)
                pass

            if val_new_ver > val_cur_ver:
                ver = new_ver

        logger.debug("end...")
        return ver

    def get_usable_version(self):
        logger.debug("start...")

        ver = ""

        if config.get_setting("new_share") == "true":

            cur_ver = config.get_version()
            val_cur_ver = 0

            new_ver = ""
            val_new_ver = 0

            split_ver = cur_ver.split(".")
            if len(split_ver) > 0:
                multiplier = 10 ** (len(split_ver) - 1)
                for val in split_ver:
                    try:
                        val_cur_ver += (int(val) * multiplier)
                    except:
                        pass
                    multiplier /= 10

            url = '%s/getLastUsableVersion.php' % (self.base)
            try:
                data = scrapertools.cache_page(url)
                json_res = json.loads(data)
                if (json_res["success"] == 1):
                    new_ver = json_res["version"]
                    split_ver = new_ver.split(".")
                    if len(split_ver) > 0:
                        multiplier = 10 ** (len(split_ver) - 1)
                        for val in split_ver:
                            try:
                                val_new_ver += (int(val) * multiplier)
                            except:
                                pass
                            multiplier /= 10
            except Exception, e:
                logger.error(e.message)
                pass

            if val_new_ver > val_cur_ver:
                ver = new_ver

        logger.debug("end...")
        return ver

    def add_show(self, pusher, digest, url, action, target_type, target, id):
        logger.debug("start...")
        if config.get_setting("new_share") == "true":
            try:
                params = "pusher=%s&hash=%s&url=%s&action=%s&target=%s&target_type=%s&idtvdbserie=%s" % \
                         (urllib.quote_plus(pusher),urllib.quote_plus(digest),urllib.quote_plus(url),
                          urllib.quote_plus(action),urllib.quote_plus(target_type),urllib.quote_plus(target),
                                                                                                id)
                url = '%s/addPusherSerie.php?%s' % (self.base, params)
                scrapertools.cache_page(url)
            except Exception, e:
                logger.error(e.message)
                pass

        logger.debug("end...")

    def get_top(self):
        logger.debug("start...")

        series = []
        if config.get_setting("new_share") == "true":
            try:
                params = "top=%d" % (20)
                url = '%s/getTopSerie.php?%s' % (self.base, params)
                data = scrapertools.cache_page(url)
                json_res = json.loads(data)
                if (json_res["success"] == 1):
                    json_series = json_res["series"]
                    for json_serie in json_series:
                        series.append(int(json_serie["id"]))
            except Exception, e:
                logger.error(e.message)
                pass

        logger.debug("end...")
        return series

    def get_pushers(self, show_id):
        logger.debug("start...")

        pushers = []
        if config.get_setting("new_share") == "true":
            try:
                params = "idtvdbserie=%d" % (show_id)
                url = '%s/getPushers.php?%s' % (self.base, params)
                data = scrapertools.cache_page(url)
                json_res = json.loads(data)
                if (json_res["success"] == 1):
                    json_pushers = json_res["pushers"]
                    for json_pusher in json_pushers:
                        pushers.append(json_pusher)
            except Exception, e:
                logger.error(e.message)
                pass

        logger.debug("end...")
        return pushers

    def add_view_show(self, show_id, season, episode, pusher):
        logger.debug("start...")

        if config.get_setting("new_share") == "true":
            try:
                params = "idtvdbserie=%d&season=%d&episode=%d&pusher=%s" % \
                         (show_id, season, episode, pusher)
                url = '%s/addViewSerie.php?%s' % (self.base, params)
                scrapertools.cache_page(url)
            except Exception, e:
                logger.error(e.message)
                pass

        logger.debug("end...")
