# -*- coding: utf-8 -*-
#------------------------------------------------------------
# smytvshow
# OPENLOAD server connector
# http://smystero.dlinkddns.org/smytvwhow/
# Adapted from
# ------------------------------------------------------------
# pelisalacarta - XBMC Plugin
# Conector for openload.io
# http://blog.tvalacarta.info/plugin-xbmc/pelisalacarta/
# by DrZ3r0
# Fix imported by DrZ3r0, credits to mortael, Fr33m1nd, anton40


import re

from core import scrapertools, common as c
from xbmcutils import logger
from util import aadecoder, jjdecoder, unpackerjs


SERVER_NAME = "[OpenLoad]"
SERVER_ID = "openload"


def find_videos(data):
    logger.debug("start...")

    found = set()

    url_list = []

    patron = '//(?:www.)?openload.../(?:embed|f)/([0-9a-zA-Z-_]+)'
    matches = re.compile(patron).findall(data)

    for match in matches:
        url = 'http://openload.co/f/%s' %  match
        if url not in found:
            url_list.append([SERVER_ID, SERVER_NAME, url, match])
            found.add(url)

    logger.debug("end...")
    return url_list


def get_video_url(page_url):
    logger.debug("start...")
    video_urls = []

    try:
        data = scrapertools.cache_page(page_url)

        aastring = re.search(r"<video(?:.|\s)*?<script\s[^>]*?>((?:.|\s)*?)</script", data,
                             re.DOTALL | re.IGNORECASE).group(1)

        aastring = aastring.replace("((ﾟｰﾟ) + (ﾟｰﾟ) + (ﾟΘﾟ))", "9")
        aastring = aastring.replace("((ﾟｰﾟ) + (ﾟｰﾟ))", "8")
        aastring = aastring.replace("((ﾟｰﾟ) + (o^_^o))", "7")
        aastring = aastring.replace("((o^_^o) +(o^_^o))", "6")
        aastring = aastring.replace("((ﾟｰﾟ) + (ﾟΘﾟ))", "5")
        aastring = aastring.replace("(ﾟｰﾟ)", "4")
        aastring = aastring.replace("((o^_^o) - (ﾟΘﾟ))", "2")
        aastring = aastring.replace("(o^_^o)", "3")
        aastring = aastring.replace("(ﾟΘﾟ)", "1")
        aastring = aastring.replace("(+!+[])", "1")
        aastring = aastring.replace("(c^_^o)", "0")
        aastring = aastring.replace("(0+0)", "0")
        aastring = aastring.replace("(ﾟДﾟ)[ﾟεﾟ]", "\\")
        aastring = aastring.replace("(3 +3 +0)", "6")
        aastring = aastring.replace("(3 - 1 +0)", "2")
        aastring = aastring.replace("(!+[]+!+[])", "2")
        aastring = aastring.replace("(-~-~2)", "4")
        aastring = aastring.replace("(-~-~1)", "3")

        decodestring = re.search(r"\\\+([^(]+)", aastring, re.DOTALL | re.IGNORECASE).group(1)
        decodestring = "\\+" + decodestring
        decodestring = decodestring.replace("+", "")
        decodestring = decodestring.replace(" ", "")

        decodestring = decode(decodestring)
        decodestring = decodestring.replace("\\/", "/")

        videourl = re.search(r"vr\s?=\s?\"|'([^\"']+)", decodestring, re.DOTALL | re.IGNORECASE).group(1)
        video_urls.append([videourl[-4:], videourl])

    except Exception, e:
        logger.error("Probably video [%s] has been removed." % page_url)
        pass

    logger.debug("end...")
    return video_urls

def decode(encoded):
    for octc in (c for c in re.findall(r'\\(\d{2,3})', encoded)):
        encoded = encoded.replace(r'\%s' % octc, chr(int(octc, 8)))
    return encoded.decode('utf8')
