# -*- coding: utf-8 -*-
#------------------------------------------------------------
# smytvshow
# NOWVIDEO server connector
# http://smystero.dlinkddns.org/smytvwhow/
#------------------------------------------------------------

import re

from core import scrapertools, common as c
from xbmcutils import logger
from util import unwise

SERVER_NAME = "[NowVideo]"
SERVER_ID = "nowvideo"


def find_videos(data):
    logger.debug("start...")

    found = set()

    url_list = []

    #<a href="http://www.nowvideo.eu/video/3695bce6e6288" target="_blank">1° Tempo</a>
    patron = '<a href="http://www.nowvideo.../video/([a-z0-9]+)"[^>]+>([^<]+)</a>'
    matches = re.compile(patron, re.DOTALL).findall(data)

    for match in matches:
        url = "http://www.nowvideo.sx/video/%s" % match[0]
        if url not in found:
            url_list.append([SERVER_ID, SERVER_NAME, url, match[0]])
            found.add(url)

    #http://www.nowvideo.eu/video/3695bce6e6288
    #http://www.nowvideo.eu/video/4fd0757fd4592
    patron = 'nowvideo.../video/([a-z0-9]+)'
    matches = re.compile(patron, re.DOTALL).findall(data)

    for match in matches:
        url = "http://www.nowvideo.sx/video/%s" % match
        if url not in found:
            url_list.append([SERVER_ID, SERVER_NAME, url, match])
            found.add(url)

    #http://www.player3k.info/nowvideo/?id=t1hkrf1bnf2ek
    patron = 'player3k.info/nowvideo/\?id\=([a-z0-9]+)'
    matches = re.compile(patron, re.DOTALL).findall(data)

    for match in matches:
        url = "http://www.nowvideo.sx/video/%s" % match
        if url not in found:
            url_list.append([SERVER_ID, SERVER_NAME, url, match])
            found.add(url)

    #http://embed.nowvideo.eu/embed.php?v=obkqt27q712s9&amp;width=600&amp;height=480
    #http://embed.nowvideo.eu/embed.php?v=4grxvdgzh9fdw&width=568&height=340
    patron = 'nowvideo.../embed.php\?v\=([a-z0-9]+)'
    matches = re.compile(patron, re.DOTALL).findall(data)

    for match in matches:
        url = "http://www.nowvideo.sx/video/%s" % match
        if url not in found:
            url_list.append([SERVER_ID, SERVER_NAME, url, match])
            found.add(url)

    #http://embed.nowvideo.eu/embed.php?width=600&amp;height=480&amp;v=9fb588463b2c8
    patron = 'nowvideo.../embed.php\?.+?v\=([a-z0-9]+)'
    matches = re.compile(patron, re.DOTALL).findall(data)

    for match in matches:
        url = "http://www.nowvideo.sx/video/%s" % match
        if url not in found:
            url_list.append([SERVER_ID, SERVER_NAME, url, match])
            found.add(url)

    logger.debug("end...")
    return url_list


def get_video_url(page_url):
    logger.debug("start...")

    video_urls = []

    try:
        data = scrapertools.cache_page(page_url)

        patron = 'name="stepkey" value="([^"]+)"'
        stepkey = c.find_single_match(data, patron)
        post = "stepkey=%s&submit=submit" % stepkey

        data = scrapertools.cache_page(page_url,post)

        video_id = c.find_single_match(data, 'flashvars\.file\s*=\s*"([^"]+)')
        flashvar_filekey = c.find_single_match(data, 'flashvars\.file[_]*key\s*=\s*([^;]+)')
        filekey = c.find_single_match(data, 'var\s+%s\s*=\s*"([^"]+)' % flashvar_filekey)
        filekey = filekey.replace(".", "%2E").replace("-", "%2D")

        # get stream url from api
        url = 'http://www.nowvideo.sx/api/player.api.php?key=%s&file=%s' % (filekey, video_id)
        data = scrapertools.cache_page(url)
        media_url = c.find_single_match(data, 'url=([^&]+)')

        if media_url == "":
            raise ValueError(data)

        video_urls.append([scrapertools.get_filename_from_url(media_url)[-4:], media_url])

    except:
        logger.error("Probably video [%s] has been removed." % page_url)
        pass

    logger.debug("end...")
    return video_urls
